/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.io.Serializable;
import org.jpedal.io.ObjectUtils;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.PdfObjectFactory;
import org.jpedal.io.security.DecryptionFactory;
import org.jpedal.io.types.Array;
import org.jpedal.io.types.ArrayHandler;
import org.jpedal.io.types.BooleanArray;
import org.jpedal.io.types.BooleanValue;
import org.jpedal.io.types.Dictionary;
import org.jpedal.io.types.DoubleArray;
import org.jpedal.io.types.FloatArray;
import org.jpedal.io.types.FloatValue;
import org.jpedal.io.types.Form;
import org.jpedal.io.types.General;
import org.jpedal.io.types.IntArray;
import org.jpedal.io.types.KeyArray;
import org.jpedal.io.types.Name;
import org.jpedal.io.types.NumberValue;
import org.jpedal.io.types.ObjectArray;
import org.jpedal.io.types.Stream;
import org.jpedal.io.types.StreamReaderUtils;
import org.jpedal.io.types.StringArray;
import org.jpedal.io.types.StringValue;
import org.jpedal.io.types.TextStream;
import org.jpedal.objects.raw.PdfDictionary;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.NumberUtils;
import org.jpedal.utils.StringUtils;

public class ObjectDecoder
implements Serializable {
    protected PdfFileReader objectReader;
    protected DecryptionFactory decryption;
    static final byte[] endPattern = new byte[]{101, 110, 100, 111, 98, 106};
    public static boolean debugFastCode;
    public static String padding;
    boolean isInlineImage;
    private int endPt = -1;

    public ObjectDecoder(PdfFileReader pdfFileReader) {
        this.init(pdfFileReader);
    }

    private void init(PdfFileReader objectReader) {
        this.objectReader = objectReader;
        this.decryption = objectReader.getDecryptionObject();
    }

    public final int readDictionaryAsObject(PdfObject pdfObject, int i2, byte[] raw) {
        int len;
        if (this.endPt == -1) {
            this.endPt = raw.length;
        }
        if (debugFastCode) {
            padding = padding + "   ";
        }
        if (debugFastCode) {
            ObjectUtils.showData(pdfObject, i2, raw, padding);
        }
        i2 = this.readObjectDataValues(pdfObject, i2, raw);
        if (!pdfObject.ignoreStream() && pdfObject.getGeneralType(-1) != 6420) {
            Stream.readStreamData(pdfObject, i2, raw, raw.length, this.objectReader);
        }
        if (pdfObject.getObjectType() == 373244477) {
            Form.setFieldNames(pdfObject, this.objectReader);
        }
        if (debugFastCode && (len = padding.length()) > 3) {
            padding = padding.substring(0, len - 3);
        }
        return i2;
    }

    private int readObjectDataValues(PdfObject pdfObject, int i2, byte[] raw) {
        int length = raw.length;
        int level = 0;
        if (this.isInlineImage) {
            level = 1;
        }
        while (true) {
            if (i2 < length && raw[i2] == 37) {
                i2 = StreamReaderUtils.skipComment(raw, i2);
            }
            if (i2 >= length || this.endPt != -1 && i2 >= this.endPt || raw[i2] == 101 && raw[i2 + 1] == 110 && raw[i2 + 2] == 100 && raw[i2 + 3] == 111 || raw[i2] == 115 && raw[i2 + 1] == 116 && raw[i2 + 2] == 114 && raw[i2 + 3] == 101 && raw[i2 + 4] == 97 && raw[i2 + 5] == 109) break;
            if (raw[i2] == 60 && raw[i2 + 1] == 60) {
                ++i2;
                ++level;
            } else if (raw[i2] == 62 && i2 + 1 != length && raw[i2 + 1] == 62) {
                ++i2;
                if (--level == 0) {
                    break;
                }
            } else if (raw[i2] == 47 && raw[++i2] != 47 && raw[i2] != 32) {
                i2 = this.getKey(i2, raw, length, pdfObject);
            }
            ++i2;
        }
        return i2;
    }

    private int getKey(int i2, byte[] raw, int length, PdfObject pdfObject) {
        int keyStart = i2;
        int keyLength = StreamReaderUtils.findDictionaryEnd(i2, raw, length);
        i2 += keyLength;
        int type = pdfObject.getObjectType();
        if (debugFastCode) {
            System.out.println("type=" + type + ' ' + ' ' + pdfObject.getID() + " chars=" + (char)raw[i2 - 1] + (char)raw[i2] + (char)raw[i2 + 1] + ' ' + pdfObject + " i=" + i2);
        }
        int PDFkeyInt = PdfDictionary.getIntKey(keyStart, keyLength, raw);
        if (this.isInlineImage) {
            PDFkeyInt = PdfObjectFactory.getInlineID(PDFkeyInt);
        }
        int pdfKeyType = PdfDictionary.getKeyType(PDFkeyInt, type);
        if (raw[i2] == 47 || raw[i2] == 40 || raw[i2] == 91 && raw[i2 + 1] != 93) {
            --i2;
        }
        if (pdfKeyType == -1) {
            i2 = ObjectUtils.handleUnknownType(i2, raw, length);
        }
        if (PDFkeyInt == -1 || pdfKeyType == -1) {
            if (debugFastCode) {
                System.out.println(padding + pdfObject.getObjectRefAsString() + " =================Not implemented=" + PdfDictionary.getKey(keyStart, keyLength, raw) + " pdfKeyType=" + pdfKeyType);
            }
            i2 = ObjectDecoder.skipValueForUnknownKey(i2, raw, length, pdfObject, keyStart, keyLength);
        } else {
            if (debugFastCode) {
                System.out.println(i2 + padding + pdfObject.getObjectRefAsString() + " =================Reading value for key=" + PdfDictionary.getKey(keyStart, keyLength, raw) + " (" + PDFkeyInt + ") type=" + PdfDictionary.showAsConstant(pdfKeyType) + ' ' + pdfObject);
            }
            i2 = this.setValue(pdfObject, i2, raw, PDFkeyInt, pdfKeyType);
        }
        return i2;
    }

    private static int skipValueForUnknownKey(int i2, byte[] raw, int length, PdfObject pdfObject, int keyStart, int keyLength) {
        int nextkeyStart = StreamReaderUtils.skipSpaces(raw, keyStart + keyLength);
        if (raw[nextkeyStart] == 91) {
            i2 = ObjectDecoder.skipArray(raw, length, nextkeyStart + 1);
        } else if (raw[nextkeyStart] == 47) {
            i2 = ObjectDecoder.ignoreSpuriousNextKey(raw, length, pdfObject, nextkeyStart);
        }
        return i2;
    }

    private static int skipArray(byte[] raw, int length, int i2) {
        while (i2 <= length && raw[i2] != 93) {
            ++i2;
        }
        return i2;
    }

    private static int ignoreSpuriousNextKey(byte[] raw, int length, PdfObject pdfObject, int nextkeyStart) {
        int i2;
        for (i2 = nextkeyStart + 1; i2 <= length && raw[i2] != 47 && raw[i2] != 91 && raw[i2] != 60 && raw[i2] != 62; ++i2) {
        }
        if (debugFastCode) {
            System.out.println(padding + pdfObject.getObjectRefAsString() + " =================Skipped=" + new String(raw).substring(nextkeyStart, i2));
        }
        if (raw[i2] != 62) {
            --i2;
        }
        return i2;
    }

    private int setValue(PdfObject pdfObject, int i2, byte[] raw, int PDFkeyInt, int pdfKeyType) {
        if (pdfKeyType == 5 && pdfObject.isDataExternal()) {
            pdfKeyType = 1;
        }
        switch (pdfKeyType) {
            case 25: {
                i2 = TextStream.setTextStreamValue(pdfObject, i2, raw, PDFkeyInt, this.objectReader);
                break;
            }
            case 35: {
                i2 = Name.setNameTreeValue(pdfObject, i2, raw, PDFkeyInt, this.objectReader);
                break;
            }
            case 2: {
                i2 = Dictionary.setDictionaryValue(pdfObject, i2, raw, this.objectReader, PDFkeyInt, true);
                break;
            }
            case 20: {
                StringArray objDecoder = new StringArray(this.objectReader, i2, raw);
                i2 = objDecoder.readArray(pdfObject, PDFkeyInt);
                break;
            }
            case 12: {
                BooleanArray objDecoder = new BooleanArray(this.objectReader, i2, raw);
                i2 = objDecoder.readArray(pdfObject, PDFkeyInt);
                break;
            }
            case 14: {
                KeyArray objDecoder = new KeyArray(this.objectReader, i2, raw);
                i2 = objDecoder.readArray(pdfObject, PDFkeyInt);
                break;
            }
            case 18: {
                Array objDecoder = new Array(this.objectReader, i2, 18, raw);
                i2 = objDecoder.readArray(pdfObject, PDFkeyInt);
                break;
            }
            case 22: {
                ObjectArray objDecoder = new ObjectArray(this.objectReader, i2, raw);
                i2 = objDecoder.readArray(pdfObject, PDFkeyInt);
                break;
            }
            case 16: {
                DoubleArray objDecoder = new DoubleArray(this.objectReader, i2, raw);
                i2 = objDecoder.readArray(pdfObject, PDFkeyInt);
                break;
            }
            case 9: {
                IntArray objDecoder = new IntArray(this.objectReader, i2, raw);
                i2 = objDecoder.readArray(pdfObject, PDFkeyInt);
                break;
            }
            case 10: {
                FloatArray objDecoder = new FloatArray(this.objectReader, i2, raw);
                i2 = objDecoder.readArray(pdfObject, PDFkeyInt);
                break;
            }
            case 30: {
                i2 = Name.setNameStringValue(pdfObject, i2, raw, PDFkeyInt, this.objectReader);
                break;
            }
            case 8: {
                i2 = BooleanValue.set(pdfObject, i2, raw, PDFkeyInt, this.objectReader);
                break;
            }
            case 3: {
                i2 = StringValue.setStringConstantValue(pdfObject, i2, raw, PDFkeyInt, this.objectReader);
                break;
            }
            case 4: {
                i2 = StringValue.setStringKeyValue(pdfObject, i2, raw, PDFkeyInt);
                break;
            }
            case 6: {
                i2 = StreamReaderUtils.skipSpacesOrOtherCharacter(raw, i2, 47);
                i2 = NumberValue.setNumberValue(pdfObject, i2, raw, PDFkeyInt, this.objectReader);
                break;
            }
            case 46: {
                i2 = StreamReaderUtils.skipSpacesOrOtherCharacter(raw, i2, 47);
                i2 = NumberValue.setLongNumberValue(pdfObject, i2, raw, PDFkeyInt);
                break;
            }
            case 7: {
                i2 = FloatValue.setFloatValue(pdfObject, i2, raw, PDFkeyInt, this.objectReader);
                break;
            }
            case 5: {
                i2 = Dictionary.setUnreadDictionaryValue(pdfObject, i2, raw, PDFkeyInt, this.isInlineImage);
                break;
            }
            case 40: {
                if (raw.length - 5 > 0 && StreamReaderUtils.isNull(raw, i2 + 1)) {
                    i2 += 4;
                    break;
                }
                i2 = ObjectDecoder.setVariousValue(pdfObject, i2, raw, PDFkeyInt, this.objectReader);
                break;
            }
            case 1: {
                i2 = Dictionary.setDictionaryValue(pdfObject, i2, raw, PDFkeyInt, this.objectReader);
                break;
            }
            case 45: {
                i2 = Dictionary.setDictionaryValue(pdfObject, i2, raw, this.objectReader, PDFkeyInt, false);
            }
        }
        return i2;
    }

    private static int setVariousValue(PdfObject pdfObject, int i2, byte[] raw, int PDFkeyInt, PdfFileReader objectReader) {
        if (raw[i2] != 60) {
            ++i2;
        }
        if (debugFastCode) {
            System.out.println(padding + "Various value (first char=" + (char)raw[i2] + (char)raw[i2 + 1] + " )");
        }
        if (raw[i2] == 47) {
            i2 = Name.setNameStringValue(pdfObject, i2, raw, PDFkeyInt, objectReader);
        } else if (raw[i2] == 102 && raw[i2 + 1] == 97 && raw[i2 + 2] == 108 && raw[i2 + 3] == 115 && raw[i2 + 4] == 101) {
            pdfObject.setBoolean(PDFkeyInt, false);
            i2 += 4;
        } else if (raw[i2] == 116 && raw[i2 + 1] == 114 && raw[i2 + 2] == 117 && raw[i2 + 3] == 101) {
            pdfObject.setBoolean(PDFkeyInt, true);
            i2 += 3;
        } else {
            i2 = raw[i2] == 40 || raw[i2] == 60 && raw[i2 - 1] != 60 && raw[i2 + 1] != 60 ? TextStream.readTextStream(pdfObject, i2, raw, PDFkeyInt, objectReader) : (raw[i2] == 91 ? ArrayHandler.setArray(pdfObject, i2, raw, PDFkeyInt, objectReader) : (raw[i2] == 60 && raw[i2 + 1] == 60 ? Dictionary.readDictionary(pdfObject, i2, raw, PDFkeyInt, objectReader) : General.readGeneral(pdfObject, i2, raw, PDFkeyInt, objectReader)));
        }
        return i2;
    }

    public static synchronized boolean resolveFully(PdfObject pdfObject, PdfFileReader objectReader) {
        boolean fullyResolved;
        boolean bl2 = fullyResolved = pdfObject != null;
        if (fullyResolved) {
            byte[] raw = pdfObject.getStatus() == 0 ? StringUtils.toBytes(pdfObject.getObjectRefAsString()) : pdfObject.getUnresolvedData();
            pdfObject.setStatus(0);
            if (raw[0] != 101 && raw[1] != 110 && raw[2] != 100 && raw[3] != 111 && raw[4] != 98) {
                int j2;
                int keyStart = j2 = StreamReaderUtils.skipSpacesOrOtherCharacter(raw, 0, 91);
                j2 = StreamReaderUtils.skipToEndOfRef(raw, j2);
                int ref = NumberUtils.parseInt(keyStart, j2, raw);
                keyStart = j2 = StreamReaderUtils.skipSpaces(raw, j2);
                j2 = StreamReaderUtils.skipToEndOfRef(raw, j2);
                int generation = NumberUtils.parseInt(keyStart, j2, raw);
                if (raw[raw.length - 1] == 82) {
                    fullyResolved = ObjectDecoder.resolveFullyChildren(pdfObject, raw, ref, generation, objectReader);
                }
                if (fullyResolved) {
                    pdfObject.ignoreRecursion(false);
                    ObjectDecoder objDecoder = new ObjectDecoder(objectReader);
                    objDecoder.readDictionaryAsObject(pdfObject, j2, raw);
                }
            }
        }
        return fullyResolved;
    }

    private static boolean resolveFullyChildren(PdfObject pdfObject, byte[] raw, int ref, int generation, PdfFileReader objectReader) {
        boolean fullyResolved = true;
        pdfObject.setRef(new String(raw));
        pdfObject.isDataExternal(true);
        byte[] pageData = objectReader.readObjectAsByteArray(pdfObject, objectReader.isCompressed(ref, generation), ref, generation);
        if (pageData == null) {
            pdfObject.setFullyResolved(false);
            fullyResolved = false;
        } else {
            pdfObject.setUnresolvedData(pageData, 2004845231);
            pdfObject.isDataExternal(true);
            if (!ObjectDecoder.resolveFully(pdfObject, objectReader)) {
                pdfObject.setFullyResolved(false);
            }
        }
        return fullyResolved;
    }

    public final void checkResolved(PdfObject pdfObject) {
        if (pdfObject != null && pdfObject.getStatus() != 0) {
            byte[] raw = pdfObject.getUnresolvedData();
            pdfObject.setStatus(0);
            if (!(raw[0] == 101 && raw[1] == 110 && raw[2] == 100 && raw[3] == 111 && raw[4] == 98 || StreamReaderUtils.isNull(raw, 0))) {
                String objectRef = pdfObject.getObjectRefAsString();
                if (raw[raw.length - 1] == 82) {
                    objectRef = new String(raw);
                    pdfObject.setRef(objectRef);
                } else if (raw[0] != 60 && raw[raw.length - 1] == 62) {
                    ObjectDecoder.extractRefFromEnd(raw, pdfObject, this.objectReader);
                    return;
                }
                Dictionary.readDictionaryFromRefOrDirect(pdfObject, objectRef, 0, raw, -1, this.objectReader);
            }
        }
    }

    private static void extractRefFromEnd(byte[] raw, PdfObject pdfObject, PdfFileReader objectReader) {
        int ptr = 0;
        int len = raw.length;
        for (int jj = 0; jj < len; ++jj) {
            if (raw[jj] < 48 || raw[jj] > 57) continue;
            ptr = jj;
            break;
        }
        int end = ptr;
        while (raw[end] >= 48 && raw[end] <= 57 || raw[end] == 32 || raw[end] == 10 || raw[end] == 13 || raw[end] == 9) {
            ++end;
        }
        if (raw[end] == 111 && raw[end + 1] == 98 && raw[end + 2] == 106) {
            String objectRef = new String(raw, 0, end) + 'R';
            int newArrayLen = raw.length - end - 4;
            byte[] newArray = new byte[newArrayLen];
            System.arraycopy(raw, end + 4, newArray, 0, newArrayLen);
            raw = newArray;
            pdfObject.setRef(objectRef);
            Dictionary.readDictionaryFromRefOrDirect(pdfObject, objectRef, 0, raw, -1, objectReader);
        }
    }

    public void setEndPt(int dataPointer) {
        this.endPt = dataPointer;
    }

    static {
        padding = "";
    }
}

