/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.util.HashMap;
import java.util.Iterator;
import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.PdfFileReader;
import org.jpedal.objects.Javascript;
import org.jpedal.objects.raw.FSObject;
import org.jpedal.objects.raw.NamesObject;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfKeyPairsIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.objects.raw.XObject;
import org.jpedal.utils.StringUtils;

public class NameLookup
extends HashMap<String, Object> {
    private final PdfFileReader objectReader;
    private final HashMap<String, String> embeddedFiles = new HashMap();

    public NameLookup(PdfFileReader objectReader) {
        this.objectReader = objectReader;
    }

    public void readNames(PdfObject nameObject, Javascript javascript, boolean isKid) {
        PdfKeyPairsIterator keyPairs = nameObject.getKeyPairsIterator();
        if (keyPairs.getTokenCount() > 0) {
            while (keyPairs.hasMorePairs()) {
                this.put(keyPairs.getNextKeyAsString(), keyPairs.getNextValueAsString());
                keyPairs.nextPair();
            }
        } else {
            this.readNamesObject(nameObject, javascript, isKid);
        }
    }

    private void readNamesObject(PdfObject nameObject, Javascript javascript, boolean isKid) {
        ObjectDecoder objectDecoder = new ObjectDecoder(this.objectReader);
        objectDecoder.checkResolved(nameObject);
        int[] nameLists = new int[]{893600855, -1432117598, -2006286978, 1195921064};
        int count = nameLists.length;
        if (isKid) {
            count = 1;
        }
        for (int ii = 0; ii < count; ++ii) {
            PdfArrayIterator namesArray;
            int kidCount;
            PdfObject pdfObj = isKid ? nameObject : nameObject.getDictionary(nameLists[ii]);
            if (pdfObj == null) continue;
            byte[][] kidList = pdfObj.getKeyArray(456733763);
            if (kidList != null && (kidCount = kidList.length) > 0) {
                for (byte[] aKidList : kidList) {
                    String nextValue = new String(aKidList);
                    NamesObject nextObject = new NamesObject(nextValue);
                    nextObject.setUnresolvedData(aKidList, nameLists[ii]);
                    nextObject.ignoreRecursion(false);
                    objectDecoder.checkResolved(nextObject);
                    if (nextObject.getObjectRefAsString().equals(pdfObj.getObjectRefAsString())) continue;
                    this.readNames(nextObject, javascript, true);
                }
            }
            if ((namesArray = pdfObj.getMixedArray(826094945)) == null || namesArray.getTokenCount() <= 0) continue;
            block7: while (namesArray.hasMoreTokens()) {
                String name = nameLists[ii] == -1432117598 ? StringUtils.getTextString(namesArray.getNextValueAsByte(true), false) : namesArray.getNextValueAsString(true);
                if (!namesArray.hasMoreTokens()) continue;
                String value = namesArray.getNextValueAsString(true);
                switch (nameLists[ii]) {
                    case -1432117598: {
                        this.embeddedFiles.put(name, value);
                        continue block7;
                    }
                    case -2006286978: {
                        NameLookup.setJavaScriptName(value, objectDecoder, javascript, name);
                        continue block7;
                    }
                    case 1195921064: {
                        this.setXFAImage(value, objectDecoder, name);
                        continue block7;
                    }
                }
                this.put(name, value);
            }
        }
    }

    private void setXFAImage(String value, ObjectDecoder objectDecoder, String name) {
        XObject XFAImagesObj = new XObject(value);
        XFAImagesObj.decompressStreamWhenRead();
        byte[] xfaData = StringUtils.toBytes(value);
        if (value.contains(" ") || value.contains("<")) {
            XFAImagesObj.setUnresolvedData(xfaData, 979194486);
            objectDecoder.checkResolved(XFAImagesObj);
            byte[] decodedImageData = this.objectReader.readStream(XFAImagesObj, true, true, false, false, false, null);
            this.put(name, decodedImageData);
        }
    }

    private static void setJavaScriptName(String value, ObjectDecoder objectDecoder, Javascript javascript, String name) {
        String JSstring;
        NamesObject javascriptObj = new NamesObject(value);
        byte[] jsData = StringUtils.toBytes(value);
        if (jsData[0] != 60 && !value.endsWith(" R")) {
            return;
        }
        if (value.contains(" ") || value.contains("<")) {
            javascriptObj.setUnresolvedData(jsData, 6691);
            objectDecoder.checkResolved(javascriptObj);
            PdfObject JS = ((PdfObject)javascriptObj).getDictionary(6691);
            JSstring = JS != null ? new String(JS.getDecodedStream()) : ((PdfObject)javascriptObj).getTextStreamValue(6691);
        } else {
            JSstring = value;
        }
        if (JSstring != null) {
            javascript.setCode(name, JSstring);
        }
    }

    public Object[] getEmbeddedFiles() {
        Object[] returnValues = new Object[this.embeddedFiles.keySet().size() * 2];
        int ptr = 0;
        Iterator<String> embeddedFileNames = this.embeddedFiles.keySet().iterator();
        ObjectDecoder objectDecoder = new ObjectDecoder(this.objectReader);
        while (embeddedFileNames.hasNext()) {
            String name = embeddedFileNames.next();
            returnValues[ptr++] = name;
            String value = this.embeddedFiles.get(name);
            FSObject embeddedObj = new FSObject(value);
            byte[] jsData = StringUtils.toBytes(value);
            if (value.contains(" ") || value.contains("<")) {
                embeddedObj.setUnresolvedData(jsData, 6691);
                objectDecoder.checkResolved(embeddedObj);
                returnValues[ptr++] = embeddedObj;
                continue;
            }
            returnValues[ptr++] = null;
        }
        return returnValues;
    }
}

