/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import javax.swing.JFormattedTextField;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.text.NumberFormatter;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.viewer.gui.swing.SwingMenuItems;
import org.jpedal.external.ErrorTracker;

public class LimitDecodeTracker
implements ErrorTracker {
    private int pageCounted = -1;
    private int commandCounted;
    private int currentDecodePt;
    private int currentLimit = -1;
    private final PdfDecoder pdfDecoder;
    private String lastFilename = "";
    private boolean isCountingCommands;

    public LimitDecodeTracker(SwingMenuItems menuItems, PdfDecoder pdfDecoder) {
        this.pdfDecoder = pdfDecoder;
        JPanel commandPane = new JPanel();
        final JSlider slider = new JSlider();
        slider.setMajorTickSpacing(10);
        NumberFormat intFormat = NumberFormat.getIntegerInstance();
        NumberFormatter numberFormatter = new NumberFormatter(intFormat);
        numberFormatter.setValueClass(Integer.class);
        numberFormatter.setAllowsInvalid(false);
        numberFormatter.setMinimum(Integer.valueOf(0));
        final JFormattedTextField commandNumber = new JFormattedTextField(numberFormatter);
        commandNumber.setColumns(8);
        commandNumber.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e2) {
                super.keyTyped(e2);
                if (e2.getKeyChar() == '\n') {
                    String text = commandNumber.getText().replace(",", "");
                    int cmd = Integer.parseInt(text);
                    if (cmd > LimitDecodeTracker.this.commandCounted) {
                        cmd = LimitDecodeTracker.this.commandCounted;
                    }
                    slider.setValue(cmd);
                }
            }
        });
        commandNumber.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                super.mouseClicked(e2);
                commandNumber.selectAll();
            }
        });
        slider.addChangeListener(e2 -> {
            commandNumber.setText(String.valueOf(slider.getValue()));
            if (!slider.getValueIsAdjusting()) {
                this.currentLimit = slider.getValue();
                pdfDecoder.decodePage(pdfDecoder.getPageNumber());
                pdfDecoder.repaint();
            }
        });
        commandPane.add(slider);
        commandPane.add(commandNumber);
        JMenuItem limitDecode = new JMenuItem("Limit decode");
        limitDecode.addActionListener(e2 -> {
            numberFormatter.setMaximum(Integer.valueOf(this.commandCounted));
            slider.setMaximum(this.commandCounted);
            slider.setValue(this.currentLimit);
            JOptionPane.showMessageDialog(null, new Object[]{"Select a command: ", commandPane}, "Command Limiter", 1);
            this.currentLimit = this.commandCounted;
            pdfDecoder.decodePage(pdfDecoder.getPageNumber());
            pdfDecoder.repaint();
        });
        menuItems.getMenu(-1).add(limitDecode);
    }

    @Override
    public String getPageFailureMessage() {
        return "";
    }

    @Override
    public void addPageFailureMessage(String value) {
    }

    @Override
    public boolean ispageSuccessful() {
        return true;
    }

    @Override
    public boolean checkForExitRequest(int dataPointer, int streamSize) {
        if (this.currentDecodePt == this.currentLimit) {
            return true;
        }
        if (this.isCountingCommands) {
            ++this.commandCounted;
        }
        ++this.currentDecodePt;
        return false;
    }

    @Override
    public void finishedPageDecoding(int rawPage) {
        this.pageCounted = rawPage;
        this.currentLimit = this.commandCounted;
    }

    @Override
    public void startedPageDecoding(int rawPage) {
        String currentFilename = this.pdfDecoder.getFileName();
        if (this.lastFilename != null) {
            this.isCountingCommands = !this.lastFilename.equals(currentFilename) || this.pageCounted != rawPage;
        } else {
            boolean bl2 = this.isCountingCommands = currentFilename != null || this.pageCounted != rawPage;
        }
        if (this.isCountingCommands) {
            this.commandCounted = -1;
            this.currentLimit = -1;
            this.lastFilename = currentFilename;
            this.isCountingCommands = true;
        }
        this.currentDecodePt = 0;
    }
}

