/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jpedal.io.security.CryptoIDR;
import org.jpedal.utils.LogWriter;

public class IdrInputStream
extends FilterInputStream {
    private final CryptoIDR crypto;
    private int salt;

    public IdrInputStream(InputStream in, CryptoIDR crypto) {
        super(in);
        this.in = in;
        this.crypto = crypto;
        if (LogWriter.isRunningFromIDE) {
            LogWriter.writeLog(in + " " + this.crypto);
        }
    }

    @Override
    public long skip(long n2) throws IOException {
        long returnN = super.skip(n2);
        this.salt += (int)n2;
        return returnN;
    }

    @Override
    public int read() throws IOException {
        int read = super.read();
        byte decoded = this.crypto.decrypt((byte)(read & 0xFF), this.salt);
        ++this.salt;
        return decoded;
    }

    @Override
    public int read(byte[] b2) throws IOException {
        return this.read(b2, 0, b2.length);
    }

    @Override
    public int read(byte[] b2, int offset, int len) throws IOException {
        int result = super.read(b2, offset, len);
        int max = Math.min(b2.length - offset, len);
        for (int i2 = offset; i2 != max; ++i2) {
            byte decoded = this.crypto.decrypt((byte)(b2[i2] & 0xFF), this.salt);
            ++this.salt;
            b2[i2] = decoded;
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        super.close();
    }
}

