/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import com.idrsolutions.image.jpeg2000.EnumeratedSpace;
import com.idrsolutions.image.util.ColorSpaceConversion;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.jpedal.color.ColorSpaces;
import org.jpedal.utils.LogWriter;

public final class ColorSpaceConvertor {
    private ColorSpaceConvertor() {
    }

    public static BufferedImage convertFromICCCMYK(int width, int height, byte[] data) {
        return ColorSpaceConvertor.convertFromICCCMYK(width, height, data, 2700557);
    }

    public static BufferedImage convertFromICCCMYK(int width, int height, byte[] data, int intent) {
        int size = width * height * 4;
        if (data.length < size) {
            byte[] newData = new byte[size];
            System.arraycopy(data, 0, newData, 0, data.length);
            data = newData;
        }
        int dim = width * height;
        byte[] bp2 = new byte[dim * 3];
        EnumeratedSpace.convertCMYKToRGB(data, bp2, intent);
        BufferedImage img = new BufferedImage(width, height, 1);
        int[] pixels = ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
        int pos = 0;
        for (int i2 = 0; i2 < dim; ++i2) {
            int r2 = bp2[pos++] & 0xFF;
            int g2 = bp2[pos++] & 0xFF;
            int b2 = bp2[pos++] & 0xFF;
            pixels[i2] = r2 << 16 | g2 << 8 | b2;
        }
        return img;
    }

    public static BufferedImage convertToRGB(BufferedImage image) {
        try {
            image = ColorSpaceConversion.getBufferedImageAsRGB(image, ColorSpaces.hints);
        }
        catch (Exception e2) {
            LogWriter.writeLog("Exception " + e2 + " converting to RGB");
        }
        catch (Error ee) {
            LogWriter.writeLog("Error " + ee + " converting to RGB");
            image = null;
        }
        return image;
    }

    public static BufferedImage convertToARGB(BufferedImage image) {
        try {
            image = ColorSpaceConversion.getBufferedImageAsARGB(image);
        }
        catch (Exception e2) {
            LogWriter.writeLog("Exception " + e2 + " creating argb image");
        }
        return image;
    }

    public static BufferedImage convertIndexedToFlat(int d2, int w2, int h2, byte[] data, byte[] index, boolean isARGB, boolean isDownsampled) {
        int[] bands;
        int[] bandsRGB = new int[]{0, 1, 2};
        int[] bandsARGB = new int[]{0, 1, 2, 3};
        int components = 3;
        if (isARGB) {
            bands = bandsARGB;
            components = 4;
        } else {
            bands = bandsRGB;
        }
        byte[] newData = ColorSpaceConvertor.convertIndexToRGBByte(index, w2, h2, d2, data, isDownsampled, isARGB);
        BufferedImage image = isARGB ? new BufferedImage(w2, h2, 2) : new BufferedImage(w2, h2, 1);
        DataBufferByte db = new DataBufferByte(newData, newData.length);
        WritableRaster raster = Raster.createInterleavedRaster(db, w2, h2, w2 * components, components, bands, null);
        image.setData(raster);
        return image;
    }

    private static byte[] expand4bitData(byte[] data, int w2, int h2) {
        int newSize = w2 * h2 * 3;
        boolean isOdd = (w2 & 1) == 1;
        int scanLine = w2 * 3 + 1 >> 1;
        byte[] newData = new byte[newSize];
        int ptr = 0;
        int currentLine = 0;
        for (byte rawByte : data) {
            ++currentLine;
            newData[ptr] = (byte)(rawByte & 0xF0);
            if (newData[ptr] == -16) {
                newData[ptr] = -1;
            }
            ++ptr;
            if (currentLine == scanLine && isOdd) {
                currentLine = 0;
            } else {
                newData[ptr] = (byte)((rawByte & 0xF) << 4);
                if (newData[ptr] == -16) {
                    newData[ptr] = -1;
                }
                ++ptr;
            }
            if (ptr == newSize) break;
        }
        data = newData;
        return data;
    }

    public static byte[] normaliseTo8Bit(int comp, int d2, int w2, int h2, byte[] data) throws RuntimeException {
        if (d2 != 8) {
            int newSize = d2 == 16 ? data.length / 2 : w2 * h2;
            byte[] newData = new byte[newSize];
            switch (d2) {
                case 1: {
                    ColorSpaceConvertor.flatten1bpc(w2, data, null, false, newSize, 0, newData);
                    break;
                }
                case 2: {
                    ColorSpaceConvertor.flatten2bpc(w2, data, null, false, newSize, newData);
                    break;
                }
                case 4: {
                    if (comp == 3) {
                        newData = ColorSpaceConvertor.expand4bitData(data, w2, h2);
                        break;
                    }
                    ColorSpaceConvertor.flatten4bpc(w2, data, newSize, newData);
                    break;
                }
                case 16: {
                    for (int ptr = 0; ptr < newSize; ++ptr) {
                        newData[ptr] = data[ptr * 2];
                    }
                    break;
                }
                default: {
                    LogWriter.writeLog("unknown comp= " + d2);
                }
            }
            data = newData;
        }
        return data;
    }

    public static byte[] convertIndexToRGBByte(byte[] index, int w2, int h2, int d2, byte[] data, boolean isDownsampled, boolean isARGB) {
        int indexLength = 0;
        if (index != null) {
            indexLength = index.length;
        }
        int length = isARGB ? w2 * h2 * 4 : w2 * h2 * 3;
        byte[] newData = new byte[length];
        switch (d2) {
            case 8: {
                ColorSpaceConvertor.flatten8bpc(data, isDownsampled, length, newData, index, indexLength, isARGB);
                break;
            }
            case 4: {
                ColorSpaceConvertor.flatten4bpc(w2, data, index, isARGB, length, newData);
                break;
            }
            case 2: {
                ColorSpaceConvertor.flatten2bpc(w2, data, index, isARGB, length, newData);
                break;
            }
            case 1: {
                ColorSpaceConvertor.flatten1bpc(w2, data, index, isARGB, length, 255, newData);
            }
        }
        return newData;
    }

    private static void flatten8bpc(byte[] data, boolean isDownsampled, int length, byte[] newData, byte[] index, int indexLength, boolean isARGB) {
        int pt = 0;
        int id2 = 0;
        float ratio = 0.0f;
        for (byte currentByte : data) {
            if (pt >= length) break;
            if (isDownsampled) {
                ratio = (float)(currentByte & 0xFF) / 255.0f;
                if (ratio > 0.0f) {
                    newData[pt++] = (byte)((float)(255 - index[0]) * ratio);
                    newData[pt++] = (byte)((float)(255 - index[1]) * ratio);
                    newData[pt++] = (byte)((float)(255 - index[2]) * ratio);
                } else {
                    pt += 3;
                }
            } else {
                id2 = (currentByte & 0xFF) * 3;
                if (id2 < indexLength) {
                    newData[pt++] = index[id2];
                    newData[pt++] = index[id2 + 1];
                    newData[pt++] = index[id2 + 2];
                }
            }
            if (!isARGB) continue;
            newData[pt++] = id2 == 0 && ratio == 0.0f ? -1 : 0;
        }
    }

    private static void flatten4bpc(int w2, byte[] data, byte[] index, boolean isARGB, int length, byte[] newData) {
        int pt = 0;
        int[] shift = new int[]{4, 0};
        int widthReached = 0;
        block0: for (byte aData : data) {
            for (int samples = 0; samples < 2; ++samples) {
                int id1 = (aData >> shift[samples] & 0xF) * 3;
                if (pt >= length) continue block0;
                newData[pt++] = index[id1];
                newData[pt++] = index[id1 + 1];
                newData[pt++] = index[id1 + 2];
                if (isARGB) {
                    newData[pt++] = 0;
                }
                if (++widthReached != w2) continue;
                widthReached = 0;
                continue block0;
            }
        }
    }

    private static void flatten1bpc(int w2, byte[] data, byte[] index, boolean isARGB, int length, int transparency, byte[] newData) {
        int pt = 0;
        int widthReached = 0;
        block0: for (byte aData : data) {
            for (int bits = 0; bits < 8; ++bits) {
                int id2 = aData >> 7 - bits & 1;
                if (pt >= length) continue block0;
                if (isARGB) {
                    newData[pt++] = index[id2 *= 3];
                    newData[pt++] = index[id2 + 1];
                    newData[pt++] = index[id2 + 2];
                    newData[pt++] = id2 == 0 ? (byte)transparency : (byte)0;
                } else if (index == null) {
                    newData[pt++] = id2 == 1 ? -1 : 0;
                } else {
                    int comp = 3;
                    if (index.length == 2) {
                        byte v2 = index[id2];
                        for (int i2 = 0; i2 < 3; ++i2) {
                            newData[pt++] = v2;
                        }
                    } else {
                        id2 *= 3;
                        for (int ii = 0; ii < 3; ++ii) {
                            newData[pt++] = index[id2 + ii];
                        }
                    }
                }
                if (++widthReached != w2) continue;
                widthReached = 0;
                continue block0;
            }
        }
    }

    private static void flatten2bpc(int w2, byte[] data, byte[] index, boolean isARGB, int length, byte[] newData) {
        int pt = 0;
        int[] shift = new int[]{6, 4, 2, 0};
        int widthReached = 0;
        block0: for (byte aData : data) {
            for (int samples = 0; samples < 4 && pt < length; ++samples) {
                int id1;
                if (index == null) {
                    id1 = aData << shift[3 - samples] & 0xC0;
                    if (id1 == 192) {
                        id1 = 255;
                    }
                    newData[pt++] = (byte)id1;
                } else {
                    id1 = (aData >> shift[samples] & 3) * 3;
                    newData[pt++] = index[id1];
                    newData[pt++] = index[id1 + 1];
                    newData[pt++] = index[id1 + 2];
                    if (isARGB) {
                        newData[pt++] = 0;
                    }
                }
                if (++widthReached != w2) continue;
                widthReached = 0;
                continue block0;
            }
        }
    }

    public static BufferedImage convertColorspace(BufferedImage image, int newType) {
        try {
            image = ColorSpaceConversion.convertBufferedImageToColorSpace(image, newType);
        }
        catch (Exception e2) {
            LogWriter.writeLog("Exception " + e2 + " converting image");
        }
        return image;
    }

    private static double clip01(double value) {
        if (value < 0.0) {
            value = 0.0;
        }
        if (value > 1.0) {
            value = 1.0;
        }
        return value;
    }

    public static Raster createInterleavedRaster(byte[] data, int w2, int h2) {
        DataBufferByte db = new DataBufferByte(data, data.length);
        int[] bands = new int[]{0, 1, 2};
        return Raster.createInterleavedRaster(db, w2, h2, w2 * 3, 3, bands, null);
    }

    private static void flatten4bpc(int w2, byte[] data, int newSize, byte[] newData) {
        int ptr = 0;
        int currentLine = 0;
        boolean oddValues = (w2 & 1) == 1;
        for (byte rawByte : data) {
            currentLine += 2;
            newData[ptr] = (byte)(rawByte & 0xF0);
            if (newData[ptr] == -16) {
                newData[ptr] = -1;
            }
            ++ptr;
            if (oddValues && currentLine > w2) {
                currentLine = 0;
            } else {
                newData[ptr] = (byte)((rawByte & 0xF) << 4);
                if (newData[ptr] == -16) {
                    newData[ptr] = -1;
                }
                ++ptr;
            }
            if (ptr == newSize) break;
        }
    }

    public static BufferedImage algorithmicConvertCMYKImageToRGB(byte[] buffer, int w2, int h2) {
        BufferedImage image = null;
        byte[] new_data = new byte[w2 * h2 * 3];
        int pixelCount = w2 * h2 * 4;
        double lastC = -1.0;
        double lastM = -1.12;
        double lastY = -1.12;
        double lastK = -1.21;
        double x2 = 255.0;
        double outRed = 0.0;
        double outGreen = 0.0;
        double outBlue = 0.0;
        int pixelReached = 0;
        for (int i2 = 0; i2 < pixelCount; i2 += 4) {
            double inCyan = (double)(buffer[i2] & 0xFF) / 255.0;
            double inMagenta = (double)(buffer[i2 + 1] & 0xFF) / 255.0;
            double inYellow = (double)(buffer[i2 + 2] & 0xFF) / 255.0;
            double inBlack = (double)(buffer[i2 + 3] & 0xFF) / 255.0;
            if (lastC != inCyan || lastM != inMagenta || lastY != inYellow || lastK != inBlack) {
                double k2 = 1.0;
                double c2 = ColorSpaceConvertor.clip01(inCyan + inBlack);
                double m2 = ColorSpaceConvertor.clip01(inMagenta + inBlack);
                double y2 = ColorSpaceConvertor.clip01(inYellow + inBlack);
                double aw2 = (1.0 - c2) * (1.0 - m2) * (1.0 - y2);
                double ac2 = c2 * (1.0 - m2) * (1.0 - y2);
                double am2 = (1.0 - c2) * m2 * (1.0 - y2);
                double ay2 = (1.0 - c2) * (1.0 - m2) * y2;
                double ar2 = (1.0 - c2) * m2 * y2;
                double ag2 = c2 * (1.0 - m2) * y2;
                double ab2 = c2 * m2 * (1.0 - y2);
                outRed = 255.0 * ColorSpaceConvertor.clip01(aw2 + 0.9137 * am2 + 0.9961 * ay2 + 0.9882 * ar2);
                outGreen = 255.0 * ColorSpaceConvertor.clip01(aw2 + 0.6196 * ac2 + ay2 + 0.5176 * ag2);
                outBlue = 255.0 * ColorSpaceConvertor.clip01(aw2 + 0.7804 * ac2 + 0.5412 * am2 + 0.0667 * ar2 + 0.2118 * ag2 + 0.4863 * ab2);
                lastC = inCyan;
                lastM = inMagenta;
                lastY = inYellow;
                lastK = inBlack;
            }
            new_data[pixelReached++] = (byte)outRed;
            new_data[pixelReached++] = (byte)outGreen;
            new_data[pixelReached++] = (byte)outBlue;
        }
        try {
            image = new BufferedImage(w2, h2, 1);
            Raster raster = ColorSpaceConvertor.createInterleavedRaster(new_data, w2, h2);
            image.setData(raster);
        }
        catch (Exception e2) {
            LogWriter.writeLog("Exception " + e2 + " with 24 bit RGB image");
        }
        return image;
    }
}

