/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.images;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import org.jpedal.color.ColorSpaces;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.objects.GraphicsState;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Matrix;

public class ImageTransformerDouble {
    private Area clip;
    private BufferedImage current_image;
    private final float[][] CTM;
    private float[][] Trm;
    private float[][] Trm1;
    private float[][] Trm2;
    private int i_x;
    private int i_y;
    private int i_w;
    private int i_h;
    private final boolean scaleImage;
    private final float scaling;
    private final int pageRotation;

    public ImageTransformerDouble(GraphicsState currentGS, BufferedImage new_image, boolean scaleImage, float scaling, int pageRotation) {
        this.current_image = new_image;
        this.scaleImage = scaleImage;
        this.scaling = scaling;
        this.pageRotation = pageRotation;
        this.CTM = currentGS.CTM;
        this.createMatrices();
        if (currentGS.getClippingShape() != null) {
            this.clip = (Area)currentGS.getClippingShape().clone();
        }
        this.calcCoordinates();
    }

    public final void doubleScaleTransformShear() {
        this.scale(this.Trm1);
        if (this.clip != null) {
            Area final_clip = (Area)this.clip.clone();
            Area unscaled_clip = this.getUnscaledClip((Area)this.clip.clone());
            int segCount = ImageTransformerDouble.isRectangle(final_clip);
            this.clipImage(unscaled_clip, final_clip, segCount);
            this.i_x = (int)this.clip.getBounds2D().getMinX();
            this.i_y = (int)this.clip.getBounds2D().getMinY();
            this.i_w = (int)(this.clip.getBounds2D().getMaxX() - (double)this.i_x);
            this.i_h = (int)(this.clip.getBounds2D().getMaxY() - (double)this.i_y);
        } else if (this.current_image.getType() != 10) {
            this.current_image = ColorSpaceConvertor.convertToARGB(this.current_image);
        }
    }

    private static int isRectangle(Shape bounds) {
        int count;
        PathIterator i2 = bounds.getPathIterator(null);
        for (count = 0; !i2.isDone() && count < 8; ++count) {
            i2.next();
        }
        return count;
    }

    private void scale(float[][] Trm) {
        if ((double)Trm[0][0] != 1.0 || (double)Trm[1][1] != 1.0 || (double)Trm[0][1] != 0.0 || (double)Trm[1][0] != 0.0) {
            int w2 = this.current_image.getWidth();
            int h2 = this.current_image.getHeight();
            AffineTransform image_at = new AffineTransform(Trm[0][0], -Trm[0][1], -Trm[1][0], Trm[1][1], 0.0f, 0.0f);
            Area r2 = new Area(new Rectangle(0, 0, w2, h2));
            r2.transform(image_at);
            double ny = r2.getBounds2D().getY();
            double nx = r2.getBounds2D().getX();
            image_at = new AffineTransform((double)Trm[0][0], (double)(-Trm[0][1]), (double)(-Trm[1][0]), (double)Trm[1][1], -nx, -ny);
            AffineTransformOp invert = w2 > 10 & h2 > 10 ? new AffineTransformOp(image_at, ColorSpaces.hints) : new AffineTransformOp(image_at, null);
            if (this.scaleImage) {
                if (h2 == 1 && Trm[0][0] == 0.0f && Trm[0][1] > 0.0f && Trm[1][0] < 0.0f && Trm[1][1] == 0.0f) {
                    BufferedImage newImage = new BufferedImage(1, w2, 2);
                    for (int i2 = 0; i2 < w2; ++i2) {
                        int col = this.current_image.getRGB(i2, 0);
                        newImage.setRGB(0, w2 - 1 - i2, col);
                    }
                    this.current_image = newImage;
                } else {
                    this.current_image = invert.filter(this.current_image, null);
                }
            }
        }
    }

    private void createMatrices() {
        float y2;
        float y1;
        float x2;
        int w2 = (int)((float)this.current_image.getWidth() / this.scaling);
        int h2 = (int)((float)this.current_image.getHeight() / this.scaling);
        this.Trm = ImageTransformerDouble.initTrm(w2, h2, this.CTM);
        this.Trm1 = new float[3][3];
        this.Trm2 = new float[3][3];
        float x1 = this.CTM[0][0];
        if (x1 < 0.0f) {
            x1 = -x1;
        }
        if ((x2 = this.CTM[0][1]) < 0.0f) {
            x2 = -x2;
        }
        if ((y1 = this.CTM[1][1]) < 0.0f) {
            y1 = -y1;
        }
        if ((y2 = this.CTM[1][0]) < 0.0f) {
            y2 = -y2;
        }
        if ((double)this.CTM[0][0] == 0.0 || (double)this.CTM[1][1] == 0.0) {
            this.Trm1 = this.Trm;
        } else if ((double)this.CTM[0][1] == 0.0 && (double)this.CTM[1][0] == 0.0) {
            this.setStandardMatrix(w2, h2);
        } else {
            this.setMatrixWithSheer(w2, h2, x1, x2, y1, y2);
        }
        this.createScalingMatrix(w2, h2, x1, x2, y1, y2);
        ImageTransformerDouble.roundMatrix(this.Trm2);
    }

    private void createScalingMatrix(int w2, int h2, float x1, float x2, float y1, float y2) {
        this.Trm2[0][0] = x1 > x2 ? this.CTM[0][0] / (float)w2 : this.CTM[0][1] / (float)w2;
        if (this.Trm2[0][0] < 0.0f) {
            this.Trm2[0][0] = -this.Trm2[0][0];
        }
        this.Trm2[0][1] = 0.0f;
        this.Trm2[0][2] = 0.0f;
        this.Trm2[1][0] = 0.0f;
        this.Trm2[1][1] = y1 > y2 ? this.CTM[1][1] / (float)h2 : this.CTM[1][0] / (float)h2;
        if (this.Trm2[1][1] < 0.0f) {
            this.Trm2[1][1] = -this.Trm2[1][1];
        }
        this.Trm2[1][2] = 0.0f;
        this.Trm2[2][0] = 0.0f;
        this.Trm2[2][1] = 0.0f;
        this.Trm2[2][2] = 1.0f;
    }

    private static void roundMatrix(float[][] trm) {
        for (int y2 = 0; y2 < 3; ++y2) {
            for (int x2 = 0; x2 < 3; ++x2) {
                if (!((double)trm[x2][y2] > 0.99 & trm[x2][y2] < 1.0f)) continue;
                trm[x2][y2] = 1.0f;
            }
        }
    }

    private void setMatrixWithSheer(int w2, int h2, float x1, float x2, float y1, float y2) {
        this.Trm1[0][0] = x1 > x2 ? (float)w2 / this.CTM[0][0] : (float)w2 / this.CTM[0][1];
        if (this.Trm1[0][0] < 0.0f) {
            this.Trm1[0][0] = -this.Trm1[0][0];
        }
        this.Trm1[0][1] = 0.0f;
        this.Trm1[0][2] = 0.0f;
        this.Trm1[1][0] = 0.0f;
        this.Trm1[1][1] = y1 > y2 ? (float)h2 / this.CTM[1][1] : (float)h2 / this.CTM[1][0];
        if (this.Trm1[1][1] < 0.0f) {
            this.Trm1[1][1] = -this.Trm1[1][1];
        }
        this.Trm1[1][2] = 0.0f;
        this.Trm1[2][0] = 0.0f;
        this.Trm1[2][1] = 0.0f;
        this.Trm1[2][2] = 1.0f;
        this.Trm1 = Matrix.multiply(this.Trm, this.Trm1);
        ImageTransformerDouble.roundMatrix(this.Trm1);
    }

    private void setStandardMatrix(int w2, int h2) {
        this.Trm1[0][0] = (float)w2 / this.CTM[0][0];
        this.Trm1[0][1] = 0.0f;
        this.Trm1[0][2] = 0.0f;
        this.Trm1[1][0] = 0.0f;
        this.Trm1[1][1] = (float)h2 / this.CTM[1][1];
        this.Trm1[1][2] = 0.0f;
        this.Trm1[2][0] = 0.0f;
        this.Trm1[2][1] = 0.0f;
        this.Trm1[2][2] = 1.0f;
        this.Trm1 = Matrix.multiply(this.Trm, this.Trm1);
        ImageTransformerDouble.roundMatrix(this.Trm1);
        if (this.Trm1[2][0] < 0.0f && this.Trm1[0][0] > 0.0f && this.CTM[0][0] < 0.0f) {
            this.Trm1[2][0] = 0.0f;
            this.Trm1[0][0] = -1.0f;
        }
        if (this.Trm1[2][1] < 0.0f && this.Trm1[1][1] > 0.0f && this.CTM[1][1] < 0.0f && this.CTM[0][0] < 0.0f) {
            this.Trm1[2][1] = 0.0f;
            this.Trm1[1][1] = -1.0f;
        }
    }

    private static float[][] initTrm(int w2, int h2, float[][] CTM) {
        float[][] Trm = new float[3][3];
        Trm[0][0] = CTM[0][0] / (float)w2;
        Trm[0][1] = CTM[0][1] / (float)w2;
        Trm[0][2] = 0.0f;
        Trm[1][0] = CTM[1][0] / (float)h2;
        Trm[1][1] = CTM[1][1] / (float)h2;
        Trm[1][2] = 0.0f;
        Trm[2][0] = CTM[2][0];
        Trm[2][1] = CTM[2][1];
        Trm[2][2] = 1.0f;
        ImageTransformerDouble.roundMatrix(Trm);
        return Trm;
    }

    private void calcCoordinates() {
        if (this.CTM[1][0] == 0.0f & this.CTM[0][1] == 0.0f) {
            this.i_x = (int)this.CTM[2][0];
            this.i_y = (int)this.CTM[2][1];
            this.i_w = (int)this.CTM[0][0];
            this.i_h = (int)this.CTM[1][1];
            if (this.i_w < 0) {
                this.i_w = -this.i_w;
            }
            if (this.i_h < 0) {
                this.i_h = -this.i_h;
            }
        } else {
            this.i_w = (int)Math.sqrt(this.CTM[0][0] * this.CTM[0][0] + this.CTM[0][1] * this.CTM[0][1]);
            this.i_h = (int)Math.sqrt(this.CTM[1][1] * this.CTM[1][1] + this.CTM[1][0] * this.CTM[1][0]);
            if (this.CTM[1][0] > 0.0f & this.CTM[0][1] < 0.0f) {
                this.i_x = (int)this.CTM[2][0];
                this.i_y = (int)(this.CTM[2][1] + this.CTM[0][1]);
            } else if (this.CTM[1][0] < 0.0f & this.CTM[0][1] > 0.0f) {
                this.i_x = (int)(this.CTM[2][0] + this.CTM[1][0]);
                this.i_y = (int)this.CTM[2][1];
            } else {
                this.i_x = (int)this.CTM[2][0];
                this.i_y = (int)this.CTM[2][1];
            }
        }
        if (this.CTM[1][1] < 0.0f) {
            this.i_y -= this.i_h;
        }
        if (this.CTM[0][0] < 0.0f) {
            this.i_x -= this.i_w;
        }
    }

    public final int getImageY() {
        return this.i_y;
    }

    public final BufferedImage getImage() {
        return this.current_image;
    }

    public final int getImageW() {
        return this.i_w;
    }

    public final int getImageH() {
        return this.i_h;
    }

    public final int getImageX() {
        return this.i_x;
    }

    private void clipImage(Area final_clip, Area unscaled_clip, int segCount) {
        boolean inverted;
        double shape_x = unscaled_clip.getBounds2D().getX();
        double shape_y = unscaled_clip.getBounds2D().getY();
        int image_w = this.current_image.getWidth();
        int image_h = this.current_image.getHeight();
        int x2 = (int)final_clip.getBounds().getX();
        int y2 = (int)final_clip.getBounds().getY();
        int w2 = (int)final_clip.getBounds().getWidth();
        int h2 = (int)final_clip.getBounds().getHeight();
        if (segCount > 5) {
            AffineTransform image_at = new AffineTransform();
            image_at.scale(1.0, -1.0);
            image_at.translate(0.0, -this.current_image.getHeight());
            AffineTransformOp invert = new AffineTransformOp(image_at, ColorSpaces.hints);
            this.current_image = invert.filter(this.current_image, null);
            Area inverseClip = new Area(new Rectangle(0, 0, image_w, image_h));
            inverseClip.exclusiveOr(final_clip);
            this.current_image = ColorSpaceConvertor.convertToARGB(this.current_image);
            Graphics2D image_g2 = this.current_image.createGraphics();
            image_g2.setComposite(AlphaComposite.Clear);
            image_g2.fill(inverseClip);
            AffineTransform image_at2 = new AffineTransform();
            image_at2.scale(1.0, -1.0);
            image_at2.translate(0.0, -this.current_image.getHeight());
            AffineTransformOp invert3 = new AffineTransformOp(image_at2, ColorSpaces.hints);
            this.current_image = invert3.filter(this.current_image, null);
        }
        boolean bl2 = inverted = this.CTM[1][1] < 0.0f && this.pageRotation == 0 && this.CTM[0][0] > 0.0f && this.CTM[1][0] == 0.0f && this.CTM[0][1] == 0.0f;
        if (!inverted) {
            y2 = image_h - h2 - y2;
        }
        if (y2 < 0) {
            y2 = 0;
        }
        if (x2 < 0) {
            w2 -= x2;
            x2 = 0;
        }
        if (w2 > image_w) {
            w2 = image_w;
        }
        if (h2 > image_h) {
            h2 = image_h;
        }
        if (y2 + h2 > image_h) {
            h2 = image_h - y2;
        }
        if (x2 + w2 > image_w) {
            w2 = image_w - x2;
        }
        if (!(h2 < 1 || w2 < 1 || x2 == 0 && y2 == 0 && w2 == this.current_image.getWidth() && h2 == this.current_image.getHeight() || this.CTM[1][1] == 0.0f && this.pageRotation == 0 && this.CTM[0][0] == 0.0f && this.CTM[1][0] < 0.0f && this.CTM[0][1] > 0.0f)) {
            try {
                this.current_image = this.current_image.getSubimage(x2, y2, w2, h2);
            }
            catch (Error | Exception e2) {
                LogWriter.writeLog("Exception " + e2 + " extracting clipped image with values x=" + x2 + " y=" + y2 + " w=" + w2 + " h=" + h2 + " from image " + this.current_image);
            }
        }
        double x1 = (double)this.i_x > shape_x ? (double)this.i_x : shape_x;
        double y1 = (double)this.i_y > shape_y ? (double)this.i_y : shape_y;
        this.i_x = (int)x1;
        this.i_y = (int)y1;
        this.i_w = w2;
        this.i_h = h2;
    }

    private Area getUnscaledClip(Area final_clip) {
        double dx = -this.CTM[2][0];
        double dy = -this.CTM[2][1];
        if (this.CTM[1][0] < 0.0f) {
            dx -= (double)this.CTM[1][0];
        }
        if (this.CTM[0][0] < 0.0f && this.CTM[1][0] >= 0.0f) {
            dx -= (double)this.CTM[1][0];
        }
        if (this.CTM[0][1] < 0.0f) {
            dy -= (double)this.CTM[0][1];
        }
        if (this.CTM[1][1] < 0.0f) {
            dy = this.CTM[0][1] > 0.0f ? (dy -= (double)this.CTM[0][1]) : (dy -= (double)this.CTM[1][1]);
        }
        AffineTransform align_clip = new AffineTransform();
        align_clip.translate(dx, dy);
        final_clip.transform(align_clip);
        AffineTransform invert2 = new AffineTransform(1.0f / this.Trm2[0][0], 0.0f, 0.0f, 1.0f / this.Trm2[1][1], 0.0f, 0.0f);
        final_clip.transform(invert2);
        int dxx = (int)final_clip.getBounds().getX();
        if (dxx < 0) {
            final_clip.transform(AffineTransform.getTranslateInstance(-dxx, 0.0));
        }
        return final_clip;
    }
}

