/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.images;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import org.jpedal.color.ColorSpaces;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.objects.GraphicsState;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Matrix;

public class ImageTransformer {
    private BufferedImage current_image;
    private final float[][] Trm;
    private final float[][] CTM;
    private int i_x;
    private int i_y;
    private int i_w;
    private int i_h;

    public ImageTransformer(GraphicsState current_graphics_state, BufferedImage new_image) {
        this.current_image = new_image;
        int w2 = this.current_image.getWidth();
        int h2 = this.current_image.getHeight();
        this.CTM = current_graphics_state.CTM;
        this.Trm = new float[3][3];
        this.Trm[0][0] = this.CTM[0][0] / (float)w2;
        this.Trm[0][1] = -(this.CTM[0][1] / (float)w2);
        this.Trm[1][0] = -(this.CTM[1][0] / (float)h2);
        this.Trm[1][1] = this.CTM[1][1] / (float)h2;
        this.Trm[2][0] = this.CTM[2][0];
        this.Trm[2][1] = this.CTM[2][1];
        this.Trm[2][2] = 1.0f;
        for (int y2 = 0; y2 < 3; ++y2) {
            for (int x2 = 0; x2 < 3; ++x2) {
                if (!((double)this.Trm[x2][y2] > 0.99 & this.Trm[x2][y2] < 1.0f)) continue;
                this.Trm[x2][y2] = 1.0f;
            }
        }
        this.scale(w2, h2);
        this.calcCoordinates();
    }

    private void scale(int w2, int h2) {
        if ((double)this.Trm[0][0] != 1.0 || (double)this.Trm[1][1] != 1.0 || (double)this.Trm[0][1] != 0.0 || (double)this.Trm[1][0] != 0.0) {
            AffineTransformOp invert;
            AffineTransform image_at = Matrix.toAffine(this.Trm);
            Area r2 = new Area(new Rectangle(0, 0, w2, h2));
            r2.transform(image_at);
            double ny = r2.getBounds2D().getY();
            double nx = r2.getBounds2D().getX();
            float a10 = this.Trm[0][0];
            float b2 = this.Trm[0][1];
            float c2 = this.Trm[1][0];
            float d2 = this.Trm[1][1];
            image_at = new AffineTransform((double)a10, (double)c2, (double)b2, (double)d2, -nx, -ny);
            if (a10 < 0.0f) {
                a10 = -a10;
            }
            if (b2 < 0.0f) {
                b2 = -b2;
            }
            if (c2 < 0.0f) {
                c2 = -c2;
            }
            if (d2 < 0.0f) {
                d2 = -d2;
            }
            if (a10 > 5.0f || b2 > 5.0f || c2 > 5.0f || d2 > 5.0f) {
                return;
            }
            if (w2 > 1 && h2 > 1) {
                if (this.CTM[0][0] == 0.0f && this.CTM[1][1] == 0.0f && this.CTM[0][1] > 0.0f && this.CTM[1][0] < 0.0f) {
                    image_at.scale(-1.0, 1.0);
                    image_at.translate(-this.current_image.getWidth(), 0.0);
                }
                invert = new AffineTransformOp(image_at, ColorSpaces.hints);
            } else {
                boolean isSolid = true;
                if (h2 == 1) {
                    WritableRaster ras = this.current_image.getRaster();
                    int bands = ras.getNumBands();
                    int width = ras.getWidth();
                    int[] elements = new int[width * bands + 1];
                    ras.getPixels(0, 0, width, 1, elements);
                    for (int j2 = 0; j2 < bands; ++j2) {
                        int first = elements[0];
                        for (int i2 = 1; i2 < width; ++i2) {
                            if (elements[i2 * j2] == first) continue;
                            isSolid = false;
                            i2 = width;
                            j2 = bands;
                        }
                    }
                }
                invert = isSolid ? new AffineTransformOp(image_at, null) : new AffineTransformOp(image_at, ColorSpaces.hints);
            }
            if (this.CTM[1][0] != 0.0f || this.CTM[0][1] != 0.0f) {
                this.current_image = ColorSpaceConvertor.convertToARGB(this.current_image);
            }
            this.scaleImage(h2, image_at, r2, invert);
        }
    }

    private void scaleImage(int h2, AffineTransform image_at, Area r2, AffineTransformOp invert) {
        int newW = (int)r2.getBounds2D().getWidth();
        int newH = (int)(r2.getBounds2D().getHeight() + 0.7);
        if (newH < 1) {
            newH = 1;
        }
        if (newW < 1) {
            newW = 1;
        }
        BufferedImage destImage = new BufferedImage(newW, newH, 2);
        if (h2 > 1) {
            boolean failed = false;
            try {
                invert.filter(this.current_image, destImage);
                this.current_image = destImage;
            }
            catch (Exception e2) {
                LogWriter.writeLog("Exception: " + e2.getMessage());
                failed = true;
            }
            if (failed) {
                try {
                    invert = new AffineTransformOp(image_at, null);
                    this.current_image = invert.filter(this.current_image, null);
                }
                catch (Exception e3) {
                    LogWriter.writeLog("Exception: " + e3.getMessage());
                }
            }
        }
    }

    private void calcCoordinates() {
        if (this.CTM[1][0] == 0.0f && this.CTM[0][1] == 0.0f) {
            this.i_x = (int)this.CTM[2][0];
            this.i_y = (int)this.CTM[2][1];
            this.i_w = (int)this.CTM[0][0];
            this.i_h = (int)this.CTM[1][1];
            if (this.i_w < 0) {
                this.i_w = -this.i_w;
            }
            if (this.i_h < 0) {
                this.i_h = -this.i_h;
            }
        } else {
            this.i_w = (int)Math.sqrt(this.CTM[0][0] * this.CTM[0][0] + this.CTM[0][1] * this.CTM[0][1]);
            this.i_h = (int)Math.sqrt(this.CTM[1][1] * this.CTM[1][1] + this.CTM[1][0] * this.CTM[1][0]);
            if (this.CTM[1][0] > 0.0f && this.CTM[0][1] < 0.0f) {
                this.i_x = (int)this.CTM[2][0];
                this.i_y = (int)(this.CTM[2][1] + this.CTM[0][1]);
            } else if (this.CTM[1][0] < 0.0f && this.CTM[0][1] > 0.0f) {
                this.i_x = (int)(this.CTM[2][0] + this.CTM[1][0]);
                this.i_y = (int)this.CTM[2][1];
            } else {
                this.i_x = (int)this.CTM[2][0];
                this.i_y = (int)this.CTM[2][1];
            }
        }
        if (this.CTM[1][1] < 0.0f) {
            this.i_y -= this.i_h;
        }
        if (this.CTM[0][0] < 0.0f) {
            this.i_x -= this.i_w;
        }
    }

    public final int getImageY() {
        return this.i_y;
    }

    public final BufferedImage getImage() {
        return this.current_image;
    }

    public final int getImageW() {
        return this.i_w;
    }

    public final int getImageH() {
        return this.i_h;
    }

    public final int getImageX() {
        return this.i_x;
    }

    public final void clipImage(Area current_shape) {
        Area final_clip = (Area)current_shape.clone();
        int image_w = this.current_image.getWidth();
        int image_h = this.current_image.getHeight();
        double shape_x = final_clip.getBounds2D().getX();
        double shape_y = final_clip.getBounds2D().getY();
        double shape_h = final_clip.getBounds2D().getHeight();
        double d_y = (double)image_h - shape_h;
        AffineTransform upside_down = new AffineTransform();
        upside_down.translate(-shape_x, -shape_y);
        upside_down.scale(1.0, -1.0);
        upside_down.translate(shape_x, -(shape_y + shape_h));
        final_clip.transform(upside_down);
        AffineTransform align_clip = new AffineTransform();
        align_clip.translate(-this.i_x, (double)this.i_y + d_y);
        final_clip.transform(align_clip);
        double x2 = final_clip.getBounds2D().getX();
        double y2 = final_clip.getBounds2D().getY();
        double w2 = final_clip.getBounds2D().getWidth();
        double h2 = final_clip.getBounds2D().getHeight();
        BufferedImage offscreen = new BufferedImage(image_w, image_h, ImageTransformer.getImage_type(this.current_image));
        Graphics2D image_g2 = offscreen.createGraphics();
        if (!offscreen.getColorModel().hasAlpha()) {
            image_g2.setBackground(Color.white);
            image_g2.fill(new Rectangle(0, 0, image_w, image_h));
        }
        image_g2.setClip(final_clip);
        try {
            image_g2.drawImage((Image)this.current_image, 0, 0, null);
        }
        catch (Exception e2) {
            LogWriter.writeLog("Exception " + e2 + " plotting clipping image");
        }
        if (y2 < 0.0) {
            h2 += y2;
            y2 = 0.0;
        }
        if (x2 < 0.0) {
            w2 += x2;
            x2 = 0.0;
        }
        if (w2 > (double)image_w) {
            w2 = image_w;
        }
        if (h2 > (double)image_h) {
            h2 = image_h;
        }
        if (y2 + h2 > (double)image_h) {
            h2 = (double)image_h - y2;
        }
        if (x2 + w2 > (double)image_w) {
            w2 = (double)image_w - x2;
        }
        try {
            this.current_image = offscreen.getSubimage((int)x2, (int)y2, (int)w2, (int)h2);
        }
        catch (Exception e3) {
            LogWriter.writeLog("Exception " + e3 + " extracting clipped image with values x=" + x2 + " y=" + y2 + " w=" + w2 + " h=" + h2 + " from image ");
        }
        double x1 = (double)this.i_x > shape_x ? (double)this.i_x : shape_x;
        double y1 = (double)this.i_y > shape_y ? (double)this.i_y : shape_y;
        this.i_x = (int)x1;
        this.i_y = (int)y1;
        this.i_w = (int)w2;
        this.i_h = (int)h2;
    }

    private static int getImage_type(BufferedImage current_image) {
        int image_type = current_image.getType();
        if (image_type == 0 || image_type == 1) {
            image_type = 2;
        }
        return image_type;
    }
}

