/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.images;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.util.Arrays;
import org.jpedal.utils.LogWriter;

public final class ImageSmoother {
    private ImageSmoother() {
    }

    public static BufferedImage smoothImage(BufferedImage image, int xRadius, int yRadius) {
        int size = xRadius * yRadius;
        float weight = 1.0f / (float)size;
        if (xRadius != 1 || yRadius != 1) {
            try {
                float[] data2 = new float[size];
                Arrays.fill(data2, weight);
                Kernel kernel = new Kernel(xRadius, yRadius, data2);
                ConvolveOp op = new ConvolveOp(kernel, 1, null);
                BufferedImage preMultipliedAlphaImage = new BufferedImage(image.getWidth(), image.getHeight(), 3);
                preMultipliedAlphaImage.createGraphics().drawImage((Image)image, 0, 0, null);
                return op.filter(preMultipliedAlphaImage, null);
            }
            catch (Exception e2) {
                LogWriter.writeLog("Failed to Smooth Image - " + e2.getMessage());
            }
        }
        return image;
    }
}

