/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.grouping;

import java.util.ArrayList;
import org.jpedal.exception.PdfException;
import org.jpedal.grouping.Fragment;
import org.jpedal.grouping.GroupingUtils;
import org.jpedal.grouping.LineData;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.objects.PdfData;
import org.jpedal.utils.Fonts;
import org.jpedal.utils.Sorts;
import org.jpedal.utils.Strip;

abstract class PdfTextExtractionUtils {
    static final String SYSTEM_LINE_SEPARATOR = System.getProperty("line.separator");
    boolean[] isUsed;
    float[] f_x1;
    float[] f_x2;
    float[] f_y1;
    float[] f_y2;
    private boolean[] hadSpace;
    String[] f_colorTag;
    int[] writingMode;
    int[] fontSize;
    private float[] spaceWidth;
    StringBuilder[] content;
    private int[] textLength;
    final PdfData pdf_data;
    int nextSlot;
    int master;
    boolean colorExtracted;
    private static final int CONTENT_ARRAY_INCREMENT = 100;
    final boolean isXMLExtraction;

    PdfTextExtractionUtils(PdfData pdf_data, boolean isXMLExtraction) {
        this.pdf_data = pdf_data;
        this.isXMLExtraction = isXMLExtraction;
        this.colorExtracted = pdf_data.isColorExtracted();
    }

    void cleanupShadowsAndDrownedObjects(boolean avoidSpaces) {
        int[] items = GroupingUtils.getUnusedFragments(this.isUsed);
        int count = items.length;
        for (int p2 = 0; p2 < count; ++p2) {
            int c2 = items[p2];
            if (this.isUsed[c2]) continue;
            float midX = (this.f_x1[c2] + this.f_x2[c2]) / 2.0f;
            float midY = (this.f_y1[c2] + this.f_y2[c2]) / 2.0f;
            for (int p22 = p2 + 1; p22 < count; ++p22) {
                String separator;
                boolean b_in_a;
                float diff;
                int n2 = items[p22];
                if (this.f_x1[n2] == this.f_x2[n2] || this.isUsed[n2] || this.isUsed[c2]) continue;
                float fontDiff = this.fontSize[n2] - this.fontSize[c2];
                if (fontDiff < 0.0f) {
                    fontDiff = -fontDiff;
                }
                if ((diff = this.f_x2[n2] - this.f_x1[n2] - (this.f_x2[c2] - this.f_x1[c2])) < 0.0f) {
                    diff = -diff;
                }
                if (fontDiff == 0.0f && midX > this.f_x1[n2] && midX < this.f_x2[n2] && diff < 10.0f && midY < this.f_y1[n2] && midY > this.f_y2[n2]) {
                    String contentForC;
                    if (avoidSpaces) {
                        this.isUsed[n2] = true;
                        continue;
                    }
                    String contentForN = Strip.trim(Strip.stripXML(GroupingUtils.removeHiddenMarkers(this.content[n2]), true)).toString();
                    if (!contentForN.equals(contentForC = Strip.trim(Strip.stripXML(GroupingUtils.removeHiddenMarkers(this.content[c2]), true)).toString())) continue;
                    this.isUsed[n2] = true;
                    continue;
                }
                boolean a_in_b = this.f_x1[n2] > this.f_x1[c2] && this.f_x2[n2] < this.f_x2[c2] && this.f_y1[n2] < this.f_y1[c2] && this.f_y2[n2] > this.f_y2[c2];
                boolean bl2 = b_in_a = this.f_x1[c2] > this.f_x1[n2] && this.f_x2[c2] < this.f_x2[n2] && this.f_y1[c2] < this.f_y1[n2] && this.f_y2[c2] > this.f_y2[n2];
                if (!a_in_b && !b_in_a) continue;
                if (this.f_y2[c2] > this.f_y2[n2]) {
                    separator = GroupingUtils.getLineDownSeparator(this.content[c2], this.content[n2], this.isXMLExtraction);
                    if (!avoidSpaces || separator.indexOf(32) == -1) {
                        this.merge(c2, n2, separator, true);
                    }
                } else {
                    separator = GroupingUtils.getLineDownSeparator(this.content[n2], this.content[c2], this.isXMLExtraction);
                    if (!avoidSpaces || separator.indexOf(32) == -1) {
                        this.merge(n2, c2, separator, true);
                    }
                }
                midX = (this.f_x1[c2] + this.f_x2[c2]) / 2.0f;
                midY = (this.f_y1[c2] + this.f_y2[c2]) / 2.0f;
            }
        }
    }

    private String isGapASpace(int c2, int l2, float actualGap, boolean addMultiplespaceXMLTag, int writingMode) {
        int spaceCount;
        String sep = "";
        float gapA = this.spaceWidth[c2] * (float)this.fontSize[c2];
        float gapB = this.spaceWidth[l2] * (float)this.fontSize[l2];
        float gap = Math.min(gapA, gapB);
        if ((gap = actualGap / (gap / 1000.0f)) > 0.51f && gap < 1.0f) {
            gap = 1.0f;
        }
        if ((spaceCount = (int)gap) > 0) {
            sep = " ";
        }
        if (spaceCount > 1 && addMultiplespaceXMLTag && writingMode == 0) {
            sep = " <SpaceCount space=\"" + spaceCount + "\" />";
        }
        return sep;
    }

    void merge(int m2, int c2, String separator, boolean moveFont) {
        if (this.f_x1[m2] > this.f_x1[c2]) {
            this.f_x1[m2] = this.f_x1[c2];
        }
        if (this.f_y1[m2] < this.f_y1[c2]) {
            this.f_y1[m2] = this.f_y1[c2];
        }
        if (this.f_x2[m2] < this.f_x2[c2]) {
            this.f_x2[m2] = this.f_x2[c2];
        }
        if (this.f_y2[m2] > this.f_y2[c2]) {
            this.f_y2[m2] = this.f_y2[c2];
        }
        if (this.isXMLExtraction) {
            String test = "</font>";
            if (this.colorExtracted) {
                test = "</font></color>";
            }
            if (moveFont && this.content[m2].toString().lastIndexOf(test) != -1) {
                String masterContent = this.content[m2].toString();
                this.content[m2] = new StringBuilder(masterContent.substring(0, masterContent.lastIndexOf(test)));
                this.content[m2].append(separator);
                this.content[m2].append(masterContent.substring(masterContent.lastIndexOf(test)));
            } else {
                this.content[m2].append(separator);
            }
            if (this.textLength[c2] > 1 && this.content[m2].toString().endsWith(" ")) {
                this.content[m2].deleteCharAt(this.content[m2].lastIndexOf(" "));
            }
            if (this.content[c2].indexOf("<color") != -1 && this.content[m2].indexOf("<color") != -1 && this.content[c2].toString().startsWith(this.content[m2].substring(this.content[m2].lastIndexOf("<color"), this.content[m2].indexOf(">", this.content[m2].lastIndexOf("<color")))) && this.content[m2].lastIndexOf("</color>") + 7 == this.content[m2].lastIndexOf(">")) {
                this.content[c2].replace(this.content[c2].indexOf("<color"), this.content[c2].indexOf(">") + 1, "");
                this.content[m2].replace(this.content[m2].lastIndexOf("</color>"), this.content[m2].lastIndexOf("</color>") + 8, "");
            }
            if (this.content[c2].indexOf("<font") != -1 && this.content[m2].indexOf("<font") != -1 && this.content[c2].toString().startsWith(this.content[m2].substring(this.content[m2].lastIndexOf("<font"), this.content[m2].indexOf(">", this.content[m2].lastIndexOf("<font")))) && this.content[m2].lastIndexOf("</font>") + 6 == this.content[m2].lastIndexOf(">")) {
                this.content[c2].replace(this.content[c2].indexOf("<font"), this.content[c2].indexOf(">") + 1, "");
                this.content[m2].replace(this.content[m2].lastIndexOf("</font>"), this.content[m2].lastIndexOf("</font>") + 7, "");
            }
            this.content[m2] = this.content[m2].append((CharSequence)this.content[c2]);
        } else {
            this.content[m2] = this.content[m2].append(separator).append((CharSequence)this.content[c2]);
        }
        int n2 = m2;
        this.textLength[n2] = this.textLength[n2] + this.textLength[c2];
        this.isUsed[c2] = true;
        this.content[c2] = null;
    }

    void copyToArrays() {
        this.colorExtracted = this.pdf_data.isColorExtracted();
        int count = this.pdf_data.getRawTextElementCount();
        this.isUsed = new boolean[count];
        this.fontSize = new int[count];
        this.writingMode = new int[count];
        this.spaceWidth = new float[count];
        this.content = new StringBuilder[count];
        this.textLength = new int[count];
        this.f_x1 = new float[count];
        this.f_colorTag = new String[count];
        this.f_x2 = new float[count];
        this.f_y1 = new float[count];
        this.f_y2 = new float[count];
        for (int i2 = 0; i2 < count; ++i2) {
            this.content[i2] = new StringBuilder(this.pdf_data.contents[i2]);
            this.fontSize[i2] = this.pdf_data.f_end_font_size[i2];
            this.writingMode[i2] = this.pdf_data.f_writingMode[i2];
            this.f_x1[i2] = this.pdf_data.f_x1[i2];
            this.f_colorTag[i2] = this.pdf_data.colorTag[i2];
            this.f_x2[i2] = this.pdf_data.f_x2[i2];
            this.f_y1[i2] = this.pdf_data.f_y1[i2];
            this.f_y2[i2] = this.pdf_data.f_y2[i2];
            this.spaceWidth[i2] = this.pdf_data.space_width[i2];
            this.textLength[i2] = this.pdf_data.text_length[i2];
        }
    }

    void copyToArrays(float minX, float minY, float maxX, float maxY, boolean keepFont, boolean breakOnSpace, String punctuation, boolean isWordlist) {
        int count = this.pdf_data.getRawTextElementCount();
        this.initArrays(count + 100);
        for (int i2 = 0; i2 < count; ++i2) {
            Fragment fragment = new Fragment(this.pdf_data, i2);
            if (!GroupingUtils.isFragmentWithinArea(fragment, minX, minY, maxX, maxY)) continue;
            this.processFragment(minX, minY, maxX, maxY, keepFont, breakOnSpace, punctuation, isWordlist, fragment, i2);
        }
        this.isUsed = new boolean[this.nextSlot];
    }

    private void processFragment(float minX, float minY, float maxX, float maxY, boolean keepFont, boolean breakOnSpace, String punctuation, boolean isWordlist, Fragment fragment, int i2) {
        StringBuilder text = new StringBuilder();
        fragment.init(minX, minY, maxX, maxY);
        char[] line = fragment.getRawData().toCharArray();
        int end = line.length;
        int pointer = 0;
        if (!fragment.getRawData().contains(PdfData.marker)) {
            text = new StringBuilder(fragment.getRawData());
        }
        boolean isFirstValue = true;
        boolean breakPointset = false;
        while (pointer < end) {
            boolean endsWithPunctuation;
            do {
                if (line[pointer] != PdfGroupingAlgorithms.MARKER2) {
                    pointer = fragment.getValue(pointer, end);
                } else {
                    pointer = fragment.getPtReached(pointer, end);
                    pointer = fragment.getCharWidth(pointer, end);
                    pointer = fragment.getValue(pointer, end);
                    fragment.textValue = fragment.value;
                    if (!fragment.pt_reached.isEmpty()) {
                        float nextPt = Float.parseFloat(fragment.pt_reached);
                        fragment.updatePoints(nextPt);
                        if (breakPointset) {
                            fragment.alterCoordsBasedOnWritingMode(nextPt);
                            breakPointset = false;
                        }
                    }
                    if (this.isXMLExtraction) {
                        fragment.addXMLTag();
                    }
                }
                if (fragment.isValid()) {
                    fragment.setFragmentCoord();
                    break;
                }
                fragment.reset();
            } while (pointer < end);
            if (isFirstValue) {
                isFirstValue = false;
                if (this.isXMLExtraction && keepFont && !fragment.value.startsWith("<font ") && !fragment.value.startsWith("<color ")) {
                    text.append(Fonts.getActiveFontTag(text.toString(), fragment.getRawData()));
                }
            }
            if ((endsWithPunctuation = GroupingUtils.checkForPunctuation(fragment.textValue, punctuation)) || fragment.isSpace(breakOnSpace)) {
                this.writeOut(keepFont, isWordlist, text, fragment, i2, endsWithPunctuation);
                if (!fragment.char_width.isEmpty()) {
                    breakPointset = GroupingUtils.handleSpaces(isWordlist, fragment);
                }
                if (breakOnSpace && this.nextSlot > 0) {
                    this.hadSpace[this.nextSlot - 1] = true;
                }
                text = new StringBuilder(Fonts.getActiveFontTag(text.toString(), fragment.getRawData()));
                fragment.alterCoordsBasedOnWritingMode(fragment.pt);
                continue;
            }
            text.append(fragment.value);
        }
        if (keepFont && this.isXMLExtraction && !text.toString().endsWith("</font>") && !text.toString().endsWith("</color>")) {
            text.append("</font>");
        }
        this.completeLine(keepFont, isWordlist, text, fragment, i2);
    }

    private void completeLine(boolean keepFont, boolean isWordlist, StringBuilder text, Fragment fragment, int i2) {
        if (fragment.getWritingMode() == 0 || fragment.getWritingMode() == 1) {
            if (fragment.getX1() < fragment.getX2()) {
                this.addFragment(i2, text, fragment.getX1(), fragment.getX2(), fragment.getY1(), fragment.getY2(), keepFont, fragment, isWordlist);
            } else {
                this.addFragment(i2, text, fragment.getX2(), fragment.getX1(), fragment.getY1(), fragment.getY2(), keepFont, fragment, isWordlist);
            }
        } else if ((fragment.getWritingMode() == 3 || fragment.getWritingMode() == 2) && fragment.getY1() > fragment.getY2()) {
            this.addFragment(i2, text, fragment.getX1(), fragment.getX2(), fragment.getY1(), fragment.getY2(), keepFont, fragment, isWordlist);
        }
    }

    private void writeOut(boolean keepFont, boolean isWordlist, StringBuilder text, Fragment fragment, int i2, boolean endsWithPunctuation) {
        int ptr;
        float pt = fragment.pt;
        String textValue = fragment.textValue;
        if (textValue.length() > 1 && textValue.indexOf(32) != -1 && (ptr = textValue.indexOf(32)) > 0) {
            String char_width = fragment.char_width;
            pt = textValue.length() == 2 ? (float)((double)pt + (double)Float.parseFloat(char_width) * 0.7) : (pt += (float)ptr * (Float.parseFloat(char_width) / (float)textValue.length()));
        }
        if (!endsWithPunctuation) {
            text.append(fragment.value.trim());
        }
        switch (fragment.getWritingMode()) {
            case 0: {
                this.addFragment(i2, text, fragment.getX1(), pt, fragment.getY1(), fragment.getY2(), keepFont, fragment, isWordlist);
                break;
            }
            case 1: {
                this.addFragment(i2, text, pt, fragment.getX2(), fragment.getY1(), fragment.getY2(), keepFont, fragment, isWordlist);
                break;
            }
            case 3: {
                this.addFragment(i2, text, fragment.getX1(), fragment.getX2(), pt, fragment.getY2(), keepFont, fragment, isWordlist);
                break;
            }
            case 2: {
                this.addFragment(i2, text, fragment.getX1(), fragment.getX2(), fragment.getY1(), pt, keepFont, fragment, isWordlist);
                break;
            }
        }
        fragment.pt = pt;
    }

    private void initArrays(int count) {
        this.f_x1 = new float[count];
        this.f_colorTag = new String[count];
        this.hadSpace = new boolean[count];
        this.f_x2 = new float[count];
        this.f_y1 = new float[count];
        this.f_y2 = new float[count];
        this.spaceWidth = new float[count];
        this.content = new StringBuilder[count];
        this.fontSize = new int[count];
        this.textLength = new int[count];
        this.writingMode = new int[count];
        this.isUsed = new boolean[count];
    }

    private void addFragment(int index, StringBuilder contentss, float x1, float x2, float y1, float y2, boolean keepFontTokens, Fragment fragment, boolean isWordlist) {
        StringBuilder current_text = contentss;
        String str = current_text.toString();
        int text_len = fragment.getTextLength();
        String currentColorTag = fragment.getColorTag();
        if (isWordlist) {
            current_text = PdfTextExtractionUtils.handleTextForWordList(current_text, str, this.isXMLExtraction);
        }
        if (GroupingUtils.getFirstChar(current_text, this.isXMLExtraction) != -1) {
            if (!keepFontTokens) {
                current_text = Strip.stripXML(current_text, this.isXMLExtraction);
            } else if (this.isXMLExtraction) {
                PdfTextExtractionUtils.gewtXMLText(current_text, this.pdf_data);
            }
            int count = this.f_x1.length;
            if (this.nextSlot >= count) {
                this.resizeArrays(count += 100);
            }
            this.f_x1[this.nextSlot] = x1;
            this.f_colorTag[this.nextSlot] = currentColorTag;
            this.f_x2[this.nextSlot] = x2;
            this.f_y1[this.nextSlot] = y1;
            this.f_y2[this.nextSlot] = y2;
            this.fontSize[this.nextSlot] = this.pdf_data.f_end_font_size[index];
            this.writingMode[this.nextSlot] = this.pdf_data.f_writingMode[index];
            this.textLength[this.nextSlot] = text_len;
            this.spaceWidth[this.nextSlot] = this.pdf_data.space_width[index];
            this.content[this.nextSlot] = current_text;
            ++this.nextSlot;
        }
    }

    private static void gewtXMLText(StringBuilder current_text, PdfData pdf_data) {
        if (pdf_data.isColorExtracted() && !current_text.toString().endsWith("</color>")) {
            if (!current_text.toString().endsWith("</font>")) {
                current_text.append("</font>");
            }
            current_text.append("</color>");
        } else if (!pdf_data.isColorExtracted() && !current_text.toString().endsWith("</font>")) {
            current_text.append("</font>");
        }
    }

    private static StringBuilder handleTextForWordList(StringBuilder current_text, String str, boolean isXMLExtraction) {
        if (str.contains("&#")) {
            current_text = Strip.stripAmpHash(current_text);
        }
        if (isXMLExtraction && (str.contains("&lt;") || str.contains("&gt;"))) {
            current_text = Strip.stripXMLArrows(current_text, true);
        } else if (!(isXMLExtraction || str.indexOf(60) == -1 && str.indexOf(62) == -1)) {
            Strip.stripArrows(current_text);
        }
        return current_text;
    }

    private void resizeArrays(int count) {
        float[] t_x1 = new float[count];
        String[] t_colorTag = new String[count];
        float[] t_x2 = new float[count];
        float[] t_y1 = new float[count];
        float[] t_y2 = new float[count];
        float[] t_spaceWidth = new float[count];
        StringBuilder[] t_content = new StringBuilder[count];
        int[] t_font_size = new int[count];
        int[] t_text_len = new int[count];
        int[] t_writingMode = new int[count];
        boolean[] t_isUsed = new boolean[count];
        boolean[] t_hadSpace = new boolean[count];
        for (int i2 = 0; i2 < count - 100; ++i2) {
            t_x1[i2] = this.f_x1[i2];
            t_colorTag[i2] = this.f_colorTag[i2];
            t_x2[i2] = this.f_x2[i2];
            t_y1[i2] = this.f_y1[i2];
            t_y2[i2] = this.f_y2[i2];
            t_hadSpace[i2] = this.hadSpace[i2];
            t_spaceWidth[i2] = this.spaceWidth[i2];
            t_content[i2] = this.content[i2];
            t_font_size[i2] = this.fontSize[i2];
            t_writingMode[i2] = this.writingMode[i2];
            t_text_len[i2] = this.textLength[i2];
            t_isUsed[i2] = this.isUsed[i2];
        }
        this.f_x1 = t_x1;
        this.f_colorTag = t_colorTag;
        this.hadSpace = t_hadSpace;
        this.f_x2 = t_x2;
        this.f_y1 = t_y1;
        this.f_y2 = t_y2;
        this.isUsed = t_isUsed;
        this.fontSize = t_font_size;
        this.writingMode = t_writingMode;
        this.textLength = t_text_len;
        this.spaceWidth = t_spaceWidth;
        this.content = t_content;
    }

    int[] getsortedUnusedFragments(boolean sortOnX, boolean use_y1) {
        int total_fragments = this.isUsed.length;
        int ii = 0;
        int[] sorted_temp_index = new int[total_fragments];
        for (int i2 = 0; i2 < total_fragments; ++i2) {
            if (this.isUsed[i2]) continue;
            sorted_temp_index[ii] = i2;
            ++ii;
        }
        int[] unsorted_items = new int[ii];
        int[] sorted_temp_x1 = new int[ii];
        int[] sorted_temp_y1 = new int[ii];
        int[] sorted_temp_y2 = new int[ii];
        for (int pointer = 0; pointer < ii; ++pointer) {
            int i3;
            unsorted_items[pointer] = i3 = sorted_temp_index[pointer];
            sorted_temp_x1[pointer] = (int)this.f_x1[i3];
            sorted_temp_y1[pointer] = (int)this.f_y1[i3];
            sorted_temp_y2[pointer] = (int)this.f_y2[i3];
        }
        int[] sorted_items = !sortOnX ? (use_y1 ? Sorts.quicksort(sorted_temp_y1, sorted_temp_x1, unsorted_items) : Sorts.quicksort(sorted_temp_y2, sorted_temp_x1, unsorted_items)) : Sorts.quicksort(sorted_temp_x1, sorted_temp_y1, unsorted_items);
        return sorted_items;
    }

    int[] getWritingModes(int[] items, int count) {
        int[] counts = new int[4];
        for (int j2 = 0; j2 < count; ++j2) {
            int c2 = items[j2];
            if (this.isUsed[c2]) continue;
            int n2 = this.writingMode[c2];
            counts[n2] = counts[n2] + 1;
        }
        ArrayList<Integer> modeList = new ArrayList<Integer>();
        for (int i2 = 0; i2 != counts.length; ++i2) {
            int highest = 0;
            for (int j3 = 1; j3 != counts.length; ++j3) {
                if (counts[j3] <= counts[highest]) continue;
                highest = j3;
            }
            if (counts[highest] <= 0) continue;
            modeList.add(highest);
            counts[highest] = 0;
        }
        int[] modes = new int[modeList.size()];
        for (int i3 = 0; i3 != modeList.size(); ++i3) {
            modes[i3] = (Integer)modeList.get(i3);
        }
        return modes;
    }

    void createLines(int count, int[] items, int mode, boolean breakOnSpace, boolean addMultiplespaceXMLTag) throws PdfException {
        LineData data = new LineData(this.f_x1, this.f_x2, this.f_y1, this.f_y2, mode);
        if (mode == 1 || mode == 2) {
            items = GroupingUtils.reverse(items);
        }
        block0: for (int j2 = 0; j2 < count; ++j2) {
            int id2 = -1;
            int c2 = items[j2];
            float smallest_gap = -1.0f;
            if (!breakOnSpace) {
                smallest_gap = -(this.fontSize[c2] / 2 + 1);
            }
            if (this.isUsed[c2] || this.writingMode[c2] != mode) continue;
            while ((id2 = this.findSmallestGap(count, items, mode, breakOnSpace, data, id2, c2, smallest_gap)) != -1) {
                float possSpace = data.l_x1[id2] - data.l_x2[c2];
                if (mode == 1 || mode == 2) {
                    possSpace = -possSpace;
                } else if (mode == 3) {
                    possSpace = data.l_x2[id2] - data.l_x1[c2];
                }
                String separator = this.isGapASpace(c2, id2, possSpace, addMultiplespaceXMLTag, mode);
                if (breakOnSpace && this.hadSpace != null && (this.hadSpace[c2] || separator.startsWith(" "))) continue block0;
                this.merge(c2, id2, separator, true);
                id2 = -1;
                smallest_gap = 1000000.0f;
            }
        }
    }

    private int findSmallestGap(int count, int[] items, int mode, boolean breakOnSpace, LineData data, int id2, int c2, float smallest_gap) {
        for (int j2 = 0; j2 < count; ++j2) {
            float lineOverlap;
            int i2 = items[j2];
            if (this.isUsed[i2]) continue;
            int topLineDifference = (int)(data.l_y1[i2] - data.l_y1[c2]);
            if (topLineDifference < 0) {
                topLineDifference = -topLineDifference;
            }
            boolean overlapTopLine = (lineOverlap = Math.max(0.0f, Math.min(data.l_y1[c2], data.l_y1[i2]) - Math.max(data.l_y2[c2], data.l_y2[i2]))) >= (data.l_y1[i2] - data.l_y2[i2]) * 0.69f;
            boolean containedAndValid = data.l_y1[c2] > data.l_y1[i2] && data.l_y2[c2] < data.l_y2[i2] && data.l_y1[i2] - data.l_y2[i2] > (data.l_y1[c2] - data.l_y2[c2]) * 0.44444f;
            int fontSizeChange = this.fontSize[c2] - this.fontSize[i2];
            if (fontSizeChange < 0) {
                fontSizeChange = -fontSizeChange;
            }
            if (this.writingMode[c2] != mode || !((float)fontSizeChange <= (float)this.fontSize[c2] * 0.667f && overlapTopLine && topLineDifference <= 6) && !containedAndValid || i2 == c2 || !(data.l_x1[i2] > data.l_x1[c2] && mode != 2) && (!(data.l_x1[i2] < data.l_x1[c2]) || mode != 2)) continue;
            float gap = data.l_x1[i2] - data.l_x2[c2];
            if (mode == 1 || mode == 2) {
                gap = -gap;
            }
            if (gap < 0.0f && gap > -2.0f) {
                gap = 0.0f;
            }
            float allowedOverlap = 0.0f;
            if (!breakOnSpace) {
                allowedOverlap = -(this.fontSize[c2] / 2);
            }
            if (!(smallest_gap < allowedOverlap) && !(gap < smallest_gap)) continue;
            smallest_gap = gap;
            id2 = i2;
        }
        return id2;
    }
}

