/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.grouping;

import java.util.ArrayList;
import java.util.List;
import org.jpedal.exception.PdfException;
import org.jpedal.grouping.GroupingUtils;
import org.jpedal.grouping.LineData;
import org.jpedal.grouping.PdfTextExtractionUtils;
import org.jpedal.objects.PdfData;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;

class PdfTextAsWordList
extends PdfTextExtractionUtils {
    PdfTextAsWordList(PdfData pdf_data, boolean isXMLExtraction) {
        super(pdf_data, isXMLExtraction);
    }

    final List<String> extractTextAsWordlist(int x1, int y1, int x2, int y2, boolean breakFragments, String punctuation) throws PdfException {
        int[] v2 = GroupingUtils.validateCoordinates(x1, y1, x2, y2);
        x1 = v2[0];
        y1 = v2[1];
        x2 = v2[2];
        y2 = v2[3];
        if (breakFragments) {
            this.copyToArrays(x1, y2, x2, y1, true, true, punctuation, true);
        } else {
            this.copyToArrays();
        }
        GroupingUtils.removeEncoding(this.isUsed, this.content);
        this.cleanupShadowsAndDrownedObjects(true);
        int[] items = this.getsortedUnusedFragments(true, false);
        int count = items.length;
        if (count == 0) {
            LogWriter.writeLog("Less than 1 text item on page");
            return null;
        }
        int[] currentWritingModes = this.getWritingModes(items, count);
        ArrayList<String> values = new ArrayList<String>();
        for (int m2 = 0; m2 != currentWritingModes.length; ++m2) {
            int mode = currentWritingModes[m2];
            this.createLines(count, items, mode, true, false);
            LineData data = new LineData(this.f_x1, this.f_x2, this.f_y1, this.f_y2, mode);
            for (int i2 = 0; i2 < this.content.length; ++i2) {
                if (this.content[i2] == null || this.isUsed[i2] || this.writingMode[i2] != mode) continue;
                if (this.colorExtracted && this.isXMLExtraction) {
                    if (!this.content[i2].toString().toLowerCase().startsWith("<color ")) {
                        this.content[i2].insert(0, this.f_colorTag[this.master]);
                    }
                    if (!this.content[i2].toString().toLowerCase().endsWith("</color>")) {
                        this.content[i2].append("</color>");
                    }
                }
                if (this.isXMLExtraction) {
                    values.add(this.content[i2].toString());
                } else {
                    values.add(Strip.convertToText(this.content[i2].toString(), false));
                }
                data.addValues(mode, values, i2);
            }
        }
        LogWriter.writeLog("Text extraction as wordlist completed");
        return values;
    }
}

