/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.grouping;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jpedal.exception.PdfException;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.objects.PdfData;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;
import org.jpedal.utils.repositories.Vector_Float;
import org.jpedal.utils.repositories.Vector_String;

class PdfSearchUtils {
    private boolean includeHTMLtags;
    private final List<String> multipleTermTeasers = new ArrayList<String>();
    private final PdfData pdf_data;
    private Line[] fragments;
    private Line[] lines;
    private static final int MULTIPLE_AREA_RESULT = -101;
    private boolean includeTease;

    PdfSearchUtils(PdfData pdf_data) {
        this.pdf_data = pdf_data;
    }

    final float[] findText(int x1, int y1, int x2, int y2, String[] terms, int searchType) throws PdfException {
        if (terms == null) {
            return new float[0];
        }
        Vector_Float resultCoords = new Vector_Float(0);
        Vector_String resultTeasers = new Vector_String(0);
        int[] v2 = PdfSearchUtils.validateCoordinates(x1, y1, x2, y2);
        x1 = v2[0];
        y1 = v2[1];
        x2 = v2[2];
        y2 = v2[3];
        this.copyToArrays(x1, y2, x2, y1);
        this.cleanupShadowsAndDrownedObjects();
        Line[] localLines = (Line[])this.fragments.clone();
        int[] unsorted = this.getWritingModeCounts(localLines);
        int[] writingModes = PdfSearchUtils.getWritingModeOrder(unsorted);
        for (int u2 = 0; u2 != writingModes.length; ++u2) {
            int mode = writingModes[u2];
            if (unsorted[mode] == 0) continue;
            this.searchWritingMode(mode, searchType, terms, resultCoords, resultTeasers);
        }
        return resultCoords.get();
    }

    String[] getTeasers() {
        return this.multipleTermTeasers.toArray(new String[0]);
    }

    private void copyToArrays(int minX, int minY, int maxX, int maxY) {
        int count = this.pdf_data.getRawTextElementCount();
        Line[] localFragments = new Line[count];
        int currentPoint = 0;
        String marker = PdfData.marker;
        for (int i2 = 0; i2 < count; ++i2) {
            if (!PdfSearchUtils.isFragmentWithinArea(this.pdf_data, i2, minX, minY, maxX, maxY)) continue;
            int mode = this.pdf_data.f_writingMode[i2];
            localFragments[currentPoint] = new Line(this.pdf_data, i2);
            StringBuilder startTags = new StringBuilder(localFragments[currentPoint].getRawData().substring(0, localFragments[currentPoint].getRawData().indexOf(marker)));
            String contentText = localFragments[currentPoint].getRawData().substring(localFragments[currentPoint].getRawData().indexOf(marker), localFragments[currentPoint].getRawData().indexOf(60, localFragments[currentPoint].getRawData().lastIndexOf(marker)));
            String endTags = localFragments[currentPoint].getRawData().substring(localFragments[currentPoint].getRawData().lastIndexOf(marker));
            endTags = endTags.substring(endTags.indexOf(60));
            StringTokenizer tokenizer = new StringTokenizer(contentText, marker);
            boolean setX1 = true;
            float width = 0.0f;
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                float xCoord = Float.parseFloat(token);
                token = tokenizer.nextToken();
                width = Float.parseFloat(token);
                String character = token = tokenizer.nextToken();
                if (setX1) {
                    if (mode == 0 || mode == 1) {
                        localFragments[currentPoint].setX1(xCoord);
                    } else {
                        localFragments[currentPoint].setY2(xCoord);
                    }
                    setX1 = false;
                }
                if (mode == 0 || mode == 1) {
                    localFragments[currentPoint].setX2(xCoord);
                } else {
                    localFragments[currentPoint].setY1(xCoord);
                }
                boolean storeValues = false;
                if (mode == 0 || mode == 1) {
                    if ((float)minX < xCoord && xCoord + width < (float)maxX) {
                        storeValues = true;
                    }
                } else if ((float)minY < xCoord && xCoord + width < (float)maxY) {
                    storeValues = true;
                }
                if (!storeValues) continue;
                startTags.append(marker);
                startTags.append(xCoord);
                startTags.append(marker);
                startTags.append(width);
                startTags.append(marker);
                startTags.append(character);
            }
            localFragments[currentPoint].setRawData(startTags.append(endTags).toString());
            if (mode == 0 || mode == 1) {
                localFragments[currentPoint].setX2(localFragments[currentPoint].getX2() + width);
            } else {
                localFragments[currentPoint].setY1(localFragments[currentPoint].getY1() + width);
            }
            ++currentPoint;
        }
        this.fragments = new Line[currentPoint];
        System.arraycopy(localFragments, 0, this.fragments, 0, this.fragments.length);
    }

    private static boolean isFragmentWithinArea(PdfData pdf_data, int i2, int minX, int minY, int maxX, int maxY) {
        float x1 = pdf_data.f_x1[i2];
        float x2 = pdf_data.f_x2[i2];
        float y1 = pdf_data.f_y1[i2];
        float y2 = pdf_data.f_y2[i2];
        int mode = pdf_data.f_writingMode[i2];
        switch (mode) {
            case 0: 
            case 1: {
                float height = y1 - y2;
                if (!((float)minX < x1 && x1 < (float)maxX || (float)minX < x2 && x2 < (float)maxX || x1 < (float)minX && (float)minX < x2) && (!(x1 < (float)maxX) || !((float)maxX < x2)) || !((float)minY < y2 + height / 4.0f) || !((double)y2 + (double)height * 0.75 < (double)maxY)) break;
                return true;
            }
            case 2: 
            case 3: {
                float height = x2 - x1;
                if (!((float)minY < y1 && y1 < (float)maxY || (float)minY < y2 && y2 < (float)maxY || y2 < (float)minY && (float)minY < y1) && (!(y2 < (float)maxY) || !((float)maxY < y1)) || !((float)minX < x1 + height / 4.0f) || !((double)x1 + (double)height * 0.75 < (double)maxX)) break;
                return true;
            }
        }
        return false;
    }

    private static int[] validateCoordinates(int x1, int y1, int x2, int y2) {
        if (x1 > x2 | y1 < y2) {
            int temp;
            if (x1 > x2) {
                temp = x1;
                x1 = x2;
                x2 = temp;
                LogWriter.writeLog("x1 > x2, coordinates were swapped to validate");
            }
            if (y1 < y2) {
                temp = y1;
                y1 = y2;
                y2 = temp;
                LogWriter.writeLog("y1 < y2, coordinates were swapped to validate");
            }
        }
        return new int[]{x1, y1, x2, y2};
    }

    final float[] findText(String[] terms, int searchType) throws PdfException {
        if (terms == null) {
            return new float[0];
        }
        Vector_Float resultCoords = new Vector_Float(0);
        Vector_String resultTeasers = new Vector_String(0);
        this.copyToArrays(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
        this.cleanupShadowsAndDrownedObjects();
        Line[] localLines = (Line[])this.fragments.clone();
        int[] unsorted = this.getWritingModeCounts(localLines);
        int[] writingModes = PdfSearchUtils.getWritingModeOrder(unsorted);
        for (int u2 = 0; u2 != writingModes.length; ++u2) {
            int mode = writingModes[u2];
            if (unsorted[mode] == 0) continue;
            this.searchWritingMode(mode, searchType, terms, resultCoords, resultTeasers);
        }
        return resultCoords.get();
    }

    private void searchWritingMode(int mode, int searchType, String[] terms, Vector_Float resultCoords, Vector_String resultTeasers) throws PdfException {
        boolean firstOccuranceOnly = false;
        boolean wholeWordsOnly = false;
        boolean foundFirst = false;
        boolean useRegEx = false;
        this.createLinesForSearch(mode);
        int options = PdfSearchUtils.loadSearcherOptions(searchType);
        if ((searchType & 4) == 4) {
            firstOccuranceOnly = true;
        }
        if ((searchType & 1) == 1) {
            wholeWordsOnly = true;
        }
        if ((searchType & 0x20) == 32) {
            useRegEx = true;
        }
        boolean valuesSwapped = mode == 3 || mode == 2;
        String searchText = this.buildSearchText(false, mode);
        String coordsText = this.buildSearchText(true, mode);
        for (int j2 = 0; j2 != terms.length; ++j2) {
            String searchValue = PdfSearchUtils.alterStringTooDisplayOrder(terms[j2]);
            String sep = " ";
            if ((searchType & 0x80) == 128) {
                sep = (searchType & 8) == 8 ? "[ \\\\n]*+" : "[ ]*+";
                StringBuilder builder = new StringBuilder();
                for (int i2 = 0; i2 != searchValue.length(); ++i2) {
                    builder.append(searchValue.charAt(i2));
                    if (i2 == searchValue.length() - 1) continue;
                    builder.append(' ');
                }
                searchValue = builder.toString();
            } else if ((searchType & 8) == 8) {
                sep = "[ \\\\n]+";
            }
            if (!useRegEx) {
                searchValue = "\\Q" + searchValue + "\\E";
                sep = "\\\\E" + sep + "\\\\Q";
            }
            if (!" ".equals(sep)) {
                searchValue = searchValue.replaceAll(" ", sep);
            }
            if (wholeWordsOnly) {
                searchValue = "\\b" + searchValue + "\\b";
            }
            Pattern searchTerm = Pattern.compile(searchValue, options);
            Pattern teaserTerm = Pattern.compile("(?:\\S+\\s+)?\\S*(?:\\S+\\s+)?\\S*" + searchValue + "\\S*(?:\\s+\\S+)?\\S*(?:\\s+\\S+)?", options);
            Matcher termFinder = searchTerm.matcher(searchText);
            Matcher teaserFinder = teaserTerm.matcher(searchText);
            while (termFinder.find()) {
                String foundTerm = termFinder.group();
                int termStarts = termFinder.start();
                int termEnds = termFinder.end() - 1;
                if (this.includeTease) {
                    if (this.includeHTMLtags) {
                        foundTerm = "<b>" + foundTerm + "</b>";
                    }
                    this.findTeaser(foundTerm, teaserFinder, termStarts, termEnds, resultTeasers);
                }
                this.getResultCoords(coordsText, mode, termStarts, termEnds, valuesSwapped, resultCoords);
                if (!firstOccuranceOnly) continue;
                foundFirst = true;
                break;
            }
            if (firstOccuranceOnly && foundFirst) break;
        }
        resultCoords.trim();
        if (this.includeTease) {
            this.storeTeasers(resultTeasers);
        }
    }

    private void getResultCoords(String coordText, int mode, int termStarts, int termEnds, boolean valuesSwapped, Vector_Float resultCoords) {
        int[] resultStart = null;
        int[] resultEnd = null;
        int pointInLine = -1;
        int lineCounter = 0;
        while (this.lines[lineCounter].getRawData() == null || Strip.stripXML(this.lines[lineCounter].getRawData(), true).toString().isEmpty() || mode != this.lines[lineCounter].getWritingMode()) {
            ++lineCounter;
        }
        for (int pointer = 1; pointer < coordText.length(); ++pointer) {
            char[] chars;
            int currentY;
            int startPointer = pointer;
            pointer = PdfSearchUtils.progressPointerToNextMarker(pointer, coordText);
            float currentX = Float.parseFloat(coordText.substring(startPointer, pointer));
            startPointer = ++pointer;
            pointer = PdfSearchUtils.progressPointerToNextMarker(pointer, coordText);
            float width = Float.parseFloat(coordText.substring(startPointer, pointer));
            startPointer = ++pointer;
            pointer = PdfSearchUtils.progressPointerToNextMarker(pointer, coordText);
            String text = coordText.substring(startPointer, pointer);
            if (resultStart == null && (pointInLine += text.length()) >= termStarts) {
                currentY = (int)this.lines[lineCounter].getY1();
                if (valuesSwapped) {
                    currentY = (int)this.lines[lineCounter].getX2();
                }
                resultStart = new int[]{(int)currentX, currentY};
            }
            if (resultStart != null && resultEnd == null && pointInLine >= termEnds) {
                currentY = (int)this.lines[lineCounter].getY2();
                if (valuesSwapped) {
                    currentY = (int)this.lines[lineCounter].getX1();
                }
                resultEnd = new int[]{(int)(currentX + width), currentY};
                PdfSearchUtils.storeResultsCoords(valuesSwapped, mode, resultCoords, resultStart[0], resultStart[1], resultEnd[0], resultEnd[1], 0.0f);
            }
            if (resultStart != null && resultEnd == null && text.contains("\n")) {
                currentY = (int)this.lines[lineCounter].getY2();
                if (valuesSwapped) {
                    currentY = (int)this.lines[lineCounter].getX1();
                }
                resultEnd = new int[]{(int)(currentX + width), currentY};
                PdfSearchUtils.storeResultsCoords(valuesSwapped, mode, resultCoords, resultStart[0], resultStart[1], resultEnd[0], resultEnd[1], -101.0f);
                resultStart = null;
                resultEnd = null;
                termStarts = pointInLine;
            }
            if (!text.contains("\n")) continue;
            for (char c2 : chars = text.toCharArray()) {
                if (c2 != '\n') continue;
                ++lineCounter;
            }
            while (lineCounter < this.lines.length && (this.lines[lineCounter].getRawData() == null || Strip.stripXML(this.lines[lineCounter].getRawData(), true).toString().isEmpty() || mode != this.lines[lineCounter].getWritingMode())) {
                ++lineCounter;
            }
        }
    }

    private static int progressPointerToNextMarker(int pointer, String coordText) {
        int length = coordText.length();
        while (pointer < length && coordText.charAt(pointer) != PdfGroupingAlgorithms.MARKER2) {
            ++pointer;
        }
        return pointer;
    }

    void clearStoredTeasers() {
        this.multipleTermTeasers.clear();
    }

    private void storeTeasers(Vector_String resultTeasers) {
        resultTeasers.trim();
        String[] results = resultTeasers.get();
        this.multipleTermTeasers.addAll(Arrays.asList(results));
        resultTeasers.clear();
    }

    private static void storeResultsCoords(boolean valuesSwapped, int mode, Vector_Float resultCoords, float x1, float y1, float x2, float y2, float connected) {
        if (valuesSwapped) {
            if (mode == 3) {
                resultCoords.addElement(y2);
                resultCoords.addElement(x2);
                resultCoords.addElement(y1);
                resultCoords.addElement(x1);
                resultCoords.addElement(connected);
            } else {
                resultCoords.addElement(y2);
                resultCoords.addElement(x1);
                resultCoords.addElement(y1);
                resultCoords.addElement(x2);
                resultCoords.addElement(connected);
            }
        } else {
            resultCoords.addElement(x1);
            resultCoords.addElement(y1);
            resultCoords.addElement(x2);
            resultCoords.addElement(y2);
            resultCoords.addElement(connected);
        }
    }

    private void findTeaser(String teaser, Matcher teaserFinder, int termStarts, int termEnds, Vector_String resultTeasers) {
        if (teaserFinder.find() && teaserFinder.start() < termStarts && teaserFinder.end() > termEnds) {
            teaser = teaserFinder.group();
            if (this.includeHTMLtags) {
                int teaseStarts = termStarts - teaserFinder.start();
                int teaseEnds = termEnds - teaserFinder.start() + 1;
                teaser = teaser.substring(0, teaseStarts) + "<b>" + teaser.substring(teaseStarts, teaseEnds) + "</b>" + teaser.substring(teaseEnds);
            }
            teaserFinder.region(termEnds + 1, teaserFinder.regionEnd());
        }
        resultTeasers.addElement(teaser);
    }

    private static String alterStringTooDisplayOrder(String testTerm) {
        StringBuilder currentBlock = new StringBuilder();
        byte lastDirection = Character.getDirectionality(testTerm.charAt(0));
        StringBuilder searchValueBuilder = new StringBuilder();
        for (int i2 = 0; i2 != testTerm.length(); ++i2) {
            byte dir = Character.getDirectionality(testTerm.charAt(i2));
            switch (dir) {
                case 1: 
                case 2: 
                case 16: 
                case 17: {
                    dir = 1;
                    break;
                }
                case 0: 
                case 14: 
                case 15: {
                    dir = 0;
                    break;
                }
                default: {
                    dir = lastDirection;
                }
            }
            if (dir != lastDirection) {
                searchValueBuilder.append((CharSequence)currentBlock);
                currentBlock = new StringBuilder();
                lastDirection = dir;
            }
            if (dir == 1) {
                currentBlock.insert(0, testTerm.charAt(i2));
                continue;
            }
            currentBlock.append(testTerm.charAt(i2));
        }
        searchValueBuilder.append((CharSequence)currentBlock);
        return searchValueBuilder.toString();
    }

    private String buildSearchText(boolean includeCoords, int mode) {
        StringBuilder str = new StringBuilder();
        for (int i2 = 0; i2 != this.lines.length; ++i2) {
            if (this.lines[i2].getRawData() == null || mode != this.lines[i2].getWritingMode()) continue;
            str.append(this.lines[i2].getRawData()).append('\n');
        }
        String searchText = PdfSearchUtils.removeDuplicateSpaces(str.toString());
        if (!includeCoords) {
            searchText = PdfGroupingAlgorithms.removeHiddenMarkers(searchText);
        }
        searchText = Strip.stripXML(searchText, true).toString();
        return searchText;
    }

    private static String removeDuplicateSpaces(String textValue) {
        if (textValue.contains("  ")) {
            textValue = textValue.replace("  ", " ");
        }
        return textValue;
    }

    private static int loadSearcherOptions(int searchType) {
        int options = 0;
        if ((searchType & 2) != 2) {
            options |= 2;
        }
        if ((searchType & 8) == 8) {
            options |= 0x28;
        }
        return options;
    }

    private static int[] getWritingModeOrder(int[] unsorted) {
        int[] sorted = new int[]{unsorted[0], unsorted[1], unsorted[2], unsorted[3]};
        int[] writingModes = new int[]{-1, -1, -1, -1};
        Arrays.sort(sorted);
        for (int i2 = 0; i2 != unsorted.length; ++i2) {
            for (int j2 = 0; j2 < sorted.length; ++j2) {
                if (unsorted[i2] != sorted[j2]) continue;
                int pos = j2 - 3;
                if (pos < 0) {
                    pos = -pos;
                }
                if (writingModes[pos] != -1) continue;
                writingModes[pos] = i2;
                j2 = sorted.length;
            }
        }
        return writingModes;
    }

    private int[] getWritingModeCounts(Line[] items) {
        int l2r = 0;
        int r2l = 0;
        int t2b = 0;
        int b2t = 0;
        block6: for (int i2 = 0; i2 != items.length; ++i2) {
            switch (items[i2].getWritingMode()) {
                case 0: {
                    ++l2r;
                    continue block6;
                }
                case 1: {
                    ++r2l;
                    continue block6;
                }
                case 2: {
                    ++t2b;
                    continue block6;
                }
                case 3: {
                    ++b2t;
                }
            }
        }
        return new int[]{l2r, r2l, t2b, b2t};
    }

    private void cleanupShadowsAndDrownedObjects() {
        int count = this.fragments.length;
        for (int p2 = 0; p2 < count; ++p2) {
            int master = p2;
            float midX = (this.fragments[master].getX1() + this.fragments[master].getX2()) / 2.0f;
            float midY = (this.fragments[master].getY1() + this.fragments[master].getY2()) / 2.0f;
            for (int p22 = p2 + 1; p22 < count; ++p22) {
                boolean b_in_a;
                float diff;
                int child = p22;
                if (this.fragments[child].getX1() == this.fragments[child].getX2() || this.fragments[child].hasMerged() || this.fragments[master].hasMerged()) continue;
                float fontDiff = this.fragments[child].getFontSize() - this.fragments[master].getFontSize();
                if (fontDiff < 0.0f) {
                    fontDiff = -fontDiff;
                }
                if ((diff = this.fragments[child].getX2() - this.fragments[child].getX1() - (this.fragments[master].getX2() - this.fragments[master].getX1())) < 0.0f) {
                    diff = -diff;
                }
                if (fontDiff == 0.0f && midX > this.fragments[child].getX1() && midX < this.fragments[child].getX2() && diff < 10.0f && midY < this.fragments[child].getY1() && midY > this.fragments[child].getY2()) {
                    this.fragments[child].setMerged();
                    continue;
                }
                boolean a_in_b = this.fragments[child].getX1() > this.fragments[master].getX1() && this.fragments[child].getX2() < this.fragments[master].getX2() && this.fragments[child].getY1() < this.fragments[master].getY1() && this.fragments[child].getY2() > this.fragments[master].getY2();
                boolean bl2 = b_in_a = this.fragments[master].getX1() > this.fragments[child].getX1() && this.fragments[master].getX2() < this.fragments[child].getX2() && this.fragments[master].getY1() < this.fragments[child].getY1() && this.fragments[master].getY2() > this.fragments[child].getY2();
                if (!a_in_b && !b_in_a) continue;
                String separator = this.fragments[master].getY2() > this.fragments[child].getY2() ? PdfSearchUtils.getLineDownSeparator(this.fragments[master].getRawData(), this.fragments[child].getRawData()) : PdfSearchUtils.getLineDownSeparator(this.fragments[child].getRawData(), this.fragments[master].getRawData());
                this.merge(this.fragments[master], this.fragments[child], separator);
                midX = (this.fragments[master].getX1() + this.fragments[master].getX2()) / 2.0f;
                midY = (this.fragments[master].getY1() + this.fragments[master].getY2()) / 2.0f;
            }
        }
    }

    private static String getLineDownSeparator(String rawLine1, String rawLine2) {
        String returnValue = " ";
        StringBuilder line1 = new StringBuilder(rawLine1);
        StringBuilder line2 = new StringBuilder(rawLine2);
        Strip.trim(line1);
        Strip.trim(line2);
        int line1Len = line1.length();
        int line2Len = line2.length();
        if (line1Len > 1 && line2Len > 1) {
            char line1Char2 = line1.charAt(line1Len - 1);
            char line1Char1 = line1.charAt(line1Len - 2);
            char line2Char1 = line2.charAt(0);
            char line2Char2 = line2.charAt(1);
            if ((line1Char1 == '.' || line1Char2 == '.') && (Character.isUpperCase(line2Char1) || line2Char1 == '&' || Character.isUpperCase(line2Char2) || line2Char2 == '&')) {
                returnValue = "\n";
            }
        }
        return returnValue;
    }

    private String isGapASpace(int c2, int l2, float actualGap) {
        int spaceCount;
        String sep = "";
        float gapA = this.fragments[c2].getSpaceWidth() * (float)this.fragments[c2].getFontSize();
        float gapB = this.fragments[l2].getSpaceWidth() * (float)this.fragments[l2].getFontSize();
        float gap = Math.min(gapA, gapB);
        if ((gap = actualGap / (gap / 1000.0f)) > 0.51f && gap < 1.0f) {
            gap = 1.0f;
        }
        if ((spaceCount = (int)gap) > 0) {
            sep = " ";
        }
        return sep;
    }

    private void createLinesForSearch(int mode) throws PdfException {
        int i2;
        Line[] localLines = (Line[])this.fragments.clone();
        int finalCount = localLines.length;
        for (i2 = 0; i2 != localLines.length; ++i2) {
            if (!localLines[i2].hasMerged) continue;
            --finalCount;
        }
        if (mode == 1 || mode == 2) {
            for (i2 = 0; i2 < localLines.length; ++i2) {
                localLines[i2] = this.fragments[localLines.length - i2 - 1];
            }
        }
        for (int master = 0; master < localLines.length; ++master) {
            int id2 = -1;
            if (localLines[master].hasMerged() || localLines[master].getWritingMode() != mode) continue;
            for (int child = 0; child < localLines.length; ++child) {
                float distance;
                float[] masterCoords = this.getCoordsForWritingMode(localLines[master], mode);
                float[] childCoords = this.getCoordsForWritingMode(localLines[child], mode);
                if (localLines[child].hasMerged() || master == child || localLines[master].getWritingMode() != localLines[child].getWritingMode() || childCoords[0] == childCoords[2]) continue;
                float mx = masterCoords[0] + (masterCoords[2] - masterCoords[0]) / 2.0f;
                float my = masterCoords[3] + (masterCoords[1] - masterCoords[3]) / 2.0f;
                float cx = childCoords[0] + (childCoords[2] - childCoords[0]) / 2.0f;
                float cy = childCoords[3] + (childCoords[1] - childCoords[3]) / 2.0f;
                float smallestHeight = masterCoords[1] - masterCoords[3];
                float fontDifference = childCoords[1] - childCoords[3] - smallestHeight;
                if (fontDifference < 0.0f) {
                    smallestHeight = childCoords[1] - childCoords[3];
                }
                if (Math.abs(fontDifference) < smallestHeight * 2.0f && (double)Math.abs(my - cy) < (double)smallestHeight * 0.5 && mx < cx && (distance = childCoords[0] - masterCoords[2]) <= smallestHeight / 2.0f) {
                    id2 = child;
                }
                if (id2 == -1) continue;
                float possSpace = childCoords[0] - masterCoords[2];
                if (mode == 1 || mode == 2) {
                    possSpace = -possSpace;
                }
                String separator = this.isGapASpace(master, id2, possSpace);
                if (childCoords[0] > masterCoords[0] && mode != 2 || childCoords[0] < masterCoords[0] && mode == 2 && localLines[master].getWritingMode() == mode) {
                    this.merge(localLines[master], localLines[id2], separator);
                    --finalCount;
                }
                id2 = -1;
            }
        }
        this.lines = new Line[finalCount];
        int next = 0;
        for (int i3 = 0; i3 != localLines.length; ++i3) {
            if (localLines[i3].hasMerged()) continue;
            this.lines[next] = localLines[i3];
            ++next;
        }
    }

    private float[] getCoordsForWritingMode(Line line, int mode) throws PdfException {
        float[] results = new float[4];
        switch (mode) {
            case 0: {
                results[0] = line.getX1();
                results[2] = line.getX2();
                results[1] = line.getY1();
                results[3] = line.getY2();
                break;
            }
            case 1: {
                results[2] = line.getX1();
                results[0] = line.getX2();
                results[1] = line.getY1();
                results[3] = line.getY2();
                break;
            }
            case 3: {
                results[0] = line.getY2();
                results[2] = line.getY1();
                results[1] = line.getX2();
                results[3] = line.getX1();
                break;
            }
            case 2: {
                results[0] = line.getY2();
                results[2] = line.getY1();
                results[3] = line.getX1();
                results[1] = line.getX2();
                break;
            }
            default: {
                throw new PdfException("Illegal value " + mode + " for currentWritingMode");
            }
        }
        return results;
    }

    private void merge(Line master, Line child, String separator) {
        if (master.getX1() > child.getX1()) {
            master.setX1(child.getX1());
        }
        if (master.getY1() < child.getY1()) {
            master.setY1(child.getY1());
        }
        if (master.getX2() < child.getX2()) {
            master.setX2(child.getX2());
        }
        if (master.getY2() > child.getY2()) {
            master.setY2(child.getY2());
        }
        String test = "</font>";
        StringBuilder masterString = new StringBuilder(master.getRawData());
        StringBuilder childString = new StringBuilder(child.getRawData());
        if (masterString.toString().lastIndexOf("</font>") != -1) {
            String masterLocal = masterString.toString();
            masterString = new StringBuilder(masterLocal.substring(0, masterLocal.lastIndexOf("</font>")));
            masterString.append(separator);
            masterString.append(masterLocal.substring(masterLocal.lastIndexOf("</font>")));
        } else {
            masterString.append(separator);
        }
        if (child.getTextLength() > 1 && masterString.toString().endsWith(" ")) {
            masterString.deleteCharAt(masterString.lastIndexOf(" "));
        }
        master.setFontSize(child.getFontSize());
        if (childString.indexOf("<color") != -1 && masterString.indexOf("<color") != -1 && childString.toString().startsWith(masterString.substring(masterString.lastIndexOf("<color"), masterString.indexOf(">", masterString.lastIndexOf("<color")))) && masterString.lastIndexOf("</color>") + 7 == masterString.lastIndexOf(">")) {
            childString.replace(childString.indexOf("<color"), childString.indexOf(">") + 1, "");
            masterString.replace(masterString.lastIndexOf("</color>"), masterString.lastIndexOf("</color>") + 8, "");
        }
        if (childString.indexOf("<font") != -1 && masterString.indexOf("<font") != -1 && childString.toString().startsWith(masterString.substring(masterString.lastIndexOf("<font"), masterString.indexOf(">", masterString.lastIndexOf("<font")))) && masterString.lastIndexOf("</font>") + 6 == masterString.lastIndexOf(">")) {
            childString.replace(childString.indexOf("<font"), childString.indexOf(">") + 1, "");
            masterString.replace(masterString.lastIndexOf("</font>"), masterString.lastIndexOf("</font>") + 7, "");
        }
        masterString.append((CharSequence)childString);
        master.setTextLength(master.getTextLength() + child.getTextLength());
        child.setRawData(null);
        child.setMerged();
        master.setRawData(masterString.toString());
    }

    void setIncludeHTML(boolean value) {
        this.includeHTMLtags = value;
    }

    void generateTeasers(boolean value) {
        this.includeTease = value;
    }

    boolean isGeneratingTeasers() {
        return this.includeTease;
    }

    private class Line
    implements Comparable<Line> {
        private float x1;
        private float y1;
        private float x2;
        private float y2;
        private float spaceWidth;
        private String raw;
        private int text_length;
        private int mode;
        private int fontSize;
        private boolean hasMerged;

        Line(PdfData pdf_data, int index) {
            this.loadData(pdf_data, index);
        }

        private void loadData(PdfData pdf_data, int index) {
            this.x1 = pdf_data.f_x1[index];
            this.x2 = pdf_data.f_x2[index];
            this.y1 = pdf_data.f_y1[index];
            this.y2 = pdf_data.f_y2[index];
            this.text_length = pdf_data.text_length[index];
            this.mode = pdf_data.f_writingMode[index];
            this.raw = pdf_data.contents[index];
            this.fontSize = pdf_data.f_end_font_size[index];
            this.spaceWidth = pdf_data.space_width[index];
            this.hasMerged = false;
        }

        float getX1() {
            return this.x1;
        }

        float getY1() {
            return this.y1;
        }

        float getX2() {
            return this.x2;
        }

        float getY2() {
            return this.y2;
        }

        float getSpaceWidth() {
            return this.spaceWidth;
        }

        String getRawData() {
            return this.raw;
        }

        int getWritingMode() {
            return this.mode;
        }

        int getTextLength() {
            return this.text_length;
        }

        int getFontSize() {
            return this.fontSize;
        }

        boolean hasMerged() {
            return this.hasMerged;
        }

        void setX1(float value) {
            this.x1 = value;
        }

        void setY1(float value) {
            this.y1 = value;
        }

        void setX2(float value) {
            this.x2 = value;
        }

        void setY2(float value) {
            this.y2 = value;
        }

        void setFontSize(int value) {
            this.fontSize = value;
        }

        void setRawData(String value) {
            this.raw = value;
        }

        void setTextLength(int value) {
            this.text_length = value;
        }

        void setMerged() {
            this.hasMerged = true;
        }

        @Override
        public int compareTo(Line o2) {
            switch (this.mode) {
                case 0: 
                case 1: {
                    return (int)(this.y1 - o2.y1);
                }
                case 2: 
                case 3: {
                    return (int)(this.x1 - o2.x1);
                }
            }
            return 0;
        }
    }
}

