/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.grouping;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.jpedal.exception.PdfException;
import org.jpedal.grouping.DefaultSearchListener;
import org.jpedal.grouping.PdfSearchUtils;
import org.jpedal.grouping.PdfTextAsWordList;
import org.jpedal.grouping.PdfTextInRectangle;
import org.jpedal.grouping.ResultsComparator;
import org.jpedal.grouping.ResultsComparatorRectangle;
import org.jpedal.objects.PdfData;
import org.jpedal.utils.repositories.Vector_Rectangle;
import org.jpedal.utils.repositories.generic.Vector_Rectangle_Int;

public class PdfGroupingAlgorithms {
    private static final String MARKER = PdfData.marker;
    public static final char MARKER2 = MARKER.charAt(0);
    private static final int linkedSearchAreas = -101;
    private final PdfSearchUtils searcher;
    private final PdfData pdf_data;
    private final boolean isXMLExtraction;

    public PdfGroupingAlgorithms(PdfData pdf_data, boolean isXMLExtraction) {
        this.pdf_data = pdf_data;
        this.isXMLExtraction = isXMLExtraction;
        this.searcher = new PdfSearchUtils(pdf_data);
    }

    public void setIncludeHTML(boolean value) {
        this.searcher.setIncludeHTML(value);
    }

    public static String removeHiddenMarkers(String contents) {
        if (contents == null) {
            return null;
        }
        if (!contents.contains(MARKER)) {
            return contents;
        }
        StringTokenizer tokens = new StringTokenizer(contents, MARKER, true);
        StringBuilder processed_data = new StringBuilder();
        while (tokens.hasMoreTokens()) {
            String temp_token = tokens.nextToken();
            if (MARKER.equals(temp_token)) {
                tokens.nextToken();
                tokens.nextToken();
                tokens.nextToken();
                tokens.nextToken();
                processed_data.append(tokens.nextToken());
                continue;
            }
            processed_data.append(temp_token);
        }
        return processed_data.toString();
    }

    public final List<String> extractTextAsWordlist(int x1, int y1, int x2, int y2, int page_number, boolean breakFragments, String punctuation) throws PdfException {
        PdfTextAsWordList extracter = new PdfTextAsWordList(this.pdf_data, this.isXMLExtraction);
        return extracter.extractTextAsWordlist(x1, y1, x2, y2, breakFragments, punctuation);
    }

    public final String extractTextInRectangle(int x1, int y1, int x2, int y2, int page_number, boolean estimateParagraphs, boolean breakFragments) throws PdfException {
        PdfTextInRectangle extracter = new PdfTextInRectangle(this.pdf_data, this.isXMLExtraction);
        return extracter.extractTextInRectangle(x1, y1, x2, y2, estimateParagraphs, breakFragments);
    }

    public SortedMap<Object, String> findMultipleTermsInRectangleWithMatchingTeasers(int x1, int y1, int x2, int y2, int rotation, String[] terms, int searchType, DefaultSearchListener listener) throws PdfException {
        this.searcher.clearStoredTeasers();
        boolean origIncludeTease = this.searcher.isGeneratingTeasers();
        this.searcher.generateTeasers(true);
        List<Object> highlights = this.findMultipleTermsInRectangle(x1, y1, x2, y2, terms, searchType, listener);
        TreeMap<Object, String> highlightsWithTeasers = new TreeMap<Object, String>(new ResultsComparatorRectangle(rotation));
        String[] teasers = this.searcher.getTeasers();
        for (int i2 = 0; i2 < highlights.size(); ++i2) {
            highlightsWithTeasers.put(highlights.get(i2), teasers[i2]);
        }
        this.searcher.generateTeasers(origIncludeTease);
        return highlightsWithTeasers;
    }

    public SortedMap<Object, String> findTextWithinInAreaWithTeasers(int x1, int y1, int x2, int y2, int rotation, String[] terms, int searchType, DefaultSearchListener listener) throws PdfException {
        this.searcher.clearStoredTeasers();
        boolean origIncludeTease = this.searcher.isGeneratingTeasers();
        this.searcher.generateTeasers(true);
        List<Object> highlights = this.findTextWithinArea(x1, y1, x2, y2, terms, searchType, listener);
        TreeMap<Object, String> highlightsWithTeasers = new TreeMap<Object, String>(new ResultsComparator(rotation));
        String[] teasers = this.searcher.getTeasers();
        for (int i2 = 0; i2 < highlights.size(); ++i2) {
            highlightsWithTeasers.put(highlights.get(i2), teasers[i2]);
        }
        this.searcher.generateTeasers(origIncludeTease);
        return highlightsWithTeasers;
    }

    public List<Object> findMultipleTermsInRectangle(int x1, int y1, int x2, int y2, int rotation, String[] terms, boolean orderResults, int searchType, DefaultSearchListener listener) throws PdfException {
        this.searcher.clearStoredTeasers();
        List<Object> highlights = this.findMultipleTermsInRectangle(x1, y1, x2, y2, terms, searchType, listener);
        if (orderResults) {
            highlights.sort(new ResultsComparator(rotation));
        }
        return highlights;
    }

    private List<Object> findMultipleTermsInRectangle(int x1, int y1, int x2, int y2, String[] terms, int searchType, DefaultSearchListener listener) throws PdfException {
        ArrayList<Object> list = new ArrayList<Object>();
        for (String term : terms) {
            if (listener != null && listener.isCanceled()) break;
            float[] co_ords = this.findText(x1, y1, x2, y2, new String[]{term}, searchType);
            if (co_ords == null) continue;
            int count = co_ords.length;
            for (int ii = 0; ii < count; ii += 5) {
                int wx1 = (int)co_ords[ii];
                int wy1 = (int)co_ords[ii + 1];
                int wx2 = (int)co_ords[ii + 2];
                int wy2 = (int)co_ords[ii + 3];
                Rectangle rectangle = new Rectangle(wx1, wy2, wx2 - wx1, wy1 - wy2);
                int seperator = (int)co_ords[ii + 4];
                if (seperator == -101) {
                    Vector_Rectangle vr = new Vector_Rectangle();
                    vr.addElement(rectangle);
                    while (seperator == -101) {
                        wx1 = (int)co_ords[ii += 5];
                        wy1 = (int)co_ords[ii + 1];
                        wx2 = (int)co_ords[ii + 2];
                        wy2 = (int)co_ords[ii + 3];
                        seperator = (int)co_ords[ii + 4];
                        rectangle = new Rectangle(wx1, wy2, wx2 - wx1, wy1 - wy2);
                        vr.addElement(rectangle);
                    }
                    vr.trim();
                    list.add(vr.get());
                    continue;
                }
                list.add(rectangle);
            }
        }
        return list;
    }

    private List<Object> findTextWithinArea(int x1, int y1, int x2, int y2, String[] terms, int searchType, DefaultSearchListener listener) throws PdfException {
        ArrayList<Object> list = new ArrayList<Object>();
        for (String term : terms) {
            if (listener != null && listener.isCanceled()) break;
            float[] co_ords = this.findText(x1, y1, x2, y2, new String[]{term}, searchType);
            if (co_ords == null) continue;
            int count = co_ords.length;
            for (int ii = 0; ii < count; ii += 5) {
                int wx1 = (int)co_ords[ii];
                int wy1 = (int)co_ords[ii + 1];
                int wx2 = (int)co_ords[ii + 2];
                int wy2 = (int)co_ords[ii + 3];
                int[] rectangle = new int[]{wx1, wy2, wx2 - wx1, wy1 - wy2};
                int seperator = (int)co_ords[ii + 4];
                if (seperator == -101) {
                    Vector_Rectangle_Int vr = new Vector_Rectangle_Int();
                    vr.addElement(rectangle);
                    while (seperator == -101) {
                        wx1 = (int)co_ords[ii += 5];
                        wy1 = (int)co_ords[ii + 1];
                        wx2 = (int)co_ords[ii + 2];
                        wy2 = (int)co_ords[ii + 3];
                        seperator = (int)co_ords[ii + 4];
                        rectangle = new int[]{wx1, wy2, wx2 - wx1, wy1 - wy2};
                        vr.addElement(rectangle);
                    }
                    vr.trim();
                    list.add(vr.get());
                    continue;
                }
                list.add(rectangle);
            }
        }
        return list;
    }

    public final float[] findText(int x1, int y1, int x2, int y2, String[] terms, int searchType) throws PdfException {
        return this.searcher.findText(x1, y1, x2, y2, terms, searchType);
    }

    public final float[] findText(String[] terms, int searchType) throws PdfException {
        return this.searcher.findText(terms, searchType);
    }

    public String[] getTeasers() {
        return this.searcher.getTeasers();
    }

    public void generateTeasers() {
        this.searcher.generateTeasers(true);
    }
}

