/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.grouping;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.jpedal.grouping.Fragment;
import org.jpedal.objects.PdfData;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;

final class GroupingUtils {
    private static final Map<String, String> asciiMappings;

    private GroupingUtils() {
    }

    static String getLineDownSeparator(StringBuilder rawLine1, StringBuilder rawLine2, boolean isXMLExtraction) {
        StringBuilder line2;
        StringBuilder line1;
        String returnValue = " ";
        if (isXMLExtraction) {
            line1 = Strip.stripXML(rawLine1, true);
            line2 = Strip.stripXML(rawLine2, true);
        } else {
            line1 = Strip.trim(rawLine1);
            line2 = Strip.trim(rawLine2);
        }
        int line1Len = line1.length();
        int line2Len = line2.length();
        if (line1Len > 1 && line2Len > 1) {
            char line1Char2 = line1.charAt(line1Len - 1);
            char line1Char1 = line1.charAt(line1Len - 2);
            char line2Char1 = line2.charAt(0);
            char line2Char2 = line2.charAt(1);
            if ((line1Char1 == '.' || line1Char2 == '.') && (Character.isUpperCase(line2Char1) || line2Char1 == '&' || Character.isUpperCase(line2Char2) || line2Char2 == '&')) {
                returnValue = isXMLExtraction ? "<p></p>\n" : "\n";
            }
        }
        return returnValue;
    }

    static int[] reverse(int[] indices) {
        int count = indices.length;
        int[] newIndex = new int[count];
        for (int i2 = 0; i2 < count; ++i2) {
            newIndex[i2] = indices[count - i2 - 1];
        }
        return newIndex;
    }

    static boolean isFragmentWithinArea(Fragment fragment, float minX, float minY, float maxX, float maxY) {
        int mode = fragment.getWritingMode();
        if (mode == 0 || mode == 1) {
            float textHeight = fragment.getY1() - fragment.getY2();
            return (fragment.getY2() > minY && fragment.getY1() < maxY || fragment.getY2() > minY && (double)(maxY - fragment.getY2()) > (double)textHeight * 0.5 || fragment.getY1() < maxY && (double)(fragment.getY1() - minY) > (double)textHeight * 0.5) && minX + maxX > 0.0f && !(fragment.getX2() < minX) && !(fragment.getX1() > maxX);
        }
        return (mode == 3 || mode == 2) && fragment.getX1() > minX && fragment.getX2() < maxX && fragment.getY1() > minY && fragment.getY2() < maxY;
    }

    static boolean checkForPunctuation(String textValue, String punctuation) {
        if (punctuation == null || punctuation.isEmpty()) {
            return false;
        }
        boolean endsWithPunctuation = false;
        int textLength = textValue.length();
        int ii = textLength - 1;
        if (textLength > 0) {
            boolean inTag;
            char testChar = textValue.charAt(ii);
            boolean bl2 = inTag = testChar == '>';
            while ((inTag || testChar == ' ') && ii > 0) {
                if (testChar == '<') {
                    inTag = false;
                }
                if ((testChar = textValue.charAt(--ii)) != '>') continue;
                inTag = true;
            }
            if (testChar == ';') {
                endsWithPunctuation = true;
                --ii;
                while (ii > -1) {
                    testChar = textValue.charAt(ii);
                    if (testChar == '&' || testChar == '#') {
                        endsWithPunctuation = false;
                        ii = 0;
                    }
                    if (ii != 0 && testChar != ' ' && Character.isLetterOrDigit(testChar)) {
                        --ii;
                        continue;
                    }
                    break;
                }
            } else if (punctuation.indexOf(testChar) != -1) {
                endsWithPunctuation = true;
            }
        }
        return endsWithPunctuation;
    }

    static int[] getUnusedFragments(boolean[] isUsed) {
        int total_fragments = isUsed.length;
        int ii = 0;
        int[] temp_index = new int[total_fragments];
        for (int i2 = 0; i2 < total_fragments; ++i2) {
            if (isUsed[i2]) continue;
            temp_index[ii] = i2;
            ++ii;
        }
        int[] items = new int[ii];
        System.arraycopy(temp_index, 0, items, 0, ii);
        return items;
    }

    static void removeEncoding(boolean[] isUsed, StringBuilder[] content) {
        int[] items;
        for (int item : items = GroupingUtils.getUnusedFragments(isUsed)) {
            int current = item;
            if (isUsed[current]) continue;
            content[current] = GroupingUtils.removeHiddenMarkers(content[current]);
        }
    }

    static StringBuilder cleanup(StringBuilder buffer) {
        if (buffer == null) {
            return null;
        }
        String buf = buffer.toString().replaceAll("&(?:(?!(?:#[0-9]+?|[A-Za-z]+?);)|(?=amp;))", "&amp;");
        Iterator<String> iterator = asciiMappings.keySet().iterator();
        while (iterator.hasNext()) {
            String o2;
            String character = o2 = iterator.next();
            String mappedCharacter = asciiMappings.get(character);
            buf = buf.replace(character, mappedCharacter);
        }
        return new StringBuilder(buf);
    }

    static int[] validateCoordinates(int x1, int y1, int x2, int y2) {
        if (x1 > x2 || y1 < y2) {
            int temp;
            if (x1 > x2) {
                temp = x1;
                x1 = x2;
                x2 = temp;
                LogWriter.writeLog("x1 > x2, coordinates were swapped to validate");
            }
            if (y1 < y2) {
                temp = y1;
                y1 = y2;
                y2 = temp;
                LogWriter.writeLog("y1 < y2, coordinates were swapped to validate");
            }
        }
        return new int[]{x1, y1, x2, y2};
    }

    static boolean handleSpaces(boolean isWordlist, Fragment fragment) {
        String textValue = fragment.textValue;
        int ptr = textValue.indexOf(32);
        if (ptr == -1) {
            ptr = 0;
        }
        if (isWordlist) {
            int len = textValue.length();
            while (ptr < len && textValue.charAt(ptr) == ' ') {
                ++ptr;
            }
        }
        fragment.pt = ptr > 0 ? (fragment.pt += (float)ptr * Float.parseFloat(fragment.char_width)) : (fragment.pt += Float.parseFloat(fragment.char_width));
        return ptr > 0;
    }

    static StringBuilder removeHiddenMarkers(StringBuilder content) {
        String marker = PdfData.marker;
        if (content.indexOf(marker) == -1) {
            return content;
        }
        StringTokenizer tokens = new StringTokenizer(content.toString(), marker, true);
        StringBuilder processedData = new StringBuilder();
        while (tokens.hasMoreTokens()) {
            String temp = tokens.nextToken();
            if (temp.equals(marker)) {
                tokens.nextToken();
                tokens.nextToken();
                tokens.nextToken();
                tokens.nextToken();
                processedData.append(tokens.nextToken());
                continue;
            }
            processedData.append(temp);
        }
        return processedData;
    }

    static int getFirstChar(StringBuilder buffer, boolean isXMLExtraction) {
        int i2 = -1;
        boolean inTag = false;
        int count = buffer.length();
        int openChar = 32;
        for (int ptr = 0; ptr < count; ++ptr) {
            char nextChar = buffer.charAt(ptr);
            if (!inTag && isXMLExtraction && (nextChar == '<' || nextChar == '&')) {
                inTag = true;
                openChar = nextChar;
                if (openChar == 38) {
                    if (ptr + 1 == count) {
                        i2 = 38;
                        ptr = count;
                    } else {
                        char c2 = buffer.charAt(ptr + 1);
                        if (c2 != '#' && c2 != 'g' && c2 != 'l') {
                            i2 = 38;
                            ptr = count;
                        }
                    }
                }
            }
            if (!inTag && nextChar != ' ') {
                i2 = nextChar;
                ptr = count;
            }
            if (inTag && openChar == 38 && nextChar == ' ') {
                i2 = 38;
                ptr = count;
                continue;
            }
            if (!inTag || nextChar != '>' && (openChar != 38 || nextChar != ';')) continue;
            if (nextChar == ';' && ptr > 2 && buffer.charAt(ptr - 1) == 't') {
                if (buffer.charAt(ptr - 2) == 'l') {
                    i2 = 60;
                    ptr = count;
                } else if (buffer.charAt(ptr - 2) == 'g') {
                    i2 = 62;
                    ptr = count;
                }
            }
            inTag = false;
        }
        return i2;
    }

    static int getLastChar(StringBuilder buffer, boolean isXMLExtraction) {
        int i2 = -1;
        boolean inTag = false;
        int count = buffer.length();
        int size = count--;
        int openChar = 32;
        while (count > -1) {
            char nextChar = buffer.charAt(count);
            if (inTag && openChar == 59 && nextChar == ';') {
                i2 = 59;
                count = -1;
            }
            if (!inTag && (nextChar == '>' || isXMLExtraction && nextChar == ';')) {
                inTag = true;
                int lastTokenStart = buffer.lastIndexOf("</");
                if (lastTokenStart == -1) {
                    inTag = false;
                } else {
                    for (int ptr = lastTokenStart; ptr < count; ++ptr) {
                        char charToTest = buffer.charAt(ptr);
                        if (charToTest != ' ' && charToTest != '>') continue;
                        inTag = false;
                        break;
                    }
                }
                if (inTag) {
                    openChar = nextChar;
                } else {
                    i2 = nextChar;
                    count = -1;
                }
            }
            if (!inTag && nextChar != ' ') {
                i2 = nextChar;
                count = -1;
            }
            if (nextChar == '<' || isXMLExtraction && openChar == 59 && nextChar == '&') {
                inTag = false;
                if (nextChar == '&' && count + 3 < size && buffer.charAt(count + 2) == 't' && buffer.charAt(count + 3) == ';') {
                    if (buffer.charAt(count + 1) == 'l') {
                        i2 = 60;
                        count = -1;
                    } else if (buffer.charAt(count + 1) == 'g') {
                        i2 = 62;
                        count = -1;
                    }
                }
            }
            if (inTag && openChar == 59 && nextChar == ' ') {
                count = -1;
                i2 = 59;
            }
            --count;
        }
        return i2;
    }

    static {
        int i2;
        asciiMappings = new HashMap<String, String>();
        for (i2 = 1; i2 <= 8; ++i2) {
            asciiMappings.put("&#" + i2 + ';', "");
        }
        for (i2 = 11; i2 <= 12; ++i2) {
            asciiMappings.put("&#" + i2 + ';', "");
        }
        for (i2 = 14; i2 <= 31; ++i2) {
            asciiMappings.put("&#" + i2 + ';', "");
        }
    }
}

