/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.grouping;

import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.objects.PdfData;
import org.jpedal.utils.Fonts;

class Fragment {
    private float x1;
    private float y1;
    private float x2;
    private float y2;
    private String raw;
    private String currentColor;
    private int text_length;
    private int mode;
    private float last_pt;
    private float min;
    private float max;
    float pt;
    String value;
    String textValue = "";
    String pt_reached;
    private char[] line;
    String char_width = "";

    Fragment(PdfData pdf_data, int index) {
        this.loadData(pdf_data, index);
    }

    private void loadData(PdfData pdf_data, int index) {
        this.x1 = pdf_data.f_x1[index];
        this.x2 = pdf_data.f_x2[index];
        this.y1 = pdf_data.f_y1[index];
        this.y2 = pdf_data.f_y2[index];
        this.currentColor = pdf_data.colorTag[index];
        this.text_length = pdf_data.text_length[index];
        this.mode = pdf_data.f_writingMode[index];
        this.raw = pdf_data.contents[index];
        this.line = this.raw.toCharArray();
    }

    public float getX1() {
        return this.x1;
    }

    public float getY1() {
        return this.y1;
    }

    public float getX2() {
        return this.x2;
    }

    public float getY2() {
        return this.y2;
    }

    public String getRawData() {
        return this.raw;
    }

    public String getColorTag() {
        return this.currentColor;
    }

    public int getWritingMode() {
        return this.mode;
    }

    public int getTextLength() {
        return this.text_length;
    }

    public void init(float minX, float minY, float maxX, float maxY) {
        if (this.mode == 0 || this.mode == 1) {
            this.pt = this.x1;
            this.last_pt = this.x1;
            this.min = minX;
            this.max = maxX;
        } else {
            this.pt = this.y2;
            this.last_pt = this.y2;
            this.min = minY;
            this.max = maxY;
        }
    }

    public void updatePoints(float nextPt) {
        this.last_pt = this.pt;
        this.pt = nextPt;
    }

    private boolean isWithinBounds() {
        return this.last_pt < this.min && this.pt > this.min;
    }

    public boolean isValid() {
        if (this.char_width.isEmpty()) {
            return false;
        }
        float midPoint = this.pt + Float.parseFloat(this.char_width) * 0.3f;
        return midPoint > this.min && midPoint < this.max;
    }

    public void reset() {
        this.value = "";
        this.textValue = "";
    }

    public void addXMLTag() {
        if (this.isWithinBounds() && !this.value.startsWith("<font ")) {
            this.value = Fonts.getActiveFontTag(this.raw, "") + this.value;
        }
    }

    public int getValue(int pointer, int end) {
        int startPointer = pointer;
        while (pointer < end && this.line[pointer] != PdfGroupingAlgorithms.MARKER2) {
            ++pointer;
        }
        this.value = this.raw.substring(startPointer, pointer);
        return pointer;
    }

    public int getPtReached(int pointer, int end) {
        while (pointer < end && this.line[pointer] != PdfGroupingAlgorithms.MARKER2) {
            ++pointer;
        }
        int startPointer = ++pointer;
        while (pointer < end && this.line[pointer] != PdfGroupingAlgorithms.MARKER2) {
            ++pointer;
        }
        this.pt_reached = this.raw.substring(startPointer, pointer);
        return ++pointer;
    }

    public void setFragmentCoord() {
        if (this.mode == 0 && Fragment.outsideOfRange(this.min, this.max, this.x1) && this.pt >= this.min) {
            this.x1 = this.pt;
        }
        if (this.mode == 1 && Fragment.outsideOfRange(this.min, this.max, this.x2) && this.pt <= this.max) {
            this.x2 = this.pt;
        }
        if (this.mode == 3 && Fragment.outsideOfRange(this.min, this.max, this.y2) && this.pt >= this.min) {
            this.y2 = this.pt;
        }
        if (this.mode == 2 && Fragment.outsideOfRange(this.min, this.max, this.y1) && this.pt <= this.min) {
            this.y1 = this.pt;
        }
    }

    private static boolean outsideOfRange(float min, float max, float value) {
        return value < min || max < value;
    }

    public int getCharWidth(int pointer, int end) {
        int startPointer = pointer;
        while (pointer < end && this.line[pointer] != PdfGroupingAlgorithms.MARKER2) {
            ++pointer;
        }
        this.char_width = this.raw.substring(startPointer, pointer);
        return ++pointer;
    }

    void alterCoordsBasedOnWritingMode(float value) {
        switch (this.mode) {
            case 0: {
                this.x1 = value;
                break;
            }
            case 1: {
                this.x2 = value;
                break;
            }
            case 3: {
                this.y2 = value;
                break;
            }
            case 2: {
                this.y1 = value;
                break;
            }
        }
    }

    public boolean isSpace(boolean breakOnSpace) {
        return breakOnSpace && (this.textValue.indexOf(32) != -1 || this.value.endsWith(" ")) || this.textValue.contains("   ");
    }
}

