/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.function;

import org.jpedal.function.PDFFunction;
import org.jpedal.function.PDFGenericFunction;

public class PDFStitching
extends PDFGenericFunction
implements PDFFunction {
    private PDFFunction[] functions;
    private float[] mbounds = new float[2];
    private final float[] subinput = new float[1];

    public PDFStitching(PDFFunction[] functions, float[] encode, float[] bounds, float[] domain, float[] range) {
        super(domain, range);
        if (bounds != null) {
            this.mbounds = new float[bounds.length + 2];
            System.arraycopy(bounds, 0, this.mbounds, 1, bounds.length);
        }
        this.mbounds[0] = domain[0];
        this.mbounds[this.mbounds.length - 1] = domain[1];
        if (encode != null) {
            this.encode = encode;
        }
        if (functions != null) {
            this.functions = functions;
        }
    }

    @Override
    public float[] compute(float[] values) {
        int subi;
        float x2 = PDFStitching.min(PDFStitching.max(values[0], this.domain[0]), this.domain[1]);
        for (subi = 0; subi < this.mbounds.length - 1 && !(x2 <= this.mbounds[subi + 1]); ++subi) {
        }
        this.subinput[0] = PDFStitching.interpolate(x2, this.mbounds[subi], this.mbounds[subi + 1], this.encode[subi * 2], this.encode[subi * 2 + 1]);
        float[] output = this.functions[subi].computeStitch(this.subinput);
        if (this.range != null) {
            for (int i2 = 0; i2 != this.range.length / 2; ++i2) {
                output[i2] = PDFStitching.min(PDFStitching.max(output[i2], this.range[i2 * 2]), this.range[i2 * 2 + 1]);
            }
        }
        return output;
    }

    @Override
    public float[] computeStitch(float[] values) {
        int subi;
        float x2 = PDFStitching.min(PDFStitching.max(values[0], this.domain[0]), this.domain[1]);
        for (subi = 0; subi < this.mbounds.length - 1 && !(x2 <= this.mbounds[subi + 1]); ++subi) {
        }
        this.subinput[0] = PDFStitching.interpolate(x2, this.mbounds[subi], this.mbounds[subi + 1], this.encode[subi * 2], this.encode[subi * 2 + 1]);
        float[] output = this.functions[subi].compute(this.subinput);
        for (int i2 = 0; i2 != this.range.length / 2; ++i2) {
            output[i2] = PDFStitching.min(PDFStitching.max(output[i2], this.range[i2 * 2]), this.range[i2 * 2 + 1]);
        }
        return output;
    }
}

