/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.function;

import org.jpedal.function.PDFFunction;
import org.jpedal.function.PDFGenericFunction;

public class PDFSampled
extends PDFGenericFunction
implements PDFFunction {
    private final int[] size;
    private final int m;
    private final int n;
    private final float[] outputs;
    private final double[] sampleArray;
    private float[] prevInputs;
    private final double[] cubeN;
    private final int[] cubeVertex;
    private final int cubeVertices;

    public PDFSampled(byte[] stream, int bits, float[] domain, float[] range, float[] encode, float[] decode, int[] size) {
        super(domain, range);
        int defaultSize;
        int i2;
        this.size = size;
        this.m = domain.length / 2;
        this.n = range.length / 2;
        int sampleLen = 1;
        for (int aSize : size) {
            sampleLen *= aSize;
        }
        this.sampleArray = new double[sampleLen *= range.length >> 1];
        int pos = 0;
        int buffer = 0;
        double sampleMul = 1.0 / (Math.pow(2.0, bits) - 1.0);
        int index = 0;
        for (i2 = 0; i2 < sampleLen; ++i2) {
            while (pos < bits) {
                buffer <<= 8;
                buffer |= stream[index++] & 0xFF;
                pos += 8;
            }
            this.sampleArray[i2] = (double)(buffer >> (pos -= bits)) * sampleMul;
            buffer = (int)((long)buffer & (1L << pos) - 1L);
        }
        if (encode != null) {
            this.encode = encode;
        } else {
            defaultSize = size.length;
            this.encode = new float[defaultSize * 2];
            for (int ii = 0; ii < defaultSize; ++ii) {
                this.encode[ii * 2 + 1] = size[ii] - 1;
            }
        }
        if (decode != null) {
            this.decode = decode;
        } else {
            defaultSize = range.length;
            this.decode = new float[defaultSize];
            System.arraycopy(range, 0, this.decode, 0, defaultSize);
        }
        this.outputs = new float[this.n];
        this.prevInputs = new float[this.m];
        for (i2 = 0; i2 < this.m; ++i2) {
            this.prevInputs[i2] = Float.MAX_VALUE;
        }
        this.cubeVertices = 1 << this.m;
        this.cubeN = new double[this.cubeVertices];
        this.cubeVertex = new int[this.cubeVertices];
    }

    @Override
    public float[] computeStitch(float[] subinput) {
        return this.compute(subinput);
    }

    private static boolean isSame(float[] arr0, float[] arr1) {
        for (int i2 = 0; i2 < arr0.length; ++i2) {
            if (arr0[i2] == arr1[i2]) continue;
            return false;
        }
        return true;
    }

    @Override
    public float[] compute(float[] input) {
        int j2;
        int i2;
        if (PDFSampled.isSame(input, this.prevInputs)) {
            return this.outputs;
        }
        this.prevInputs = (float[])input.clone();
        for (i2 = 0; i2 < this.cubeVertices; ++i2) {
            this.cubeN[i2] = 1.0;
            this.cubeVertex[i2] = 0;
        }
        int k2 = this.n;
        int pos = 1;
        for (i2 = 0; i2 < this.m; ++i2) {
            int first = 2 * i2;
            int next = first + 1;
            double xi = Math.min(Math.max(input[i2], this.domain[first]), this.domain[next]);
            double e2 = PDFSampled.interpolateDouble(xi, this.domain[first], this.domain[next], this.encode[first], this.encode[next]);
            int cur = this.size[i2];
            double e0 = (e2 = Math.min(Math.max(e2, 0.0), (double)(cur - 1))) < (double)(cur - 1) ? (double)((int)e2) : e2 - 1.0;
            double n0 = e0 + 1.0 - e2;
            double n1 = e2 - e0;
            double offset0 = e0 * (double)k2;
            double offset1 = offset0 + (double)k2;
            for (j2 = 0; j2 < this.cubeVertices; ++j2) {
                if ((j2 & pos) != 0) {
                    int n2 = j2;
                    this.cubeN[n2] = this.cubeN[n2] * n1;
                    int n3 = j2;
                    this.cubeVertex[n3] = (int)((double)this.cubeVertex[n3] + offset1);
                    continue;
                }
                int n4 = j2;
                this.cubeN[n4] = this.cubeN[n4] * n0;
                int n5 = j2;
                this.cubeVertex[n5] = (int)((double)this.cubeVertex[n5] + offset0);
            }
            k2 *= cur;
            pos <<= 1;
        }
        for (i2 = 0; i2 < this.n; ++i2) {
            int ff = i2 << 1;
            int nn = ff + 1;
            double pp = 0.0;
            for (j2 = 0; j2 < this.cubeVertices; ++j2) {
                int kk = this.cubeVertex[j2] + 1;
                if (kk <= -1) continue;
                pp += this.sampleArray[this.cubeVertex[j2] + i2] * this.cubeN[j2];
            }
            pp = PDFSampled.interpolateDouble(pp, 0.0, 1.0, this.decode[ff], this.decode[nn]);
            this.outputs[i2] = (float)Math.min(Math.max(pp, (double)this.range[ff]), (double)this.range[nn]);
        }
        return this.outputs;
    }

    private static double interpolateDouble(double x2, double xmin, double xmax, double ymin, double ymax) {
        return (x2 - xmin) * (ymax - ymin) / (xmax - xmin) + ymin;
    }
}

