/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.function;

import org.jpedal.function.PDFFunction;
import org.jpedal.function.PDFGenericFunction;

public class PDFExponential
extends PDFGenericFunction
implements PDFFunction {
    private float[] C0 = new float[]{0.0f};
    private final float N;
    private final float[] diffs;
    private final float[] output;
    private final float domain0;
    private final float domain1;

    public PDFExponential(float N2, float[] C0, float[] C1, float[] domain, float[] range) {
        super(domain, range);
        this.N = N2;
        if (C0 != null) {
            this.C0 = C0;
        }
        float[] c1 = new float[]{1.0f};
        if (C1 != null) {
            c1 = C1;
        }
        int returnValues = this.C0.length;
        this.diffs = new float[returnValues];
        for (int i2 = 0; i2 < this.diffs.length; ++i2) {
            this.diffs[i2] = c1[i2] - this.C0[i2];
        }
        this.output = new float[returnValues];
        this.domain0 = domain[0];
        this.domain1 = domain[1];
    }

    @Override
    public float[] computeStitch(float[] subinput) {
        return this.compute(subinput);
    }

    @Override
    public float[] compute(float[] values) {
        int i2;
        float x2 = PDFExponential.min(PDFExponential.max(values[0], this.domain0), this.domain1);
        if ((double)this.N != 1.0) {
            x2 = (float)Math.pow(x2, this.N);
        }
        for (i2 = 0; i2 < this.C0.length; ++i2) {
            this.output[i2] = this.C0[i2] + x2 * this.diffs[i2];
        }
        if (this.range != null) {
            for (i2 = 0; i2 < this.C0.length; ++i2) {
                this.output[i2] = PDFExponential.min(PDFExponential.max(this.output[i2], this.range[i2 * 2]), this.range[i2 * 2 + 1]);
            }
        }
        return this.output;
    }
}

