/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.function;

import org.jpedal.function.PDFFunction;
import org.jpedal.function.PDFGenericFunction;
import org.jpedal.function.PostScriptCompiler;
import org.jpedal.utils.LogWriter;

public class PDFCalculator
extends PDFGenericFunction
implements PDFFunction {
    private final PostScriptCompiler comp;

    public PDFCalculator(byte[] stream, float[] domain, float[] range) {
        super(domain, range);
        this.comp = new PostScriptCompiler(stream);
    }

    @Override
    public float[] computeStitch(float[] subinput) {
        return this.compute(subinput);
    }

    @Override
    public float[] compute(float[] values) {
        float[] result = new float[this.range.length / 2];
        try {
            double[] stack = this.comp.executeScript(values);
            for (int i2 = 0; i2 < result.length; ++i2) {
                result[i2] = PDFCalculator.min(PDFCalculator.max((float)stack[i2], this.range[i2 * 2]), this.range[i2 * 2 + 1]);
            }
        }
        catch (Exception e2) {
            LogWriter.writeLog("Exception: " + e2.getMessage());
        }
        return result;
    }
}

