/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import org.jpedal.io.ObjectStore;
import org.jpedal.utils.FastByteArrayOutputStream;
import org.jpedal.utils.LogWriter;

public final class FontLoader {
    private FontLoader() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] getBytes(String substituteFont) {
        byte[] subFontData = null;
        if (substituteFont.startsWith("jar:") || substituteFont.startsWith("http:")) {
            String fontToUsed = substituteFont;
            throw new RuntimeException("Substitute fonts using the jar or http protocol have been deprecated");
        }
        String fontToUsed = "file:///" + substituteFont;
        try (InputStream jarFile = FontLoader.class.getResourceAsStream(fontToUsed);){
            byte[] buffer = new byte[65535];
            if (jarFile == null) {
                File file = new File(substituteFont);
                long length = file.length();
                if (length > Integer.MAX_VALUE) {
                    LogWriter.writeLog("Substituted font file exceeded the maximum supported file size (2147483647 bytes). Could not load.");
                    byte[] byArray = null;
                    return byArray;
                }
                subFontData = ObjectStore.readFromFile(substituteFont, null);
                return subFontData;
            }
            try (BufferedInputStream from = new BufferedInputStream(jarFile);){
                int bytes_read;
                FastByteArrayOutputStream to = new FastByteArrayOutputStream(from.available());
                while ((bytes_read = from.read(buffer)) != -1) {
                    to.write(buffer, 0, bytes_read);
                }
                subFontData = to.toByteArray();
                return subFontData;
            }
        }
        catch (Error | Exception e2) {
            LogWriter.writeLog("Unable to load substitute font " + e2);
        }
        return subFontData;
    }
}

