/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt.hinting;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.text.NumberFormat;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.EventListener;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Maxp;
import org.jpedal.fonts.tt.hinting.PointData;
import org.jpedal.fonts.tt.hinting.TTGraphicsState;
import org.jpedal.fonts.tt.hinting.TTVM;
import org.jpedal.utils.LogWriter;

public class TTVMDebug
extends TTVM {
    private static final boolean PRINT_COORDS_AFTER_EACH_INSTRUCTION = false;
    private static final boolean WATCH_A_POINT = false;
    private static final int WATCH_POINT = 53;
    private static boolean showDebugWindow;
    private static final String[] OPCODE_DESCRIPTIONS;
    private static final String GLYPH_PROGRAM_STRING = "Glyph program";
    private static final String X_STRING = "  X: ";
    private static final String Y_STRING = "  Y: ";
    private JList<String> currentInstructionList;
    private JList<String> stackList;
    private JList<String> cvtList;
    private JList<String> storageList;
    private final Deque<int[]> codeStack = new ArrayDeque<int[]>();
    private final Deque<Integer> numberStack = new ArrayDeque<Integer>();
    private final Deque<String> idStack = new ArrayDeque<String>();
    private int watchX;
    private int watchY;
    private int[] programToDebug;
    private boolean[] programToDebugIsData;
    private JDialog debugWindow;
    private JLabel currentCode;
    private JLabel debugXLabel;
    private JLabel debugYLabel;
    private JButton stepOutButton;
    private JComponent stateDisplay;
    private JComponent debugGlyphDisplay;
    private JCheckBox showInterpolatedShadow;
    private JLabel currentInstructionDescription;
    private boolean stepInto;
    private boolean debuggerRunningInBackground;
    private int debugPointer;
    private int instructionsExecuted;
    private int functionsLineCount;
    private TTGraphicsState dGS;
    private JPanel chooserPanel;
    private JFrame chooserFrame;
    private final String fontName;
    private static int nextWindowY;

    public TTVMDebug(FontFile2 currentFontFile, Maxp maxp, String fontName) {
        super(currentFontFile, maxp);
        this.fontName = fontName;
    }

    private void setUpChooserFrame() {
        this.chooserFrame = new JFrame("Hinting Debugger Glyphs - " + this.fontName);
        this.chooserFrame.setSize(800, 600);
        this.chooserFrame.setLocation(0, nextWindowY);
        nextWindowY = (nextWindowY + 30) % 300;
        this.chooserFrame.setDefaultCloseOperation(2);
        this.chooserFrame.setLayout(new BorderLayout());
        this.chooserPanel = new JPanel();
        this.chooserPanel.setLayout(new GridLayout(0, 6));
        JScrollPane scrollPane = new JScrollPane(this.chooserPanel);
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setVerticalScrollBarPolicy(20);
        this.chooserFrame.add((Component)scrollPane, "Center");
        this.chooserFrame.setVisible(true);
    }

    private String getCurrentFunc() {
        String function = GLYPH_PROGRAM_STRING;
        for (Map.Entry entry : this.functions.entrySet()) {
            if (entry.getValue() != this.programToDebug) continue;
            function = "Function " + entry.getKey();
        }
        for (Map.Entry entry : this.instructions.entrySet()) {
            if (entry.getValue() != this.programToDebug) continue;
            function = "Instruction " + entry.getKey();
        }
        return function;
    }

    @Override
    void setProgramToDebug(int[] instructions) {
        if (showDebugWindow) {
            this.programToDebug = instructions;
            this.programToDebugIsData = TTVMDebug.getInstructionStreamIsData(this.programToDebug);
        }
    }

    @Override
    int process(int code, int currentPointer, int[] program, TTGraphicsState gs) {
        if (this.printOut) {
            System.out.print(currentPointer + "\t");
            System.out.println(TTVMDebug.getStringForOpcode(program, currentPointer));
        }
        if (showDebugWindow) {
            this.stack.setCurrentFunc(this.getCurrentFunc());
        }
        int originalPointer = currentPointer;
        if ((currentPointer = super.process(code, currentPointer, program, gs)) < 0) {
            currentPointer = -currentPointer;
        }
        if (showDebugWindow && this.debugWindow != null && this.debugWindow.isVisible()) {
            this.instructionsExecuted += currentPointer + 1 - originalPointer;
            if (this.debugPointer == -1) {
                return this.debugPointer;
            }
        }
        return currentPointer;
    }

    @Override
    boolean execute(int[] program, TTGraphicsState gs) {
        if (program == null) {
            return false;
        }
        if (showDebugWindow && this.stepInto && this.debugWindow != null && this.debugWindow.isVisible()) {
            this.codeStack.push(this.programToDebug);
            this.numberStack.push(this.debugPointer);
            this.idStack.push(this.getCurrentFunc());
            this.functionsLineCount += program.length;
            this.setCurrentCodeForDebug(program, -1, !this.debuggerRunningInBackground);
            return false;
        }
        boolean failedOnHinting = super.execute(program, gs);
        return failedOnHinting;
    }

    private void printCoords() {
        for (int i2 = 0; i2 < this.x[1].length; ++i2) {
            System.out.print(i2 + "\t" + this.x[1][i2] + '\t' + this.y[1][i2] + '\t' + this.x[3][i2] + '\t' + this.y[3][i2]);
            System.out.println();
            if (!this.contour[1][i2]) continue;
            System.out.println();
        }
        System.out.println();
        System.out.println();
    }

    private void restartDebugger() {
        this.stack = new TTVM.Stack();
        try {
            this.dGS = (TTGraphicsState)this.graphicsState.clone();
            this.graphicsState.resetForGlyph();
            this.dGS.resetForGlyph();
        }
        catch (CloneNotSupportedException e2) {
            LogWriter.writeLog("Exception: " + e2.getMessage());
        }
        int twilightCount = this.maxp.getMaxTwilightPoints();
        this.x[1] = new int[this.x[1].length];
        this.y[1] = new int[this.y[1].length];
        this.fontProgramRun = false;
        this.setScaleVars(this.scaler, this.ppem, this.ptSize);
        System.arraycopy(this.x[3], 0, this.x[1], 0, this.x[1].length);
        this.x[0] = new int[twilightCount];
        this.x[2] = new int[twilightCount];
        System.arraycopy(this.y[3], 0, this.y[1], 0, this.y[1].length);
        this.y[0] = new int[twilightCount];
        this.y[2] = new int[twilightCount];
        System.arraycopy(this.touched[3], 0, this.touched[1], 0, this.touched[1].length);
        this.touched[0] = new boolean[twilightCount][2];
        this.touched[2] = new boolean[twilightCount][2];
        if (!this.codeStack.isEmpty()) {
            this.programToDebug = this.codeStack.getFirst();
            this.programToDebugIsData = TTVMDebug.getInstructionStreamIsData(this.programToDebug);
        }
        this.codeStack.clear();
        this.numberStack.clear();
        this.idStack.clear();
        this.functionsLineCount = 0;
        this.debugPointer = 0;
        this.instructionsExecuted = 0;
        this.currentCode.setText(GLYPH_PROGRAM_STRING);
        this.stepOutButton.setEnabled(false);
    }

    private void refreshDebugger(boolean programHasChanged) {
        if (programHasChanged) {
            this.currentInstructionList.setListData((String[])TTVMDebug.getInstructionsAsStringArray(this.programToDebug));
        }
        int start = this.debugPointer;
        int end = this.debugPointer;
        while (end + 1 < this.programToDebug.length && this.programToDebugIsData[end + 1]) {
            ++end;
        }
        this.currentInstructionList.setSelectionInterval(start, end);
        if (start != 0) {
            int forward = end + 3;
            if (forward >= this.programToDebug.length) {
                forward = this.programToDebug.length - 1;
            }
            this.currentInstructionList.ensureIndexIsVisible(forward);
            int back = start - 2;
            if (back < 0) {
                back = 0;
            }
            this.currentInstructionList.ensureIndexIsVisible(back);
            this.currentInstructionList.ensureIndexIsVisible(end);
        }
        this.currentInstructionList.ensureIndexIsVisible(start);
        this.stackList.setListData((String[])this.stack.toStringArray());
        this.cvtList.setListData((String[])this.cvt.getCVTForDebug());
        this.storageList.setListData((String[])this.getStorageAsArray());
        int line = Math.max(this.debugPointer, 0);
        this.currentInstructionDescription.setText(TTVMDebug.getStringForOpcode(this.programToDebug, line));
        this.stateDisplay.repaint();
        this.debugGlyphDisplay.repaint();
    }

    private static String getStringForOpcode(int[] program, int line) {
        if (line < 0) {
            line = 0;
        }
        int opcode = line < program.length ? program[line] : -1;
        if ((opcode = TTVMDebug.reduceInstructionToKey(opcode)) >= 0 && opcode <= 142) {
            return OPCODE_DESCRIPTIONS[opcode];
        }
        switch (opcode) {
            case 176: {
                return "PUSHB     - Pushes bytes to the stack";
            }
            case 184: {
                return "PUSHW     - Pushes words to the stack";
            }
            case 192: {
                return "MDRP      - Preserves the master outline distance between the specified point and the reference point rp0";
            }
            case 224: {
                return "MIRP      - Sets the distance between a point and rp0 to a CVT entry";
            }
        }
        return " ";
    }

    private String[] getStorageAsArray() {
        String[] result = new String[this.storage.length];
        for (int i2 = 0; i2 < this.storage.length; ++i2) {
            result[i2] = i2 + ": " + this.storage[i2] + "       (" + NumberFormat.getNumberInstance().format((double)this.storage[i2] / 64.0) + ')';
        }
        return result;
    }

    private void setCurrentCodeForDebug(int[] code, int pointer, boolean updateDisplay) {
        this.programToDebug = code;
        this.debugPointer = pointer;
        try {
            if (!updateDisplay) {
                return;
            }
            this.programToDebugIsData = TTVMDebug.getInstructionStreamIsData(this.programToDebug);
            this.refreshDebugger(true);
            StringBuilder idText = new StringBuilder("<html>");
            for (String s2 : this.idStack) {
                idText.append(s2).append("<br>");
            }
            idText.append("> ").append(this.getCurrentFunc()).append("</html>");
            this.currentCode.setText(idText.toString());
            this.stepOutButton.setEnabled(!GLYPH_PROGRAM_STRING.equals(this.getCurrentFunc()));
        }
        catch (Exception e2) {
            LogWriter.writeLog(e2);
        }
    }

    private void runDebuggerTo(int targetPointer) {
        if (targetPointer == this.debugPointer) {
            return;
        }
        int targetInstr = targetPointer;
        int diff = -1;
        if (targetInstr >= 0) {
            int add = 0;
            if (targetInstr >= this.programToDebug.length) {
                add = targetInstr - (this.programToDebug.length - 1);
                targetInstr = this.programToDebug.length - 1;
            }
            while (this.programToDebugIsData[targetInstr]) {
                --targetInstr;
            }
            diff = targetInstr - this.debugPointer + add;
        }
        int target = this.instructionsExecuted + diff;
        boolean skipFunctions = true;
        if (target < this.instructionsExecuted) {
            this.restartDebugger();
            skipFunctions = false;
        }
        int startLineCount = this.functionsLineCount;
        this.debuggerRunningInBackground = true;
        while (this.instructionsExecuted < target + (skipFunctions ? this.functionsLineCount - startLineCount : 0)) {
            this.stepInto = true;
            this.debugPointer = this.process(this.programToDebug[this.debugPointer], this.debugPointer, this.programToDebug, this.dGS);
            if (!this.stepInto && this.debugPointer < 0) {
                this.debugPointer = -this.debugPointer;
            }
            ++this.debugPointer;
            if (this.debugPointer != this.programToDebug.length || this.codeStack.isEmpty()) continue;
            this.idStack.pop();
            this.setCurrentCodeForDebug(this.codeStack.pop(), this.numberStack.pop() + 1, false);
        }
        this.debuggerRunningInBackground = false;
        this.setCurrentCodeForDebug(this.programToDebug, this.debugPointer, true);
        this.stepInto = false;
        this.instructionsExecuted = target;
    }

    private void advanceDebugger(boolean stepIntoCall) {
        if (this.debugPointer < this.programToDebug.length) {
            Runnable t2 = () -> {
                this.stepInto = stepIntoCall;
                this.debugPointer = this.process(this.programToDebug[this.debugPointer], this.debugPointer, this.programToDebug, this.dGS);
                if (!this.stepInto && this.debugPointer < 0) {
                    this.debugPointer = -this.debugPointer;
                }
                this.stepInto = false;
                ++this.debugPointer;
                this.refreshDebugger(false);
                while (this.debugPointer == this.programToDebug.length && !this.codeStack.isEmpty()) {
                    this.idStack.pop();
                    this.setCurrentCodeForDebug(this.codeStack.pop(), this.numberStack.pop() + 1, true);
                }
            };
            try {
                SwingUtilities.invokeAndWait(t2);
            }
            catch (InterruptedException | InvocationTargetException e2) {
                LogWriter.writeLog("Exception: " + e2.getMessage());
            }
        }
    }

    private void runDebugger() {
        if (this.programToDebug == null) {
            JOptionPane.showMessageDialog(this.debugWindow, "No glyph program found to debug!");
            return;
        }
        this.debugWindow = new JDialog(this.chooserFrame, "TrueType Hinting Debugger", true){

            @Override
            public void dispose() {
                showDebugWindow = false;
                super.dispose();
            }
        };
        this.debugWindow.setSize(1000, 700);
        this.debugWindow.setLayout(new BorderLayout());
        this.debugWindow.setDefaultCloseOperation(2);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(0));
        JButton stepOverButton = new JButton("Step Over");
        stepOverButton.addActionListener(e2 -> this.advanceDebugger(false));
        buttonPanel.add(stepOverButton);
        JButton stepIntoButton = new JButton("Step Into");
        stepIntoButton.addActionListener(e2 -> this.advanceDebugger(true));
        buttonPanel.add(stepIntoButton);
        this.stepOutButton = new JButton("Step Out");
        this.stepOutButton.setEnabled(false);
        this.stepOutButton.addActionListener(e2 -> this.runDebuggerTo(this.programToDebug.length));
        buttonPanel.add(this.stepOutButton);
        JButton restartButton = new JButton("Restart");
        restartButton.addActionListener(e2 -> {
            this.restartDebugger();
            this.refreshDebugger(true);
        });
        buttonPanel.add(restartButton);
        JButton backButton = new JButton("Back");
        backButton.addActionListener(e2 -> this.runDebuggerTo(this.debugPointer - 1));
        buttonPanel.add(backButton);
        this.debugWindow.add("North", buttonPanel);
        JPanel instructionPanel = new JPanel();
        instructionPanel.setLayout(new BorderLayout());
        instructionPanel.setBorder(new LineBorder(Color.BLACK));
        this.currentInstructionList = new JList();
        for (MouseMotionListener mouseMotionListener : this.currentInstructionList.getMouseMotionListeners()) {
            this.currentInstructionList.removeMouseMotionListener(mouseMotionListener);
        }
        for (EventListener eventListener : this.currentInstructionList.getMouseListeners()) {
            this.currentInstructionList.removeMouseListener((MouseListener)eventListener);
        }
        JScrollPane codePane = new JScrollPane(this.currentInstructionList){

            @Override
            public Dimension getPreferredSize() {
                Dimension pref = super.getPreferredSize();
                Dimension min = this.getMinimumSize();
                int w2 = Math.max(pref.width, min.width);
                int h2 = Math.max(pref.height, min.height);
                return new Dimension(w2, h2);
            }
        };
        codePane.setMinimumSize(new Dimension(150, 100));
        this.currentCode = new JLabel(GLYPH_PROGRAM_STRING);
        instructionPanel.add("Center", codePane);
        instructionPanel.add("South", this.currentCode);
        this.debugWindow.add("West", instructionPanel);
        JPanel glyphPanel = new JPanel();
        glyphPanel.setLayout(new BorderLayout());
        glyphPanel.setBorder(new LineBorder(Color.BLACK));
        this.debugGlyphDisplay = new JComponent(){

            @Override
            public void paint(Graphics g2) {
                Graphics2D g22 = (Graphics2D)g2;
                int[] glyphBounds = TTVMDebug.getBounds(TTVMDebug.this.x[1], TTVMDebug.this.y[1]);
                int[] twilightBounds = TTVMDebug.getBounds(TTVMDebug.this.x[0], TTVMDebug.this.y[0]);
                int minX = Math.min(glyphBounds[0], twilightBounds[0]);
                int minY = Math.min(glyphBounds[1], twilightBounds[1]);
                int maxX = Math.max(glyphBounds[2], twilightBounds[2]);
                int maxY = Math.max(glyphBounds[3], twilightBounds[3]);
                int displayWidth = this.getWidth();
                int displayHeight = this.getHeight();
                int xRange = maxX - minX;
                int yRange = maxY - minY;
                double xScale = (double)displayWidth / (double)xRange;
                double yScale = (double)displayHeight / (double)yRange;
                double scale = Math.min(xScale, yScale);
                int borderWidth = 15;
                minX = (int)((double)minX - 15.0 / scale);
                maxX = (int)((double)maxX + 15.0 / scale);
                minY = (int)((double)minY - 15.0 / scale);
                maxY = (int)((double)maxY + 15.0 / scale);
                xRange = maxX - minX;
                yRange = maxY - minY;
                xScale = (double)displayWidth / (double)xRange;
                yScale = (double)displayHeight / (double)yRange;
                scale = Math.min(xScale, yScale);
                g22.translate(0, displayHeight);
                g22.scale(scale, -scale);
                g22.translate(-minX, -minY);
                g22.setPaint(Color.WHITE);
                g22.fillRect(minX, minY, (int)((double)displayWidth / scale), (int)((double)displayHeight / scale));
                g22.setPaint(new Color(180, 180, 255));
                g22.drawLine(0, minY, 0, (int)((double)displayHeight / scale));
                g22.drawLine(minX, 0, (int)((double)displayWidth / scale), 0);
                int len = (int)(3.0 / scale);
                for (int i2 = 0; i2 < TTVMDebug.this.x[1].length; ++i2) {
                    int xVal = TTVMDebug.this.x[1][i2];
                    int yVal = TTVMDebug.this.y[1][i2];
                    if (TTVMDebug.this.curve[1][i2]) {
                        g22.setPaint(Color.BLACK);
                        Ellipse2D.Double s2 = new Ellipse2D.Double((double)xVal - 2.0 / scale, (double)yVal - 2.0 / scale, 4.0 / scale, 4.0 / scale);
                        g22.fill(s2);
                    } else {
                        g22.setPaint(Color.RED);
                        g22.drawLine(xVal - len, yVal - len, xVal + len, yVal + len);
                        g22.drawLine(xVal + len, yVal - len, xVal - len, yVal + len);
                    }
                    AffineTransform store = g22.getTransform();
                    g22.translate(xVal, yVal);
                    g22.scale(1.0 / scale, -1.0 / scale);
                    g22.drawString(String.valueOf(i2), 3, -3);
                    g22.setTransform(store);
                }
                if (TTVMDebug.this.showInterpolatedShadow.isSelected()) {
                    int c2 = TTVMDebug.this.x[1].length;
                    int[] xStore = new int[c2];
                    System.arraycopy(TTVMDebug.this.x[1], 0, xStore, 0, c2);
                    int[] yStore = new int[c2];
                    System.arraycopy(TTVMDebug.this.y[1], 0, yStore, 0, c2);
                    boolean[] curveStore = new boolean[c2];
                    System.arraycopy(TTVMDebug.this.curve[1], 0, curveStore, 0, c2);
                    boolean[] contourStore = new boolean[c2];
                    System.arraycopy(TTVMDebug.this.contour[1], 0, contourStore, 0, c2);
                    TTVMDebug.this.interpolateUntouchedPoints(48);
                    TTVMDebug.this.interpolateUntouchedPoints(49);
                    GeneralPath shape = TTVMDebug.getPathFromPoints(TTVMDebug.this.x[1], TTVMDebug.this.y[1], TTVMDebug.this.curve[1], TTVMDebug.this.contour[1]);
                    g22.setPaint(new Color(255, 0, 0, 100));
                    g22.draw(shape);
                    g22.setPaint(new Color(0, 0, 0, 30));
                    g22.fill(shape);
                    System.arraycopy(xStore, 0, TTVMDebug.this.x[1], 0, c2);
                    System.arraycopy(yStore, 0, TTVMDebug.this.y[1], 0, c2);
                    System.arraycopy(curveStore, 0, TTVMDebug.this.curve[1], 0, c2);
                    System.arraycopy(contourStore, 0, TTVMDebug.this.contour[1], 0, c2);
                }
                GeneralPath shape = TTVMDebug.getPathFromPoints(TTVMDebug.this.x[1], TTVMDebug.this.y[1], TTVMDebug.this.curve[1], TTVMDebug.this.contour[1]);
                g22.setPaint(new Color(100, 100, 255, 100));
                g22.fill(shape);
                g22.setPaint(Color.BLACK);
                g22.draw(shape);
                g22.setPaint(Color.BLUE);
                for (int i3 = 0; i3 < TTVMDebug.this.x[0].length; ++i3) {
                    int xVal = TTVMDebug.this.x[0][i3];
                    int yVal = TTVMDebug.this.y[0][i3];
                    if (xVal == 0 && yVal == 0) continue;
                    if (TTVMDebug.this.curve[0][i3]) {
                        Ellipse2D.Double s3 = new Ellipse2D.Double((double)xVal - 2.0 / scale, (double)yVal - 2.0 / scale, 4.0 / scale, 4.0 / scale);
                        g22.fill(s3);
                    } else {
                        g22.drawLine(xVal - len, yVal - len, xVal + len, yVal + len);
                        g22.drawLine(xVal + len, yVal - len, xVal - len, yVal + len);
                    }
                    AffineTransform store = g22.getTransform();
                    g22.translate(xVal, yVal);
                    g22.scale(1.0 / scale, -1.0 / scale);
                    g22.drawString(String.valueOf(i3), 3, -3);
                    g22.setTransform(store);
                }
            }
        };
        this.debugGlyphDisplay.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e2) {
                double eX = e2.getX();
                double eY = e2.getY();
                int w2 = TTVMDebug.this.debugGlyphDisplay.getWidth();
                int h2 = TTVMDebug.this.debugGlyphDisplay.getHeight();
                int minX = Integer.MAX_VALUE;
                int minY = Integer.MAX_VALUE;
                int maxX = Integer.MIN_VALUE;
                int maxY = Integer.MIN_VALUE;
                for (int i2 = 0; i2 < TTVMDebug.this.x[1].length; ++i2) {
                    int val = TTVMDebug.this.x[1][i2];
                    if (val > maxX) {
                        maxX = val;
                    }
                    if (val < minX) {
                        minX = val;
                    }
                    if ((val = TTVMDebug.this.y[1][i2]) > maxY) {
                        maxY = val;
                    }
                    if (val >= minY) continue;
                    minY = val;
                }
                int xRange = maxX - minX;
                int yRange = maxY - minY;
                double xScale = (double)w2 / (double)xRange;
                double yScale = (double)h2 / (double)yRange;
                double scale = Math.min(xScale, yScale);
                int borderWidth = 15;
                minX = (int)((double)minX - 15.0 / scale);
                maxX = (int)((double)maxX + 15.0 / scale);
                minY = (int)((double)minY - 15.0 / scale);
                maxY = (int)((double)maxY + 15.0 / scale);
                xRange = maxX - minX;
                yRange = maxY - minY;
                xScale = (double)w2 / (double)xRange;
                yScale = (double)h2 / (double)yRange;
                scale = Math.min(xScale, yScale);
                eX = eX / scale + (double)minX;
                eY = (double)h2 - eY;
                eY = eY / scale + (double)minY;
                TTVMDebug.this.debugXLabel.setText(TTVMDebug.X_STRING + eX);
                TTVMDebug.this.debugYLabel.setText(TTVMDebug.Y_STRING + eY);
            }

            @Override
            public void mouseExited(MouseEvent e2) {
                TTVMDebug.this.debugXLabel.setText(TTVMDebug.X_STRING);
                TTVMDebug.this.debugYLabel.setText(TTVMDebug.Y_STRING);
            }
        });
        glyphPanel.add("Center", this.debugGlyphDisplay);
        this.showInterpolatedShadow = new JCheckBox("Show Interpolated Shadow");
        this.showInterpolatedShadow.setSelected(true);
        this.showInterpolatedShadow.addActionListener(e2 -> glyphPanel.repaint());
        glyphPanel.add("North", this.showInterpolatedShadow);
        this.currentInstructionDescription = new JLabel(OPCODE_DESCRIPTIONS[0]);
        glyphPanel.add("South", this.currentInstructionDescription);
        this.debugWindow.add("Center", glyphPanel);
        JPanel dataPanel = new JPanel(){

            @Override
            public Dimension getPreferredSize() {
                Dimension pref = super.getPreferredSize();
                Dimension min = this.getMinimumSize();
                Dimension max = this.getMaximumSize();
                int w2 = Math.max(pref.width, min.width);
                int h2 = Math.max(pref.height, min.height);
                w2 = Math.min(w2, max.width);
                h2 = Math.min(h2, max.height);
                return new Dimension(w2, h2);
            }
        };
        dataPanel.setMinimumSize(new Dimension(200, 100));
        dataPanel.setMaximumSize(new Dimension(200, 1000000));
        dataPanel.setLayout(new BorderLayout());
        dataPanel.setBorder(new LineBorder(Color.BLACK));
        JPanel jPanel = new JPanel(new BorderLayout());
        this.stackList = new JList();
        this.stackList.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e2) {
                int i2 = TTVMDebug.this.stackList.locationToIndex(e2.getPoint());
                if (i2 >= 0) {
                    TTVMDebug.this.stackList.setToolTipText("Pushed by " + TTVMDebug.this.stack.getPushedBy(i2));
                }
            }
        });
        JScrollPane stackScroll = new JScrollPane(this.stackList);
        jPanel.add("North", new JLabel("Stack:"));
        jPanel.add("Center", stackScroll);
        JPanel cvtPanel = new JPanel(new BorderLayout());
        this.cvtList = new JList<String>(this.cvt.getCVTForDebug());
        JScrollPane cvtScroll = new JScrollPane(this.cvtList);
        cvtPanel.add("North", new JLabel("CVT:"));
        cvtPanel.add("Center", cvtScroll);
        JPanel storagePanel = new JPanel(new BorderLayout());
        this.storageList = new JList<String>(this.getStorageAsArray());
        JScrollPane storageScroll = new JScrollPane(this.storageList);
        storagePanel.add("North", new JLabel("Storage:"));
        storagePanel.add("Center", storageScroll);
        dataPanel.add("North", jPanel);
        dataPanel.add("Center", cvtPanel);
        dataPanel.add("South", storagePanel);
        this.debugWindow.add("East", dataPanel);
        JPanel statePanel = new JPanel();
        statePanel.setLayout(new BorderLayout());
        statePanel.setBorder(new LineBorder(Color.BLACK));
        this.stateDisplay = new JComponent(){

            @Override
            public void paint(Graphics g2) {
                Graphics2D g22 = (Graphics2D)g2;
                g22.setPaint(Color.WHITE);
                g22.fillRect(0, 0, 81, 81);
                g22.setPaint(Color.BLACK);
                g22.drawRect(0, 0, 81, 81);
                g22.setPaint(Color.GRAY);
                g22.drawOval(0, 0, 81, 81);
                g22.drawLine(0, 40, 5, 40);
                g22.drawLine(81, 40, 76, 40);
                g22.drawLine(40, 0, 40, 5);
                g22.drawLine(40, 81, 40, 76);
                g22.drawLine(12, 12, 15, 15);
                g22.drawLine(69, 12, 66, 15);
                g22.drawLine(12, 69, 15, 66);
                g22.drawLine(69, 69, 66, 66);
                g22.setPaint(new Color(0, 100, 0));
                int[] vec = TTGraphicsState.getVectorComponents(((TTVMDebug)TTVMDebug.this).dGS.freedomVector);
                g22.drawLine(40, 40, 40 + vec[0] * 40 / 16384, 40 - vec[1] * 40 / 16384);
                g22.drawString("Freedom Vector", 84, 13);
                g22.drawString("(" + (double)vec[0] / 16384.0 + ", " + (double)vec[1] / 16384.0 + ')', 98, 23);
                g22.setPaint(Color.BLUE);
                vec = TTGraphicsState.getVectorComponents(((TTVMDebug)TTVMDebug.this).dGS.dualProjectionVector);
                g22.drawLine(41, 41, 41 + vec[0] * 40 / 16384, 41 - vec[1] * 40 / 16384);
                g22.drawString("Dual Projection Vector", 84, 65);
                g22.drawString("(" + (double)vec[0] / 16384.0 + ", " + (double)vec[1] / 16384.0 + ')', 98, 75);
                g22.setPaint(Color.MAGENTA);
                vec = TTGraphicsState.getVectorComponents(((TTVMDebug)TTVMDebug.this).dGS.projectionVector);
                g22.drawLine(41, 41, 41 + vec[0] * 40 / 16384, 41 - vec[1] * 40 / 16384);
                g22.drawString("Projection Vector", 84, 39);
                g22.drawString("(" + (double)vec[0] / 16384.0 + ", " + (double)vec[1] / 16384.0 + ')', 98, 49);
                g22.setPaint(Color.GRAY);
                g22.drawLine(240, 4, 240, 77);
                g22.setPaint(Color.BLACK);
                String TWILIGHT_ZONE_STRING = " (Twilight Zone)";
                String GLYPH_ZONE_STRING = " (Glyph Zone)";
                g22.drawString("zp0: " + ((TTVMDebug)TTVMDebug.this).dGS.zp0 + (((TTVMDebug)TTVMDebug.this).dGS.zp0 == 0 ? " (Twilight Zone)" : " (Glyph Zone)"), 250, 13);
                g22.drawString("zp1: " + ((TTVMDebug)TTVMDebug.this).dGS.zp1 + (((TTVMDebug)TTVMDebug.this).dGS.zp1 == 0 ? " (Twilight Zone)" : " (Glyph Zone)"), 250, 25);
                g22.drawString("zp2: " + ((TTVMDebug)TTVMDebug.this).dGS.zp2 + (((TTVMDebug)TTVMDebug.this).dGS.zp2 == 0 ? " (Twilight Zone)" : " (Glyph Zone)"), 250, 37);
                g22.drawString("rp0: " + ((TTVMDebug)TTVMDebug.this).dGS.rp0, 250, 51);
                g22.drawString("rp1: " + ((TTVMDebug)TTVMDebug.this).dGS.rp1, 250, 63);
                g22.drawString("rp2: " + ((TTVMDebug)TTVMDebug.this).dGS.rp2, 250, 75);
                g22.setPaint(Color.GRAY);
                g22.drawLine(404, 4, 404, 77);
                g22.setPaint(Color.BLACK);
                g22.drawString("Instruct Control: " + ((TTVMDebug)TTVMDebug.this).dGS.instructControl, 414, 13);
                g22.drawString("Auto Flip: " + ((TTVMDebug)TTVMDebug.this).dGS.autoFlip, 414, 30);
                g22.drawString("Delta Base: " + ((TTVMDebug)TTVMDebug.this).dGS.deltaBase, 414, 47);
                g22.drawString("Delta Shift: " + ((TTVMDebug)TTVMDebug.this).dGS.deltaShift, 414, 59);
                g22.drawString("Loop: " + ((TTVMDebug)TTVMDebug.this).dGS.loop, 414, 75);
                g22.setPaint(Color.GRAY);
                g22.drawLine(548, 4, 548, 77);
                g22.setPaint(Color.BLACK);
                g22.drawString("Round State: " + TTVMDebug.this.dGS.getRoundStateAsString(), 558, 13);
                g22.drawString("Minimum Distance: " + ((TTVMDebug)TTVMDebug.this).dGS.minimumDistance, 558, 30);
                g22.drawString("CVT Cut In: " + ((TTVMDebug)TTVMDebug.this).dGS.controlValueTableCutIn, 558, 46);
                g22.drawString("Single Width Cut In: " + ((TTVMDebug)TTVMDebug.this).dGS.singleWidthCutIn, 558, 63);
                g22.drawString("Single Width Value: " + ((TTVMDebug)TTVMDebug.this).dGS.singleWidthValue, 558, 75);
            }
        };
        this.stateDisplay.setMinimumSize(new Dimension(700, 81));
        this.stateDisplay.setPreferredSize(new Dimension(700, 81));
        this.stateDisplay.setMaximumSize(new Dimension(700, 81));
        statePanel.add("West", this.stateDisplay);
        JPanel mousePanel = new JPanel();
        mousePanel.setLayout(new GridLayout(0, 1));
        this.debugXLabel = new JLabel(X_STRING){

            @Override
            public Dimension getPreferredSize() {
                Dimension pref = super.getPreferredSize();
                Dimension min = this.getMinimumSize();
                int w2 = Math.max(pref.width, min.width);
                int h2 = Math.max(pref.height, min.height);
                return new Dimension(w2, h2);
            }
        };
        this.debugXLabel.setBackground(Color.WHITE);
        this.debugXLabel.setOpaque(true);
        this.debugXLabel.setBorder(new LineBorder(Color.BLACK));
        this.debugXLabel.setMinimumSize(new Dimension(200, 20));
        this.debugYLabel = new JLabel(Y_STRING);
        this.debugYLabel.setBackground(Color.WHITE);
        this.debugYLabel.setOpaque(true);
        this.debugYLabel.setBorder(new LineBorder(Color.BLACK));
        this.debugYLabel.setMinimumSize(new Dimension(200, 20));
        mousePanel.add(this.debugXLabel);
        mousePanel.add(this.debugYLabel);
        statePanel.add("East", mousePanel);
        this.debugWindow.add("South", statePanel);
        try {
            this.dGS = (TTGraphicsState)this.graphicsState.clone();
            this.dGS.resetForGlyph();
        }
        catch (CloneNotSupportedException e3) {
            LogWriter.writeLog("Exception: " + e3.getMessage());
        }
        this.stack = new TTVM.Stack();
        int twilightCount = this.maxp.getMaxTwilightPoints();
        System.arraycopy(this.x[3], 0, this.x[1], 0, this.x[1].length);
        this.x[0] = new int[twilightCount];
        this.x[2] = new int[twilightCount];
        System.arraycopy(this.y[3], 0, this.y[1], 0, this.y[1].length);
        this.y[0] = new int[twilightCount];
        this.y[2] = new int[twilightCount];
        System.arraycopy(this.touched[3], 0, this.touched[1], 0, this.touched[1].length);
        this.touched[0] = new boolean[twilightCount][2];
        this.touched[2] = new boolean[twilightCount][2];
        this.refreshDebugger(true);
        this.debugWindow.setVisible(true);
    }

    private static int[] getBounds(int[] x2, int[] y2) {
        int[] bounds = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE};
        for (int i2 = 0; i2 < x2.length; ++i2) {
            int val = x2[i2];
            if (val > bounds[2]) {
                bounds[2] = val;
            }
            if (val < bounds[0]) {
                bounds[0] = val;
            }
            if ((val = y2[i2]) > bounds[3]) {
                bounds[3] = val;
            }
            if (val >= bounds[1]) continue;
            bounds[1] = val;
        }
        return bounds;
    }

    @Override
    public boolean processGlyph(int[] instructions, int[] glyfX, int[] glyfY, boolean[] curves, boolean[] contours, double ppem, double scaler) {
        if (this.chooserFrame == null) {
            this.setUpChooserFrame();
        }
        GlyphDetails details = new GlyphDetails(instructions, glyfX, glyfY, curves, contours, ppem, scaler);
        this.chooserPanel.add(details.button);
        boolean failedOnHinting = super.processGlyph(instructions, glyfX, glyfY, curves, contours, ppem, scaler);
        if (showDebugWindow) {
            this.runDebugger();
        }
        return failedOnHinting;
    }

    private static boolean[] getInstructionStreamIsData(int[] program) {
        if (program == null) {
            return new boolean[0];
        }
        String[] strings = TTVMDebug.getInstructionsAsStringArray(program);
        boolean[] result = new boolean[strings.length];
        for (int i2 = 0; i2 < strings.length; ++i2) {
            result[i2] = !strings[i2].contains(":");
        }
        return result;
    }

    private static String[] getInstructionsAsStringArray(int[] program) {
        if (program == null) {
            return new String[0];
        }
        String[] result = new String[program.length];
        StringBuilder depth = new StringBuilder();
        for (int n2 = 0; n2 < program.length; ++n2) {
            int word;
            int j2;
            int count;
            int commandKey = program[n2];
            commandKey = TTVMDebug.reduceInstructionToKey(commandKey);
            String commandName = TTVMDebug.getStringForOpcode(program, n2).split(" ")[0];
            if (commandKey == 45 || commandKey == 27 || commandKey == 89) {
                depth.delete(0, 2);
            }
            result[n2] = n2 + ": " + depth + commandName;
            if (commandKey == 64) {
                count = program[++n2];
                result[n2] = depth + "  count: " + count;
                for (j2 = 0; j2 < count; ++j2) {
                    result[++n2] = depth + "   " + program[n2];
                }
                continue;
            }
            if (commandKey == 65) {
                count = program[++n2];
                result[n2] = depth + "  count: " + count;
                for (j2 = 0; j2 < count; ++j2) {
                    word = TTVMDebug.getIntFrom2Uint8(program[++n2], program[n2 + 1]);
                    result[n2] = depth + "   (first half of number)";
                    result[++n2] = depth + "   " + word;
                }
                continue;
            }
            if (program[n2] >= 176 && program[n2] < 184) {
                count = program[n2] - 175;
                for (j2 = 0; j2 < count; ++j2) {
                    result[++n2] = depth + "   " + program[n2];
                }
                continue;
            }
            if (program[n2] >= 184 && program[n2] < 192) {
                count = program[n2] - 183;
                for (j2 = 0; j2 < count; ++j2) {
                    word = TTVMDebug.getIntFrom2Uint8(program[++n2], program[n2 + 1]);
                    result[n2] = depth + "   (first half of number)";
                    result[++n2] = depth + "   " + word;
                }
                continue;
            }
            if (commandKey != 44 && commandKey != 137 && commandKey != 27 && commandKey != 88) continue;
            depth.append("  ");
        }
        return result;
    }

    private static int reduceInstructionToKey(int test) {
        if (test >= 192 && test <= 223) {
            test = 192;
        }
        if (test >= 224 && test <= 255) {
            test = 224;
        }
        if (test >= 176 && test <= 183) {
            test = 176;
        }
        if (test >= 184 && test <= 191) {
            test = 184;
        }
        return test;
    }

    private static GeneralPath getPathFromPoints(int[] x2, int[] y2, boolean[] curve, boolean[] contour) {
        int ptCount = x2.length;
        int[] pX = new int[ptCount];
        System.arraycopy(x2, 0, pX, 0, ptCount);
        int[] pY = new int[ptCount];
        System.arraycopy(y2, 0, pY, 0, ptCount);
        boolean[] endOfContour = new boolean[ptCount];
        System.arraycopy(contour, 0, endOfContour, 0, ptCount);
        boolean[] onCurve = new boolean[ptCount];
        System.arraycopy(curve, 0, onCurve, 0, ptCount);
        int start = 0;
        int firstPt = -1;
        for (int ii = 0; ii < ptCount; ++ii) {
            if (endOfContour[ii]) {
                if (!(firstPt == -1 || onCurve[start] && onCurve[ii])) {
                    TTVMDebug.resetValues(pX, pY, onCurve, start, firstPt, ii);
                }
                start = ii + 1;
                firstPt = -1;
                continue;
            }
            if (!onCurve[ii] || firstPt != -1) continue;
            firstPt = ii;
        }
        int c2 = pX.length;
        int fc = -1;
        for (int jj = 0; jj < c2; ++jj) {
            if (!endOfContour[jj]) continue;
            fc = jj + 1;
            break;
        }
        return TTVMDebug.processPoints(ptCount, pX, pY, endOfContour, onCurve, c2, fc);
    }

    private static void resetValues(int[] pX, int[] pY, boolean[] onCurve, int start, int firstPt, int ii) {
        int diff = firstPt - start;
        int pXlength = pX.length;
        int[] oldPX = new int[pXlength];
        System.arraycopy(pX, 0, oldPX, 0, pXlength);
        int[] oldPY = new int[pXlength];
        System.arraycopy(pY, 0, oldPY, 0, pXlength);
        boolean[] oldOnCurve = new boolean[pXlength];
        System.arraycopy(onCurve, 0, oldOnCurve, 0, pXlength);
        for (int oldPos = start; oldPos < ii + 1; ++oldPos) {
            int newPos = oldPos + diff;
            if (newPos > ii) {
                newPos -= ii - start + 1;
            }
            pX[oldPos] = oldPX[newPos];
            pY[oldPos] = oldPY[newPos];
            onCurve[oldPos] = oldOnCurve[newPos];
        }
    }

    private static GeneralPath processPoints(int ptCount, int[] pX, int[] pY, boolean[] endOfContour, boolean[] onCurve, int c2, int fc) {
        boolean isFirstDraw = true;
        GeneralPath currentPath = new GeneralPath(1);
        PointData pointData = new PointData(pX, pY);
        currentPath.moveTo(pX[0], pY[0]);
        int xs = 0;
        int ys = 0;
        int lc = 0;
        boolean isEnd = false;
        for (int j2 = 0; j2 < ptCount; ++j2) {
            int p2 = j2 % fc;
            int p1 = (j2 + 1) % fc;
            int p22 = (j2 + 2) % fc;
            int pm1 = (j2 - 1) % fc;
            if (j2 == 0) {
                pm1 = fc - 1;
            }
            if (p1 < lc) {
                p1 += lc;
            }
            if (p22 < lc) {
                p22 += lc;
            }
            if (endOfContour[j2]) {
                isEnd = true;
                if (onCurve[fc]) {
                    xs = pX[fc];
                    ys = pY[fc];
                } else {
                    xs = pX[j2 + 1];
                    ys = pY[j2 + 1];
                }
                lc = fc;
                for (int jj = j2 + 1; jj < c2; ++jj) {
                    if (!endOfContour[jj]) continue;
                    fc = jj + 1;
                    jj = c2;
                }
            }
            if (lc == fc && onCurve[p2]) {
                j2 = c2;
                continue;
            }
            if (onCurve[p2] && onCurve[p1]) {
                pointData.x3 = pX[p1];
                pointData.y3 = pY[p1];
                currentPath.lineTo(pX[p1], pY[p1]);
                isFirstDraw = false;
            } else if (j2 < c2 - 3 && (fc - lc > 1 || fc == lc)) {
                boolean checkEnd = false;
                if (onCurve[p2] && !onCurve[p1] && onCurve[p22]) {
                    pointData.set2Points1Control(p2, p1, p22);
                    ++j2;
                    checkEnd = true;
                } else if (onCurve[p2] && !onCurve[p1] && !onCurve[p22]) {
                    pointData.set1Point2Control(p2, p1, p22);
                    ++j2;
                    checkEnd = true;
                } else if (!(onCurve[p2] || onCurve[p1] || endOfContour[p22] && fc - p22 != 1)) {
                    pointData.set2Control1Point(p2, p1, pm1);
                } else if (!onCurve[p2] && onCurve[p1]) {
                    pointData.set1Control2Point(p2, p1, pm1);
                }
                if (isFirstDraw) {
                    currentPath.moveTo(pointData.x1, pointData.y1);
                    isFirstDraw = false;
                }
                if (!endOfContour[p2] || p2 <= 0 || !endOfContour[p2 - 1]) {
                    currentPath.curveTo(pointData.x1, pointData.y1, pointData.x2, pointData.y2, pointData.x3, pointData.y3);
                }
                if (checkEnd && endOfContour[j2]) {
                    isEnd = true;
                    xs = pX[fc];
                    ys = pY[fc];
                    lc = fc;
                    for (int jj = j2 + 1; jj < c2; ++jj) {
                        if (!endOfContour[jj]) continue;
                        fc = jj + 1;
                        jj = c2;
                    }
                }
            }
            if (endOfContour[p2]) {
                currentPath.closePath();
            }
            if (!isEnd) continue;
            currentPath.moveTo(xs, ys);
            isEnd = false;
        }
        return currentPath;
    }

    static {
        OPCODE_DESCRIPTIONS = new String[]{"SVTCA_Y    - Set both vectors to y", "SVTCA_X    - Set both vectors to x", "SPVTCA_Y   - Sets projection vector to y", "SPVTCA_X   - Sets projection vector to x", "SFVTCA_Y   - Sets freedom vector to y", "SFVTCA_X   - Sets freedom vector to x", "SPVTL0    - Set projection vector to line", "SPVTL1    - Set projection vector perpendicular to line", "SFVTL0    - Set freedom vector to line", "SFVTL1    - Set freedom vector perpendicular to line", "SPVFS     - Sets the projection vector from the stack", "SFVFS     - Sets the freedom vector from the stack", "GPV       - Gets the projection vector onto the stack", "GFV       - Gets the freedom vector onto the stack", "SFVTPV    - Sets freedom vector to projection vector", "ISECT     - Set point to intersection of lines", "SRP0      - Set rp0", "SRP1      - Set rp1", "SRP2      - Set rp2", "SZP0      - Sets zp0", "SZP1      - Sets zp1", "SZP2      - Sets zp2", "SZPS      - Sets all zone pointers", "SLOOP     - Sets loop variable", "RTG       - Sets round state to grid", "RTHG      - Sets round state to half grid", "SMD       - Sets minimum distance", "ELSE      - ELSE", "JMPR      - Jump", "SCVTCI    - Set control value table cut in", "SSWCI     - Set single width cut in", "SSW       - Set single width", "DUP       - Duplicate the top stack element", "POP       - Remove the top stack element", "CLEAR     - Clear the stack", "SWAP      - Swap the top two stack elements", "DEPTH     - Returns depth of stack", "CINDEX    - Copy Indexed element to top of stack", "MINDEX    - Move Indexed element to top of stack", "ALIGNPTS  - Move points along fv to average of their pv positions", "", "UTP       - Untouch point", "LOOPCALL  - Call a function many times", "CALL      - Call a function", "FDEF      - Define a function", "ENDF      - End a function definition", "MDAP0     - Sets a point as touched", "MDAP1     - Rounds a point along the pV and marks as touched", "IUP_Y      - Interpolate untouched points in the y axis", "IUP_X      - Interpolate untouched points on the x axis", "SHP0      - Shift point using RP2", "SHP1      - Shift point using RP1", "SHC0      - Shift a contour using RP2", "SHC1      - Shift a contour using RP1", "SHZ0      - Shift a zone using RP2", "SHZ1      - Shift a zone using RP1", "SHPIX     - Move point along freedom vector", "IP        - Interpolate point", "MSIRP0    - Move stack indirect relative point", "MSIRP1    - Move stack indirect relative point", "ALIGNRP   - Align point to RP0", "RTDG      - Sets round state to double grid", "MIAP0     - Move point to CVT value", "MIAP1     - Move point to CVT using cut in and round", "NPUSHB    - Push N bytes from IS to stack", "NPUSHW    - Push N words from IS to stack", "WS        - Write Store", "RS        - Read Store", "WCVTP     - Write Control Value Table in Pixels", "RCVT      - Read Control Value Table", "GC0       - Get coords on the pv", "GC1       - Get original coords on the pv", "SCFS", "MD0       - Measure current distance", "MD1       - Measure original distance", "MPPEM     - Measure pixels per em in the direction of the projection vector", "MPS", "FLIPON    - Sets autoflip to true", "FLIPOFF   - Sets autoflip to false", "DEBUG     - Shouldn't be in live fonts", "LT        - Less Than", "LTEQ      - Less Than or Equal", "GT        - Greater Than", "GTEQ      - Greater Than or Equal", "EQ        - Equal", "NEQ       - Not Equal", "ODD       - Rounds, truncates, and returns if odd.", "EVEN      - Rounds, truncates, and returns if even", "IF        - IF", "EIF       - End IF", "AND       - Logical AND", "OR        - Logical OR", "NOT       - Logical NOT", "DELTAP1   - Delta exception p1", "SDB       - Set delta base", "SDS       - Set delta shift", "ADD       - Add two F26Dot6 numbers", "SUB       - Subtract a number from another", "DIV       - Divide two F26Dot6 numbers", "MUL       - Multiply two F26Dot6 numbers", "ABS       - Return the absolute value of a F26Dot6 number", "NEG       - Negate a number", "FLOOR     - Round a number down if it has a fractional component", "CEILING   - Round a number up if it has a fractional component", "ROUND00   - Round a number", "ROUND01   - Round a number", "ROUND10   - Round a number", "ROUND11   - Round a number", "NROUND00  - Compensate for engine characteristics", "NROUND01  - Compensate for engine characteristics", "NROUND10  - Compensate for engine characteristics", "NROUND11  - Compensate for engine characteristics", "WCVTF", "DELTAP2   - Delta exception p2", "DELTAP3   - Delta exception p3", "DELTAC1   - Delta exception c1", "DELTAC2   - Delta exception c2", "DELTAC3   - Delta exception c3", "SROUND    - Sets the roundState specifically", "S45ROUND  - Sets the round state for working at 45degrees", "JROT      - Jump Relative On True", "JROF      - Jump Relative On False", "ROFF      - Set round state to off", "", "RUTG      - Set round state to up to grid", "RDTG      - Set round state to down to grid", "SANGW     - deprecated", "AA        - deprecated", "FLIPPT    - Flips a number of points on/off the curve", "FLIPRGON  - Flips a range of points onto the curve", "FLIPRGOFF - Flips a range of points off the curve", "", "", "SCANCTRL  - We don't scan convert, so only pops a value", "SDPVTL0   - Sets dual projection vector to line", "SDPVTL1   - Sets dual projection vector perpendicular to line", "GETINFO   - Gets info about current glyph & font engine", "IDEF      - Define an instruction", "ROLL      - Roll the top three stack elements", "MAX       - Returns the maximum of two values", "MIN       - Returns the minimum of two values", "SCANTYPE  - We don't scan convert, so only pops a value", "INSTCTRL  - Allows for setting flags to do with glyph execution"};
        isDebug = true;
    }

    private final class GlyphDetails {
        private BufferedImage image;
        private static final int IMAGE_SIZE = 100;
        private final JButton button;

        private GlyphDetails(int[] instructions, int[] glyfX, int[] glyfY, boolean[] curves, boolean[] contours, double ppem, double scaler) {
            this.setImage(glyfX, glyfY, curves, contours);
            this.button = new JButton("", new ImageIcon(this.image));
            int[] newInstructions = Arrays.copyOf(instructions, instructions.length);
            int[] newGlyfX = Arrays.copyOf(glyfX, glyfX.length);
            int[] newGlyfY = Arrays.copyOf(glyfY, glyfY.length);
            boolean[] newCurves = Arrays.copyOf(curves, curves.length);
            boolean[] newContours = Arrays.copyOf(contours, contours.length);
            this.button.addActionListener(e2 -> {
                showDebugWindow = true;
                TTVMDebug.this.processGlyph(newInstructions, newGlyfX, newGlyfY, newCurves, newContours, ppem, scaler);
            });
            this.button.setMaximumSize(new Dimension(110, 110));
        }

        private void setImage(int[] glyfX, int[] glyfY, boolean[] curves, boolean[] contours) {
            this.image = new BufferedImage(100, 100, 1);
            GeneralPath shape = TTVMDebug.getPathFromPoints(glyfX, glyfY, curves, contours);
            int[] bounds = TTVMDebug.getBounds(glyfX, glyfY);
            int minX = bounds[0];
            int minY = bounds[1];
            int maxX = bounds[2];
            int maxY = bounds[3];
            int xRange = maxX - minX;
            int yRange = maxY - minY;
            double xScale = 100.0 / (double)xRange;
            double yScale = 100.0 / (double)yRange;
            double scale = Math.min(xScale, yScale);
            Graphics2D g2 = (Graphics2D)this.image.getGraphics();
            g2.setPaint(new Color(230, 230, 230));
            g2.fillRect(0, 0, 100, 100);
            minX = (int)((double)minX - 6.0 / scale);
            maxX = (int)((double)maxX + 6.0 / scale);
            minY = (int)((double)minY - 6.0 / scale);
            maxY = (int)((double)maxY + 6.0 / scale);
            xRange = maxX - minX;
            yRange = maxY - minY;
            xScale = 100.0 / (double)xRange;
            yScale = 100.0 / (double)yRange;
            scale = Math.min(xScale, yScale);
            g2.translate(0, 100);
            g2.scale(scale, -scale);
            g2.translate(-minX, -minY);
            g2.setPaint(Color.BLACK);
            g2.draw(shape);
        }
    }
}

