/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt.hinting;

import java.io.Serializable;
import java.text.NumberFormat;
import java.util.HashMap;
import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Maxp;
import org.jpedal.fonts.tt.hinting.Cvt;
import org.jpedal.fonts.tt.hinting.TTGraphicsState;
import org.jpedal.utils.LogWriter;

public class TTVM
implements Serializable {
    static final int TWILIGHT_ZONE = 0;
    static final int GLYPH_ZONE = 1;
    static final int ORIGINAL = 2;
    protected static boolean isDebug;
    boolean printOut;
    private final int[] preProgram;
    private final int[] fontProgram;
    boolean fontProgramRun;
    double ptSize;
    double ppem;
    double scaler;
    final int[][] x;
    final int[][] y;
    final boolean[][] curve;
    final boolean[][] contour;
    boolean[][][] touched;
    final Maxp maxp;
    private boolean useDefaultGS;
    Stack stack = new Stack();
    final Cvt cvt;
    final TTGraphicsState graphicsState;
    final int[] storage;
    final HashMap<Integer, int[]> functions;
    final HashMap<Integer, int[]> instructions;
    static final int SVTCA_Y = 0;
    static final int SVTCA_X = 1;
    static final int SPVTCA_Y = 2;
    static final int SPVTCA_X = 3;
    static final int SFVTCA_Y = 4;
    static final int SFVTCA_X = 5;
    static final int SPVTL0 = 6;
    static final int SPVTL1 = 7;
    static final int SFVTL0 = 8;
    static final int SFVTL1 = 9;
    static final int SPVFS = 10;
    static final int SFVFS = 11;
    static final int GPV = 12;
    static final int GFV = 13;
    static final int SFVTPV = 14;
    static final int ISECT = 15;
    static final int SRP0 = 16;
    static final int SRP1 = 17;
    static final int SRP2 = 18;
    static final int SZP0 = 19;
    static final int SZP1 = 20;
    static final int SZP2 = 21;
    static final int SZPS = 22;
    static final int SLOOP = 23;
    static final int RTG = 24;
    static final int RTHG = 25;
    static final int SMD = 26;
    static final int ELSE = 27;
    static final int JMPR = 28;
    static final int SCVTCI = 29;
    static final int SSWCI = 30;
    static final int SSW = 31;
    static final int DUP = 32;
    static final int POP = 33;
    static final int CLEAR = 34;
    static final int SWAP = 35;
    static final int DEPTH = 36;
    static final int CINDEX = 37;
    static final int MINDEX = 38;
    static final int ALIGNPTS = 39;
    static final int UTP = 41;
    static final int LOOPCALL = 42;
    static final int CALL = 43;
    static final int FDEF = 44;
    static final int ENDF = 45;
    static final int MDAP0 = 46;
    static final int MDAP1 = 47;
    static final int IUP_Y = 48;
    static final int IUP_X = 49;
    static final int SHP0 = 50;
    static final int SHP1 = 51;
    static final int SHC0 = 52;
    static final int SHC1 = 53;
    static final int SHZ0 = 54;
    static final int SHZ1 = 55;
    static final int SHPIX = 56;
    static final int IP = 57;
    static final int MSIRP0 = 58;
    static final int MSIRP1 = 59;
    static final int ALIGNRP = 60;
    static final int RTDG = 61;
    static final int MIAP0 = 62;
    static final int MIAP1 = 63;
    static final int NPUSHB = 64;
    static final int NPUSHW = 65;
    static final int WS = 66;
    static final int RS = 67;
    static final int WCVTP = 68;
    static final int RCVT = 69;
    static final int GC0 = 70;
    static final int GC1 = 71;
    static final int SCFS = 72;
    static final int MD0 = 73;
    static final int MD1 = 74;
    static final int MPPEM = 75;
    static final int MPS = 76;
    static final int FLIPON = 77;
    static final int FLIPOFF = 78;
    static final int DEBUG = 79;
    static final int LT = 80;
    static final int LTEQ = 81;
    static final int GT = 82;
    static final int GTEQ = 83;
    static final int EQ = 84;
    static final int NEQ = 85;
    static final int ODD = 86;
    static final int EVEN = 87;
    static final int IF = 88;
    static final int EIF = 89;
    static final int AND = 90;
    static final int OR = 91;
    static final int NOT = 92;
    static final int DELTAP1 = 93;
    static final int SDB = 94;
    static final int SDS = 95;
    static final int ADD = 96;
    static final int SUB = 97;
    static final int DIV = 98;
    static final int MUL = 99;
    static final int ABS = 100;
    static final int NEG = 101;
    static final int FLOOR = 102;
    static final int CEILING = 103;
    static final int ROUND00 = 104;
    static final int ROUND01 = 105;
    static final int ROUND10 = 106;
    static final int ROUND11 = 107;
    static final int NROUND00 = 108;
    static final int NROUND01 = 109;
    static final int NROUND10 = 110;
    static final int NROUND11 = 111;
    static final int WCVTF = 112;
    static final int DELTAP2 = 113;
    static final int DELTAP3 = 114;
    static final int DELTAC1 = 115;
    static final int DELTAC2 = 116;
    static final int DELTAC3 = 117;
    static final int SROUND = 118;
    static final int S45ROUND = 119;
    static final int JROT = 120;
    static final int JROF = 121;
    static final int ROFF = 122;
    static final int RUTG = 124;
    static final int RDTG = 125;
    static final int SANGW = 126;
    static final int AA = 127;
    static final int FLIPPT = 128;
    static final int FLIPRGON = 129;
    static final int FLIPRGOFF = 130;
    static final int SCANCTRL = 133;
    static final int SDPVTL0 = 134;
    static final int SDPVTL1 = 135;
    static final int GETINFO = 136;
    static final int IDEF = 137;
    static final int ROLL = 138;
    static final int MAX = 139;
    static final int MIN = 140;
    static final int SCANTYPE = 141;
    static final int INSTCTRL = 142;
    static final int PUSHB = 176;
    static final int PUSHW = 184;
    static final int MDRP = 192;
    static final int MIRP = 224;
    private static final int PARAM_RESETRP0 = 16;
    private static final int PARAM_USEMINDIST = 8;
    private static final int PARAM_ROUND = 4;

    public TTVM(FontFile2 currentFontFile, Maxp maxp) {
        this.cvt = new Cvt(currentFontFile);
        this.graphicsState = new TTGraphicsState();
        this.preProgram = TTVM.readProgramTable(currentFontFile, 14);
        this.fontProgram = TTVM.readProgramTable(currentFontFile, 10);
        this.storage = new int[maxp.getMaxStorage()];
        this.functions = new HashMap();
        this.instructions = new HashMap();
        this.maxp = maxp;
        int len = maxp.getMaxPoints();
        this.x = new int[4][len];
        this.y = new int[4][len];
        this.curve = new boolean[2][len];
        this.contour = new boolean[2][len];
        this.touched = new boolean[4][len][2];
        this.x[0] = new int[maxp.getMaxTwilightPoints()];
        this.y[0] = new int[maxp.getMaxTwilightPoints()];
    }

    void setScaleVars(double scaler, double ppem, double ptSize) {
        boolean forceRunPrep = false;
        this.ppem = (int)(ppem + 0.5);
        this.ptSize = ptSize;
        if (!this.fontProgramRun) {
            this.execute(this.fontProgram, this.graphicsState);
            this.fontProgramRun = true;
            forceRunPrep = true;
        }
        if (scaler != this.scaler || forceRunPrep) {
            this.scaler = scaler;
            this.cvt.scale(scaler);
            this.execute(this.preProgram, this.graphicsState);
        }
        this.stack = new Stack();
    }

    public boolean processGlyph(int[] instructions, int[] glyfX, int[] glyfY, boolean[] curves, boolean[] contours, double ppem, double scaler) {
        TTGraphicsState gs;
        this.x[2] = new int[this.x[0].length];
        this.x[0] = new int[this.x[0].length];
        this.y[0] = new int[this.y[0].length];
        this.y[2] = new int[this.y[0].length];
        this.setScaleVars(scaler, ppem, ppem * 72.0 / 96.0);
        this.x[1] = glyfX;
        this.x[3] = new int[glyfX.length];
        System.arraycopy(this.x[1], 0, this.x[3], 0, this.x[1].length);
        this.y[1] = glyfY;
        this.y[3] = new int[glyfY.length];
        System.arraycopy(this.y[1], 0, this.y[3], 0, this.y[1].length);
        this.curve[1] = curves;
        this.contour[1] = contours;
        int max = this.maxp.getMaxTwilightPoints();
        if (glyfX.length > max) {
            max = glyfX.length;
        }
        this.touched = new boolean[4][max][2];
        if (this.useDefaultGS) {
            gs = new TTGraphicsState();
        } else {
            try {
                gs = (TTGraphicsState)this.graphicsState.clone();
                gs.resetForGlyph();
            }
            catch (CloneNotSupportedException e2) {
                LogWriter.writeLog("Exception: " + e2.getMessage());
                gs = new TTGraphicsState();
            }
        }
        if (gs.instructControl != 0) {
            return false;
        }
        this.setProgramToDebug(instructions);
        return this.execute(instructions, gs);
    }

    void setProgramToDebug(int[] instructions) {
    }

    boolean execute(int[] program, TTGraphicsState gs) {
        boolean failedOnHinting = false;
        if (program == null) {
            return false;
        }
        for (int currentPointer = 0; currentPointer < program.length; ++currentPointer) {
            if ((currentPointer = this.process(program[currentPointer], currentPointer, program, gs)) < 0) {
                currentPointer = -currentPointer;
                failedOnHinting = true;
            }
            if (!failedOnHinting) continue;
            return true;
        }
        return false;
    }

    int process(int code, int currentPointer, int[] program, TTGraphicsState gs) {
        boolean failedOnHinting = false;
        int bytesToRead = 0;
        if (code >= 176 && code <= 191) {
            bytesToRead = code % 8;
            code -= bytesToRead;
            ++bytesToRead;
        }
        try {
            switch (code) {
                case 0: {
                    TTVM.SVTCAy(gs);
                    break;
                }
                case 1: {
                    TTVM.SVTCAx(gs);
                    break;
                }
                case 2: {
                    gs.projectionVector = 16384;
                    gs.dualProjectionVector = 16384;
                    break;
                }
                case 3: {
                    gs.projectionVector = 0x40000000;
                    gs.dualProjectionVector = 0x40000000;
                    break;
                }
                case 4: {
                    gs.freedomVector = 16384;
                    break;
                }
                case 5: {
                    gs.freedomVector = 0x40000000;
                    break;
                }
                case 6: {
                    TTVM.SPVTL0(gs, this.stack, this.x, this.y);
                    break;
                }
                case 7: {
                    TTVM.SPVTL1(gs, this.stack, this.x, this.y);
                    break;
                }
                case 8: {
                    TTVM.SFVTL0(gs, this.stack, this.x, this.y);
                    break;
                }
                case 9: {
                    TTVM.SFVTL1(gs, this.stack, this.x, this.y);
                    break;
                }
                case 10: {
                    TTVM.SPVFS(gs, this.stack);
                    break;
                }
                case 11: {
                    TTVM.SFVFS(gs, this.stack);
                    break;
                }
                case 12: {
                    TTVM.GPV(currentPointer, this.stack, gs.projectionVector);
                    break;
                }
                case 13: {
                    TTVM.GPV(currentPointer, this.stack, gs.freedomVector);
                    break;
                }
                case 14: {
                    gs.freedomVector = gs.projectionVector;
                    break;
                }
                case 15: {
                    this.ISECT(gs);
                    break;
                }
                case 16: {
                    gs.rp0 = this.stack.pop();
                    break;
                }
                case 17: {
                    gs.rp1 = this.stack.pop();
                    break;
                }
                case 18: {
                    gs.rp2 = this.stack.pop();
                    break;
                }
                case 19: {
                    this.SZP0(gs);
                    break;
                }
                case 20: {
                    this.SZP1(gs);
                    break;
                }
                case 21: {
                    this.SZP2(gs);
                    break;
                }
                case 22: {
                    this.SZPS(gs);
                    break;
                }
                case 23: {
                    gs.loop = this.stack.pop();
                    break;
                }
                case 24: {
                    gs.roundState = 72;
                    gs.gridPeriod = 1.0;
                    break;
                }
                case 25: {
                    gs.roundState = 104;
                    gs.gridPeriod = 1.0;
                    break;
                }
                case 26: {
                    gs.minimumDistance = this.stack.pop();
                    break;
                }
                case 27: {
                    currentPointer = TTVM.ELSE(currentPointer, program);
                    break;
                }
                case 28: {
                    currentPointer = this.JMPR(currentPointer);
                    break;
                }
                case 29: {
                    gs.controlValueTableCutIn = this.stack.pop();
                    break;
                }
                case 30: {
                    gs.singleWidthCutIn = this.stack.pop();
                    break;
                }
                case 31: {
                    gs.singleWidthValue = this.stack.pop();
                    break;
                }
                case 32: {
                    this.DUP(currentPointer);
                    break;
                }
                case 33: 
                case 79: 
                case 126: 
                case 127: 
                case 133: 
                case 141: {
                    this.stack.pop();
                    break;
                }
                case 34: {
                    this.stack = new Stack();
                    break;
                }
                case 35: {
                    this.SWAP(currentPointer);
                    break;
                }
                case 36: {
                    this.stack.push(this.stack.size(), currentPointer);
                    break;
                }
                case 37: {
                    this.CINDEX(currentPointer);
                    break;
                }
                case 38: {
                    this.MINDEX(currentPointer);
                    break;
                }
                case 39: {
                    TTVM.ALIGNPTS(gs, this.stack, this.x, this.y, this.touched);
                    break;
                }
                case 41: {
                    this.UTP(gs);
                    break;
                }
                case 42: {
                    failedOnHinting = this.LOOPCALL(gs);
                    break;
                }
                case 43: {
                    failedOnHinting = this.CALL(gs);
                    break;
                }
                case 44: {
                    currentPointer = this.FDEF(currentPointer, program);
                    break;
                }
                case 45: {
                    break;
                }
                case 46: {
                    this.MDAP0(gs);
                    break;
                }
                case 47: {
                    this.MDAP1(gs);
                    break;
                }
                case 48: {
                    this.interpolateUntouchedPoints(48);
                    break;
                }
                case 49: {
                    this.interpolateUntouchedPoints(49);
                    break;
                }
                case 50: {
                    this.SHP0(gs);
                    break;
                }
                case 51: {
                    this.SHP1(gs);
                    break;
                }
                case 52: 
                case 53: {
                    TTVM.SHC(gs, this.stack, this.contour, this.x, this.y, code);
                    break;
                }
                case 54: {
                    TTVM.SHZ0(gs, this.stack, this.x, this.y, gs.zp1, gs.rp2);
                    break;
                }
                case 55: {
                    TTVM.SHZ0(gs, this.stack, this.x, this.y, gs.zp0, gs.rp1);
                    break;
                }
                case 56: {
                    TTVM.SHPIX(gs, this.stack, this.x, this.y, this.touched);
                    break;
                }
                case 57: {
                    TTVM.IP(gs, this.stack, this.x, this.y, this.touched);
                    break;
                }
                case 58: {
                    TTVM.MSIRP0(gs, this.stack, this.x, this.y, this.touched);
                    break;
                }
                case 59: {
                    TTVM.MSIRP1(gs, this.stack, this.x, this.y, this.touched);
                    break;
                }
                case 60: {
                    TTVM.ALIGNRP(gs, this.stack, this.x, this.y, this.touched);
                    break;
                }
                case 61: {
                    gs.roundState = 8;
                    gs.gridPeriod = 1.0;
                    break;
                }
                case 62: {
                    TTVM.MIAP0(gs, this.stack, this.cvt, this.x, this.y, this.touched);
                    break;
                }
                case 63: {
                    TTVM.MIAP1(gs, this.stack, this.cvt, this.x, this.y, this.touched);
                    break;
                }
                case 64: {
                    ++currentPointer;
                    currentPointer = this.readFromIS(program[currentPointer], false, currentPointer, program);
                    break;
                }
                case 65: {
                    ++currentPointer;
                    currentPointer = this.readFromIS(program[currentPointer], true, currentPointer, program);
                    break;
                }
                case 66: {
                    int value = this.stack.pop();
                    int key = this.stack.pop();
                    this.storage[key] = value;
                    break;
                }
                case 67: {
                    int key = this.stack.pop();
                    this.stack.push(this.storage[key], currentPointer);
                    break;
                }
                case 68: {
                    this.WCVTP();
                    break;
                }
                case 69: {
                    this.RCVT(currentPointer);
                    break;
                }
                case 70: {
                    int p2 = this.stack.pop();
                    this.stack.push(TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[gs.zp2][p2], this.y[gs.zp2][p2]), currentPointer);
                    break;
                }
                case 71: {
                    int p3 = this.stack.pop();
                    this.stack.push(TTGraphicsState.getCoordsOnVector(gs.dualProjectionVector, this.x[2 + gs.zp2][p3], this.y[2 + gs.zp2][p3]), currentPointer);
                    break;
                }
                case 72: {
                    TTVM.SCFS(gs, this.stack, this.x, this.y, this.touched);
                    break;
                }
                case 73: {
                    this.MD0(gs, currentPointer);
                    break;
                }
                case 74: {
                    this.MD1(gs, currentPointer);
                    break;
                }
                case 75: {
                    this.MPPEM(gs, currentPointer);
                    break;
                }
                case 76: {
                    this.stack.push((int)(this.ptSize * 64.0), currentPointer);
                    break;
                }
                case 77: {
                    gs.autoFlip = true;
                    break;
                }
                case 78: {
                    gs.autoFlip = false;
                    break;
                }
                case 80: {
                    this.LT(currentPointer);
                    break;
                }
                case 81: {
                    this.LTEQ(currentPointer);
                    break;
                }
                case 82: {
                    this.GT(currentPointer);
                    break;
                }
                case 83: {
                    this.GTEQ(currentPointer);
                    break;
                }
                case 84: {
                    this.EQ(currentPointer);
                    break;
                }
                case 85: {
                    this.NEQ(currentPointer);
                    break;
                }
                case 86: {
                    this.ODD(gs, currentPointer);
                    break;
                }
                case 87: {
                    this.EVEN(gs, currentPointer);
                    break;
                }
                case 88: {
                    currentPointer = this.IF(currentPointer, program);
                    break;
                }
                case 89: {
                    break;
                }
                case 90: {
                    this.AND(currentPointer);
                    break;
                }
                case 91: {
                    this.OR(currentPointer);
                    break;
                }
                case 92: {
                    this.NOT(currentPointer);
                    break;
                }
                case 93: {
                    this.DELTAP(gs, 0);
                    break;
                }
                case 94: {
                    gs.deltaBase = this.stack.pop();
                    break;
                }
                case 95: {
                    gs.deltaShift = this.stack.pop();
                    break;
                }
                case 96: {
                    this.stack.push(Math.addExact(this.stack.pop(), this.stack.pop()), currentPointer);
                    break;
                }
                case 97: {
                    this.SUB(currentPointer);
                    break;
                }
                case 98: {
                    this.DIV(currentPointer);
                    break;
                }
                case 99: {
                    this.MUL(currentPointer);
                    break;
                }
                case 100: {
                    this.ABS(currentPointer);
                    break;
                }
                case 101: {
                    this.stack.push(-this.stack.pop(), currentPointer);
                    break;
                }
                case 102: {
                    this.stack.push(this.stack.pop() >> 6 << 6, currentPointer);
                    break;
                }
                case 103: {
                    this.CEILING(currentPointer);
                    break;
                }
                case 104: 
                case 105: 
                case 106: 
                case 107: {
                    this.ROUND(gs, currentPointer);
                    break;
                }
                case 108: 
                case 109: 
                case 110: 
                case 111: {
                    this.stack.push(this.stack.pop(), currentPointer);
                    break;
                }
                case 112: {
                    int value = this.stack.pop();
                    int key = this.stack.pop();
                    this.cvt.putInFUnits(key, value);
                    break;
                }
                case 113: {
                    this.DELTAP(gs, 16);
                    break;
                }
                case 114: {
                    this.DELTAP(gs, 32);
                    break;
                }
                case 115: {
                    this.DELTAC(gs, 0);
                    break;
                }
                case 116: {
                    this.DELTAC(gs, 16);
                    break;
                }
                case 117: {
                    this.DELTAC(gs, 32);
                    break;
                }
                case 118: {
                    gs.roundState = this.stack.pop();
                    gs.gridPeriod = 1.0;
                    break;
                }
                case 119: {
                    gs.roundState = this.stack.pop();
                    gs.gridPeriod = 0.7071067811865476;
                    break;
                }
                case 120: {
                    currentPointer = this.JROT(currentPointer);
                    break;
                }
                case 121: {
                    currentPointer = this.JROF(currentPointer);
                    break;
                }
                case 122: {
                    gs.roundState = -1;
                    break;
                }
                case 124: {
                    gs.roundState = 64;
                    gs.gridPeriod = 1.0;
                    break;
                }
                case 125: {
                    gs.roundState = 68;
                    gs.gridPeriod = 1.0;
                    break;
                }
                case 128: {
                    this.FLIPPT(gs);
                    break;
                }
                case 129: {
                    this.FLIPRGON(gs);
                    break;
                }
                case 130: {
                    this.FLIPRGOFF(gs);
                    break;
                }
                case 134: {
                    this.SDPVTL0(gs);
                    break;
                }
                case 135: {
                    this.SDOVTL1(gs);
                    break;
                }
                case 136: {
                    this.GETINFO(currentPointer);
                    break;
                }
                case 137: {
                    currentPointer = this.IDEF(currentPointer, program);
                    break;
                }
                case 138: {
                    this.ROLL(currentPointer);
                    break;
                }
                case 139: {
                    this.MAX(currentPointer);
                    break;
                }
                case 140: {
                    this.MIN(currentPointer);
                    break;
                }
                case 142: {
                    this.INSTCTRL(gs);
                    break;
                }
                case 176: {
                    currentPointer = this.readFromIS(bytesToRead, false, currentPointer, program);
                    break;
                }
                case 184: {
                    currentPointer = this.readFromIS(bytesToRead, true, currentPointer, program);
                    break;
                }
                default: {
                    if (code >= 192 && code < 224) {
                        this.MDRP(code, gs);
                        break;
                    }
                    if (code >= 224 && code <= 255) {
                        this.MIRP(code, gs);
                        break;
                    }
                    if (this.instructions.containsKey(code)) {
                        failedOnHinting = this.handleCustomInstruction(code, gs);
                        break;
                    }
                    if (LogWriter.isRunningFromIDE) {
                        System.out.println("Unknown truetype opcode 0x" + Integer.toHexString(code) + " at line " + currentPointer);
                    }
                    break;
                }
            }
        }
        catch (Exception e2) {
            LogWriter.writeLog(e2);
            LogWriter.writeLog("Exception: " + e2.getMessage() + " at line " + currentPointer + "- hinting turned off");
            failedOnHinting = true;
        }
        if (failedOnHinting) {
            return -currentPointer;
        }
        return currentPointer;
    }

    private void RCVT(int currentPointer) {
        int cvtValue;
        int key = this.stack.pop();
        try {
            cvtValue = this.cvt.get(key);
        }
        catch (Cvt.EntryNotFoundException e2) {
            cvtValue = 0;
        }
        this.stack.push(cvtValue, currentPointer);
    }

    private void MDRP(int code, TTGraphicsState gs) {
        int args = code - 192;
        boolean setRP0toP = (args & 0x10) == 16;
        boolean useMinimumDistance = (args & 8) == 8;
        boolean roundDistance = (args & 4) == 4;
        int p2 = this.stack.pop();
        int originalDistance = TTGraphicsState.getCoordsOnVector(gs.dualProjectionVector, this.x[2 + gs.zp1][p2], this.y[2 + gs.zp1][p2]) - TTGraphicsState.getCoordsOnVector(gs.dualProjectionVector, this.x[2 + gs.zp0][gs.rp0], this.y[2 + gs.zp0][gs.rp0]);
        if (Math.abs(originalDistance) < gs.singleWidthCutIn) {
            originalDistance = originalDistance > 0 ? gs.singleWidthValue : -gs.singleWidthValue;
        }
        if (roundDistance) {
            originalDistance = TTVM.storeDoubleAsF26Dot6(gs.round(TTVM.getDoubleFromF26Dot6(originalDistance)));
        }
        originalDistance = TTVM.checkMinimumDistance(gs, useMinimumDistance, originalDistance);
        int target = TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[gs.zp0][gs.rp0], this.y[gs.zp0][gs.rp0]) + originalDistance;
        int pVMove = target - TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[gs.zp1][p2], this.y[gs.zp1][p2]);
        int[] shift = gs.getFVMoveforPVDistance(pVMove);
        int[] nArray = this.x[gs.zp1];
        int n2 = p2;
        nArray[n2] = nArray[n2] + shift[0];
        int[] nArray2 = this.y[gs.zp1];
        int n3 = p2;
        nArray2[n3] = nArray2[n3] + shift[1];
        this.markAsTouched(gs, p2);
        TTVM.setReferencePoints(gs, p2, setRP0toP);
    }

    private void MIRP(int code, TTGraphicsState gs) {
        int pMove;
        int cvtEntry;
        int args = code - 224;
        boolean setRP0toP = (args & 0x10) == 16;
        boolean useMinimumDistance = (args & 8) == 8;
        boolean roundDistanceAndCheckCutIn = (args & 4) == 4;
        try {
            cvtEntry = this.cvt.get(this.stack.pop());
        }
        catch (Cvt.EntryNotFoundException e2) {
            cvtEntry = 1;
        }
        int p2 = this.stack.pop();
        int distance = TTGraphicsState.getCoordsOnVector(gs.dualProjectionVector, this.x[2 + gs.zp1][p2], this.y[2 + gs.zp1][p2]) - TTGraphicsState.getCoordsOnVector(gs.dualProjectionVector, this.x[2 + gs.zp0][gs.rp0], this.y[2 + gs.zp0][gs.rp0]);
        if (Math.abs(distance - gs.singleWidthValue) < gs.singleWidthCutIn) {
            distance = gs.singleWidthValue;
        }
        if (gs.zp1 == 0) {
            this.x[2][p2] = this.x[2 + gs.zp0][gs.rp0] + (int)(TTVM.getDoubleFromF2Dot14(TTGraphicsState.getVectorComponents(gs.freedomVector)[0]) * (double)cvtEntry);
            this.x[0][p2] = this.x[2][p2];
            this.y[2][p2] = this.y[2 + gs.zp0][gs.rp0] + (int)(TTVM.getDoubleFromF2Dot14(TTGraphicsState.getVectorComponents(gs.freedomVector)[1]) * (double)cvtEntry);
            this.y[0][p2] = this.y[2][p2];
        }
        if (gs.autoFlip && (distance < 0 && cvtEntry > 0 || distance > 0 && cvtEntry < 0)) {
            cvtEntry = -cvtEntry;
        }
        if (roundDistanceAndCheckCutIn && gs.zp0 == gs.zp1 && (pMove = Math.abs(distance - cvtEntry)) < gs.controlValueTableCutIn) {
            distance = cvtEntry;
        }
        if (roundDistanceAndCheckCutIn) {
            distance = gs.round(distance);
        }
        distance = TTVM.checkMinimumDistance(gs, useMinimumDistance, distance);
        int target = TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[gs.zp0][gs.rp0], this.y[gs.zp0][gs.rp0]) + distance;
        int pVMove = target - TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[gs.zp1][p2], this.y[gs.zp1][p2]);
        int[] shift = gs.getFVMoveforPVDistance(pVMove);
        if (gs.zp1 == 0) {
            int[] nArray = this.x[2];
            int n2 = p2;
            nArray[n2] = nArray[n2] + shift[0];
            int[] nArray2 = this.y[2];
            int n3 = p2;
            nArray2[n3] = nArray2[n3] + shift[1];
        }
        int[] nArray = this.x[gs.zp1];
        int n4 = p2;
        nArray[n4] = nArray[n4] + shift[0];
        int[] nArray3 = this.y[gs.zp1];
        int n5 = p2;
        nArray3[n5] = nArray3[n5] + shift[1];
        this.markAsTouched(gs, p2);
        TTVM.setReferencePoints(gs, p2, setRP0toP);
    }

    private static int checkMinimumDistance(TTGraphicsState gs, boolean useMinimumDistance, int distance) {
        if (useMinimumDistance && Math.abs(distance) < gs.minimumDistance) {
            distance = distance < 0 ? -gs.minimumDistance : gs.minimumDistance;
        }
        return distance;
    }

    private boolean handleCustomInstruction(int code, TTGraphicsState gs) {
        if (this.printOut) {
            System.out.println("I 0x" + Integer.toHexString(code) + "    - Custom Instruction");
        }
        boolean failed = this.execute(this.instructions.get(code), gs);
        if (this.printOut) {
            System.out.println("I 0x" + Integer.toHexString(code) + " finished");
        }
        return failed;
    }

    private void ROUND(TTGraphicsState gs, int currentPointer) {
        int n2 = this.stack.pop();
        double num = TTVM.getDoubleFromF26Dot6(n2);
        this.stack.push(TTVM.storeDoubleAsF26Dot6(gs.round(num)), currentPointer);
    }

    private void WCVTP() {
        int value = this.stack.pop();
        int key = this.stack.pop();
        this.cvt.putInPixels(key, value);
    }

    private void SUB(int currentPointer) {
        int right = this.stack.pop();
        int left = this.stack.pop();
        this.stack.push(left - right, currentPointer);
    }

    private void MINDEX(int currentPointer) {
        int key = this.stack.pop();
        int value = this.stack.remove(key);
        this.stack.push(value, currentPointer);
    }

    private void CINDEX(int currentPointer) {
        int key = this.stack.pop();
        int value = this.stack.elementAt(key);
        this.stack.push(value, currentPointer);
    }

    private static void SVTCAx(TTGraphicsState gs) {
        gs.freedomVector = 0x40000000;
        gs.projectionVector = 0x40000000;
        gs.dualProjectionVector = 0x40000000;
    }

    private static void SVTCAy(TTGraphicsState gs) {
        gs.freedomVector = 16384;
        gs.projectionVector = 16384;
        gs.dualProjectionVector = 16384;
    }

    private void SZP0(TTGraphicsState gs) {
        int value = this.stack.pop();
        if (value > 1 || value < 0) {
            LogWriter.writeLog("ZP0 set incorrectly! " + value);
        }
        gs.zp0 = value;
    }

    private void SZP1(TTGraphicsState gs) {
        int value = this.stack.pop();
        if (value > 1 || value < 0) {
            LogWriter.writeLog("ZP1 set incorrectly! " + value);
        }
        gs.zp1 = value;
    }

    private void DUP(int currentPointer) {
        int value = this.stack.pop();
        this.stack.push(value, currentPointer);
        this.stack.push(value, currentPointer);
    }

    private static void setReferencePoints(TTGraphicsState gs, int p2, boolean setRP0toP) {
        gs.rp1 = gs.rp0;
        gs.rp2 = p2;
        if (setRP0toP) {
            gs.rp0 = p2;
        }
    }

    private void markAsTouched(TTGraphicsState gs, int p2) {
        int[] fv = TTGraphicsState.getVectorComponents(gs.freedomVector);
        if (fv[0] != 0) {
            this.touched[gs.zp1][p2][0] = true;
        }
        if (fv[1] != 0) {
            this.touched[gs.zp1][p2][1] = true;
        }
    }

    private void ROLL(int currentPointer) {
        int top = this.stack.pop();
        int middle = this.stack.pop();
        int bottom = this.stack.pop();
        this.stack.push(middle, currentPointer);
        this.stack.push(top, currentPointer);
        this.stack.push(bottom, currentPointer);
    }

    private void FLIPRGOFF(TTGraphicsState gs) {
        int low;
        int high = this.stack.pop();
        for (int i2 = low = this.stack.pop(); i2 <= high; ++i2) {
            this.curve[gs.zp0][i2] = false;
        }
    }

    private void FLIPRGON(TTGraphicsState gs) {
        int low;
        int high = this.stack.pop();
        for (int i2 = low = this.stack.pop(); i2 <= high; ++i2) {
            this.curve[gs.zp0][i2] = true;
        }
    }

    private void FLIPPT(TTGraphicsState gs) {
        for (int i2 = 0; i2 < gs.loop; ++i2) {
            int point = this.stack.pop();
            this.curve[gs.zp0][point] = !this.curve[gs.zp0][point];
        }
        gs.loop = 1;
    }

    private int JROF(int currentPointer) {
        boolean jump = this.stack.pop() != 0;
        int amount = this.stack.pop();
        if (!jump) {
            currentPointer = currentPointer + amount - 1;
        }
        return currentPointer;
    }

    private int JROT(int currentPointer) {
        boolean jump = this.stack.pop() != 0;
        int amount = this.stack.pop();
        if (jump) {
            currentPointer = currentPointer + amount - 1;
        }
        return currentPointer;
    }

    private void CEILING(int currentPointer) {
        int value = this.stack.pop();
        if ((value & 0x3F) != 0) {
            value = (value >> 6) + 1 << 6;
        }
        this.stack.push(value, currentPointer);
    }

    private void ABS(int currentPointer) {
        int value = this.stack.pop();
        if (value < 0) {
            value = -value;
        }
        this.stack.push(value, currentPointer);
    }

    private void MUL(int currentPointer) {
        long b2;
        long a10 = this.stack.pop();
        long result = Math.multiplyExact(a10, b2 = (long)this.stack.pop()) / 64L;
        if (result > Integer.MAX_VALUE) {
            throw new RuntimeException("Integer overflow in TrueType hinting");
        }
        this.stack.push((int)result, currentPointer);
    }

    private void DIV(int currentPointer) {
        int right = this.stack.pop();
        int left = this.stack.pop();
        if (right != 0) {
            this.stack.push((int)(Math.multiplyExact((long)left, 64L) / (long)right), currentPointer);
        } else {
            this.stack.push(0, currentPointer);
        }
    }

    private void NOT(int currentPointer) {
        boolean value;
        boolean bl2 = value = this.stack.pop() != 0;
        if (!value) {
            this.stack.push(1, currentPointer);
        } else {
            this.stack.push(0, currentPointer);
        }
    }

    private void OR(int currentPointer) {
        boolean left;
        boolean right = this.stack.pop() != 0;
        boolean bl2 = left = this.stack.pop() != 0;
        if (left || right) {
            this.stack.push(1, currentPointer);
        } else {
            this.stack.push(0, currentPointer);
        }
    }

    private void AND(int currentPointer) {
        boolean left;
        boolean right = this.stack.pop() != 0;
        boolean bl2 = left = this.stack.pop() != 0;
        if (left && right) {
            this.stack.push(1, currentPointer);
        } else {
            this.stack.push(0, currentPointer);
        }
    }

    private void EVEN(TTGraphicsState gs, int currentPointer) {
        int value = this.stack.pop();
        value = TTVM.storeDoubleAsF26Dot6(gs.round(TTVM.getDoubleFromF26Dot6(value)));
        value = ((value >> 6) + 1) % 2;
        this.stack.push(value, currentPointer);
    }

    private void ODD(TTGraphicsState gs, int currentPointer) {
        int value = this.stack.pop();
        value = TTVM.storeDoubleAsF26Dot6(gs.round(TTVM.getDoubleFromF26Dot6(value)));
        value = (value >> 6) % 2;
        this.stack.push(value, currentPointer);
    }

    private void NEQ(int currentPointer) {
        int right = this.stack.pop();
        int left = this.stack.pop();
        if (left != right) {
            this.stack.push(1, currentPointer);
        } else {
            this.stack.push(0, currentPointer);
        }
    }

    private void EQ(int currentPointer) {
        int right = this.stack.pop();
        int left = this.stack.pop();
        if (left == right) {
            this.stack.push(1, currentPointer);
        } else {
            this.stack.push(0, currentPointer);
        }
    }

    private void GTEQ(int currentPointer) {
        int right = this.stack.pop();
        int left = this.stack.pop();
        if (left >= right) {
            this.stack.push(1, currentPointer);
        } else {
            this.stack.push(0, currentPointer);
        }
    }

    private void GT(int currentPointer) {
        int right = this.stack.pop();
        int left = this.stack.pop();
        if (left > right) {
            this.stack.push(1, currentPointer);
        } else {
            this.stack.push(0, currentPointer);
        }
    }

    private void LTEQ(int currentPointer) {
        int right = this.stack.pop();
        int left = this.stack.pop();
        if (left <= right) {
            this.stack.push(1, currentPointer);
        } else {
            this.stack.push(0, currentPointer);
        }
    }

    private void LT(int currentPointer) {
        int right = this.stack.pop();
        int left = this.stack.pop();
        if (left < right) {
            this.stack.push(1, currentPointer);
        } else {
            this.stack.push(0, currentPointer);
        }
    }

    private void MPPEM(TTGraphicsState gs, int currentPointer) {
        int pvppem = TTGraphicsState.getCoordsOnVector(gs.projectionVector, (int)(this.ppem * 64.0), (int)(this.ppem * 64.0)) / 64;
        if (pvppem < 0) {
            pvppem = -pvppem;
        }
        this.stack.push(pvppem, currentPointer);
    }

    private void MD1(TTGraphicsState gs, int currentPointer) {
        int p1 = this.stack.pop();
        int p2 = this.stack.pop();
        int distance = TTGraphicsState.getCoordsOnVector(gs.dualProjectionVector, this.x[2 + gs.zp1][p2], this.y[2 + gs.zp1][p2]) - TTGraphicsState.getCoordsOnVector(gs.dualProjectionVector, this.x[2 + gs.zp0][p1], this.y[2 + gs.zp0][p1]);
        this.stack.push(distance, currentPointer);
    }

    private void MD0(TTGraphicsState gs, int currentPointer) {
        int p1 = this.stack.pop();
        int p2 = this.stack.pop();
        int distance = TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[gs.zp0][p2], this.y[gs.zp0][p2]) - TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[gs.zp1][p1], this.y[gs.zp1][p1]);
        this.stack.push(distance, currentPointer);
    }

    private void SWAP(int currentPointer) {
        int top = this.stack.pop();
        int under = this.stack.pop();
        this.stack.push(top, currentPointer);
        this.stack.push(under, currentPointer);
    }

    private int JMPR(int currentPointer) throws RuntimeException {
        int value = this.stack.pop();
        if ((currentPointer = currentPointer + value - 1) < 0) {
            throw new RuntimeException("Jumped back further than the start of the instruction.");
        }
        return currentPointer;
    }

    private void SZPS(TTGraphicsState gs) {
        int value = this.stack.pop();
        if (value > 1 || value < 0) {
            LogWriter.writeLog("All zone pointers set incorrectly! " + value);
        }
        gs.zp0 = value;
        gs.zp1 = value;
        gs.zp2 = value;
    }

    private void SZP2(TTGraphicsState gs) {
        int value = this.stack.pop();
        if (value > 1 || value < 0) {
            LogWriter.writeLog("ZP2 set incorrectly! " + value);
        }
        gs.zp2 = value;
    }

    private void GETINFO(int currentPointer) {
        int selector = this.stack.pop();
        int result = 0;
        if ((selector & 1) == 1) {
            result += 3;
        }
        this.stack.push(result, currentPointer);
    }

    private void MAX(int currentPointer) {
        int value1 = this.stack.pop();
        int value2 = this.stack.pop();
        this.stack.push(Math.max(value1, value2), currentPointer);
    }

    private void MIN(int currentPointer) {
        int value1 = this.stack.pop();
        int value2 = this.stack.pop();
        this.stack.push(Math.min(value1, value2), currentPointer);
    }

    private void INSTCTRL(TTGraphicsState gs) {
        int s2 = this.stack.pop();
        int value = this.stack.pop();
        if (s2 == 1) {
            gs.instructControl = value;
        } else if (s2 == 2) {
            this.useDefaultGS = value == 2;
        }
    }

    private void SDOVTL1(TTGraphicsState gs) {
        int p2 = this.stack.pop();
        int p1 = this.stack.pop();
        double xdiff = TTVM.getDoubleFromF26Dot6(this.x[gs.zp2][p2] - this.x[gs.zp1][p1]);
        double ydiff = TTVM.getDoubleFromF26Dot6(this.y[gs.zp2][p2] - this.y[gs.zp1][p1]);
        double dxdiff = TTVM.getDoubleFromF26Dot6(this.x[2 + gs.zp2][p2] - this.x[2 + gs.zp1][p1]);
        double dydiff = TTVM.getDoubleFromF26Dot6(this.y[2 + gs.zp2][p2] - this.y[2 + gs.zp1][p1]);
        double factor = Math.sqrt(xdiff * xdiff + ydiff * ydiff);
        double dfactor = Math.sqrt(dxdiff * dxdiff + dydiff * dydiff);
        gs.projectionVector = TTGraphicsState.createVector(TTVM.storeDoubleAsF2Dot14(ydiff /= factor), TTVM.storeDoubleAsF2Dot14(-(xdiff /= factor)));
        gs.dualProjectionVector = TTGraphicsState.createVector(TTVM.storeDoubleAsF2Dot14(dydiff /= dfactor), TTVM.storeDoubleAsF2Dot14(-(dxdiff /= dfactor)));
    }

    private void SDPVTL0(TTGraphicsState gs) {
        int p2 = this.stack.pop();
        int p1 = this.stack.pop();
        double xdiff = TTVM.getDoubleFromF26Dot6(this.x[gs.zp2][p2] - this.x[gs.zp1][p1]);
        double ydiff = TTVM.getDoubleFromF26Dot6(this.y[gs.zp2][p2] - this.y[gs.zp1][p1]);
        double dxdiff = TTVM.getDoubleFromF26Dot6(this.x[2 + gs.zp2][p2] - this.x[2 + gs.zp1][p1]);
        double dydiff = TTVM.getDoubleFromF26Dot6(this.y[2 + gs.zp2][p2] - this.y[2 + gs.zp1][p1]);
        double factor = Math.sqrt(xdiff * xdiff + ydiff * ydiff);
        double dfactor = Math.sqrt(dxdiff * dxdiff + dydiff * dydiff);
        gs.projectionVector = TTGraphicsState.createVector(TTVM.storeDoubleAsF2Dot14(xdiff /= factor), TTVM.storeDoubleAsF2Dot14(ydiff /= factor));
        gs.dualProjectionVector = TTGraphicsState.createVector(TTVM.storeDoubleAsF2Dot14(dxdiff /= dfactor), TTVM.storeDoubleAsF2Dot14(dydiff /= dfactor));
    }

    private int IDEF(int currentPointer, int[] program) {
        int curr;
        int func = this.stack.pop();
        int start = currentPointer;
        while ((curr = program[++currentPointer]) != 45) {
        }
        int len = currentPointer - start - 1;
        currentPointer = start;
        int[] instruction = new int[len];
        for (int i2 = 0; i2 < len; ++i2) {
            instruction[i2] = program[++currentPointer];
        }
        this.instructions.put(func, instruction);
        return ++currentPointer;
    }

    private void DELTAC(TTGraphicsState gs, int scaling) {
        int loop = this.stack.pop();
        for (int i2 = 0; i2 < loop; ++i2) {
            int value;
            int cvtEntry = this.stack.pop();
            int arg = this.stack.pop();
            int testPpem = gs.deltaBase + scaling + (arg >> 4);
            if ((double)testPpem != this.ppem) continue;
            int mag = (arg & 0xF) - 7;
            if (mag <= 0) {
                --mag;
            }
            int change = TTVM.storeDoubleAsF26Dot6((double)mag * (1.0 / Math.pow(2.0, gs.deltaShift)));
            try {
                value = this.cvt.get(cvtEntry);
            }
            catch (Cvt.EntryNotFoundException e2) {
                value = 0;
            }
            this.cvt.putInPixels(cvtEntry, value += change);
        }
    }

    private void DELTAP(TTGraphicsState gs, int scaling) {
        int loop = this.stack.pop();
        for (int i2 = 0; i2 < loop; ++i2) {
            int p2 = this.stack.pop();
            int arg = this.stack.pop();
            int testPpem = gs.deltaBase + scaling + (arg >> 4);
            if ((double)testPpem != this.ppem) continue;
            int mag = (arg & 0xF) - 7;
            if (mag <= 0) {
                --mag;
            }
            int pMove = TTVM.storeDoubleAsF26Dot6((double)mag * (1.0 / Math.pow(2.0, gs.deltaShift)));
            int[] shift = gs.getFVMoveforPVDistance(pMove);
            int[] nArray = this.x[gs.zp0];
            int n2 = p2;
            nArray[n2] = nArray[n2] + shift[0];
            int[] nArray2 = this.y[gs.zp0];
            int n3 = p2;
            nArray2[n3] = nArray2[n3] + shift[1];
            int[] fv = TTGraphicsState.getVectorComponents(gs.freedomVector);
            if (fv[0] != 0) {
                this.touched[gs.zp0][p2][0] = true;
            }
            if (fv[1] == 0) continue;
            this.touched[gs.zp0][p2][1] = true;
        }
    }

    private int IF(int currentPointer, int[] program) {
        boolean value;
        boolean bl2 = value = this.stack.pop() != 0;
        if (!value) {
            int curr = 0;
            int nest = 0;
            do {
                if (curr == 89) {
                    --nest;
                }
                if ((curr = program[++currentPointer]) == 88) {
                    ++nest;
                }
                currentPointer = TTVM.skipOverData(currentPointer, program, curr);
            } while (curr != 27 && curr != 89 || nest != 0);
        }
        return currentPointer;
    }

    private static int skipOverData(int currentPointer, int[] program, int curr) {
        if (curr == 64) {
            ++currentPointer;
            currentPointer += program[currentPointer];
        } else if (curr == 65) {
            ++currentPointer;
            currentPointer += program[currentPointer] * 2;
        } else if (curr >= 176 && curr <= 183) {
            currentPointer += curr + 1 - 176;
        } else if (curr >= 184 && curr <= 191) {
            currentPointer += (curr + 1 - 184) * 2;
        }
        return currentPointer;
    }

    private void SHP1(TTGraphicsState gs) {
        for (int i2 = 0; i2 < gs.loop; ++i2) {
            int p2 = this.stack.pop();
            int newRP = TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[gs.zp0][gs.rp1], this.y[gs.zp0][gs.rp1]);
            int oldRP = TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[2 + gs.zp0][gs.rp1], this.y[2 + gs.zp0][gs.rp1]);
            int shift = newRP - oldRP;
            int[] move = gs.getFVMoveforPVDistance(shift);
            int[] nArray = this.x[gs.zp2];
            int n2 = p2;
            nArray[n2] = nArray[n2] + move[0];
            int[] nArray2 = this.y[gs.zp2];
            int n3 = p2;
            nArray2[n3] = nArray2[n3] + move[1];
            if (move[0] != 0) {
                this.touched[gs.zp2][p2][0] = true;
            }
            if (move[1] == 0) continue;
            this.touched[gs.zp2][p2][1] = true;
        }
        gs.loop = 1;
    }

    private void SHP0(TTGraphicsState gs) {
        for (int i2 = 0; i2 < gs.loop; ++i2) {
            int p2 = this.stack.pop();
            if (p2 > this.x[gs.zp2].length || gs.rp2 > this.x[gs.zp1].length) {
                LogWriter.writeLog("Trying to use a point which doesn't exist! (SHP0, zone " + gs.zp2 + ')');
                break;
            }
            int newRP = TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[gs.zp1][gs.rp2], this.y[gs.zp1][gs.rp2]);
            int oldRP = TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[2 + gs.zp1][gs.rp2], this.y[2 + gs.zp1][gs.rp2]);
            int pMove = newRP - oldRP;
            int[] shift = gs.getFVMoveforPVDistance(pMove);
            int[] nArray = this.x[gs.zp2];
            int n2 = p2;
            nArray[n2] = nArray[n2] + shift[0];
            int[] nArray2 = this.y[gs.zp2];
            int n3 = p2;
            nArray2[n3] = nArray2[n3] + shift[1];
            int[] fv = TTGraphicsState.getVectorComponents(gs.freedomVector);
            if (fv[0] != 0) {
                this.touched[gs.zp2][p2][0] = true;
            }
            if (fv[1] == 0) continue;
            this.touched[gs.zp2][p2][1] = true;
        }
        gs.loop = 1;
    }

    private void MDAP1(TTGraphicsState gs) {
        int p2;
        gs.rp0 = p2 = this.stack.pop();
        gs.rp1 = p2;
        int m2 = TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[gs.zp0][p2], this.y[gs.zp0][p2]);
        m2 = TTVM.storeDoubleAsF26Dot6(gs.round(TTVM.getDoubleFromF26Dot6(m2))) - m2;
        int[] shift = gs.getFVMoveforPVDistance(m2);
        int[] nArray = this.x[gs.zp0];
        int n2 = p2;
        nArray[n2] = nArray[n2] + shift[0];
        int[] nArray2 = this.y[gs.zp0];
        int n3 = p2;
        nArray2[n3] = nArray2[n3] + shift[1];
        int[] fv = TTGraphicsState.getVectorComponents(gs.freedomVector);
        if (fv[0] != 0) {
            this.touched[gs.zp0][p2][0] = true;
        }
        if (fv[1] != 0) {
            this.touched[gs.zp0][p2][1] = true;
        }
    }

    private void MDAP0(TTGraphicsState gs) {
        int p2;
        gs.rp0 = p2 = this.stack.pop();
        gs.rp1 = p2;
        switch (gs.freedomVector) {
            case 0x40000000: {
                this.touched[gs.zp0][p2][0] = true;
                break;
            }
            case 16384: {
                this.touched[gs.zp0][p2][1] = true;
                break;
            }
            default: {
                this.touched[gs.zp0][p2][0] = true;
                this.touched[gs.zp0][p2][1] = true;
            }
        }
    }

    private int FDEF(int currentPointer, int[] program) {
        int curr;
        int num = this.stack.pop();
        int start = currentPointer;
        do {
            if ((curr = program[++currentPointer]) == 64) {
                ++currentPointer;
                currentPointer += program[currentPointer];
                continue;
            }
            if (curr == 65) {
                ++currentPointer;
                currentPointer += program[currentPointer] * 2;
                continue;
            }
            if (curr >= 176 && curr <= 183) {
                currentPointer += curr + 1 - 176;
                continue;
            }
            if (curr < 184 || curr > 191) continue;
            currentPointer += (curr + 1 - 184) * 2;
        } while (curr != 45);
        int len = currentPointer - start - 1;
        currentPointer = start;
        int[] function = new int[len];
        for (int i2 = 0; i2 < len; ++i2) {
            function[i2] = program[++currentPointer];
        }
        this.functions.put(num, function);
        return ++currentPointer;
    }

    private boolean CALL(TTGraphicsState gs) {
        int func = this.stack.pop();
        int[] function = this.functions.get(func);
        boolean failedOnHinting = this.execute(function, gs);
        if (this.printOut) {
            System.out.println("CALL finished");
        }
        return failedOnHinting;
    }

    private boolean LOOPCALL(TTGraphicsState gs) {
        boolean failedOnHinting = false;
        int func = this.stack.pop();
        int count = this.stack.pop();
        int[] function = this.functions.get(func);
        for (int i2 = 0; i2 < count; ++i2) {
            boolean failed = this.execute(function, gs);
            if (!failed) continue;
            failedOnHinting = true;
        }
        if (this.printOut) {
            System.out.println("LOOPCALL finished");
        }
        return failedOnHinting;
    }

    private void UTP(TTGraphicsState gs) {
        int p2 = this.stack.pop();
        switch (gs.freedomVector) {
            case 0x40000000: {
                this.touched[gs.zp0][p2][0] = false;
                break;
            }
            case 16384: {
                this.touched[gs.zp0][p2][1] = false;
                break;
            }
            default: {
                this.touched[gs.zp0][p2][0] = false;
                this.touched[gs.zp0][p2][1] = false;
            }
        }
    }

    private static void SCFS(TTGraphicsState gs, Stack stack, int[][] x2, int[][] y2, boolean[][][] touched) {
        int value = stack.pop();
        int p2 = stack.pop();
        int current = TTGraphicsState.getCoordsOnVector(gs.projectionVector, x2[gs.zp2][p2], y2[gs.zp2][p2]);
        int pMove = value - current;
        int[] shift = gs.getFVMoveforPVDistance(pMove);
        if (gs.zp2 == 0) {
            int[] nArray = x2[2];
            int n2 = p2;
            nArray[n2] = nArray[n2] + shift[0];
            int[] nArray2 = y2[2];
            int n3 = p2;
            nArray2[n3] = nArray2[n3] + shift[1];
        }
        int[] nArray = x2[gs.zp2];
        int n4 = p2;
        nArray[n4] = nArray[n4] + shift[0];
        int[] nArray3 = y2[gs.zp2];
        int n5 = p2;
        nArray3[n5] = nArray3[n5] + shift[1];
        int[] fv = TTGraphicsState.getVectorComponents(gs.freedomVector);
        if (fv[0] != 0) {
            touched[gs.zp2][p2][0] = true;
        }
        if (fv[1] != 0) {
            touched[gs.zp2][p2][1] = true;
        }
    }

    private static void MIAP1(TTGraphicsState gs, Stack stack, Cvt cvt, int[][] x2, int[][] y2, boolean[][][] touched) {
        int target;
        int cvtEntry = stack.pop();
        int p2 = stack.pop();
        int current = TTGraphicsState.getCoordsOnVector(gs.projectionVector, x2[gs.zp0][p2], y2[gs.zp0][p2]);
        try {
            target = cvt.get(cvtEntry);
        }
        catch (Cvt.EntryNotFoundException e2) {
            target = current;
        }
        int pMove = Math.abs(target - current);
        if (gs.zp0 != 0 && pMove > gs.controlValueTableCutIn) {
            target = current;
        }
        target = TTVM.storeDoubleAsF26Dot6(gs.round(TTVM.getDoubleFromF26Dot6(target)));
        pMove = target - current;
        int[] shift = gs.getFVMoveforPVDistance(pMove);
        if (gs.zp0 == 0) {
            int[] nArray = x2[2];
            int n2 = p2;
            nArray[n2] = nArray[n2] + shift[0];
            int[] nArray2 = y2[2];
            int n3 = p2;
            nArray2[n3] = nArray2[n3] + shift[1];
        }
        int[] nArray = x2[gs.zp0];
        int n4 = p2;
        nArray[n4] = nArray[n4] + shift[0];
        int[] nArray3 = y2[gs.zp0];
        int n5 = p2;
        nArray3[n5] = nArray3[n5] + shift[1];
        int[] fv = TTGraphicsState.getVectorComponents(gs.freedomVector);
        if (fv[0] != 0) {
            touched[gs.zp0][p2][0] = true;
        }
        if (fv[1] != 0) {
            touched[gs.zp0][p2][1] = true;
        }
        gs.rp0 = gs.rp1 = p2;
    }

    private static void MIAP0(TTGraphicsState gs, Stack stack, Cvt cvt, int[][] x2, int[][] y2, boolean[][][] touched) {
        int target;
        int cvtEntry = stack.pop();
        int p2 = stack.pop();
        int current = TTGraphicsState.getCoordsOnVector(gs.projectionVector, x2[gs.zp0][p2], y2[gs.zp0][p2]);
        try {
            target = cvt.get(cvtEntry);
        }
        catch (Cvt.EntryNotFoundException e2) {
            target = current;
        }
        int pMove = target - current;
        int[] shift = gs.getFVMoveforPVDistance(pMove);
        if (gs.zp0 == 0) {
            int[] nArray = x2[2];
            int n2 = p2;
            nArray[n2] = nArray[n2] + shift[0];
            int[] nArray2 = y2[2];
            int n3 = p2;
            nArray2[n3] = nArray2[n3] + shift[1];
        }
        int[] nArray = x2[gs.zp0];
        int n4 = p2;
        nArray[n4] = nArray[n4] + shift[0];
        int[] nArray3 = y2[gs.zp0];
        int n5 = p2;
        nArray3[n5] = nArray3[n5] + shift[1];
        int[] fv = TTGraphicsState.getVectorComponents(gs.freedomVector);
        if (fv[0] != 0) {
            touched[gs.zp0][p2][0] = true;
        }
        if (fv[1] != 0) {
            touched[gs.zp0][p2][1] = true;
        }
        gs.rp0 = gs.rp1 = p2;
    }

    private static void ALIGNRP(TTGraphicsState gs, Stack stack, int[][] x2, int[][] y2, boolean[][][] touched) {
        for (int i2 = 0; i2 < gs.loop; ++i2) {
            int p2 = stack.pop();
            int target = TTGraphicsState.getCoordsOnVector(gs.projectionVector, x2[gs.zp0][gs.rp0], y2[gs.zp0][gs.rp0]);
            int pMove = target - TTGraphicsState.getCoordsOnVector(gs.projectionVector, x2[gs.zp1][p2], y2[gs.zp1][p2]);
            int[] shift = gs.getFVMoveforPVDistance(pMove);
            int[] nArray = x2[gs.zp1];
            int n2 = p2;
            nArray[n2] = nArray[n2] + shift[0];
            int[] nArray2 = y2[gs.zp1];
            int n3 = p2;
            nArray2[n3] = nArray2[n3] + shift[1];
            int[] fv = TTGraphicsState.getVectorComponents(gs.freedomVector);
            if (fv[0] != 0) {
                touched[gs.zp1][p2][0] = true;
            }
            if (fv[1] == 0) continue;
            touched[gs.zp1][p2][1] = true;
        }
        gs.loop = 1;
    }

    private static void MSIRP1(TTGraphicsState gs, Stack stack, int[][] x2, int[][] y2, boolean[][][] touched) {
        int d2 = stack.pop();
        int p2 = stack.pop();
        int[] shift = gs.getFVMoveforPVDistance(d2 - (TTGraphicsState.getCoordsOnVector(gs.projectionVector, x2[gs.zp1][p2], y2[gs.zp1][p2]) - TTGraphicsState.getCoordsOnVector(gs.projectionVector, x2[gs.zp0][gs.rp0], y2[gs.zp0][gs.rp0])));
        if (gs.zp1 == 0) {
            int[] nArray = x2[2];
            int n2 = p2;
            nArray[n2] = nArray[n2] + shift[0];
            int[] nArray2 = y2[2];
            int n3 = p2;
            nArray2[n3] = nArray2[n3] + shift[1];
        }
        int[] nArray = x2[gs.zp1];
        int n4 = p2;
        nArray[n4] = nArray[n4] + shift[0];
        int[] nArray3 = y2[gs.zp1];
        int n5 = p2;
        nArray3[n5] = nArray3[n5] + shift[1];
        int[] fv = TTGraphicsState.getVectorComponents(gs.freedomVector);
        if (fv[0] != 0) {
            touched[gs.zp1][p2][0] = true;
        }
        if (fv[1] != 0) {
            touched[gs.zp1][p2][1] = true;
        }
        gs.rp1 = gs.rp0;
        gs.rp2 = p2;
        gs.rp0 = p2;
    }

    private static void MSIRP0(TTGraphicsState gs, Stack stack, int[][] x2, int[][] y2, boolean[][][] touched) {
        int d2 = stack.pop();
        int p2 = stack.pop();
        int[] shift = gs.getFVMoveforPVDistance(d2 - (TTGraphicsState.getCoordsOnVector(gs.projectionVector, x2[gs.zp1][p2], y2[gs.zp1][p2]) - TTGraphicsState.getCoordsOnVector(gs.projectionVector, x2[gs.zp0][gs.rp0], y2[gs.zp0][gs.rp0])));
        if (gs.zp1 == 0) {
            int[] nArray = x2[2];
            int n2 = p2;
            nArray[n2] = nArray[n2] + shift[0];
            int[] nArray2 = y2[2];
            int n3 = p2;
            nArray2[n3] = nArray2[n3] + shift[1];
        }
        int[] nArray = x2[gs.zp1];
        int n4 = p2;
        nArray[n4] = nArray[n4] + shift[0];
        int[] nArray3 = y2[gs.zp1];
        int n5 = p2;
        nArray3[n5] = nArray3[n5] + shift[1];
        int[] fv = TTGraphicsState.getVectorComponents(gs.freedomVector);
        if (fv[0] != 0) {
            touched[gs.zp1][p2][0] = true;
        }
        if (fv[1] != 0) {
            touched[gs.zp1][p2][1] = true;
        }
        gs.rp1 = gs.rp0;
        gs.rp2 = p2;
    }

    private static void IP(TTGraphicsState gs, Stack stack, int[][] x2, int[][] y2, boolean[][][] touched) {
        for (int i2 = 0; i2 < gs.loop; ++i2) {
            int originalRP2;
            int p2 = stack.pop();
            if (p2 < 0 || p2 > x2[gs.zp2].length || gs.rp1 > x2[gs.zp0].length || gs.rp2 > x2[gs.zp1].length) {
                LogWriter.writeLog("Trying to use a point which doesn't exist! (IP, zone " + gs.zp2 + ')');
                break;
            }
            int originalRP1 = TTGraphicsState.getCoordsOnVector(gs.dualProjectionVector, x2[2 + gs.zp0][gs.rp1], y2[2 + gs.zp0][gs.rp1]);
            if (originalRP1 == (originalRP2 = TTGraphicsState.getCoordsOnVector(gs.dualProjectionVector, x2[2 + gs.zp1][gs.rp2], y2[2 + gs.zp1][gs.rp2]))) continue;
            int originalP = TTGraphicsState.getCoordsOnVector(gs.dualProjectionVector, x2[2 + gs.zp2][p2], y2[2 + gs.zp2][p2]);
            double pos = (double)(originalP - originalRP1) / (double)(originalRP2 - originalRP1);
            int newRP1 = TTGraphicsState.getCoordsOnVector(gs.projectionVector, x2[gs.zp0][gs.rp1], y2[gs.zp0][gs.rp1]);
            int newRP2 = TTGraphicsState.getCoordsOnVector(gs.projectionVector, x2[gs.zp1][gs.rp2], y2[gs.zp1][gs.rp2]);
            int pMove = (int)(pos * (double)(newRP2 - newRP1) + (double)newRP1 + 0.5) - originalP;
            int[] shift = gs.getFVMoveforPVDistance(pMove);
            int[] nArray = x2[gs.zp2];
            int n2 = p2;
            nArray[n2] = nArray[n2] + shift[0];
            int[] nArray2 = y2[gs.zp2];
            int n3 = p2;
            nArray2[n3] = nArray2[n3] + shift[1];
            int[] fv = TTGraphicsState.getVectorComponents(gs.freedomVector);
            if (fv[0] != 0) {
                touched[gs.zp2][p2][0] = true;
            }
            if (fv[1] == 0) continue;
            touched[gs.zp2][p2][1] = true;
        }
        gs.loop = 1;
    }

    private static void SHPIX(TTGraphicsState gs, Stack stack, int[][] x2, int[][] y2, boolean[][][] touched) {
        int magnitude = stack.pop();
        int[] fv = TTGraphicsState.getVectorComponents(gs.freedomVector);
        for (int i2 = 0; i2 < gs.loop; ++i2) {
            int point = stack.pop();
            int[] nArray = x2[gs.zp2];
            int n2 = point;
            nArray[n2] = (int)((double)nArray[n2] + (double)magnitude * TTVM.getDoubleFromF2Dot14(fv[0]));
            int[] nArray2 = y2[gs.zp2];
            int n3 = point;
            nArray2[n3] = (int)((double)nArray2[n3] + (double)magnitude * TTVM.getDoubleFromF2Dot14(fv[1]));
            if (fv[0] != 0) {
                touched[gs.zp2][point][0] = true;
            }
            if (fv[1] == 0) continue;
            touched[gs.zp2][point][1] = true;
        }
        gs.loop = 1;
    }

    private static void SHZ0(TTGraphicsState gs, Stack stack, int[][] x2, int[][] y2, int zp1, int rp2) {
        int z2 = stack.pop();
        int newRP = TTGraphicsState.getCoordsOnVector(gs.projectionVector, x2[zp1][rp2], y2[zp1][rp2]);
        int oldRP = TTGraphicsState.getCoordsOnVector(gs.projectionVector, x2[2 + zp1][rp2], y2[2 + zp1][rp2]);
        int shift = newRP - oldRP;
        int[] move = gs.getFVMoveforPVDistance(shift);
        for (int i2 = 0; i2 < x2[z2].length; ++i2) {
            if (z2 == zp1 && i2 == rp2) continue;
            int[] nArray = x2[z2];
            int n2 = i2;
            nArray[n2] = nArray[n2] + move[0];
            int[] nArray2 = y2[z2];
            int n3 = i2;
            nArray2[n3] = nArray2[n3] + move[1];
        }
    }

    private static void SHC(TTGraphicsState gs, Stack stack, boolean[][] contour, int[][] x2, int[][] y2, int code) {
        boolean b2;
        int refPoint;
        int zone;
        int c2 = stack.pop();
        if (code == 52) {
            zone = gs.zp1;
            refPoint = gs.rp2;
            b2 = gs.zp1 == gs.zp2;
        } else {
            zone = gs.zp0;
            refPoint = gs.rp1;
            b2 = gs.zp2 != gs.zp0;
        }
        int[] contourLengths = new int[contour[1].length];
        int[] contourStarts = new int[contour[1].length];
        int contourCount = 0;
        int lastContour = 0;
        contourStarts[0] = 0;
        for (int i2 = 0; i2 < contour[1].length; ++i2) {
            if (!contour[1][i2]) continue;
            contourStarts[contourCount + 1] = i2 + 1;
            contourLengths[contourCount] = i2 + 1 - lastContour;
            lastContour = i2 + 1;
            ++contourCount;
        }
        int newRP = TTGraphicsState.getCoordsOnVector(gs.projectionVector, x2[zone][refPoint], y2[zone][refPoint]);
        int oldRP = TTGraphicsState.getCoordsOnVector(gs.projectionVector, x2[2 + zone][refPoint], y2[2 + zone][refPoint]);
        int shift = newRP - oldRP;
        int[] move = gs.getFVMoveforPVDistance(shift);
        for (int i3 = contourStarts[c2]; i3 < contourStarts[c2] + contourLengths[c2]; ++i3) {
            if (!b2 && i3 == refPoint) continue;
            int[] nArray = x2[gs.zp2];
            int n2 = i3;
            nArray[n2] = nArray[n2] + move[0];
            int[] nArray2 = y2[gs.zp2];
            int n3 = i3;
            nArray2[n3] = nArray2[n3] + move[1];
        }
    }

    private static void ALIGNPTS(TTGraphicsState gs, Stack stack, int[][] x2, int[][] y2, boolean[][][] touched) {
        int p1 = stack.pop();
        int p2 = stack.pop();
        int p1loc = TTGraphicsState.getCoordsOnVector(gs.projectionVector, x2[gs.zp1][p1], y2[gs.zp1][p1]);
        int p2loc = TTGraphicsState.getCoordsOnVector(gs.projectionVector, x2[gs.zp0][p2], y2[gs.zp0][p2]);
        int target = (p1loc + p2loc) / 2;
        int[] shift = gs.getFVMoveforPVDistance(target - p1loc);
        int[] nArray = x2[gs.zp1];
        int n2 = p1;
        nArray[n2] = nArray[n2] + shift[0];
        int[] nArray2 = y2[gs.zp1];
        int n3 = p1;
        nArray2[n3] = nArray2[n3] + shift[1];
        int[] nArray3 = x2[gs.zp0];
        int n4 = p2;
        nArray3[n4] = nArray3[n4] - shift[0];
        int[] nArray4 = y2[gs.zp0];
        int n5 = p2;
        nArray4[n5] = nArray4[n5] - shift[1];
        int[] fv = TTGraphicsState.getVectorComponents(gs.freedomVector);
        if (fv[0] != 0) {
            touched[gs.zp1][p1][0] = true;
            touched[gs.zp0][p2][0] = true;
        }
        if (fv[1] != 0) {
            touched[gs.zp1][p1][1] = true;
            touched[gs.zp0][p2][1] = true;
        }
    }

    private static int ELSE(int currentPointer, int[] program) {
        int curr = 0;
        int nest = 0;
        do {
            if (curr == 89) {
                --nest;
            }
            if ((curr = program[++currentPointer]) == 88) {
                ++nest;
            }
            if (curr == 64) {
                ++currentPointer;
                currentPointer += program[currentPointer];
                continue;
            }
            if (curr == 65) {
                ++currentPointer;
                currentPointer += program[currentPointer] * 2;
                continue;
            }
            if (curr >= 176 && curr <= 183) {
                currentPointer += curr + 1 - 176;
                continue;
            }
            if (curr < 184 || curr > 191) continue;
            currentPointer += (curr + 1 - 184) * 2;
        } while (curr != 89 || nest != 0);
        return currentPointer;
    }

    private void ISECT(TTGraphicsState gs) {
        double am2;
        int newX;
        int b1 = this.stack.pop();
        int b0 = this.stack.pop();
        int a12 = this.stack.pop();
        int a02 = this.stack.pop();
        int ax2 = this.x[gs.zp1][a02];
        int ay2 = this.y[gs.zp1][a02];
        int adx = this.x[gs.zp1][a12] - ax2;
        int ady = this.y[gs.zp1][a12] - ay2;
        int bx = this.x[gs.zp0][b0];
        int by = this.y[gs.zp0][b0];
        int bdx = this.x[gs.zp0][b1] - bx;
        int bdy = this.y[gs.zp0][b1] - by;
        int newY = (ay2 + by + (ay2 + ady) + (by + bdy)) / 4;
        if (adx == 0 && bdx == 0) {
            newX = ax2 + bx / 2;
        } else if (adx == 0) {
            double bm2 = TTVM.getDoubleFromF26Dot6(bdy) / TTVM.getDoubleFromF26Dot6(bdx);
            double bc2 = TTVM.getDoubleFromF26Dot6(by) - bm2 * TTVM.getDoubleFromF26Dot6(bx);
            newX = ax2;
            newY = TTVM.storeDoubleAsF26Dot6(bm2 * TTVM.getDoubleFromF26Dot6(ax2) + bc2);
        } else if (bdx == 0) {
            am2 = TTVM.getDoubleFromF26Dot6(ady) / TTVM.getDoubleFromF26Dot6(adx);
            double ac2 = TTVM.getDoubleFromF26Dot6(ay2) - am2 * TTVM.getDoubleFromF26Dot6(ax2);
            newX = bx;
            newY = TTVM.storeDoubleAsF26Dot6(am2 * TTVM.getDoubleFromF26Dot6(bx) + ac2);
        } else {
            am2 = TTVM.getDoubleFromF26Dot6(ady) / TTVM.getDoubleFromF26Dot6(adx);
            double ac3 = TTVM.getDoubleFromF26Dot6(ay2) - am2 * TTVM.getDoubleFromF26Dot6(ax2);
            double bm3 = TTVM.getDoubleFromF26Dot6(bdy) / TTVM.getDoubleFromF26Dot6(bdx);
            double bc3 = TTVM.getDoubleFromF26Dot6(by) - bm3 * TTVM.getDoubleFromF26Dot6(bx);
            if (am2 == bm3) {
                newX = (ax2 + bx + (ax2 + adx) + (bx + bdx)) / 4;
            } else {
                double fx = (bc3 - ac3) / (am2 - bm3);
                newX = TTVM.storeDoubleAsF26Dot6(fx);
                newY = TTVM.storeDoubleAsF26Dot6(am2 * fx + ac3);
            }
        }
        int p2 = this.stack.pop();
        this.x[gs.zp2][p2] = newX;
        this.y[gs.zp2][p2] = newY;
    }

    private static void GPV(int currentPointer, Stack stack, int projectionVector) {
        int[] pv = TTGraphicsState.getVectorComponents(projectionVector);
        stack.push(pv[0], currentPointer);
        stack.push(pv[1], currentPointer);
    }

    private static void SFVFS(TTGraphicsState gs, Stack stack) {
        int y2 = stack.pop();
        int x2 = stack.pop();
        gs.freedomVector = TTGraphicsState.createVector(x2, y2);
    }

    private static void SPVFS(TTGraphicsState gs, Stack stack) {
        int y2 = stack.pop();
        int x2 = stack.pop();
        gs.dualProjectionVector = gs.projectionVector = TTGraphicsState.createVector(x2, y2);
    }

    private static void SFVTL1(TTGraphicsState gs, Stack stack, int[][] x2, int[][] y2) {
        int p1 = stack.pop();
        int p2 = stack.pop();
        double xdiff = TTVM.getDoubleFromF26Dot6(x2[gs.zp1][p2] - x2[gs.zp2][p1]);
        double ydiff = TTVM.getDoubleFromF26Dot6(y2[gs.zp1][p2] - y2[gs.zp2][p1]);
        double factor = Math.sqrt(xdiff * xdiff + ydiff * ydiff);
        gs.freedomVector = TTGraphicsState.createVector(TTVM.storeDoubleAsF2Dot14(-(ydiff /= factor)), TTVM.storeDoubleAsF2Dot14(xdiff /= factor));
    }

    private static void SFVTL0(TTGraphicsState gs, Stack stack, int[][] x2, int[][] y2) {
        int p1 = stack.pop();
        int p2 = stack.pop();
        double xdiff = TTVM.getDoubleFromF26Dot6(x2[gs.zp1][p2] - x2[gs.zp2][p1]);
        double ydiff = TTVM.getDoubleFromF26Dot6(y2[gs.zp1][p2] - y2[gs.zp2][p1]);
        double factor = Math.sqrt(xdiff * xdiff + ydiff * ydiff);
        gs.freedomVector = TTGraphicsState.createVector(TTVM.storeDoubleAsF2Dot14(xdiff /= factor), TTVM.storeDoubleAsF2Dot14(ydiff /= factor));
    }

    private static void SPVTL0(TTGraphicsState gs, Stack stack, int[][] x2, int[][] y2) {
        int p1 = stack.pop();
        int p2 = stack.pop();
        double xdiff = TTVM.getDoubleFromF26Dot6(x2[gs.zp2][p2] - x2[gs.zp1][p1]);
        double ydiff = TTVM.getDoubleFromF26Dot6(y2[gs.zp2][p2] - y2[gs.zp1][p1]);
        double factor = Math.sqrt(xdiff * xdiff + ydiff * ydiff);
        gs.dualProjectionVector = gs.projectionVector = TTGraphicsState.createVector(TTVM.storeDoubleAsF2Dot14(xdiff /= factor), TTVM.storeDoubleAsF2Dot14(ydiff /= factor));
    }

    private static void SPVTL1(TTGraphicsState gs, Stack stack, int[][] x2, int[][] y2) {
        int p1 = stack.pop();
        int p2 = stack.pop();
        double xdiff = TTVM.getDoubleFromF26Dot6(x2[gs.zp2][p2] - x2[gs.zp1][p1]);
        double ydiff = TTVM.getDoubleFromF26Dot6(y2[gs.zp2][p2] - y2[gs.zp1][p1]);
        double factor = Math.sqrt(xdiff * xdiff + ydiff * ydiff);
        gs.dualProjectionVector = gs.projectionVector = TTGraphicsState.createVector(TTVM.storeDoubleAsF2Dot14(-(ydiff /= factor)), TTVM.storeDoubleAsF2Dot14(xdiff /= factor));
    }

    void interpolateUntouchedPoints(int axis) {
        int touchedAxis;
        int[][] axisPoints;
        boolean[] touchedInAxis = new boolean[this.touched[1].length];
        if (axis == 49) {
            axisPoints = this.x;
            touchedAxis = 0;
        } else {
            axisPoints = this.y;
            touchedAxis = 1;
        }
        int[] points = axisPoints[1];
        int[] original = axisPoints[3];
        for (int i2 = 0; i2 < this.touched[1].length; ++i2) {
            touchedInAxis[i2] = this.touched[1][i2][touchedAxis];
        }
        int contourStart = 0;
        while (contourStart < points.length) {
            contourStart = this.interpolateContour(points, original, touchedInAxis, contourStart);
        }
    }

    private int interpolateContour(int[] points, int[] original, boolean[] touchedInAxis, int contourStart) {
        int[] touchedPointNumbers = new int[original.length];
        int touchedCount = 0;
        int point = 0;
        do {
            if (!touchedInAxis[contourStart + point]) continue;
            touchedPointNumbers[touchedCount] = contourStart + point;
            ++touchedCount;
        } while (!this.contour[1][contourStart + ++point - 1] && contourStart + point < this.contour[1].length);
        int contourEnd = contourStart + point;
        if (touchedCount == 1) {
            int shift = points[touchedPointNumbers[0]] - original[touchedPointNumbers[0]];
            TTVM.shiftUntouchedPoints(points, shift, touchedInAxis, contourStart, contourEnd);
        } else if (touchedCount > 1) {
            for (int i2 = 0; i2 < touchedCount; ++i2) {
                if (i2 + 1 >= touchedCount) {
                    TTVM.interpolateRange(touchedPointNumbers[i2] + 1, contourEnd - 1, touchedPointNumbers[i2], touchedPointNumbers[0], points, original);
                    TTVM.interpolateRange(contourStart, touchedPointNumbers[0] - 1, touchedPointNumbers[i2], touchedPointNumbers[0], points, original);
                    continue;
                }
                TTVM.interpolateRange(touchedPointNumbers[i2] + 1, touchedPointNumbers[i2 + 1] - 1, touchedPointNumbers[i2], touchedPointNumbers[i2 + 1], points, original);
            }
        }
        return contourEnd;
    }

    private static void shiftUntouchedPoints(int[] points, int shift, boolean[] touchedInAxis, int contourStart, int contourEnd) {
        for (int i2 = contourStart; i2 < contourEnd; ++i2) {
            if (touchedInAxis[i2]) continue;
            int n2 = i2;
            points[n2] = points[n2] + shift;
        }
    }

    private static void interpolateRange(int start, int end, int ref1, int ref2, int[] points, int[] original) {
        int higherRef;
        int lowerRef;
        if (original[ref2] < original[ref1]) {
            lowerRef = ref2;
            higherRef = ref1;
        } else {
            lowerRef = ref1;
            higherRef = ref2;
        }
        for (int i2 = start; i2 <= end; ++i2) {
            if (original[i2] < original[lowerRef]) {
                int n2 = i2;
                points[n2] = points[n2] + (points[lowerRef] - original[lowerRef]);
                continue;
            }
            if (original[i2] > original[higherRef]) {
                int n3 = i2;
                points[n3] = points[n3] + (points[higherRef] - original[higherRef]);
                continue;
            }
            double pos = (double)(original[i2] - original[lowerRef]) / (double)(original[higherRef] - original[lowerRef]);
            points[i2] = points[lowerRef] + (int)(pos * (double)(points[higherRef] - points[lowerRef]));
        }
    }

    private int readFromIS(int number, boolean readWord, int currentPointer, int[] program) {
        for (int i2 = 0; i2 < number; ++i2) {
            int data;
            ++currentPointer;
            if (!readWord) {
                data = program[currentPointer];
            } else {
                int d1 = program[currentPointer];
                int d2 = program[++currentPointer];
                data = TTVM.getIntFrom2Uint8(d1, d2);
            }
            this.stack.push(data, currentPointer);
        }
        return currentPointer;
    }

    static int getIntFrom2Uint8(int high, int low) {
        return (high << 8) + low + (high >> 7 & 1) * -65536;
    }

    static double getDoubleFromF26Dot6(int a10) {
        return (double)a10 / 64.0;
    }

    static double getDoubleFromF2Dot14(int a10) {
        return (double)a10 / 16384.0;
    }

    static int storeDoubleAsF26Dot6(double a10) {
        return (int)(a10 * 64.0 + 0.5);
    }

    private static int storeDoubleAsF2Dot14(double a10) {
        return (int)(a10 * 16384.0 + 0.5);
    }

    private static int[] readProgramTable(FontFile2 currentFontFile, int table) {
        int[] program = new int[]{};
        int startPointer = currentFontFile.selectTable(table);
        if (startPointer == 0) {
            LogWriter.writeLog("No program table found: " + table);
        } else {
            int len = currentFontFile.getOffset(table);
            program = new int[len];
            for (int i2 = 0; i2 < len; ++i2) {
                program[i2] = currentFontFile.getNextUint8();
            }
        }
        return program;
    }

    static class Stack
    implements Serializable {
        private int pointer;
        private int[] values = new int[10];
        private String currentFunc;
        private String[] pushedByLine;

        Stack() {
            if (isDebug) {
                this.pushedByLine = new String[10];
            }
        }

        void push(int a10, int currentPointer) {
            if (this.pointer >= this.values.length) {
                int[] newValues = new int[(int)((double)this.values.length * 1.5)];
                System.arraycopy(this.values, 0, newValues, 0, this.values.length);
                this.values = newValues;
                if (isDebug) {
                    String[] newPBL = new String[(int)((double)this.values.length * 1.5)];
                    System.arraycopy(this.pushedByLine, 0, newPBL, 0, this.pushedByLine.length);
                    this.pushedByLine = newPBL;
                }
            }
            this.values[this.pointer] = a10;
            if (isDebug) {
                this.pushedByLine[this.pointer] = this.currentFunc + " Line " + currentPointer;
            }
            ++this.pointer;
        }

        void setCurrentFunc(String currentFunc) {
            this.currentFunc = currentFunc;
        }

        int pop() {
            --this.pointer;
            if (this.pointer >= 0) {
                return this.values[this.pointer];
            }
            throw new RuntimeException("Popped an empty stack!");
        }

        int size() {
            return this.pointer;
        }

        int elementAt(int key) {
            return this.values[this.pointer - key];
        }

        int remove(int key) {
            int valPos = this.pointer - key;
            int result = this.values[valPos];
            int[] newValues = new int[this.values.length];
            System.arraycopy(this.values, 0, newValues, 0, valPos);
            System.arraycopy(this.values, valPos + 1, newValues, valPos, this.values.length - valPos - 1);
            this.values = newValues;
            if (isDebug) {
                String[] newPBL = new String[this.values.length];
                System.arraycopy(this.pushedByLine, 0, newPBL, 0, valPos);
                System.arraycopy(this.pushedByLine, valPos + 1, newPBL, valPos, this.values.length - valPos - 1);
                this.pushedByLine = newPBL;
            }
            --this.pointer;
            return result;
        }

        String[] toStringArray() {
            String[] result = new String[this.pointer];
            for (int i2 = this.pointer - 1; i2 >= 0; --i2) {
                result[this.pointer - i2 - 1] = this.pointer - i2 - 1 + ": " + this.values[i2] + "       (" + NumberFormat.getNumberInstance().format((double)this.values[i2] / 64.0) + ')';
            }
            return result;
        }

        String getPushedBy(int i2) {
            return this.pushedByLine[this.pointer - (i2 + 1)];
        }
    }
}

