/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt.cmap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.cmap.Format;

public class Format4
implements Format {
    private int segCount;
    private int[] endCode;
    private int[] startCode;
    private int[] idDelta;
    private int[] idRangeOffset;
    private int[] glyphIdArray;
    private final int[] CMAPsegCount;
    private final int[] CMAPsearchRange;
    private final int[] CMAPentrySelector;
    private final int[] CMAPrangeShift;
    private final int[] CMAPreserved;

    public Format4(int[] CMAPsegCount, int[] CMAPsearchRange, int[] CMAPentrySelector, int[] CMAPrangeShift, int[] CMAPreserved) {
        this.CMAPsegCount = CMAPsegCount;
        this.CMAPsearchRange = CMAPsearchRange;
        this.CMAPentrySelector = CMAPentrySelector;
        this.CMAPrangeShift = CMAPrangeShift;
        this.CMAPreserved = CMAPreserved;
    }

    @Override
    public boolean readTable(FontFile2 currentFontFile, int j2, int[] CMAPlength, int[] CMAPlang) {
        int i2;
        CMAPlength[j2] = currentFontFile.getNextUint16();
        CMAPlang[j2] = currentFontFile.getNextUint16();
        this.CMAPsegCount[j2] = currentFontFile.getNextUint16();
        this.segCount = this.CMAPsegCount[j2] / 2;
        this.CMAPsearchRange[j2] = currentFontFile.getNextUint16();
        this.CMAPentrySelector[j2] = currentFontFile.getNextUint16();
        this.CMAPrangeShift[j2] = currentFontFile.getNextUint16();
        this.endCode = new int[this.segCount];
        for (i2 = 0; i2 < this.segCount; ++i2) {
            this.endCode[i2] = currentFontFile.getNextUint16();
        }
        this.CMAPreserved[j2] = currentFontFile.getNextUint16();
        this.startCode = new int[this.segCount];
        for (i2 = 0; i2 < this.segCount; ++i2) {
            this.startCode[i2] = currentFontFile.getNextUint16();
        }
        this.idDelta = new int[this.segCount];
        for (i2 = 0; i2 < this.segCount; ++i2) {
            this.idDelta[i2] = currentFontFile.getNextUint16();
        }
        this.idRangeOffset = new int[this.segCount];
        for (i2 = 0; i2 < this.segCount; ++i2) {
            this.idRangeOffset[i2] = currentFontFile.getNextUint16();
        }
        int count = (CMAPlength[j2] - 16 - this.segCount * 8) / 2;
        this.glyphIdArray = new int[count];
        for (int i3 = 0; i3 < count; ++i3) {
            this.glyphIdArray[i3] = currentFontFile.getNextUint16();
        }
        return true;
    }

    @Override
    public int getValue(int index) {
        int value = this.getFormat4Value(index, -1);
        if (value == -1) {
            value = index > 61440 ? this.getFormat4Value(index - 61440, value) : this.getFormat4Value(index + 61440, value);
        }
        return value;
    }

    @Override
    public Map<Integer, Integer> setGlyphValues() {
        HashMap<Integer, Integer> glyfValues = new HashMap<Integer, Integer>();
        ArrayList<Integer> list4 = new ArrayList<Integer>();
        for (int z2 = 0; z2 < this.segCount; ++z2) {
            int total = this.endCode[z2] - this.startCode[z2] + 1;
            for (int q2 = 0; q2 < total; ++q2) {
                list4.add(this.startCode[z2] + q2);
            }
        }
        for (Integer i2 : list4) {
            glyfValues.put(i2, this.getFormat4Value(i2, 0));
        }
        return glyfValues;
    }

    private int getFormat4Value(int index, int value) {
        for (int i2 = 0; i2 < this.segCount; ++i2) {
            if (this.endCode[i2] < index || this.startCode[i2] > index) continue;
            if (this.idRangeOffset[i2] == 0) {
                value = (this.idDelta[i2] + index) % 65536;
                break;
            }
            int rangesRemaining = this.idRangeOffset.length - i2;
            int idx = this.idRangeOffset[i2] / 2 + (index - this.startCode[i2]) - rangesRemaining;
            if (idx < this.glyphIdArray.length) {
                value = this.glyphIdArray[idx];
                if (value == 0) break;
                value = (this.idDelta[i2] + value) % 65536;
                break;
            }
            value = 0;
            break;
        }
        return value;
    }
}

