/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt.cmap;

import java.util.ArrayList;
import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.cmap.Format;

public class Format2
implements Format {
    private int[] subHeaders;
    private int[] firstCode;
    private int[] entryCount;
    private int[] idDelta;
    private int[] glyphIdArray;

    @Override
    public boolean readTable(FontFile2 currentFontFile, int subtableID, int[] CMAPlength, int[] CMAPlang) {
        int idRangeOffset;
        int start = currentFontFile.getPointer() - 2;
        CMAPlength[subtableID] = currentFontFile.getNextUint16();
        CMAPlang[subtableID] = currentFontFile.getNextUint16();
        this.subHeaders = new int[256];
        for (int i3 = 0; i3 < 256; ++i3) {
            this.subHeaders[i3] = currentFontFile.getNextUint16() << 3;
        }
        ArrayList<Integer> raw_firstCode = new ArrayList<Integer>();
        ArrayList<Integer> raw_entryCount = new ArrayList<Integer>();
        ArrayList<Integer> raw_idDelta = new ArrayList<Integer>();
        int glyphsRead = 0;
        do {
            raw_firstCode.add(currentFontFile.getNextUint16());
            int glyphCount = currentFontFile.getNextUint16();
            glyphsRead += glyphCount;
            raw_entryCount.add(glyphCount);
            raw_idDelta.add(currentFontFile.getNextUint16());
            idRangeOffset = currentFontFile.getNextUint16();
        } while (CMAPlength[subtableID] - (currentFontFile.getPointer() - start) > idRangeOffset);
        this.firstCode = raw_firstCode.stream().mapToInt(i2 -> i2).toArray();
        this.entryCount = raw_entryCount.stream().mapToInt(i2 -> i2).toArray();
        this.idDelta = raw_idDelta.stream().mapToInt(i2 -> i2).toArray();
        this.glyphIdArray = new int[glyphsRead];
        for (int glyph = 0; glyph < glyphsRead && currentFontFile.getBytesLeft() >= 2; ++glyph) {
            this.glyphIdArray[glyph] = currentFontFile.getNextUint16();
        }
        return true;
    }

    @Override
    public int getValue(int index) {
        int i2 = index & 0xFF00;
        int j2 = index & 0xFF;
        int k2 = this.subHeaders[i2];
        if (j2 < this.firstCode[i2] || j2 > this.firstCode[i2] + this.entryCount[i2]) {
            return 0;
        }
        int p2 = this.glyphIdArray[j2];
        if (p2 == 0) {
            return 0;
        }
        return p2 + this.idDelta[i2];
    }
}

