/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Table;

public class Name
extends Table {
    private final Map<Integer, String> strings = new HashMap<Integer, String>();
    public static final Integer FONT_FAMILY_NAME = 1;
    public static final Integer FULL_FONT_NAME = 4;
    public static final Integer POSTSCRIPT_NAME = 6;
    public static final String[] stringNames = new String[]{"COPYRIGHT_NOTICE", "FONT_FAMILY_NAME", "FONT_SUBFAMILY_NAME", "UNIQUE_FONT_IDENTIFIER", "FULL_FONT_NAME", "VERSION_STRING", "POSTSCRIPT_NAME", "TRADEMARK", "MANUFACTURER", "DESIGNER", "DESCRIPTION", "VENDOR_URL", "DESIGNER_URL", "LICENSE", "LICENSE_URL", "PREFERRED_FAMILY", "PREFERRED_SUBFAMILY", "COMPATIBLE", "SAMPLE_TEXT"};

    public Name(FontFile2 currentFontFile) {
        int startPointer = currentFontFile.selectTable(7);
        if (startPointer != 0) {
            currentFontFile.getNextUint16();
            int count = currentFontFile.getNextUint16();
            int offset = currentFontFile.getNextUint16();
            for (int i2 = 0; i2 < count; ++i2) {
                int platformID = currentFontFile.getNextUint16();
                int platformSpecificID = currentFontFile.getNextUint16();
                int langID = currentFontFile.getNextUint16();
                int nameID = currentFontFile.getNextUint16();
                int length = currentFontFile.getNextUint16();
                int offset2 = currentFontFile.getNextUint16();
                if (!(platformID == 1 && platformSpecificID == 0 && langID == 0 || platformID == 3 && platformSpecificID == 0 && langID == 1033) && (platformID != 3 || platformSpecificID != 1 || langID != 1033)) continue;
                int oldP = currentFontFile.getPointer();
                currentFontFile.setPointer(startPointer + offset + offset2);
                if (platformID == 3) {
                    length /= 2;
                }
                StringBuilder s2 = new StringBuilder();
                s2.setLength(length);
                for (int ii = 0; ii < length; ++ii) {
                    int nextChar = platformID == 3 ? currentFontFile.getNextUint16() : currentFontFile.getNextUint8();
                    s2.setCharAt(ii, (char)nextChar);
                }
                this.strings.put(nameID, s2.toString());
                currentFontFile.setPointer(oldP);
            }
        }
    }

    protected Name() {
    }

    public Map<Integer, String> getStrings() {
        return Collections.unmodifiableMap(this.strings);
    }

    public String getString(Integer id2) {
        return this.strings.get(id2);
    }
}

