/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt;

import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Table;
import org.jpedal.utils.LogWriter;

public class Loca
extends Table {
    private int[] glyphOffsets;

    public Loca(FontFile2 currentFontFile, int glyphCount, int format) {
        if (currentFontFile == null) {
            return;
        }
        int startPointer = currentFontFile.selectTable(3);
        int locaLength = currentFontFile.getOffset(3);
        this.glyphOffsets = new int[glyphCount + 1];
        if (startPointer != 0) {
            this.glyphOffsets[0] = 0;
            if (format == 1 || format == 256) {
                if (locaLength / 4 != glyphCount + 1) {
                    LogWriter.writeLog("Incorrect length");
                }
                for (int i2 = 0; i2 < glyphCount; ++i2) {
                    this.glyphOffsets[i2] = currentFontFile.getNextUint32();
                }
            } else {
                for (int i3 = 0; i3 < glyphCount; ++i3) {
                    this.glyphOffsets[i3] = currentFontFile.getNextUint16() * 2;
                }
            }
            this.glyphOffsets[glyphCount] = currentFontFile.getOffset(4);
        }
    }

    public int[] getOffsets() {
        return this.glyphOffsets;
    }
}

