/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt;

import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Table;
import org.jpedal.utils.LogWriter;

public class Hmtx
extends Table {
    private int[] widths;
    private short[] leftSideBearing;
    private float scaling = 0.001f;

    public Hmtx(FontFile2 currentFontFile, int glyphCount, int metricsCount, int maxAdvance) {
        this.scaling = maxAdvance;
        if (metricsCount < 0) {
            metricsCount = -metricsCount;
        }
        int startPointer = currentFontFile.selectTable(6);
        int lsbCount = glyphCount - metricsCount;
        this.widths = new int[glyphCount];
        this.leftSideBearing = new short[glyphCount];
        int currentWidth = 0;
        if (startPointer == 0) {
            LogWriter.writeLog("No Hmtx table found");
        } else {
            int i2;
            int min = Math.min(metricsCount, glyphCount);
            try {
                for (i2 = 0; i2 < min; ++i2) {
                    this.widths[i2] = currentWidth = currentFontFile.getNextUint16();
                    this.leftSideBearing[i2] = currentFontFile.getNextInt16();
                }
            }
            catch (ArrayIndexOutOfBoundsException e2) {
                LogWriter.writeLog("Invalid hmtx table found");
                return;
            }
            if (lsbCount < 0) {
                LogWriter.writeLog("Potentially invalid hmtx table found");
                return;
            }
            int tableLength = currentFontFile.getTableSize(6);
            int lsbBytes = tableLength - i2 * 4;
            lsbCount = lsbBytes / 2;
            try {
                for (int j2 = i2; j2 < glyphCount; ++j2) {
                    this.widths[j2] = currentWidth;
                    this.leftSideBearing[j2] = j2 - i2 < lsbCount ? currentFontFile.getFWord() : (short)0;
                }
            }
            catch (Exception ee) {
                LogWriter.writeLog("Exception in reading Hmtx " + ee);
            }
        }
    }

    protected Hmtx() {
    }

    public short getLeftSideBearing(int i2) {
        int length = this.widths.length;
        if (i2 < length) {
            return (short)(this.leftSideBearing[i2] & 0xFFFF);
        }
        return 0;
    }

    public float getWidth(int i2) {
        return (float)this.widths[i2] / this.scaling;
    }

    public int getUnscaledWidth(int i2) {
        return this.widths[i2];
    }
}

