/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt;

import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Table;

public class Hhea
extends Table {
    private static final int VERSION = 0;
    public static final int ASCENDER = 1;
    private static final int DESCENDER = 2;
    private static final int LINEGAP = 3;
    public static final int ADVANCEWIDTHMAX = 4;
    private static final int MINIMUMLEFTSIDEBEARING = 5;
    public static final int MINIMUMRIGHTSIDEBEARING = 6;
    public static final int XMAXEXTENT = 7;
    private static final int CARETSLOPERISING = 8;
    private static final int CARETSLOPERUN = 9;
    private static final int CARETOFFSET = 10;
    private static final int METRICDATAFORMAT = 11;
    private static final int NUMBEROFMETRICS = 12;
    private int version = 65536;
    private int ascender = 1;
    private int descender = -1;
    private int lineGap;
    private int advancedWidthMax;
    private int minimumLeftSideBearing;
    private int minimumRightSideBearing;
    private int xMaxExtent;
    private int caretSlopeRise;
    private int caretSlopeRun;
    private int caretOffset;
    private int metricDataFormat;
    private int numberOfHMetrics;

    public Hhea(FontFile2 currentFontFile) {
        int startPointer = currentFontFile.selectTable(5);
        if (startPointer != 0) {
            this.version = currentFontFile.getNextUint32();
            this.ascender = currentFontFile.getFWord();
            this.descender = currentFontFile.getFWord();
            this.lineGap = currentFontFile.getFWord();
            this.advancedWidthMax = currentFontFile.readUFWord();
            this.minimumLeftSideBearing = currentFontFile.getFWord();
            this.minimumRightSideBearing = currentFontFile.getFWord();
            this.xMaxExtent = currentFontFile.getFWord();
            this.caretSlopeRise = currentFontFile.getNextInt16();
            this.caretSlopeRun = currentFontFile.getNextInt16();
            this.caretOffset = currentFontFile.getFWord();
            for (int i2 = 0; i2 < 4; ++i2) {
                currentFontFile.getNextUint16();
            }
            this.metricDataFormat = currentFontFile.getNextInt16();
            this.numberOfHMetrics = currentFontFile.getNextUint16();
        }
    }

    protected Hhea() {
    }

    public int getNumberOfHMetrics() {
        return this.numberOfHMetrics;
    }

    public int getIntValue(int key) {
        switch (key) {
            case 0: {
                return this.version;
            }
            case 1: {
                return this.ascender;
            }
            case 2: {
                return this.descender;
            }
            case 3: {
                return this.lineGap;
            }
            case 4: {
                return this.advancedWidthMax;
            }
            case 5: {
                return this.minimumLeftSideBearing;
            }
            case 6: {
                return this.minimumRightSideBearing;
            }
            case 7: {
                return this.xMaxExtent;
            }
            case 8: {
                return this.caretSlopeRise;
            }
            case 9: {
                return this.caretSlopeRun;
            }
            case 10: {
                return this.caretOffset;
            }
            case 11: {
                return this.metricDataFormat;
            }
            case 12: {
                return this.numberOfHMetrics;
            }
        }
        return 0;
    }
}

