/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt;

import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Table;

public class Glyf
extends Table {
    private final int[] glyphOffsets;
    protected final int glyphCount;
    protected final boolean[] emptyGlyphs;
    protected byte[] glyphTable;

    protected Glyf(FontFile2 currentFontFile, int glyphCount, int[] glyphIndexStart) {
        this.glyphCount = glyphCount;
        this.glyphOffsets = new int[glyphCount];
        this.emptyGlyphs = new boolean[glyphCount];
        int startPointer = currentFontFile.selectTable(3);
        if (startPointer != 0) {
            for (int i2 = 0; i2 < glyphCount; ++i2) {
                if (glyphIndexStart[i2] == glyphIndexStart[i2 + 1]) {
                    this.glyphOffsets[i2] = -1;
                    this.emptyGlyphs[i2] = true;
                    continue;
                }
                this.glyphOffsets[i2] = glyphIndexStart[i2];
            }
            this.glyphTable = currentFontFile.getTableBytes(4);
        }
    }

    public int getGlyphOffset(int glyph) {
        int value = glyph < 0 || glyph >= this.glyphCount ? glyph : this.glyphOffsets[glyph];
        return value;
    }

    public byte[] getTableData() {
        return this.glyphTable;
    }

    public int getGlyphCount() {
        return this.glyphCount;
    }

    public boolean containsKey(Integer key) {
        return !this.emptyGlyphs[key];
    }
}

