/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt;

import java.util.HashMap;
import java.util.Map;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Table;
import org.jpedal.fonts.tt.cmap.Format;
import org.jpedal.fonts.tt.cmap.Format0;
import org.jpedal.fonts.tt.cmap.Format12;
import org.jpedal.fonts.tt.cmap.Format2;
import org.jpedal.fonts.tt.cmap.Format4;
import org.jpedal.fonts.tt.cmap.Format6;
import org.jpedal.utils.LogWriter;

public class CMAP
extends Table {
    private static final int[] formats = new int[]{1, 4, 0, 2, 6, 12};
    private static final boolean debugMarksOldCode = false;
    private static final int PLATFORM_UNICODE = 0;
    private static final int PLATFORM_MAC = 1;
    private static final int PLATFORM_WIN = 3;
    private static final int ENCODING_SYMBOL = 0;
    private static final int ENCODING_UNICODE_BMP = 1;
    private static final int ENCODING_PRC = 3;
    private boolean remapToGlyphValue;
    private boolean remapFromWINEncoding;
    protected int[] CMAPformats;
    protected int[] CMAPlength;
    protected int[] CMAPlang;
    protected int[] CMAPsegCount;
    protected int[] CMAPsearchRange;
    protected int[] CMAPentrySelector;
    protected int[] CMAPrangeShift;
    protected int[] CMAPreserved;
    private Map<Integer, Integer> glyfValues;
    protected int[] platformID;
    private static final Map<String, Integer> exceptions = new HashMap<String, Integer>();
    private int subtableToUse;
    protected int id;
    protected int subtableCount;
    protected int[] CMAPsubtables;
    protected int[] encodingID;
    private Format[] table;
    private int platform;

    public CMAP(FontFile2 currentFontFile, int startPointer) {
        if (startPointer == 0) {
            LogWriter.writeLog("No CMAP table found");
        } else {
            this.id = currentFontFile.getNextUint16();
            this.subtableCount = currentFontFile.getNextUint16();
            this.CMAPsubtables = new int[this.subtableCount];
            this.platformID = new int[this.subtableCount];
            this.encodingID = new int[this.subtableCount];
            this.CMAPformats = new int[this.subtableCount];
            this.CMAPsearchRange = new int[this.subtableCount];
            this.CMAPentrySelector = new int[this.subtableCount];
            this.CMAPrangeShift = new int[this.subtableCount];
            this.CMAPreserved = new int[this.subtableCount];
            this.CMAPsegCount = new int[this.subtableCount];
            this.CMAPlength = new int[this.subtableCount];
            this.CMAPlang = new int[this.subtableCount];
            this.table = new Format[this.subtableCount];
            for (int i2 = 0; i2 < this.subtableCount; ++i2) {
                this.platformID[i2] = currentFontFile.getNextUint16();
                this.encodingID[i2] = currentFontFile.getNextUint16();
                this.CMAPsubtables[i2] = currentFontFile.getNextUint32();
            }
            for (int j2 = 0; j2 < this.subtableCount; ++j2) {
                currentFontFile.selectTable(2);
                currentFontFile.skip(this.CMAPsubtables[j2]);
                this.CMAPformats[j2] = currentFontFile.getNextUint16();
                this.table[j2] = this.readTable(currentFontFile, j2);
            }
        }
    }

    private Format readTable(FontFile2 currentFontFile, int j2) {
        boolean valid = false;
        Format table = this.getTableForFormat(this.CMAPformats[j2]);
        if (table != null) {
            valid = table.readTable(currentFontFile, j2, this.CMAPlength, this.CMAPlang);
        }
        if (!valid) {
            this.CMAPformats[j2] = -1;
        }
        return table;
    }

    private Format getTableForFormat(int cmapFormat) {
        switch (cmapFormat) {
            case 0: {
                return new Format0();
            }
            case 2: {
                return new Format2();
            }
            case 4: {
                return new Format4(this.CMAPsegCount, this.CMAPsearchRange, this.CMAPentrySelector, this.CMAPrangeShift, this.CMAPreserved);
            }
            case 6: {
                return new Format6();
            }
            case 12: {
                return new Format12();
            }
        }
        return null;
    }

    protected CMAP() {
    }

    int convertIndexToCharacterCode(String glyph, int index) {
        if (this.remapFromWINEncoding) {
            index = StandardFonts.lookupCharacterIndex(glyph, 0);
        } else if (this.remapToGlyphValue && glyph != null && !"notdef".equals(glyph)) {
            index = StandardFonts.getAdobeMap(glyph);
        }
        if (this.table[this.subtableToUse] != null) {
            return this.table[this.subtableToUse].getValue(index);
        }
        return -1;
    }

    public void setEncodingToUse(int fontEncoding, boolean hasCFF) {
        int i2;
        this.subtableToUse = -1;
        int count = this.platformID.length;
        block0: for (int format : formats) {
            if (this.subtableToUse != -1) break;
            for (i2 = 0; i2 < count; ++i2) {
                if (this.CMAPformats[i2] != format || this.platformID[i2] != 3 || fontEncoding != 2 || this.encodingID[i2] != 1) continue;
                this.subtableToUse = i2;
                continue block0;
            }
        }
        if (this.subtableToUse == -1) {
            block2: for (int format : formats) {
                if (this.subtableToUse != -1) break;
                for (i2 = 0; i2 < count; ++i2) {
                    if (this.CMAPformats[i2] != format) continue;
                    this.subtableToUse = i2;
                    continue block2;
                }
            }
        }
        this.checkForRemapping(fontEncoding, hasCFF);
    }

    private void checkForRemapping(int fontEncoding, boolean hasCFF) {
        int encoding = this.encodingID[this.subtableToUse];
        int platform = this.platformID[this.subtableToUse];
        if (platform == 1 && fontEncoding == 2) {
            this.remapFromWINEncoding = true;
        } else if ((encoding == 3 || encoding == 1) && fontEncoding != 6) {
            this.remapToGlyphValue = true;
        } else if (platform == 0 && fontEncoding == 2) {
            this.remapToGlyphValue = true;
        }
        if (this.remapToGlyphValue && hasCFF) {
            this.remapToGlyphValue = false;
        }
    }

    public boolean containsKey(Integer key) {
        if (this.glyfValues == null) {
            this.glyfValues = this.buildCharStringTable();
        }
        return this.glyfValues.containsKey(key);
    }

    public Map<Integer, Integer> buildCharStringTable() {
        return this.table[this.subtableToUse].setGlyphValues();
    }

    static {
        String[] keys = new String[]{"notequal", "infinity", "lessequal", "greaterequal", "partialdiff", "summation", "product", "pi", "integral", "Omega", "radical", "approxequal", "Delta", "lozenge", "Euro", "apple"};
        int[] values = new int[]{173, 176, 178, 179, 182, 183, 184, 185, 186, 189, 195, 197, 198, 215, 219, 240};
        for (int i2 = 0; i2 < values.length; ++i2) {
            exceptions.put(keys[i2], values[i2]);
        }
        StandardFonts.checkLoaded(2);
    }
}

