/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.glyph.objects;

import org.jpedal.fonts.objects.FontData;

public final class T1GlyphNumber {
    private static final String nybChars = "0123456789.ee -";

    private T1GlyphNumber() {
    }

    public static int getNumber(byte[] fontDataAsArray, int pos, double[] values, int valuePointer, boolean is1C) {
        double x2 = 0.0;
        int b0 = fontDataAsArray[pos] & 0xFF;
        if (b0 < 28 || b0 == 31) {
            System.err.println("!!!!Incorrect type1C operand");
        } else if (b0 == 28) {
            x2 = (fontDataAsArray[pos + 1] << 8) + (fontDataAsArray[pos + 2] & 0xFF);
            pos += 3;
        } else if (b0 == 255) {
            x2 = T1GlyphNumber.handle2Byte(fontDataAsArray, pos, is1C);
            pos += 5;
        } else if (b0 == 29) {
            x2 = ((fontDataAsArray[pos + 1] & 0xFF) << 24) + ((fontDataAsArray[pos + 2] & 0xFF) << 16) + ((fontDataAsArray[pos + 3] & 0xFF) << 8) + (fontDataAsArray[pos + 4] & 0xFF);
            pos += 5;
        } else if (b0 == 30) {
            String bufStr;
            ++pos;
            int i2 = 0;
            char[] buf = new char[65];
            while (i2 < 64) {
                int b2 = fontDataAsArray[pos++] & 0xFF;
                int nyb0 = b2 >> 4 & 0xF;
                int nyb1 = b2 & 0xF;
                if (nyb0 == 15) break;
                buf[i2++] = nybChars.charAt(nyb0);
                if (i2 == 64) break;
                if (nyb0 == 12) {
                    buf[i2++] = 45;
                }
                if (i2 == 64 || nyb1 == 15) break;
                buf[i2++] = nybChars.charAt(nyb1);
                if (i2 == 64) break;
                if (nyb1 != 12) continue;
                buf[i2++] = 45;
            }
            if ((bufStr = new String(buf, 0, i2)).isEmpty()) {
                values[valuePointer] = 0.0;
                return pos;
            }
            if (bufStr.toLowerCase().startsWith("e")) {
                bufStr = '1' + bufStr;
            }
            x2 = Double.parseDouble(bufStr);
        } else if (b0 < 247) {
            x2 = b0 - 139;
            ++pos;
        } else if (b0 < 251) {
            x2 = (b0 - 247 << 8) + (fontDataAsArray[pos + 1] & 0xFF) + 108;
            pos += 2;
        } else {
            x2 = -(b0 - 251 << 8) - (fontDataAsArray[pos + 1] & 0xFF) - 108;
            pos += 2;
        }
        values[valuePointer] = x2;
        return pos;
    }

    private static double handle2Byte(byte[] fontDataAsArray, int pos, boolean is1C) {
        double x2;
        if (is1C) {
            x2 = ((fontDataAsArray[pos + 1] & 0xFF) << 8) + (fontDataAsArray[pos + 2] & 0xFF);
            x2 += (double)(((fontDataAsArray[pos + 3] & 0xFF) << 8) + (fontDataAsArray[pos + 4] & 0xFF)) / 65536.0;
            if (fontDataAsArray[pos + 1] < 0) {
                x2 -= 65536.0;
            }
        } else {
            x2 = ((fontDataAsArray[pos + 1] & 0xFF) << 24) + ((fontDataAsArray[pos + 2] & 0xFF) << 16) + ((fontDataAsArray[pos + 3] & 0xFF) << 8) + (fontDataAsArray[pos + 4] & 0xFF);
        }
        return x2;
    }

    public static int getNumber(FontData fontDataAsObject, int pos, double[] values, int valuePointer, boolean is1C) {
        double x2 = 0.0;
        int b0 = fontDataAsObject.getByte(pos) & 0xFF;
        if (b0 < 28 || b0 == 31) {
            System.err.println("!!!!Incorrect type1C operand");
        } else if (b0 == 28) {
            x2 = (fontDataAsObject.getByte(pos + 1) << 8) + (fontDataAsObject.getByte(pos + 2) & 0xFF);
            pos += 3;
        } else if (b0 == 255) {
            if (is1C) {
                int top = ((fontDataAsObject.getByte(pos + 1) & 0xFF) << 8) + (fontDataAsObject.getByte(pos + 2) & 0xFF);
                if (top > 32768) {
                    top = 65536 - top;
                }
                double numb = top;
                double dec = ((fontDataAsObject.getByte(pos + 3) & 0xFF) << 8) + (fontDataAsObject.getByte(pos + 4) & 0xFF);
                x2 = numb + dec / 65536.0;
                if (fontDataAsObject.getByte(pos + 1) < 0) {
                    x2 = -x2;
                }
            } else {
                x2 = ((fontDataAsObject.getByte(pos + 1) & 0xFF) << 24) + ((fontDataAsObject.getByte(pos + 2) & 0xFF) << 16) + ((fontDataAsObject.getByte(pos + 3) & 0xFF) << 8) + (fontDataAsObject.getByte(pos + 4) & 0xFF);
            }
            pos += 5;
        } else if (b0 == 29) {
            x2 = ((fontDataAsObject.getByte(pos + 1) & 0xFF) << 24) + ((fontDataAsObject.getByte(pos + 2) & 0xFF) << 16) + ((fontDataAsObject.getByte(pos + 3) & 0xFF) << 8) + (fontDataAsObject.getByte(pos + 4) & 0xFF);
            pos += 5;
        } else if (b0 == 30) {
            char[] buf = new char[65];
            ++pos;
            int i2 = 0;
            while (i2 < 64) {
                int b2 = fontDataAsObject.getByte(pos++) & 0xFF;
                int nyb0 = b2 >> 4 & 0xF;
                int nyb1 = b2 & 0xF;
                if (nyb0 == 15) break;
                buf[i2++] = nybChars.charAt(nyb0);
                if (i2 == 64) break;
                if (nyb0 == 12) {
                    buf[i2++] = 45;
                }
                if (i2 == 64 || nyb1 == 15) break;
                buf[i2++] = nybChars.charAt(nyb1);
                if (i2 == 64) break;
                if (nyb1 != 12) continue;
                buf[i2++] = 45;
            }
            x2 = Double.parseDouble(new String(buf, 0, i2));
        } else if (b0 < 247) {
            x2 = b0 - 139;
            ++pos;
        } else if (b0 < 251) {
            x2 = (b0 - 247 << 8) + (fontDataAsObject.getByte(pos + 1) & 0xFF) + 108;
            pos += 2;
        } else {
            x2 = -(b0 - 251 << 8) - (fontDataAsObject.getByte(pos + 1) & 0xFF) - 108;
            pos += 2;
        }
        values[valuePointer] = x2;
        return pos;
    }
}

