/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.glyph;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.io.IOException;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.color.PdfPaint;
import org.jpedal.color.PdfTexturePaint;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.io.PathSerializer;
import org.jpedal.utils.repositories.Vector_Path;

public class T1Glyph
extends PdfGlyph {
    private transient Vector_Path cached_current_path;
    private Paint strokePaint;
    private float glyfwidth = 1000.0f;
    private boolean isStroked;
    private final Map<String, String> strokedPositions = new HashMap<String, String>();
    private Area glyphShape;
    private final Double glyphScaling;

    public T1Glyph(Vector_Path cached_current_path, Double glyphScaling) {
        this.cached_current_path = cached_current_path;
        this.glyphScaling = glyphScaling;
    }

    @Override
    public void setStrokedOnly(boolean flag) {
        this.isStroked = flag;
    }

    @Override
    public void setWidth(float width) {
        this.glyfwidth = width;
    }

    @Override
    public float getmaxWidth() {
        return this.glyfwidth;
    }

    @Override
    public void render(int text_fill_type, Graphics2D g2, float scaling, boolean isFormGlyph) {
        Area glyphShape = this.getShape();
        if (glyphShape == null) {
            return;
        }
        if (this.glyphScaling != null) {
            g2.scale(this.glyphScaling, this.glyphScaling);
        }
        if (text_fill_type == 2) {
            Paint fillPaint;
            if (this.isStroked && !((fillPaint = g2.getPaint()) instanceof PdfTexturePaint) && ((PdfPaint)this.strokePaint).getRGB() != ((PdfPaint)fillPaint).getRGB() && this.strokedPositions.containsKey(String.valueOf((int)g2.getTransform().getTranslateX()) + '-' + (int)g2.getTransform().getTranslateY())) {
                g2.setPaint(this.strokePaint);
                g2.draw(glyphShape);
                g2.setPaint(fillPaint);
            }
            g2.fill(glyphShape);
        }
        if (text_fill_type == 1) {
            g2.draw(glyphShape);
            this.strokePaint = g2.getPaint();
            this.strokedPositions.put(String.valueOf((int)g2.getTransform().getTranslateX()) + '-' + (int)g2.getTransform().getTranslateY(), "x");
        }
    }

    @Override
    public Area getShape() {
        if (this.cached_current_path != null && this.glyphShape == null) {
            GeneralPath[] oldPaths = this.cached_current_path.get();
            GeneralPath[] paths = new GeneralPath[oldPaths.length];
            for (int i2 = 0; i2 < paths.length; ++i2) {
                if (oldPaths[i2] == null) continue;
                paths[i2] = (GeneralPath)oldPaths[i2].clone();
            }
            int cacheCount = paths.length;
            for (int i3 = 1; i3 < cacheCount && paths[i3] != null; ++i3) {
                paths[0].append(paths[i3], false);
            }
            if (paths[0] != null) {
                this.glyphShape = new Area(paths[0]);
            }
        }
        return this.glyphShape;
    }

    public void setPaths(Vector_Path vp) {
        this.cached_current_path = vp;
    }

    public void writePathsToStream(ObjectOutput os) throws IOException {
        if (this.cached_current_path != null) {
            int i2;
            GeneralPath[] paths = this.cached_current_path.get();
            int count = 0;
            for (i2 = 0; i2 < paths.length; ++i2) {
                if (paths[i2] != null) continue;
                count = i2;
                break;
            }
            os.writeObject(count);
            for (i2 = 0; i2 < count; ++i2) {
                PathIterator pathIterator = paths[i2].getPathIterator(new AffineTransform());
                PathSerializer.serializePath(os, pathIterator);
            }
        }
    }

    public void flushArea() {
        this.glyphShape = null;
    }
}

