/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.glyph;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jpedal.fonts.FontMappings;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.fonts.glyph.PdfGlyphs;
import org.jpedal.fonts.glyph.T1GlyphFactory;
import org.jpedal.fonts.objects.FontData;
import org.jpedal.fonts.tt.Table;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.StringUtils;

public class PdfJavaGlyphs
implements PdfGlyphs,
Serializable {
    protected boolean hasCIDToGID;
    final T1GlyphFactory factory = new T1GlyphFactory();
    private Area[] cachedShapes;
    private AffineTransform[] cachedAt;
    public int[] CMAP_Translate;
    protected int glyphCount;
    public boolean isFontInstalled;
    public String defaultFont = "SansSerif";
    public String fontName = "default";
    public String logicalfontName = "default";
    private Map<Integer, String> chars = new HashMap<Integer, String>();
    private Map<Integer, String> displayValues = new HashMap<Integer, String>();
    private Map<Integer, String> embeddedChars = new HashMap<Integer, String>();
    private boolean isIdentity;
    private boolean isFontEmbedded;
    private boolean hasWidths = true;
    private int objID;
    public String baseFontName = "";
    public boolean isSubsetted;
    public float[][] lastTrm = new float[3][3];
    private Font unscaledFont;
    public boolean isArialInstalledLocally;
    private int maxCharCount = 255;
    public boolean isCIDFont;
    public String font_family_name;
    public int style;
    private int size;
    private String weight;
    private String testFont;
    public static final FontRenderContext frc = new FontRenderContext(null, true, true);
    private static String[] fontList;
    private PdfGlyph[] cachedEmbeddedShapes;
    int[] localBias = new int[1];
    int globalBias;

    public void flush() {
        this.cachedShapes = null;
        this.cachedAt = null;
    }

    @Override
    public String getBaseFontName() {
        return this.baseFontName;
    }

    public void setBaseFontName(String baseFontName) {
        this.baseFontName = baseFontName;
    }

    @Override
    public Area getStandardGlyph(float[][] Trm, int rawInt, String displayValue, float currentWidth, boolean isSTD) {
        Area transformedGlyph2 = this.getCachedShape(rawInt);
        if (transformedGlyph2 == null) {
            AffineTransform at2;
            double dY = -1.0;
            double dX = 1.0;
            double y2 = 0.0;
            if (isSTD) {
                transformedGlyph2 = this.getGlyph(displayValue, currentWidth);
                if (transformedGlyph2 != null && rawInt == 146 && this.isArialInstalledLocally) {
                    y2 = -(transformedGlyph2.getBounds().height - transformedGlyph2.getBounds().y);
                }
            } else {
                GlyphVector gv1 = null;
                if (!this.isCIDFont || this.isFontInstalled) {
                    gv1 = this.getUnscaledFont().createGlyphVector(frc, displayValue);
                }
                if (gv1 != null) {
                    double glyphWidth;
                    double scaleFactor;
                    transformedGlyph2 = new Area(gv1.getOutline());
                    double glyphX = gv1.getOutline().getBounds2D().getX();
                    if (glyphX < 0.0) {
                        glyphX = -glyphX;
                        at2 = AffineTransform.getTranslateInstance(glyphX * 2.0, 0.0);
                        transformedGlyph2.transform(at2);
                    }
                    if ((scaleFactor = (double)currentWidth / (glyphWidth = gv1.getVisualBounds().getWidth() + glyphX * 2.0)) < 1.0) {
                        dX *= scaleFactor;
                    }
                }
            }
            at2 = new AffineTransform(dX * (double)Trm[0][0], dX * (double)Trm[0][1], -1.0 * (double)Trm[1][0], -1.0 * (double)Trm[1][1], 0.0, y2);
            if (transformedGlyph2 != null) {
                transformedGlyph2.transform(at2);
            }
            this.setCachedShape(rawInt, transformedGlyph2, at2);
        }
        return transformedGlyph2;
    }

    public Area getGlyph(String displayValue, float currentWidth) {
        boolean fontMatched = true;
        GlyphVector gv1 = null;
        if (!this.getUnscaledFont().canDisplay(displayValue.charAt(0))) {
            fontMatched = false;
        }
        if (!(this.isCIDFont && this.isFontEmbedded && fontMatched)) {
            if (fontMatched) {
                gv1 = this.getUnscaledFont().createGlyphVector(frc, displayValue);
            } else {
                Font tempFont = new Font(this.defaultFont, 0, 1);
                if (!tempFont.canDisplay(displayValue.charAt(0))) {
                    tempFont = new Font("SansSerif", 0, 1);
                }
                if (tempFont.canDisplay(displayValue.charAt(0))) {
                    gv1 = tempFont.createGlyphVector(frc, displayValue);
                }
            }
        }
        Area transformedGlyph2 = null;
        if (gv1 != null) {
            transformedGlyph2 = new Area(gv1.getOutline());
            double glyphX = gv1.getOutline().getBounds2D().getX();
            double width = gv1.getOutline().getBounds2D().getWidth();
            if (!this.hasWidths) {
                float leading = (float)((double)currentWidth - (width + glyphX + glyphX)) / 2.0f;
                if (leading > 0.0f) {
                    AffineTransform at2 = AffineTransform.getTranslateInstance(leading, 0.0);
                    transformedGlyph2.transform(at2);
                }
            } else {
                double scaleFactor;
                AffineTransform at3;
                if (glyphX < 0.0) {
                    glyphX = -glyphX;
                    at3 = AffineTransform.getTranslateInstance(glyphX, 0.0);
                    transformedGlyph2.transform(at3);
                }
                if ((scaleFactor = (double)currentWidth / transformedGlyph2.getBounds2D().getWidth()) < 1.0) {
                    at3 = AffineTransform.getScaleInstance(scaleFactor, 1.0);
                    transformedGlyph2.transform(at3);
                }
            }
        }
        return transformedGlyph2;
    }

    public final void setCachedShape(int idx, Area shape, AffineTransform at2) {
        Area[] cache = this.cachedShapes;
        AffineTransform[] atCache = this.cachedAt;
        if (cache == null) {
            this.cachedShapes = cache = new Area[this.maxCharCount];
            this.cachedAt = atCache = new AffineTransform[this.maxCharCount];
        }
        cache[idx] = shape;
        if (shape != null && at2 != null) {
            atCache[idx] = at2;
        }
    }

    public final AffineTransform getCachedTransform(int idx) {
        AffineTransform[] cache = this.cachedAt;
        if (cache == null) {
            return null;
        }
        return cache[idx];
    }

    public final Area getCachedShape(int idx) {
        Area[] cache = this.cachedShapes;
        if (cache == null) {
            return null;
        }
        return cache[idx];
    }

    public void init(int maxCharCount, boolean isCIDFont) {
        this.maxCharCount = maxCharCount;
        this.isCIDFont = isCIDFont;
    }

    public final void setFont(String name, int size) {
        int pointer;
        Font f2;
        this.size = size;
        if (DecoderOptions.Helper != null && (f2 = DecoderOptions.Helper.setFont(this, StringUtils.convertHexChars(name), size)) != null) {
            this.style = f2.getStyle();
            this.font_family_name = f2.getFamily();
            this.unscaledFont = f2;
            return;
        }
        this.font_family_name = name = StandardFonts.expandName(name);
        this.style = 0;
        String mappedName = null;
        if (this.font_family_name == null) {
            this.font_family_name = this.fontName;
        }
        this.testFont = this.font_family_name;
        if (this.font_family_name != null) {
            this.testFont = this.font_family_name.toLowerCase();
            pointer = this.font_family_name.indexOf(44);
            if (pointer == -1) {
                pointer = this.font_family_name.indexOf(45);
            }
            if (pointer != -1) {
                mappedName = FontMappings.fontSubstitutionAliasTable.get(this.testFont);
                this.weight = this.testFont.substring(pointer + 1);
                this.style = PdfJavaGlyphs.getWeight(this.weight);
                this.testFont = this.font_family_name = this.font_family_name.substring(0, pointer).toLowerCase();
                if (this.testFont.endsWith("mt")) {
                    this.testFont = this.testFont.substring(0, this.testFont.length() - 2);
                }
            }
        }
        if (mappedName == null) {
            mappedName = FontMappings.fontSubstitutionAliasTable.get(this.testFont);
        }
        if ("arialbd".equals(mappedName)) {
            mappedName = "arial-bold";
        }
        if (mappedName != null) {
            this.font_family_name = mappedName;
            pointer = this.font_family_name.indexOf(45);
            if (pointer != -1) {
                this.font_family_name = this.font_family_name.toLowerCase();
                this.weight = this.font_family_name.substring(pointer + 1);
                this.style = PdfJavaGlyphs.getWeight(this.weight);
                this.font_family_name = this.font_family_name.substring(0, pointer);
            }
            this.testFont = this.font_family_name.toLowerCase();
            if (this.testFont.endsWith("mt")) {
                this.testFont = this.testFont.substring(0, this.testFont.length() - 2);
            }
        }
    }

    public boolean hasEnoughTablesToConvert() {
        return true;
    }

    public double[] getFontMatrix() {
        return new double[]{0.001, 0.0, 0.0, 0.001, 0.0, 0.0};
    }

    private static int getWeight(String weight) {
        int style = 0;
        if (weight.endsWith("mt")) {
            weight = weight.substring(0, weight.length() - 2);
        }
        if (weight.contains("heavy") || weight.contains("bold")) {
            style = 1;
        }
        if (weight.contains("italic") || weight.contains("oblique")) {
            style += 2;
        }
        return style;
    }

    public final Font getUnscaledFont() {
        if (this.unscaledFont == null && this.font_family_name != null) {
            if (fontList == null) {
                fontList = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
                for (int i2 = 0; i2 < fontList.length; ++i2) {
                    PdfJavaGlyphs.fontList[i2] = fontList[i2].toLowerCase();
                }
            }
            boolean isFound = false;
            for (String s2 : fontList) {
                if (!s2.equals(this.testFont) && (this.weight != null || !this.testFont.startsWith(s2))) continue;
                this.isFontInstalled = true;
                this.font_family_name = s2;
                isFound = true;
                break;
            }
            if (!isFound) {
                for (String s2 : fontList) {
                    if (!s2.equals(this.testFont) && (this.weight != null || !this.testFont.startsWith(s2))) continue;
                    this.isFontInstalled = true;
                    this.font_family_name = s2;
                    break;
                }
            }
            if (this.isFontInstalled && "arial".equals(this.font_family_name)) {
                this.isArialInstalledLocally = true;
            }
            if (!this.isFontInstalled) {
                if (this.weight == null) {
                    String test = this.font_family_name.toLowerCase();
                    this.style = PdfJavaGlyphs.getWeight(test);
                }
                this.font_family_name = this.defaultFont;
            }
            this.unscaledFont = new Font(this.font_family_name, this.style, this.size);
        }
        if (this.unscaledFont == null) {
            this.unscaledFont = new Font(this.defaultFont, 0, 1);
        }
        return this.unscaledFont;
    }

    protected final void setEmbeddedCachedShape(int idx, PdfGlyph shape) {
        PdfGlyph[] cache = this.cachedEmbeddedShapes;
        if (cache == null) {
            this.cachedEmbeddedShapes = cache = new PdfGlyph[this.maxCharCount];
        }
        if (idx < cache.length) {
            cache[idx] = shape;
        }
    }

    protected final PdfGlyph getEmbeddedCachedShape(int idx) {
        PdfGlyph[] cache = this.cachedEmbeddedShapes;
        if (cache == null) {
            return null;
        }
        if (idx < cache.length) {
            return cache[idx];
        }
        return null;
    }

    @Override
    public PdfGlyph getEmbeddedGlyph(String glyph, float[][] trm, int rawInt, String displayValue, float currentWidth, String key) {
        return null;
    }

    public void setCIDtoGID(int[] cidToGIDMap) {
    }

    public void setEncodingToUse(int fontEncoding) {
    }

    public int readEmbeddedFont(boolean TTstreamisCID, byte[] fontDataAsArray, FontData fontData) {
        throw new RuntimeException("readEmbeddedFont in PdfJavaGlyphs should not be called");
    }

    public void setIsSubsetted(boolean b2) {
        this.isSubsetted = b2;
    }

    public void setT3Glyph(Set<Integer> keys, PdfGlyph glyph) {
    }

    public void setCharString(String s2, byte[] bytes, int glyphNo, Double glyphScaling) {
    }

    public boolean is1C() {
        return false;
    }

    public void setIs1C(boolean b2) {
    }

    public void setValuesForGlyph(int rawInt, String charGlyph, String displayValue, String embeddedChar) {
        Integer key = rawInt;
        this.chars.put(key, charGlyph);
        this.displayValues.put(key, displayValue);
        this.embeddedChars.put(key, embeddedChar);
    }

    @Override
    public String getDisplayValue(Integer key) {
        return this.displayValues.get(key);
    }

    @Override
    public String getCharGlyph(Integer key) {
        return this.chars.get(key);
    }

    @Override
    public String getEmbeddedEnc(Integer key) {
        return this.embeddedChars.get(key);
    }

    public Map<Integer, String> getDisplayValues() {
        return Collections.unmodifiableMap(this.displayValues);
    }

    public Map<Integer, String> getCharGlyphs() {
        return Collections.unmodifiableMap(this.chars);
    }

    public Map<Integer, String> getEmbeddedEncs() {
        return Collections.unmodifiableMap(this.embeddedChars);
    }

    public void setDisplayValues(Map<Integer, String> displayValues) {
        this.displayValues = displayValues;
    }

    public void setCharGlyphs(Map<Integer, String> chars) {
        this.chars = chars;
    }

    public void setEmbeddedEncs(Map<Integer, String> embeddedChars) {
        this.embeddedChars = embeddedChars;
    }

    public void setLocalBias(int currentFD, int i2) {
        if (currentFD >= this.localBias.length) {
            int[] newBias = new int[currentFD + 1];
            System.arraycopy(this.localBias, 0, newBias, 0, this.localBias.length);
            this.localBias = newBias;
        }
        this.localBias[currentFD] = i2;
    }

    public void setGlobalBias(int i2) {
        this.globalBias = i2;
    }

    public float getTTWidth(String charGlyph, int rawInt, boolean b2) {
        throw new RuntimeException("getTTWidth should not be called");
    }

    public int getConvertedGlyph(int rawInt) {
        return -1;
    }

    public void setIsIdentity(boolean isIdentity) {
        this.isIdentity = isIdentity;
    }

    public boolean isIdentity() {
        return this.isIdentity;
    }

    public void setFontEmbedded(boolean isSet) {
        this.isFontEmbedded = isSet;
    }

    public int getType() {
        return 0;
    }

    public void setHasWidths(boolean hasWidths) {
        this.hasWidths = hasWidths;
    }

    public int getCMAPValue(int rawInt) {
        if (this.CMAP_Translate == null) {
            return -1;
        }
        return this.CMAP_Translate[rawInt];
    }

    public void setNameForGlyphIndex(int jj, String glyphName) {
    }

    public String getNameForGlyphIndex(int jj) {
        return null;
    }

    public Map<String, byte[]> getCharStringData() {
        return null;
    }

    public void setGlyphCount(int nGlyphs) {
        this.glyphCount = nGlyphs;
    }

    public int getGlyphCount() {
        return this.glyphCount;
    }

    public void setRenderer(DynamicVectorRenderer current) {
    }

    public Table getTable(int id2) {
        return null;
    }

    public boolean hasCIDtoGID() {
        return this.hasCIDToGID;
    }

    public void setObjID(int objID) {
        this.objID = objID;
    }

    public int getObjID() {
        return this.objID;
    }

    public boolean containsKey(String valueOf) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

