/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts;

import java.util.Set;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.glyph.T3Glyph;
import org.jpedal.fonts.glyph.T3Glyphs;
import org.jpedal.fonts.glyph.T3Size;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectFactory;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.raw.FontObject;
import org.jpedal.objects.raw.PdfKeyPairsIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.T3StreamDecoder;
import org.jpedal.render.T3Display;
import org.jpedal.utils.LogWriter;

public class Type3
extends PdfFont {
    private final GraphicsState currentGraphicsState = new GraphicsState();
    private final ObjectStore objectStore;

    public Type3(PdfObjectReader current_pdf_file, ObjectStore objectStore) {
        this.glyphs = new T3Glyphs();
        this.objectStore = objectStore;
        this.init(current_pdf_file);
    }

    @Override
    public final void createFont(PdfObject pdfObject, String fontID, boolean renderPage) {
        this.fontTypes = 1228944679;
        this.init(fontID, renderPage);
        PdfObject pdfFontDescriptor = pdfObject.getDictionary(-1044665361);
        this.setBoundsAndMatrix(pdfObject);
        this.setName(pdfObject);
        this.setEncoding(pdfObject, pdfFontDescriptor);
        this.readWidths(pdfObject, false);
        this.readEmbeddedFont(pdfObject, this.objectStore);
        if (renderPage) {
            this.setFont(this.getBaseFontName(), 1);
        }
    }

    private void readEmbeddedFont(PdfObject pdfObject, ObjectStore objectStore) {
        PdfObject CharProcs = pdfObject.getDictionary(2054190454);
        if (CharProcs != null) {
            T3StreamDecoder glyphDecoder = new T3StreamDecoder(this.currentPdfFile);
            glyphDecoder.setParameters(false, true, 7, 0, false);
            glyphDecoder.setObjectValue(-8, objectStore);
            PdfObject Resources = pdfObject.getDictionary(2004251818);
            if (Resources != null) {
                glyphDecoder.readResources(Resources, false);
            }
            PdfKeyPairsIterator keyPairs = CharProcs.getKeyPairsIterator();
            while (keyPairs.hasMorePairs()) {
                String glyphKey = keyPairs.getNextKeyAsString();
                byte[] data = keyPairs.getNextValueAsBytes();
                if (data != null && this.renderPage && !".notdef".equals(glyphKey) && !".".equals(glyphKey)) {
                    this.decodeT3GlyphData(data, objectStore, glyphKey, glyphDecoder, pdfObject);
                }
                keyPairs.nextPair();
            }
            this.isFontEmbedded = true;
        }
    }

    private void decodeT3GlyphData(byte[] data, ObjectStore objectStore, String glyphKey, T3StreamDecoder glyphDecoder, PdfObject pdfObject) {
        PdfObject glyphObj = PdfObjectFactory.getPDFObjectObjectFromRefOrDirect(new FontObject("1 0 R"), this.currentPdfFile.getObjectReader(), data, 2054190454);
        T3Display glyphDisplay = new T3Display(0, false, 20, objectStore);
        glyphDisplay.setType3Glyph(glyphKey);
        try {
            glyphDecoder.setRenderer(glyphDisplay);
            glyphDecoder.setDefaultColors(this.currentGraphicsState.getNonstrokeColor(), this.currentGraphicsState.getNonstrokeColor());
            int factor = 1;
            double[] fontMatrix = pdfObject.getDoubleArray(-2105119560);
            if (fontMatrix != null && fontMatrix[0] == 1.0 && (fontMatrix[3] == 1.0 || fontMatrix[3] == -1.0)) {
                factor = 10;
            }
            GraphicsState gs = new GraphicsState(0, 0);
            gs.CTM = new float[][]{{factor, 0.0f, 0.0f}, {0.0f, factor, 0.0f}, {0.0f, 0.0f, 1.0f}};
            T3Size t3 = glyphDecoder.decodePageContent(glyphObj, gs);
            int renderX = t3.x;
            int renderY = t3.y;
            if (renderX == 0 && renderY != 0) {
                renderX = t3.y;
                renderY = t3.x;
            }
            T3Glyph glyph = new T3Glyph(glyphDisplay, renderX, renderY, glyphDecoder.ignoreColors);
            glyph.setScaling(1.0f / (float)factor);
            Set keys = (Set)this.rawDiffKeys.get(glyphKey);
            this.type3_d1_Max = Math.max(this.type3_d1_Max, t3.y);
            this.glyphs.setT3Glyph(keys, glyph);
        }
        catch (Exception e2) {
            LogWriter.writeLog("Exception " + e2 + " is Type3 font code");
        }
    }
}

