/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.StringTokenizer;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.io.types.StreamReaderUtils;
import org.jpedal.parser.text.CoreHexTextUtils;
import org.jpedal.utils.FastByteArrayOutputStream;
import org.jpedal.utils.LogWriter;

public class Type1
extends PdfFont {
    boolean isCID;
    boolean isCIDROS;
    private static final String rd = "rd";
    private static final String nd = "nd";
    private static final int c1 = 52845;
    private static final int c2 = 22719;
    private int skipBytes = 4;
    protected int[] blueValues;
    protected int[] otherBlues;
    protected int[] familyBlues;
    protected int[] familyOtherBlues;
    protected Double blueScale;
    protected Integer blueShift;
    protected Integer blueFuzz;
    protected Double stdHW;
    protected Double stdVW;
    protected int[] stemSnapH;
    protected int[] stemSnapV;
    protected Boolean forceBold;
    protected Integer languageGroup;
    boolean trackIndices;
    private static final char[] DEF_CHARS = "def".toCharArray();
    private static final char[] charstringsChars = "/CharStrings".toCharArray();
    private static final char[] subrsChars = "/Subrs".toCharArray();
    private static final char[] blueValuesChars = "/BlueValues".toCharArray();
    private static final char[] otherBluesChars = "/OtherBlues".toCharArray();
    private static final char[] familyBluesChars = "/FamilyBlues".toCharArray();
    private static final char[] familyOtherBluesChars = "/FamilyOtherBlues".toCharArray();
    private static final char[] blueScaleChars = "/BlueScale".toCharArray();
    private static final char[] blueShiftChars = "/BlueShift".toCharArray();
    private static final char[] blueFuzzChars = "/BlueFuzz".toCharArray();
    private static final char[] stdHWChars = "/StdHW".toCharArray();
    private static final char[] stdVWChars = "/StdVW".toCharArray();
    private static final char[] stemSnapHChars = "/StemSnapH".toCharArray();
    private static final char[] stemSnapVChars = "/StemSnapV".toCharArray();
    private static final char[] forceBoldChars = "/ForceBold".toCharArray();
    private static final char[] languageGroupChars = "/LanguageGroup".toCharArray();

    protected Type1() {
    }

    protected final void readType1FontFile(byte[] content) throws Exception {
        LogWriter.writeLog("Embedded Type1 font used " + this.getBaseFontName());
        this.readT1FontData(content);
        int glyphCount = 0;
        if (this.renderPage) {
            glyphCount = this.readEncodedContent(content);
        }
        this.glyphs.setGlyphCount(glyphCount);
        if (!this.renderPage || glyphCount > 0) {
            this.isFontEmbedded = true;
        }
        if (glyphCount > 0) {
            this.glyphs.setFontEmbedded(true);
        } else {
            this.isFontSubstituted = false;
        }
    }

    private void readT1FontData(byte[] content) throws Exception {
        try (BufferedReader br2 = new BufferedReader(new StringReader(new String(content)));){
            String line;
            while ((line = br2.readLine()) != null) {
                if (line.startsWith("/Encoding") && line.contains("array")) {
                    this.readDiffEncoding(br2);
                    continue;
                }
                if (line.startsWith("/lenIV")) {
                    StringTokenizer vals = new StringTokenizer(line);
                    vals.nextToken();
                    this.skipBytes = Integer.parseInt(vals.nextToken());
                    continue;
                }
                if (!line.contains("/FontMatrix")) continue;
                Type1.readFontMatrix(line, this.FontMatrix);
            }
        }
    }

    private static void readFontMatrix(String line, double[] fontMatrix) {
        String values = "";
        int startP = line.indexOf(91);
        if (startP != -1) {
            values = line.substring(startP + 1, line.indexOf(93));
        } else {
            startP = line.indexOf(123);
            if (startP != -1) {
                values = line.substring(startP + 1, line.indexOf(125));
            }
        }
        StringTokenizer matrixValues = new StringTokenizer(values);
        for (int i2 = 0; i2 < 6; ++i2) {
            fontMatrix[i2] = Double.parseDouble(matrixValues.nextToken());
        }
    }

    private void readDiffEncoding(BufferedReader br2) throws Exception {
        String line;
        int count = 0;
        while ((line = br2.readLine()) != null && !(line = line.trim()).startsWith("readonly") && !line.startsWith("def") && count != 256) {
            int code;
            if (!line.startsWith("dup") || !line.contains("/")) continue;
            ++count;
            StringTokenizer info = new StringTokenizer(line, " /");
            if (info.countTokens() < 3) continue;
            info.nextToken();
            String rawVal = info.nextToken();
            int ptr = rawVal.indexOf(35);
            if (ptr == -1) {
                code = Integer.parseInt(rawVal);
            } else {
                String base = rawVal.substring(0, ptr);
                String val = rawVal.substring(ptr + 1);
                code = Integer.parseInt(val, Integer.parseInt(base));
            }
            String name = info.nextToken();
            this.putChar(code, name);
            char c2 = name.charAt(0);
            if (c2 != 'B' && c2 != 'C' && c2 != 'c' && c2 != 'G') continue;
            int i2 = 1;
            int l2 = name.length();
            while (!this.isHex && i2 < l2) {
                this.isHex = Character.isLetter(name.charAt(i2++));
            }
        }
    }

    final void putChar(int charInt, String mappedChar) {
        if (this.diffs == null) {
            this.diffs = new String[this.maxCharCount];
        }
        this.diffs[charInt] = mappedChar;
        if (!this.hasEncoding && !this.isCIDROS && StandardFonts.getUnicodeName(mappedChar, this.getFontEncoding(true)) != null) {
            this.putMappedChar(charInt, mappedChar);
        }
    }

    private void setForceBold(byte[] cont, int l2, int forceBoldStart) {
        int forceBoldEnd = -1;
        for (int j2 = forceBoldStart; j2 < l2 && forceBoldEnd == -1; ++j2) {
            if (!Type1.checkForString(cont, j2, DEF_CHARS)) continue;
            forceBoldEnd = j2;
        }
        String val = new String(cont, forceBoldStart, forceBoldEnd - forceBoldStart);
        try {
            this.forceBold = Boolean.parseBoolean(val);
        }
        catch (NumberFormatException e2) {
            LogWriter.writeLog("Exception " + e2);
        }
    }

    private static int scanKeysForLenIV(byte[] cont, int skipBytes) throws IOException {
        try (BufferedReader br2 = new BufferedReader(new StringReader(new String(cont)));){
            String line;
            while ((line = br2.readLine()) != null) {
                if (!line.startsWith("/lenIV")) continue;
                StringTokenizer vals = new StringTokenizer(line);
                vals.nextToken();
                skipBytes = Integer.parseInt(vals.nextToken());
            }
        }
        return skipBytes;
    }

    private int readEncodedContent(byte[] cont) throws Exception {
        int size = cont.length;
        int charstringStart = Type1.findStart(cont, size);
        int end = Type1.findEnd(cont, size, charstringStart);
        cont = Type1.isAscii(cont, charstringStart) ? Type1.getAsciiBytes(cont, charstringStart, end) : Type1.getBinBytes(cont, charstringStart, end);
        this.skipBytes = Type1.scanKeysForLenIV(cont, this.skipBytes);
        return this.setDictValues(cont);
    }

    private int setDictValues(byte[] cont) {
        int glyphCount = 0;
        int l2 = cont.length;
        int charstringStart = -1;
        for (int p2 = 4; p2 < l2; ++p2) {
            if (charstringStart == -1 && p2 + 11 < l2 && Type1.checkForString(cont, p2, charstringsChars)) {
                charstringStart = p2 + 11;
                glyphCount = this.extractFontData(this.skipBytes, cont, charstringStart, l2);
                continue;
            }
            if (Type1.checkForString(cont, p2, subrsChars)) {
                this.extractSubroutineData(this.skipBytes, cont, p2 + 6, charstringStart, l2);
                continue;
            }
            if (Type1.checkForString(cont, p2, blueValuesChars)) {
                this.blueValues = Type1.readIntArray(cont, p2 + 11);
                continue;
            }
            if (Type1.checkForString(cont, p2, otherBluesChars)) {
                this.otherBlues = Type1.readIntArray(cont, p2 + 11);
                continue;
            }
            if (Type1.checkForString(cont, p2, familyBluesChars)) {
                this.familyBlues = Type1.readIntArray(cont, p2 + 12);
                continue;
            }
            if (Type1.checkForString(cont, p2, familyOtherBluesChars)) {
                this.familyOtherBlues = Type1.readIntArray(cont, p2 + 17);
                continue;
            }
            if (Type1.checkForString(cont, p2, blueScaleChars)) {
                this.blueScale = Type1.readReal(cont, p2 + 10);
                continue;
            }
            if (Type1.checkForString(cont, p2, blueShiftChars)) {
                this.blueShift = Type1.readInteger(cont, p2 + 10);
                continue;
            }
            if (Type1.checkForString(cont, p2, blueFuzzChars)) {
                this.blueFuzz = Type1.readInteger(cont, p2 + 9);
                continue;
            }
            if (Type1.checkForString(cont, p2, stdHWChars)) {
                this.stdHW = Type1.readReal(cont, p2 + 6);
                continue;
            }
            if (Type1.checkForString(cont, p2, stdVWChars)) {
                this.stdVW = Type1.readReal(cont, p2 + 6);
                continue;
            }
            if (Type1.checkForString(cont, p2, stemSnapHChars)) {
                this.stemSnapH = Type1.readIntArray(cont, p2 + 10);
                continue;
            }
            if (Type1.checkForString(cont, p2, stemSnapVChars)) {
                this.stemSnapV = Type1.readIntArray(cont, p2 + 10);
                continue;
            }
            if (Type1.checkForString(cont, p2, forceBoldChars)) {
                this.setForceBold(cont, l2, p2 + 10);
                continue;
            }
            if (!Type1.checkForString(cont, p2, languageGroupChars)) continue;
            this.languageGroup = Type1.readInteger(cont, p2 + 14);
        }
        return glyphCount;
    }

    private static byte[] getAsciiBytes(byte[] cont, int charstringStart, int end) {
        int r2 = 55665;
        int ptr = 0;
        byte[] bytes = new byte[end - charstringStart];
        for (int i2 = charstringStart; i2 < end; ++i2) {
            int charCount = CoreHexTextUtils.getHexCharCount(i2, cont, 2);
            i2 += charCount;
            int cipher = CoreHexTextUtils.getHexValue(--i2, charCount, cont);
            int plain = cipher ^ r2 >> 8;
            r2 = (cipher + r2) * 52845 + 22719 & 0xFFFF;
            bytes[ptr++] = (byte)plain;
        }
        return bytes;
    }

    private static byte[] getBinBytes(byte[] cont, int charstringStart, int end) {
        int r2 = 55665;
        int ptr = 0;
        byte[] bytes = new byte[end - charstringStart];
        for (int i2 = charstringStart; i2 < end; ++i2) {
            int cipher = cont[i2] & 0xFF;
            int plain = cipher ^ r2 >> 8;
            r2 = (cipher + r2) * 52845 + 22719 & 0xFFFF;
            bytes[ptr++] = (byte)plain;
        }
        return bytes;
    }

    private static boolean isAscii(byte[] cont, int charstringStart) {
        for (int i2 = charstringStart; i2 < charstringStart + 8; ++i2) {
            char c2 = (char)cont[i2];
            if (c2 >= '0' && c2 <= '9' || c2 >= 'A' && c2 <= 'F' || c2 >= 'a' && c2 <= 'f') continue;
            return false;
        }
        return true;
    }

    private static int findEnd(byte[] cont, int rawSize, int charstringStart) {
        if (charstringStart != -1) {
            int size = rawSize - 10;
            for (int i2 = charstringStart; i2 < size; ++i2) {
                if (cont[i2] != 99 || cont[i2 + 1] != 108 || cont[i2 + 2] != 101 || cont[i2 + 3] != 97 || cont[i2 + 4] != 114 || cont[i2 + 5] != 116 || cont[i2 + 6] != 111 || cont[i2 + 7] != 109 || cont[i2 + 8] != 97 || cont[i2 + 9] != 114 || cont[i2 + 10] != 107) continue;
                int end = i2 - 1;
                while (cont[end] == 10 || cont[end] == 13) {
                    --end;
                }
                return end;
            }
        }
        return rawSize;
    }

    private static int findStart(byte[] cont, int size) {
        int charstringStart = -1;
        for (int i2 = 4; i2 < size; ++i2) {
            if (cont[i2 - 3] != 101 || cont[i2 - 2] != 120 || cont[i2 - 1] != 101 || cont[i2] != 99) continue;
            charstringStart = i2 + 1;
            while (cont[charstringStart] == 10 || cont[charstringStart] == 13 || cont[charstringStart] == 32) {
                ++charstringStart;
            }
            break;
        }
        if (cont[charstringStart] == -128 && cont[charstringStart + 1] == 2) {
            charstringStart += 6;
        }
        return charstringStart;
    }

    private static Integer readInteger(byte[] data, int offset) {
        int l2 = data.length;
        int end = -1;
        for (int j2 = offset; j2 < l2 && end == -1; ++j2) {
            if (!Type1.checkForString(data, j2, DEF_CHARS)) continue;
            end = j2;
        }
        String val = new String(data, offset, end - offset);
        try {
            return Integer.parseInt(val.trim());
        }
        catch (NumberFormatException e2) {
            Double result = Type1.readReal(data, offset);
            if (result == null) {
                LogWriter.writeLog("Exception in handling Integer in Type1 " + e2);
                return null;
            }
            return (int)Math.round(result);
        }
    }

    private static Double readReal(byte[] data, int offset) {
        int l2 = data.length;
        int end = -1;
        for (int j2 = offset; j2 < l2 && end == -1; ++j2) {
            if (!Type1.checkForString(data, j2, DEF_CHARS) && data[j2] != 93 && data[j2] != 10) continue;
            end = j2;
        }
        String val = new String(data, offset, end - offset);
        if (val.contains("[")) {
            String[] stringParts = val.split("\\[");
            if (stringParts.length < 2) {
                return null;
            }
            val = stringParts[1];
        }
        try {
            return Double.parseDouble(val);
        }
        catch (NumberFormatException e2) {
            LogWriter.writeLog("Exception in handling real in Type1 " + e2);
            return null;
        }
    }

    private static int[] readIntArray(byte[] data, int start) {
        int j2;
        int[] result = null;
        int l2 = data.length;
        int end = -1;
        for (j2 = start; j2 < l2 && end == -1; ++j2) {
            if (data[j2] != 93 && data[j2] != 47 && data[j2] != 10) continue;
            end = j2;
        }
        if (end != -1) {
            String values = new String(data, start, end - start);
            if (values.contains("[")) {
                String[] stringParts = values.split("\\[");
                if (stringParts.length < 2) {
                    return null;
                }
                values = stringParts[1];
            }
            if ((values = values.trim()).isEmpty()) {
                return null;
            }
            String[] stringValues = values.split(" ");
            result = new int[stringValues.length];
            for (j2 = 0; j2 < stringValues.length; ++j2) {
                try {
                    result[j2] = Integer.parseInt(stringValues[j2].split("\\.")[0]);
                    continue;
                }
                catch (NumberFormatException e2) {
                    LogWriter.writeLog("Exception in handling IntArray " + e2);
                    result[j2] = -1;
                }
            }
        }
        return result;
    }

    private static boolean checkForString(byte[] data, int offset, char[] chars) {
        int length = chars.length;
        if (offset + length > data.length) {
            return false;
        }
        for (int i2 = 0; i2 < length; ++i2) {
            if (data[offset + i2] == chars[i2]) continue;
            return false;
        }
        return true;
    }

    private void extractSubroutineData(int skipBytes, byte[] cont, int start, int charStart, int l2) {
        char c2;
        start = StreamReaderUtils.skipSpaces(cont, start);
        StringBuilder tmp = new StringBuilder();
        while ((c2 = (char)cont[start]) != ' ') {
            tmp.append(c2);
            ++start;
        }
        int count = Integer.parseInt(tmp.toString());
        for (int i2 = 0; i2 < count; ++i2) {
            char c3;
            char c4;
            while (start < l2 && !((cont[start - 2] == 100 && cont[start - 1] == 117 && cont[start] == 112) | start == charStart)) {
                ++start;
            }
            if (start == charStart) {
                i2 = count;
                continue;
            }
            while (cont[start + 1] == 32) {
                ++start;
            }
            StringBuilder glyph = new StringBuilder("subrs");
            while ((c4 = (char)cont[++start]) != ' ') {
                glyph.append(c4);
            }
            tmp = new StringBuilder();
            boolean isANumber = true;
            while ((c3 = (char)cont[++start]) != ' ') {
                if (c3 >= '0' && c3 <= '9') {
                    tmp.append(c3);
                    continue;
                }
                isANumber = false;
                break;
            }
            if (!isANumber) {
                return;
            }
            int byteCount = Integer.parseInt(tmp.toString());
            while (cont[start] == 32) {
                ++start;
            }
            byte[] stream = Type1.getStream(skipBytes, start += rd.length() + 1, byteCount, cont);
            this.glyphs.setCharString(glyph.toString(), stream, i2, null);
            start += byteCount + nd.length();
        }
    }

    private int extractFontData(int skipBytes, byte[] cont, int start, int l2) {
        int total = cont.length;
        int glyphCount = 0;
        while (start < total && cont[start] != 47) {
            ++start;
        }
        int end = start;
        if (start < l2) {
            while (true) {
                if (cont[end] == 47) {
                    end += 2;
                    while (end < total && (cont[end - 1] != 124 || cont[end] != 45 && cont[end] != 48 || cont[end + 1] != 10 && cont[end + 1] != 13) && (cont[end - 1] != 78 || cont[end] != 68)) {
                        ++end;
                    }
                }
                if (total - end < 3 || cont[end - 1] != 47 && cont[end] == 101 && cont[end + 1] == 110 && cont[end + 2] == 100) break;
                ++end;
            }
        }
        while (start <= end) {
            char c2;
            char c3;
            StringBuilder glyph = new StringBuilder(20);
            while ((c3 = (char)cont[++start]) != ' ') {
                glyph.append(c3);
            }
            if (this.trackIndices) {
                this.glyphs.setNameForGlyphIndex(glyphCount, glyph.toString());
            }
            ++start;
            StringBuilder tmp = new StringBuilder();
            while ((c2 = (char)cont[start]) != ' ') {
                tmp.append(c2);
                ++start;
            }
            int byteCount = Integer.parseInt(tmp.toString());
            while (cont[start] == 32) {
                ++start;
            }
            byte[] stream = Type1.getStream(skipBytes, start += rd.length() + 1, byteCount, cont);
            this.glyphs.setCharString(glyph.toString(), stream, glyphCount, null);
            ++glyphCount;
            start += byteCount + nd.length();
            while (start <= end && cont[start] != 47) {
                ++start;
            }
        }
        return glyphCount;
    }

    private static byte[] getStream(int skipBytes, int start, int byteCount, byte[] cont) {
        FastByteArrayOutputStream bos = new FastByteArrayOutputStream();
        int r2 = 4330;
        for (int i2 = 0; i2 < byteCount; ++i2) {
            int cipher = cont[start + i2] & 0xFF;
            int plain = cipher ^ r2 >> 8;
            r2 = (cipher + r2) * 52845 + 22719 & 0xFFFF;
            if (i2 < skipBytes) continue;
            bos.write(plain);
        }
        return bos.toByteArray();
    }
}

