/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import org.jpedal.fonts.glyph.T1Glyphs;
import org.jpedal.fonts.objects.FontData;
import org.jpedal.fonts.tt.TTGlyphs;
import org.jpedal.utils.LogWriter;

public final class StandardFonts {
    private static Map<String, String> unicode_name_mapping_table = new ConcurrentHashMap<String, String>();
    private static String[][] unicode_char_decoding_table = new String[7][335];
    public static final int PDF = 6;
    public static final int ZAPF = 5;
    public static final int SYMBOL = 4;
    public static final int MACEXPERT = 3;
    public static final int WIN = 2;
    public static final int STD = 1;
    public static final int MAC = 0;
    public static final int TYPE0 = 1228944676;
    public static final int TYPE1 = 1228944677;
    public static final int TRUETYPE = 1217103210;
    public static final int TYPE3 = 1228944679;
    public static final int CIDTYPE0 = -1684566726;
    public static final int CIDTYPE2 = -1684566724;
    public static final int OPENTYPE = 1133081971;
    public static final int TRUETYPE_COLLECTION = 7;
    public static final int FONT_UNSUPPORTED = 8;
    private static final String ellipsis = String.valueOf((char)Integer.parseInt("2026", 16)).intern();
    private static final String enc = "Cp1252";
    private static Map<String, Integer>[] glyphToChar = new ConcurrentHashMap[7];
    private static String[] MAC_char_encoding_table;
    private static String[] WIN_char_encoding_table;
    private static String[] STD_char_encoding_table;
    private static String[] PDF_char_encoding_table;
    private static String[] ZAPF_char_encoding_table;
    private static String[] SYMBOL_char_encoding_table;
    private static String[] MACEXPERT_char_encoding_table;
    private static final Map<String, String> unicodeToName;
    private static Map<String, Integer> standardFileList;
    private static Map<Integer, String> standardFontLoaded;
    private static Map<String, Float> widthTableStandard;
    static Map<String, String> javaFontList;
    static String[] javaFonts;
    static String[] files_names;
    static String[] files_names_bis;
    private static ConcurrentHashMap<String, Integer> adobeMap;
    private static Map<String, float[]> fontBounds;
    private static final ConcurrentHashMap<String, ConcurrentHashMap<Integer, Integer>> mappedCharacters;
    private static final ConcurrentHashMap<String, Set<Integer>> takenChars;
    private static final int MAX_CHAR_CODE = 55296;
    public static String[] CMAP;

    private StandardFonts() {
    }

    public static void dispose() {
        unicode_name_mapping_table = null;
        unicode_char_decoding_table = null;
        glyphToChar = null;
        MAC_char_encoding_table = null;
        WIN_char_encoding_table = null;
        STD_char_encoding_table = null;
        PDF_char_encoding_table = null;
        ZAPF_char_encoding_table = null;
        SYMBOL_char_encoding_table = null;
        MACEXPERT_char_encoding_table = null;
        standardFileList = null;
        standardFontLoaded = null;
        widthTableStandard = null;
        javaFontList = null;
        javaFonts = null;
        files_names = null;
        files_names_bis = null;
        adobeMap = null;
        fontBounds = null;
    }

    public static int getFontType(String name) {
        int type = 8;
        if (name.endsWith(".ttf")) {
            type = 1217103210;
        } else if (name.endsWith(".otf")) {
            type = 1133081971;
        } else if (name.endsWith(".ttc")) {
            type = 7;
        } else if (name.endsWith(".pfb")) {
            type = 1228944677;
        }
        return type;
    }

    public static float[] getFontBounds(String fontName) {
        return fontBounds.get(fontName);
    }

    public static String getUnicodeName(String key, int enc) {
        String result = unicode_name_mapping_table.get(enc + key);
        if (result == null) {
            result = unicode_name_mapping_table.get(key);
        }
        if (result == null && key.startsWith("uni")) {
            result = String.valueOf((char)StandardFonts.getIDForGlyphName("", key));
        }
        return result;
    }

    public static String getUnicodeChar(int i2, int key) {
        return unicode_char_decoding_table[i2][key];
    }

    public static Float getStandardWidth(String font, String key) {
        String altfont;
        int p2;
        Float value = widthTableStandard.get((font = font.toLowerCase()) + key);
        if (value == null && (p2 = (altfont = font).indexOf(44)) != -1) {
            altfont = altfont.substring(0, p2);
            value = widthTableStandard.get(altfont + key);
        }
        return value;
    }

    private static void readStandardMappingTable(int key, String file_name) {
        BufferedReader input_stream = null;
        StandardFonts.glyphToChar[key] = new ConcurrentHashMap<String, Integer>();
        try {
            String line;
            BufferedReader bufferedReader = input_stream = "symbol.cfg".equals(file_name) ? new BufferedReader(new InputStreamReader(StandardFonts.class.getResourceAsStream("/org/jpedal/res/pdf/" + file_name), enc)) : new BufferedReader(new InputStreamReader(StandardFonts.class.getResourceAsStream("/org/jpedal/res/pdf/" + file_name), StandardCharsets.UTF_16));
            while ((line = input_stream.readLine()) != null) {
                String char_value;
                String VAL;
                String NAME;
                StringTokenizer values = new StringTokenizer(line);
                int tokenCount = values.countTokens();
                if (tokenCount <= 1 || line.contains("space")) continue;
                switch (tokenCount) {
                    case 4: {
                        String hexVal = values.nextToken();
                        values.nextToken();
                        NAME = values.nextToken();
                        VAL = values.nextToken();
                        char_value = Character.toString((char)Integer.parseInt(hexVal, 16));
                        break;
                    }
                    case 2: {
                        char_value = " ";
                        NAME = values.nextToken();
                        VAL = values.nextToken();
                        break;
                    }
                    default: {
                        char_value = values.nextToken();
                        NAME = values.nextToken();
                        VAL = values.nextToken();
                    }
                }
                if (tokenCount != 2) {
                    unicode_name_mapping_table.put(key + NAME, char_value);
                }
                if (NAME != null) {
                    glyphToChar[key].put(NAME, Integer.parseInt(VAL));
                }
                if (!Character.isDigit(VAL.charAt(0))) continue;
                int value = Integer.parseInt(VAL, 8);
                switch (key) {
                    case 5: {
                        StandardFonts.ZAPF_char_encoding_table[value] = char_value;
                        break;
                    }
                    case 4: {
                        StandardFonts.SYMBOL_char_encoding_table[value] = char_value;
                        break;
                    }
                    case 3: {
                        StandardFonts.MACEXPERT_char_encoding_table[value] = char_value;
                        break;
                    }
                }
                StandardFonts.unicode_char_decoding_table[key][value] = NAME;
            }
        }
        catch (Exception e2) {
            LogWriter.writeLog("Exception " + e2 + " reading lookup table for pdf");
        }
        if (input_stream != null) {
            try {
                input_stream.close();
            }
            catch (Exception e3) {
                LogWriter.writeLog("Exception " + e3 + " reading lookup table for pdf  for abobe map");
            }
        }
    }

    private static void readStandardMappingTable(int idx) {
        if (idx == 0) {
            StandardFonts.checkLoaded(2);
        }
        try {
            StandardFonts.glyphToChar[idx] = new ConcurrentHashMap<String, Integer>();
            try (BufferedReader input_stream = new BufferedReader(new InputStreamReader(StandardFonts.class.getResourceAsStream("/org/jpedal/res/pdf/standard_encoding.cfg"), enc));){
                String line;
                while ((line = input_stream.readLine()) != null) {
                    StringTokenizer values = new StringTokenizer(line);
                    int count = values.countTokens();
                    String NAME = values.nextToken().intern();
                    String STD_value = values.nextToken().intern();
                    String MAC_value = values.nextToken().intern();
                    String WIN_value = values.nextToken().intern();
                    String PDF_value = values.nextToken().intern();
                    String raw = values.nextToken().intern();
                    String char_value = count == 7 ? Character.toString((char)Integer.parseInt(raw, 16)).intern() : raw;
                    unicodeToName.put(char_value, NAME);
                    if (idx == 0 && Character.isDigit(MAC_value.charAt(0))) {
                        char_value = StandardFonts.setValue(char_value, NAME, MAC_value, 201, MAC_char_encoding_table, 0);
                    } else if (idx == 1 && Character.isDigit(STD_value.charAt(0))) {
                        char_value = StandardFonts.setValue(char_value, NAME, STD_value, 188, STD_char_encoding_table, 1);
                    } else if (idx == 6 && Character.isDigit(PDF_value.charAt(0))) {
                        int std_value = Integer.parseInt(PDF_value, 8);
                        if (std_value == 131) {
                            char_value = ellipsis;
                        }
                        StandardFonts.PDF_char_encoding_table[std_value] = char_value;
                        StandardFonts.unicode_char_decoding_table[6][std_value] = NAME;
                    } else if (idx == 2 && Character.isDigit(WIN_value.charAt(0))) {
                        char_value = StandardFonts.setValue(char_value, NAME, WIN_value, 133, WIN_char_encoding_table, 2);
                    }
                    unicode_name_mapping_table.put(idx + NAME, char_value);
                }
            }
            if (idx == 0) {
                StandardFonts.MAC_char_encoding_table[202] = " ";
            }
            if (idx == 2) {
                StandardFonts.WIN_char_encoding_table[160] = " ";
                StandardFonts.WIN_char_encoding_table[255] = "-";
                StandardFonts.unicode_char_decoding_table[2][160] = "space";
            }
        }
        catch (Exception e2) {
            LogWriter.writeLog("Exception " + e2 + " reading lookup table for pdf  for " + idx);
        }
    }

    private static String setValue(String char_value, String NAME, String MAC_value, int i2, String[] mac_char_encoding_table, int mac) {
        int mac_value = Integer.parseInt(MAC_value, 8);
        if (mac_value == i2) {
            char_value = ellipsis;
        }
        mac_char_encoding_table[mac_value] = char_value;
        StandardFonts.unicode_char_decoding_table[mac][mac_value] = NAME;
        if (NAME != null) {
            glyphToChar[mac].put(NAME, mac_value);
        }
        return char_value;
    }

    public static String getNameFromUnicode(String unicode) {
        return unicodeToName.get(unicode);
    }

    public static String getEncodedChar(int font_encoding, int char_int) {
        String return_character = null;
        switch (font_encoding) {
            case 2: {
                return_character = WIN_char_encoding_table[char_int];
                break;
            }
            case 1: {
                return_character = STD_char_encoding_table[char_int];
                break;
            }
            case 0: {
                return_character = MAC_char_encoding_table[char_int];
                break;
            }
            case 6: {
                return_character = PDF_char_encoding_table[char_int];
                break;
            }
            case 5: {
                return_character = ZAPF_char_encoding_table[char_int];
                break;
            }
            case 4: {
                return_character = SYMBOL_char_encoding_table[char_int];
                break;
            }
            case 3: {
                return_character = MACEXPERT_char_encoding_table[char_int];
                break;
            }
        }
        if (return_character == null) {
            return_character = "&#" + char_int + ';';
        }
        return return_character;
    }

    public static synchronized void checkLoaded(int enc) {
        if (enc == 0 && MAC_char_encoding_table == null) {
            MAC_char_encoding_table = new String[335];
            StandardFonts.readStandardMappingTable(enc);
        } else if (enc == 2 && WIN_char_encoding_table == null) {
            WIN_char_encoding_table = new String[335];
            StandardFonts.readStandardMappingTable(enc);
        } else if (enc == 1 && STD_char_encoding_table == null) {
            STD_char_encoding_table = new String[335];
            StandardFonts.readStandardMappingTable(enc);
        } else if (enc == 6 && PDF_char_encoding_table == null) {
            PDF_char_encoding_table = new String[335];
            StandardFonts.readStandardMappingTable(enc);
        } else if (enc == 4 && SYMBOL_char_encoding_table == null) {
            SYMBOL_char_encoding_table = new String[335];
            StandardFonts.readStandardMappingTable(4, "symbol.cfg");
        } else if (enc == 5 && ZAPF_char_encoding_table == null) {
            ZAPF_char_encoding_table = new String[335];
            StandardFonts.readStandardMappingTable(5, "zapf.cfg");
        } else if (enc == 3 && MACEXPERT_char_encoding_table == null) {
            MACEXPERT_char_encoding_table = new String[335];
            StandardFonts.readStandardMappingTable(3, "mac_expert.cfg");
        }
    }

    private static synchronized void loadStandardFont(int i2) throws IOException {
        String char_name = "";
        float width = 200.0f;
        if (standardFontLoaded.get(i2) != null) {
            return;
        }
        try (BufferedReader input_stream = new BufferedReader(new InputStreamReader(StandardFonts.class.getResourceAsStream("/org/jpedal/res/pdf/defaults/" + files_names[i2] + ".afm"), enc));){
            String line;
            boolean char_mapping_table = false;
            while ((line = input_stream.readLine()) != null) {
                if (line.startsWith("EndCharMetrics")) {
                    char_mapping_table = false;
                }
                if (line.startsWith("FontBBox")) {
                    float[] fontBBox = new float[4];
                    StringTokenizer values = new StringTokenizer(line);
                    values.nextToken();
                    for (int a10 = 0; a10 < 4; ++a10) {
                        fontBBox[a10] = Integer.parseInt(values.nextToken());
                    }
                    fontBounds.put(files_names[i2], fontBBox);
                }
                if (char_mapping_table) {
                    StringTokenizer values = new StringTokenizer(line, " ;");
                    while (values.hasMoreTokens()) {
                        String next_command = values.nextToken();
                        if ("WX".equals(next_command)) {
                            width = Float.parseFloat(values.nextToken()) / 1000.0f;
                            continue;
                        }
                        if (!"N".equals(next_command)) continue;
                        char_name = values.nextToken();
                    }
                    widthTableStandard.put(files_names_bis[i2].toLowerCase() + char_name, Float.valueOf(width));
                    widthTableStandard.put(files_names[i2].toLowerCase() + char_name, Float.valueOf(width));
                }
                if (!line.startsWith("StartCharMetrics")) continue;
                char_mapping_table = true;
            }
        }
        standardFontLoaded.put(i2, "x");
    }

    static void loadStandardFontWidth(String fontName) {
        Integer fileNumber = standardFileList.get(fontName);
        if (fileNumber != null && standardFontLoaded.get(fileNumber) == null) {
            try {
                StandardFonts.loadStandardFont(fileNumber);
            }
            catch (Exception e2) {
                LogWriter.writeLog("[PDF] " + e2 + " problem reading lookup table for pdf font " + fontName + ' ' + fontName);
            }
        }
    }

    public static int lookupCharacterIndex(String glyph, int idx) {
        if (glyph == null) {
            return 0;
        }
        Integer value = glyphToChar[idx].get(glyph);
        if (value == null) {
            return 0;
        }
        return value;
    }

    private static void loadAdobeMap() {
        if (adobeMap == null) {
            try {
                adobeMap = new ConcurrentHashMap();
                try (BufferedReader input_stream = new BufferedReader(new InputStreamReader(StandardFonts.class.getResourceAsStream("/org/jpedal/res/pdf/glyphlist.cfg"), enc));){
                    String line;
                    while ((line = input_stream.readLine()) != null) {
                        if (line.startsWith("#") || line.indexOf(59) == -1) continue;
                        StringTokenizer vals = new StringTokenizer(line, ";");
                        String key = vals.nextToken();
                        String operand = vals.nextToken();
                        int space = operand.indexOf(32);
                        if (space != -1) {
                            operand = operand.substring(0, space);
                        }
                        int opVal = Integer.parseInt(operand, 16);
                        adobeMap.put(key, opVal);
                        unicode_name_mapping_table.put(key, Character.toString((char)opVal));
                    }
                }
            }
            catch (Exception e2) {
                LogWriter.writeLog("Exception " + e2 + " reading lookup table for pdf  for abobe map");
            }
        }
    }

    public static int getAdobeMap(String key) {
        Integer value = adobeMap.get(key);
        if (value == null) {
            String ss;
            if (key.startsWith("uni") && (ss = key.substring(3)).matches("-?[0-9a-fA-F]+")) {
                return Integer.parseInt(ss, 16);
            }
            return -1;
        }
        return value;
    }

    public static boolean isValidGlyphName(String key) {
        return key != null && adobeMap.get(key) != null;
    }

    public static boolean isStandardFont(String fontName, boolean excludeWeights) {
        boolean isStandard;
        boolean bl2 = isStandard = standardFileList.get(fontName) != null;
        if (!isStandard && excludeWeights) {
            char valueToTest;
            char[] valuesToTest;
            char[] cArray = valuesToTest = new char[]{'-', ','};
            int n2 = cArray.length;
            for (int i2 = 0; i2 < n2 && !(isStandard = StandardFonts.checkSubFontName(fontName, valueToTest = cArray[i2])); ++i2) {
            }
        }
        return isStandard;
    }

    private static boolean checkSubFontName(String fontName, char charToTest) {
        boolean isStandard = false;
        int ptr = fontName.indexOf(charToTest);
        if (ptr != -1) {
            isStandard = standardFileList.get(fontName.substring(0, ptr)) != null;
        }
        return isStandard;
    }

    public static Map<String, String> getFontDetails(int type, String subFont) {
        ConcurrentHashMap<String, String> fontDetails = new ConcurrentHashMap<String, String>();
        if (type == 1217103210 || type == 7) {
            TTGlyphs.addStringValues(new FontData(subFont), fontDetails);
        }
        return fontDetails;
    }

    public static String[] readNamesFromFont(int type, String subFont, int mode) {
        String[] fontNames = new String[]{""};
        if (type == 1217103210 || type == 7) {
            fontNames = TTGlyphs.readFontNames(new FontData(subFont), mode);
        } else if (type == 1228944677) {
            fontNames = T1Glyphs.readFontNames(new FontData(subFont));
        }
        return fontNames;
    }

    public static String convertNumberToGlyph(String mappedChar, boolean containsHexNumbers, boolean allowSingleValue) {
        int charCount = mappedChar.length();
        boolean isNumber = true;
        boolean hasHex = false;
        if (charCount == 2 || charCount == 3 || allowSingleValue && charCount == 1) {
            for (int ii = 0; ii < charCount; ++ii) {
                char c2 = mappedChar.charAt(ii);
                if (c2 >= '0' && c2 <= '9') continue;
                if (containsHexNumbers && c2 >= 'A' && c2 <= 'F') {
                    hasHex = true;
                    continue;
                }
                isNumber = false;
                break;
            }
            if (isNumber) {
                if (charCount == 3 || !containsHexNumbers) {
                    if (!hasHex) {
                        mappedChar = String.valueOf((char)Integer.parseInt(mappedChar)).intern();
                    }
                } else {
                    mappedChar = String.valueOf((char)Integer.parseInt(mappedChar, 16)).intern();
                }
            }
        } else {
            boolean hasHash = false;
            boolean hasText = false;
            for (int ii = 0; ii < charCount; ++ii) {
                char c3 = mappedChar.charAt(ii);
                if (c3 == '#') {
                    hasHash = true;
                }
                if (c3 < 'A' || c3 > 'Z') continue;
                hasText = true;
            }
            if (hasHash) {
                StringBuilder buf = new StringBuilder(mappedChar);
                if (hasText) {
                    StandardFonts.replaceHex(charCount, buf);
                } else {
                    for (int ii = 0; ii < charCount; ++ii) {
                        char c4 = buf.charAt(ii);
                        if (c4 != '#') continue;
                        if ((ii += 3) < charCount) {
                            char c2 = buf.charAt(ii);
                            while (c2 >= '0' && c2 <= '9') {
                                buf.deleteCharAt(ii);
                                if (ii >= --charCount) break;
                                c2 = buf.charAt(ii);
                            }
                        }
                        --ii;
                    }
                }
                mappedChar = buf.toString();
            }
        }
        return mappedChar;
    }

    private static void replaceHex(int charCount, StringBuilder buf) {
        try {
            for (int ii = 0; ii < charCount; ++ii) {
                char c2 = buf.charAt(ii);
                if (c2 != '#') continue;
                String actualChar = StandardFonts.convertNumberToGlyph(buf.substring(ii + 1, ii + 3), true, false);
                buf.setCharAt(ii, actualChar.charAt(0));
                for (int aa2 = 0; aa2 < 2; ++aa2) {
                    buf.deleteCharAt(ii + 1);
                    --charCount;
                }
            }
        }
        catch (Exception e2) {
            LogWriter.writeLog("Exception: " + e2.getMessage());
        }
    }

    public static String getFontTypeAsString(int fontType) {
        switch (fontType) {
            case 1217103210: {
                return "TrueType";
            }
            case 1228944677: {
                return "Type1";
            }
            case 1228944679: {
                return "Type3";
            }
            case -1684566726: {
                return "CIDFontType0";
            }
            case -1684566724: {
                return "CIDFontType2";
            }
        }
        return "Unknown";
    }

    private static void blockForbiddenRanges(Set<Integer> ids) {
        int i2;
        for (i2 = 0; i2 <= 31; ++i2) {
            ids.add(i2);
        }
        for (i2 = 127; i2 <= 160; ++i2) {
            ids.add(i2);
        }
        for (i2 = 8204; i2 <= 8207; ++i2) {
            ids.add(i2);
        }
    }

    private static int mapCIDToValidUnicode(String fontName, int cid) {
        Integer result;
        ConcurrentHashMap<Integer, Integer> cidMap = mappedCharacters.get(fontName);
        Set<Integer> taken = takenChars.get(fontName);
        mappedCharacters.putIfAbsent(fontName, new ConcurrentHashMap());
        takenChars.putIfAbsent(fontName, Collections.newSetFromMap(new ConcurrentHashMap()));
        if (cidMap == null) {
            cidMap = mappedCharacters.get(fontName);
            taken = takenChars.get(fontName);
            StandardFonts.blockForbiddenRanges(taken);
        }
        if ((result = cidMap.get(cid)) != null) {
            return result;
        }
        int newCid = cid;
        if (cid < 32) {
            newCid += 32;
        }
        while (taken.contains(newCid) && taken.size() < 55296) {
            newCid = (newCid + 1) % 55296;
        }
        cidMap.put(cid, newCid);
        taken.add(newCid);
        return newCid;
    }

    public static int getIDForGlyphName(String fontName, String glyphName) {
        boolean base10 = false;
        int uc = StandardFonts.getAdobeMap(glyphName);
        if (uc >= 0) {
            return uc;
        }
        if (glyphName.startsWith("uni")) {
            glyphName = glyphName.substring(3);
        } else if (glyphName.charAt(0) == 'u' || glyphName.charAt(0) == 'G') {
            glyphName = glyphName.substring(1);
        } else {
            base10 = true;
        }
        try {
            if (base10 && glyphName.matches("[0-9]+")) {
                int num = Integer.parseInt(glyphName, 10);
                return StandardFonts.mapCIDToValidUnicode(fontName, num);
            }
            if (glyphName.matches("[0-9A-F]+")) {
                return Integer.parseInt(glyphName, 16);
            }
        }
        catch (NumberFormatException e2) {
            LogWriter.writeLog("Exception in handling cid id " + e2);
        }
        return -1;
    }

    public static String expandName(String name) {
        String testName;
        switch (testName = name.toLowerCase()) {
            case "cour": {
                name = "Courier";
                break;
            }
            case "helv": {
                name = "Helvetica";
                break;
            }
            case "hebo": {
                name = "Helvetica-BOLD";
                break;
            }
            case "zadb": {
                name = "ZapfDingbats";
                break;
            }
            case "tiro": {
                name = "Times";
                break;
            }
        }
        return name;
    }

    public static void readCMAP() {
        CMAP = new String[65536];
        try (BufferedReader input_stream = new BufferedReader(new InputStreamReader(StandardFonts.class.getResourceAsStream("/org/jpedal/res/pdf/jis.cfg")));){
            String line;
            while ((line = input_stream.readLine()) != null) {
                if (!line.startsWith("0") || !line.contains("#")) continue;
                StringTokenizer values = new StringTokenizer(line);
                String xx = values.nextToken().substring(2);
                int rawVal = Integer.parseInt(xx, 16);
                int unicodeVal = Integer.parseInt(values.nextToken().substring(2), 16);
                StandardFonts.CMAP[rawVal] = String.valueOf((char)unicodeVal).intern();
            }
        }
        catch (Exception e2) {
            LogWriter.writeLog("Exception: " + e2.getMessage());
        }
    }

    static {
        unicodeToName = new ConcurrentHashMap<String, String>();
        standardFileList = new ConcurrentHashMap<String, Integer>();
        standardFontLoaded = new ConcurrentHashMap<Integer, String>();
        widthTableStandard = new ConcurrentHashMap<String, Float>();
        javaFontList = new ConcurrentHashMap<String, String>();
        javaFonts = new String[]{"Courier", "Courier-Bold", "Courier", "Courier-Bold", "Arial", "Arial-Bold", "Arial", "Arial-Italic", "Symbol", "Times New Roman", "Times New Roman", "Times New Roman", "Times New Roman", "Wingdings"};
        files_names = new String[]{"Courier", "Courier-Bold", "Courier-BoldOblique", "Courier-Oblique", "Helvetica", "Helvetica-Bold", "Helvetica-BoldOblique", "Helvetica-Oblique", "Symbol", "Times-Bold", "Times-BoldItalic", "Times-Italic", "Times-Roman", "ZapfDingbats"};
        files_names_bis = new String[]{"CourierNew", "CourierNew,Bold", "CourierNew,BoldItalic", "CourierNew,Italic", "Arial", "Arial,Bold", "Arial,BoldItalic", "Arial,Italic", "Symbol", "TimesNewRoman,Bold", "TimesNewRoman,BoldItalic", "TimesNewRoman,Italic", "TimesNewRoman", "Wingdings"};
        fontBounds = new ConcurrentHashMap<String, float[]>();
        for (int i2 = 0; i2 < files_names.length; ++i2) {
            standardFileList.put(files_names_bis[i2], i2);
            standardFileList.put(files_names[i2], i2);
        }
        StandardFonts.loadAdobeMap();
        mappedCharacters = new ConcurrentHashMap();
        takenChars = new ConcurrentHashMap();
    }
}

