/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts;

import java.awt.Font;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.jpedal.fonts.CodeSpaceRange;
import org.jpedal.fonts.FontMappings;
import org.jpedal.fonts.FontSource;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.UnicodeReader;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.CIDEncodings;
import org.jpedal.objects.raw.FontObject;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.parser.FallbackFont;
import org.jpedal.parser.PdfFontFactory;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.NumberUtils;
import org.jpedal.utils.StringUtils;

public class PdfFont
implements Serializable {
    private PdfObject ToUnicode;
    private String truncatedName;
    public String CMapName;
    private boolean handleOddSapFontMapping;
    private boolean isFirstScan = true;
    private int isDouble = -1;
    private static final int noWidth = -1;
    public int type3_d1_Max;
    String copyright;
    private int objID;
    private FontSource source = FontSource.RESOURCES;
    private boolean isCIDIdentity;
    private boolean hasCIDSet;
    private float missingWidth = -1.0f;
    private boolean isSingleByte;
    private boolean isFontVertical;
    private float lastWidth = -1.0f;
    public PdfJavaGlyphs glyphs = new PdfJavaGlyphs();
    private String[] cachedValue = new String[256];
    private String rawFontName;
    public boolean hasDoubleBytes;
    private boolean hasExtractionValues = true;
    private FallbackFont fallbackFont;
    public CodeSpaceRange codeSpaceRange;
    String substituteFont;
    protected boolean renderPage;
    private static final float xscale = 0.001f;
    int embeddedEnc = 1;
    String[] diffs;
    public boolean isFontEmbedded;
    boolean TTstreamisCID;
    String fontID = "";
    int maxCharCount = 256;
    boolean hasEncoding = true;
    int fontTypes;
    String substituteFontFile;
    private int spaceChar = -1;
    private String[] diffTable;
    final Map<String, Set<Integer>> rawDiffKeys = new HashMap<String, Set<Integer>>();
    private int[] diffCharTable;
    private float[] widthTable;
    public float[][] vMatrix;
    private float possibleSpaceWidth = -1.0f;
    PdfObjectReader currentPdfFile;
    final ClassLoader loader = this.getClass().getClassLoader();
    public double[] FontMatrix = new double[]{0.001, 0.0, 0.0, 0.001, 0.0, 0.0};
    public float[] FontBBox = new float[]{0.0f, 0.0f, 1000.0f, 1000.0f};
    boolean isHex;
    private String[] unicodeMappings;
    int fontEnc = -1;
    boolean isCIDFont;
    private String[] CMAP;
    private int[] rawCMAP;
    private String CIDfontEncoding;
    private float defaultWidth = -1.0f;
    boolean isFontSubstituted;
    private int[] CIDToGIDMap;

    public PdfFont() {
    }

    public PdfFont(PdfObjectReader current_pdf_file) {
        this.init(current_pdf_file);
    }

    public String getTruncatedName() {
        if (this.truncatedName == null) {
            return this.fontID;
        }
        return this.truncatedName;
    }

    private static void setStandardFontMappings() {
        String value;
        String key;
        int i2;
        int count = StandardFonts.files_names.length;
        for (i2 = 0; i2 < count; ++i2) {
            key = StandardFonts.files_names_bis[i2].toLowerCase();
            if (key.equals(value = StandardFonts.javaFonts[i2].toLowerCase()) || FontMappings.fontSubstitutionAliasTable.containsKey(key)) continue;
            FontMappings.fontSubstitutionAliasTable.put(key, value);
        }
        for (i2 = 0; i2 < count; ++i2) {
            key = StandardFonts.files_names[i2].toLowerCase();
            if (!key.equals(value = StandardFonts.javaFonts[i2].toLowerCase()) && !FontMappings.fontSubstitutionAliasTable.containsKey(key)) {
                FontMappings.fontSubstitutionAliasTable.put(key, value);
            }
            StandardFonts.javaFontList.put(StandardFonts.files_names[i2], "x");
        }
    }

    public boolean isFontSubstituted() {
        return this.isFontSubstituted;
    }

    private void setCIDFontWidths(Object[] values) {
        float shortestWidth = 0.0f;
        this.widthTable = new float[65536];
        for (int ii = 0; ii < 65536; ++ii) {
            this.widthTable[ii] = -1.0f;
        }
        int ptr = 0;
        int count = values.length;
        int widthsCount = 0;
        byte[] nextNumber = null;
        for (int i2 = 0; i2 < count; ++i2) {
            float nextWidth;
            Object o2 = values[i2];
            if (o2 instanceof byte[]) {
                if (nextNumber != null) {
                    int start = ptr;
                    nextNumber = (byte[])o2;
                    int end = NumberUtils.parseInt(0, nextNumber.length, nextNumber);
                    if ((nextWidth = NumberUtils.parseFloat(0, (nextNumber = (byte[])values[++i2]).length, nextNumber) / 1000.0f) > 0.0f) {
                        shortestWidth += nextWidth;
                        ++widthsCount;
                    }
                    for (int i22 = start; i22 <= end; ++i22) {
                        this.widthTable[i22] = nextWidth;
                    }
                    nextNumber = null;
                    continue;
                }
                nextNumber = (byte[])o2;
                ptr = NumberUtils.parseInt(0, nextNumber.length, nextNumber);
                continue;
            }
            nextNumber = null;
            for (Object widths : (Object[])o2) {
                byte[] rawNextWidth = (byte[])widths;
                this.widthTable[ptr] = nextWidth = NumberUtils.parseFloat(0, rawNextWidth.length, rawNextWidth) / 1000.0f;
                if (nextWidth > 0.0f) {
                    shortestWidth += nextWidth;
                    ++widthsCount;
                }
                ++ptr;
            }
        }
        if (widthsCount > 0) {
            this.possibleSpaceWidth = shortestWidth / (float)(2 * widthsCount);
        }
    }

    private void setFontDW2(int[] dw2) {
        if (this.vMatrix == null) {
            this.vMatrix = new float[65536][3];
        }
        for (int i2 = 0; i2 < 65536; ++i2) {
            this.vMatrix[i2][0] = (float)dw2[0] / 1000.0f;
            this.vMatrix[i2][1] = (float)dw2[1] / 1000.0f;
        }
    }

    private void setCIDFontW2(Object[] values) {
        if (this.vMatrix == null) {
            this.vMatrix = new float[65536][3];
            for (int i2 = 0; i2 < 65536; ++i2) {
                this.vMatrix[i2][0] = 0.88f;
                this.vMatrix[i2][1] = -1.0f;
            }
        }
        try {
            int ii = values.length;
            int i3 = 0;
            while (i3 < ii) {
                int end;
                int start;
                byte[] nextNumber;
                if (i3 < ii - 1 && values[i3 + 1] instanceof Object[]) {
                    nextNumber = (byte[])values[i3++];
                    start = NumberUtils.parseInt(0, nextNumber.length, nextNumber);
                    Object[] objArr = (Object[])values[i3++];
                    end = start + objArr.length / 3;
                    for (int j2 = start; j2 < end; ++j2) {
                        float vy;
                        int j3 = (j2 - start) * 3;
                        float y2 = (float)NumberUtils.parseInt(0, ((byte[])objArr[j3]).length, (byte[])objArr[j3]) / 1000.0f;
                        float vx = (float)NumberUtils.parseInt(0, ((byte[])objArr[j3 + 1]).length, (byte[])objArr[j3 + 1]) / 1000.0f;
                        this.vMatrix[j2][0] = vy = (float)NumberUtils.parseInt(0, ((byte[])objArr[j3 + 2]).length, (byte[])objArr[j3 + 2]) / 1000.0f;
                        this.vMatrix[j2][1] = y2;
                        this.vMatrix[j2][2] = vx;
                    }
                    continue;
                }
                nextNumber = (byte[])values[i3++];
                start = NumberUtils.parseInt(0, nextNumber.length, nextNumber);
                nextNumber = (byte[])values[i3++];
                end = NumberUtils.parseInt(0, nextNumber.length, nextNumber);
                nextNumber = (byte[])values[i3++];
                float y3 = (float)NumberUtils.parseInt(0, nextNumber.length, nextNumber) / 1000.0f;
                nextNumber = (byte[])values[i3++];
                float vx = (float)NumberUtils.parseInt(0, nextNumber.length, nextNumber) / 1000.0f;
                nextNumber = (byte[])values[i3++];
                float vy = (float)NumberUtils.parseInt(0, nextNumber.length, nextNumber) / 1000.0f;
                for (int j3 = start; j3 <= end; ++j3) {
                    this.vMatrix[j3][0] = vy;
                    this.vMatrix[j3][1] = y3;
                    this.vMatrix[j3][2] = vx;
                }
            }
        }
        catch (Exception e2) {
            this.vMatrix = null;
            LogWriter.writeLog("W2 table parsing error with exception " + e2.getMessage() + " vMatrix set to null");
        }
    }

    public final boolean isCIDFont() {
        return this.isCIDFont;
    }

    final void init(PdfObjectReader current_pdf_file) {
        this.currentPdfFile = current_pdf_file;
        if (this.isCIDFont) {
            this.maxCharCount = 65536;
        }
        this.glyphs.init(this.maxCharCount, this.isCIDFont);
    }

    public final String getUnicodeMapping(int char_int) {
        if (this.unicodeMappings == null || char_int >= this.unicodeMappings.length) {
            return null;
        }
        return this.unicodeMappings[char_int];
    }

    public final void putFontEncoding(int enc) {
        if (enc == 2 && "Symbol".equals(this.getBaseFontName())) {
            this.putFontEncoding(4);
            enc = 4;
        }
        if (enc == 1 && this.getBaseFontName().contains("ZapfDingbats")) {
            StandardFonts.checkLoaded(5);
        }
        this.fontEnc = enc;
        StandardFonts.checkLoaded(enc);
    }

    public final String getUnicodeValue(String displayValue, int rawInt) {
        String textValue = this.getUnicodeMapping(rawInt);
        if (textValue == null) {
            textValue = displayValue;
        }
        if (!displayValue.isEmpty()) {
            char displayChar = displayValue.charAt(0);
            switch (displayChar) {
                case '\u00ad': {
                    if (this.fontEnc != 2 && this.fontEnc != 1) break;
                    textValue = "-";
                    break;
                }
                case '\ufb00': {
                    textValue = "ff";
                    break;
                }
                case '\ufb01': {
                    textValue = "fi";
                    break;
                }
                case '\ufb04': {
                    textValue = "ffl";
                }
            }
        }
        return textValue;
    }

    public final String getGlyphValue(int rawInt) {
        if (this.cachedValue[rawInt] != null) {
            return this.cachedValue[rawInt];
        }
        String return_value = null;
        if (this.isCIDFont) {
            String unicodeMappings = this.getUnicodeMapping(rawInt);
            if (unicodeMappings != null) {
                return_value = unicodeMappings;
            }
            if (return_value == null) {
                String newChar;
                String fontEncoding = this.CIDfontEncoding;
                if (this.diffTable != null) {
                    return_value = this.diffTable[rawInt];
                } else if (fontEncoding != null) {
                    String newChar2;
                    if (fontEncoding.startsWith("Identity-")) {
                        return_value = String.valueOf((char)rawInt).intern();
                    } else if (this.CMAP != null && (newChar2 = this.CMAP[rawInt]) != null) {
                        return_value = newChar2;
                    }
                } else if (this.CMAP != null && this.CMapName != null && !this.CMapName.endsWith("-V") && !this.CMapName.endsWith("-H") && (newChar = this.CMAP[rawInt]) != null) {
                    return_value = newChar;
                }
                if (return_value == null) {
                    return_value = String.valueOf((char)rawInt).intern();
                }
            }
        } else {
            return_value = this.getStandardGlyphValue(rawInt);
        }
        this.cachedValue[rawInt] = return_value;
        return return_value;
    }

    private String handleCIDEncoding(PdfObject Encoding, PdfObject fontObject) {
        int encodingType = Encoding.getGeneralType(1232564598);
        String encodingName = this.getEncoding(Encoding, encodingType);
        PdfObject descendent = fontObject == null ? null : fontObject.getDictionary(-1547306032);
        String ordering = null;
        PdfObject systemInfo = null;
        if (descendent != null && (systemInfo = descendent.getDictionary(1972801240)) != null) {
            ordering = systemInfo.getTextStreamValue(1635480172);
        }
        this.CMapName = Encoding.getName(827223669);
        if (this.CMapName != null) {
            byte[] stream = this.currentPdfFile.readStream(Encoding, true, true, false, false, false, Encoding.getCacheName(this.currentPdfFile.getObjectReader()));
            encodingName = this.CMapName;
            String CMAPstream = new String(stream);
            CMAPstream = CMAPstream.replaceAll(" begincidchar ", "\nbegincidchar\n");
            CMAPstream = CMAPstream.replaceAll(" endcidchar", "\nendcidchar");
            CMAPstream = CMAPstream.replaceAll(" begincidrange ", "\begincidrange\n");
            CMAPstream = CMAPstream.replaceAll(" endcidrange", "\nendcidrange");
            try (BufferedReader CIDstream = new BufferedReader(new StringReader(CMAPstream));){
                this.createCIDCMap(CIDstream, encodingType, fontObject, encodingName);
            }
            catch (IOException e2) {
                LogWriter.writeLog(e2.getMessage());
            }
        } else {
            if (encodingType == 2038913669 || encodingType == 2038913683) {
                String registry;
                if (systemInfo != null && "Adobe".equals(registry = systemInfo.getTextStreamValue(1702459778)) && ("Japan1".equals(ordering) || "CNS1".equals(ordering) || "Korea1".equals(ordering) || "GB1".equals(ordering))) {
                    CodeSpaceRange csr = new CodeSpaceRange("Adobe-" + ordering + "-UCS2");
                    if (csr.hasEncoding) {
                        this.codeSpaceRange = csr;
                    }
                }
            } else {
                CodeSpaceRange csr = new CodeSpaceRange(encodingName);
                if (csr.hasEncoding) {
                    this.codeSpaceRange = csr;
                }
            }
            this.createCIDCMap(null, encodingType, fontObject, encodingName);
        }
        return this.CMapName;
    }

    private void createCIDCMap(BufferedReader CIDstream, int encodingType, PdfObject fontObject, String encodingName) {
        boolean isIdentity;
        boolean bl2 = isIdentity = encodingType == 2038913669 || encodingType == 2038913683;
        if (!isIdentity) {
            String name;
            String string = name = fontObject == null ? null : fontObject.getName(678461817);
            if (encodingType != -1 && name != null && name.contains("Identity")) {
                isIdentity = true;
                this.handleOddSapFontMapping = true;
                this.isSingleByte = true;
            }
        }
        if (CIDstream == null) {
            this.CIDfontEncoding = encodingName;
        }
        if (!isIdentity && CIDstream != null) {
            this.glyphs.setIsIdentity(true);
            this.CMAP = new String[65536];
            this.rawCMAP = new int[65536];
            this.glyphs.CMAP_Translate = new int[65536];
            if (this.readCIDCMap(CIDstream)) {
                this.glyphs.setIsIdentity(true);
                return;
            }
            int length = this.CMAP.length;
            boolean mismatchFound = false;
            for (int count = 0; !mismatchFound && count < length; ++count) {
                if (this.CMAP[count] == null || this.rawCMAP[count] == count) continue;
                mismatchFound = true;
                this.glyphs.setIsIdentity(false);
            }
        } else {
            this.glyphs.setIsIdentity(isIdentity);
        }
    }

    private String getEncoding(PdfObject Encoding, int encodingType) {
        String encodingName = CIDEncodings.getNameForEncoding(encodingType);
        if (encodingName == null) {
            switch (encodingType) {
                case 2038913669: {
                    encodingName = "Identity-H";
                    break;
                }
                case 2038913683: {
                    encodingName = "Identity-V";
                    this.isFontVertical = true;
                    break;
                }
                default: {
                    encodingName = Encoding.getGeneralStringValue();
                    break;
                }
            }
        } else if (encodingName.endsWith("V")) {
            this.isFontVertical = true;
        }
        return encodingName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean readCIDCMap(BufferedReader CIDstream) {
        String line = "";
        boolean inDefinition = false;
        boolean inMap = false;
        boolean failed = false;
        while (true) {
            int end;
            int begin;
            StringTokenizer CIDentry;
            try {
                line = CIDstream.readLine();
            }
            catch (Exception e2) {
                LogWriter.writeLog("[PDF] Error reading line from font " + e2.getMessage());
            }
            if (line == null) {
                return failed;
            }
            if (failed || line.contains("/CIDSystemInfo 3 dict dup begin")) {
                boolean bl2 = failed = !line.contains("end def");
            }
            if (line.contains("endcidrange")) {
                inDefinition = false;
            } else if (line.contains("endcidchar")) {
                inMap = false;
            }
            if (!inDefinition) {
                if (inMap) {
                    try {
                        CIDentry = new StringTokenizer(line, " <>[]");
                        if (CIDentry.countTokens() == 2) {
                            begin = Integer.parseInt(CIDentry.nextToken(), 16);
                            this.rawCMAP[begin] = end = Integer.parseInt(CIDentry.nextToken());
                            this.glyphs.CMAP_Translate[begin] = end;
                        }
                    }
                    catch (Exception ef) {
                        LogWriter.writeLog("Exception " + ef);
                    }
                }
            } else {
                CIDentry = new StringTokenizer(line, " <>[]");
                boolean multiple_values = line.indexOf(91) != -1;
                begin = Integer.parseInt(CIDentry.nextToken(), 16);
                end = Integer.parseInt(CIDentry.nextToken(), 16);
                String value = CIDentry.nextToken();
                int charCount = value.length();
                boolean isHex = false;
                for (int ptr = 0; ptr < charCount; ++ptr) {
                    char c2 = value.charAt(ptr);
                    if (c2 >= '0' && c2 <= '9') continue;
                    isHex = true;
                    ptr = charCount;
                }
                int entry = isHex ? Integer.parseInt(value, 16) : Integer.parseInt(value, 10);
                for (int i2 = begin; i2 < end + 1; ++i2) {
                    if (multiple_values) {
                        this.rawCMAP[i2] = entry = Integer.parseInt(CIDentry.nextToken(), 16);
                        this.CMAP[i2] = String.valueOf((char)entry).intern();
                        continue;
                    }
                    this.CMAP[i2] = String.valueOf((char)entry).intern();
                    this.rawCMAP[i2] = entry++;
                }
            }
            if (line.contains("begincidrange")) {
                inDefinition = true;
                continue;
            }
            if (!line.contains("begincidchar")) continue;
            inMap = true;
        }
    }

    private String getStandardGlyphValue(int char_int) {
        String unicode_char = this.getUnicodeMapping(char_int);
        if (unicode_char != null) {
            return unicode_char;
        }
        String return_value = "";
        int font_encoding = this.getFontEncoding(true);
        String mapped_char = this.getMappedChar(char_int, true);
        if (mapped_char != null) {
            String char_mapping = StandardFonts.getUnicodeName(mapped_char, font_encoding);
            if (char_mapping != null) {
                return_value = char_mapping;
            } else if (mapped_char.length() == 1) {
                return_value = mapped_char;
            } else if (mapped_char.length() > 1) {
                char c0 = mapped_char.charAt(0);
                if (c0 == 'B' || c0 == 'C' || c0 == 'c' || c0 == 'G') {
                    boolean isHexValue = mapped_char.length() == 3 && this.isHex && PdfFont.isHexValue(mapped_char.charAt(1)) && PdfFont.isHexValue(mapped_char.charAt(2));
                    String valueToParse = mapped_char.substring(1);
                    if (isHexValue || PdfFont.isDecimalValue(valueToParse)) {
                        return_value = String.valueOf((char)Integer.parseInt(valueToParse, isHexValue ? 16 : 10)).intern();
                    }
                }
                if (return_value.isEmpty()) {
                    if (this.fontTypes == 1228944679) {
                        return_value = String.valueOf((char)char_int).intern();
                    } else if (this.diffTable != null && this.diffTable[char_int] != null && this.fontEnc == 2 && (return_value = this.diffTable[char_int]).indexOf(95) != -1) {
                        return_value = return_value.replaceAll("_", "");
                    }
                }
            }
        } else if (font_encoding > -1) {
            return_value = StandardFonts.getEncodedChar(font_encoding, char_int);
        }
        return return_value;
    }

    private static boolean isHexValue(char c2) {
        return c2 >= '0' && c2 <= '9' || c2 >= 'a' && c2 <= 'f' || c2 >= 'A' && c2 <= 'F';
    }

    private static boolean isDecimalValue(String s2) {
        for (char c2 : s2.toCharArray()) {
            if (c2 >= '0' && c2 <= '9') continue;
            return false;
        }
        return true;
    }

    public final void setDefaultDisplayFont(String fontName) {
        this.glyphs.defaultFont = fontName;
    }

    public final Font getJavaFontX(int size) {
        Font f2;
        if (DecoderOptions.Helper != null && (f2 = DecoderOptions.Helper.getJavaFontX(this, size)) != null) {
            return f2;
        }
        return new Font(this.glyphs.font_family_name, this.glyphs.style, size);
    }

    public final String getFontName() {
        StandardFonts.loadStandardFontWidth(this.glyphs.fontName);
        return this.glyphs.fontName;
    }

    public final String getCopyright() {
        return this.copyright;
    }

    public final String getBaseFontName() {
        return this.glyphs.getBaseFontName();
    }

    public final float getCurrentFontSpaceWidth() {
        int space_value = this.spaceChar;
        float width = space_value != -1 ? this.getWidth(space_value) : this.possibleSpaceWidth;
        if (width == -1.0f || width == 0.0f) {
            width = 0.3f;
        }
        return width;
    }

    public final float getSpaceWidthHTML() {
        Float width = null;
        if (this.spaceChar != -1 && (width = Float.valueOf(this.getEmbeddedFontWidth(this.spaceChar))).floatValue() == -1.0f) {
            width = this.isCIDFont ? Float.valueOf(this.defaultWidth) : this.getStandardFontWidth(this.spaceChar);
        }
        if (width == null || width.floatValue() == -1.0f || width.floatValue() == 0.0f) {
            width = Float.valueOf(0.25f);
        }
        return width.floatValue();
    }

    public final int getFontEncoding(boolean notNull) {
        int result = this.fontEnc;
        if (result == -1 && notNull) {
            result = 1;
        }
        return result;
    }

    private float getEmbeddedFontWidth(int charInt) {
        int ptr;
        float width = -1.0f;
        if (this.widthTable != null && charInt < this.maxCharCount) {
            width = this.widthTable[charInt];
        }
        if (this.isCIDFont && this.rawCMAP != null && this.widthTable != null && !this.isCIDIdentity && this.hasCIDSet && (ptr = this.rawCMAP[charInt]) > 0) {
            width = this.widthTable[ptr];
        }
        return width;
    }

    private Float getStandardFontWidth(int charInt) {
        Float value;
        String charName = this.getMappedChar(charInt, false);
        if (".notdef".equals(charName)) {
            charName = StandardFonts.getUnicodeChar(this.getFontEncoding(true), charInt);
        }
        if ((value = StandardFonts.getStandardWidth(this.glyphs.logicalfontName, charName)) == null && this.rawFontName != null) {
            StandardFonts.loadStandardFontWidth(this.rawFontName);
            value = StandardFonts.getStandardWidth(this.rawFontName, charName);
        }
        return value;
    }

    public final float getWidth(int charInt) {
        if (charInt == -1) {
            return this.lastWidth;
        }
        float width = this.getEmbeddedFontWidth(charInt);
        if (width == -1.0f) {
            Float value;
            width = this.isCIDFont ? (this.missingWidth != -1.0f ? this.missingWidth * 0.001f : this.defaultWidth) : ((value = this.getStandardFontWidth(charInt)) != null ? value.floatValue() : (this.missingWidth != -1.0f ? this.missingWidth * 0.001f : 0.0f));
        }
        this.lastWidth = width;
        return width;
    }

    void createCIDFont(PdfObject pdfObject, PdfObject Descendent) {
        String ordering;
        PdfObject CIDSystemInfo;
        this.cachedValue = new String[65536];
        String CMapName = null;
        PdfObject Encoding = pdfObject.getDictionary(1232564598);
        if (Encoding != null) {
            CMapName = this.handleCIDEncoding(Encoding, pdfObject);
        }
        this.ToUnicode = pdfObject.getDictionary(1919185554);
        if (this.ToUnicode != null) {
            UnicodeReader uniReader = new UnicodeReader(this.currentPdfFile.readStream(this.ToUnicode, true, true, false, false, false, this.ToUnicode.getCacheName(this.currentPdfFile.getObjectReader())));
            this.unicodeMappings = uniReader.readUnicode();
            this.hasDoubleBytes = uniReader.hasDoubleByteValues();
            if (this.unicodeMappings != null) {
                this.spaceChar = PdfFont.findUnicodeSpaceEntry(this.unicodeMappings);
            }
        }
        PdfObject FontDescriptor = Descendent.getDictionary(-1044665361);
        this.setWidths(Descendent, FontDescriptor);
        PdfObject CIDToGID = Descendent.getDictionary(946823533);
        if (CIDToGID != null) {
            CMapName = this.handleCIDToGID(CMapName, CIDToGID);
        }
        if ((CIDSystemInfo = Descendent.getDictionary(1972801240)) != null && (ordering = CIDSystemInfo.getTextStreamValue(1635480172)) != null) {
            this.handleOrdering(CMapName, FontDescriptor, CIDToGID, ordering);
        }
        if (FontDescriptor != null) {
            this.setBoundsAndMatrix(FontDescriptor);
            this.setName(FontDescriptor);
        }
    }

    private static int findUnicodeSpaceEntry(String[] toUnicodeArray) {
        for (int i2 = 0; i2 != toUnicodeArray.length; ++i2) {
            if (!" ".equals(toUnicodeArray[i2])) continue;
            return i2;
        }
        return -1;
    }

    private void handleOrdering(String CMapName, PdfObject fontDescriptor, PdfObject CIDToGID, String ordering) {
        this.isCIDIdentity = ordering.contains("Identity");
        boolean bl2 = this.hasCIDSet = fontDescriptor != null && fontDescriptor.getDictionary(337856605) != null;
        if (CIDToGID == null && this.isCIDIdentity) {
            if (CMapName == null && this.ToUnicode == null) {
                this.hasExtractionValues = false;
            }
        } else if (this.hasCIDSet && ordering.contains("CNS1")) {
            this.hasDoubleBytes = true;
        } else if (ordering.contains("Japan")) {
            this.TTstreamisCID = false;
        } else if ("Identity".equals(ordering) && (CMapName == null || CMapName.contains("Ident"))) {
            this.glyphs.setIsIdentity(true);
        }
        if (this.substituteFontFile != null) {
            LogWriter.writeLog("Using font " + this.substituteFontFile + " for " + ordering);
        }
    }

    private String handleCIDToGID(String CMapName, PdfObject CIDToGID) {
        byte[] stream = this.currentPdfFile.readStream(CIDToGID, true, true, false, false, false, null);
        if (stream != null) {
            int j2 = 0;
            int count = stream.length;
            this.CIDToGIDMap = new int[count / 2];
            Arrays.fill(this.CIDToGIDMap, -1);
            for (int i2 = 0; i2 < count; i2 += 2) {
                this.CIDToGIDMap[j2] = ((stream[i2] & 0xFF) << 8) + (stream[i2 + 1] & 0xFF);
                ++j2;
            }
            this.glyphs.setCIDtoGID(this.CIDToGIDMap);
        } else if (CIDToGID.getNameAsConstant(946823533) == -1) {
            CMapName = this.handleCIDEncoding(new FontObject(2038913669), null);
        }
        return CMapName;
    }

    private void setWidths(PdfObject Descendent, PdfObject FontDescriptor) {
        int Width;
        Object[] verticalWidths;
        int[] dw2;
        Object[] widths = Descendent.getObjectArray(39);
        if (this.isFontVertical) {
            this.vMatrix = new float[65536][3];
            for (int i2 = 0; i2 < 65536; ++i2) {
                this.vMatrix[i2][0] = 0.88f;
                this.vMatrix[i2][1] = -1.0f;
            }
        }
        if ((dw2 = Descendent.getIntArray(1320706)) != null) {
            this.setFontDW2(dw2);
        }
        if ((verticalWidths = Descendent.getObjectArray(9986)) != null) {
            this.setCIDFontW2(verticalWidths);
        }
        if (widths != null) {
            int Flags2;
            this.setCIDFontWidths(widths);
            this.defaultWidth = 1.0f;
            if (FontDescriptor != null && ((Flags2 = FontDescriptor.getInt(1009858393)) & 1) == 1) {
                this.defaultWidth = this.widthTable[0];
            }
        }
        if ((Width = Descendent.getInt(5159)) >= 0) {
            this.defaultWidth = (float)Width / 1000.0f;
        }
        if (this.handleOddSapFontMapping) {
            this.defaultWidth = 0.5f;
        }
        if (FontDescriptor != null) {
            this.missingWidth = FontDescriptor.getInt(-1884569950);
            if (this.defaultWidth == -1.0f) {
                int AvgWidth = FontDescriptor.getInt(1249540959);
                if (AvgWidth != -1) {
                    this.defaultWidth = 1.0f;
                }
            } else if (this.isCIDFont) {
                this.missingWidth = Width;
            }
            if (this.defaultWidth == -1.0f) {
                this.defaultWidth = 1.0f;
            }
        }
    }

    void readWidths(PdfObject pdfObject, boolean setSpace) {
        float shortestWidth = 0.0f;
        int count = 0;
        float[] floatWidthValues = pdfObject.getFloatArray(876896124);
        if (floatWidthValues != null && floatWidthValues.length > 0) {
            this.widthTable = new float[this.maxCharCount];
            for (int ii = 0; ii < this.maxCharCount; ++ii) {
                this.widthTable[ii] = -1.0f;
            }
            int firstCharNumber = pdfObject.getInt(1283093660);
            int lastCharNumber = pdfObject.getInt(795440262);
            float ratio = (float)(1.0 / this.FontMatrix[0]);
            if (ratio < 0.0f) {
                ratio = -ratio;
            }
            int j2 = 0;
            int widthCount = floatWidthValues.length;
            for (int i2 = firstCharNumber; i2 < lastCharNumber + 1; ++i2) {
                if (j2 < widthCount) {
                    float nextValue = floatWidthValues[j2];
                    float widthValue = this.fontTypes == 1228944679 ? nextValue / ratio : nextValue * 0.001f;
                    if (widthValue > 0.0f) {
                        shortestWidth += widthValue;
                        ++count;
                    }
                    this.widthTable[i2] = widthValue;
                } else {
                    this.widthTable[i2] = 0.0f;
                }
                ++j2;
            }
        }
        if (setSpace && count > 0) {
            this.possibleSpaceWidth = shortestWidth / (float)(2 * count);
        }
    }

    public void createFont(PdfObject pdfObject, String fontID, boolean renderPage) {
        this.init(fontID, renderPage);
        PdfObject pdfFontDescriptor = pdfObject.getDictionary(-1044665361);
        this.setName(pdfObject);
        this.setEncoding(pdfObject, pdfFontDescriptor);
    }

    void setName(PdfObject pdfObject) {
        String baseFontName = pdfObject.getName(678461817);
        if (baseFontName == null) {
            baseFontName = pdfObject.getName(879786873);
        }
        if (baseFontName == null) {
            baseFontName = this.fontID;
        }
        if (baseFontName.contains("#20")) {
            baseFontName = StringUtils.convertHexChars(baseFontName);
        }
        this.glyphs.setBaseFontName(baseFontName);
        this.objID = PdfFont.chooseObjID(pdfObject);
        this.glyphs.setObjID(this.objID);
        this.truncatedName = pdfObject.getStringValue(678461817, 2);
        if (this.truncatedName == null) {
            this.truncatedName = pdfObject.getStringValue(879786873, 2);
        }
        if (this.truncatedName == null) {
            this.truncatedName = this.fontID;
        }
        if (this.truncatedName.contains("#20") || this.truncatedName.contains("#2D")) {
            this.truncatedName = StringUtils.convertHexChars(this.truncatedName);
        }
        this.glyphs.fontName = this.truncatedName;
        if (this.truncatedName != null) {
            switch (this.truncatedName) {
                case "Arial-BoldMT": {
                    this.glyphs.logicalfontName = "Arial,Bold";
                    StandardFonts.loadStandardFontWidth(this.glyphs.logicalfontName);
                    break;
                }
                case "ArialMT": {
                    this.glyphs.logicalfontName = "Arial";
                    StandardFonts.loadStandardFontWidth(this.glyphs.logicalfontName);
                    break;
                }
                default: {
                    this.glyphs.logicalfontName = this.truncatedName;
                }
            }
        }
    }

    protected static PdfObject getEmbeddedFontFile(PdfObject fontDescriptor) {
        PdfObject fontFile = fontDescriptor.getDictionary(746093177);
        fontFile = fontFile == null ? fontDescriptor.getDictionary(2021292334) : fontFile;
        fontFile = fontFile == null ? fontDescriptor.getDictionary(2021292335) : fontFile;
        return fontFile;
    }

    private static int chooseObjID(PdfObject pdfObject) {
        PdfObject fontFile;
        PdfObject fontDescriptor = pdfObject.getDictionary(-1044665361);
        PdfObject baseObject = pdfObject;
        if (fontDescriptor != null) {
            baseObject = fontDescriptor;
        }
        if ((fontFile = PdfFont.getEmbeddedFontFile(baseObject)) != null) {
            return fontFile.getObjectRefID();
        }
        return baseObject.getObjectRefID();
    }

    public void resetNameForHTML(String newName) {
        this.glyphs.fontName = newName;
        this.glyphs.baseFontName = newName;
    }

    public int getObjID() {
        return this.objID;
    }

    void setEncoding(PdfObject pdfObject, PdfObject pdfFontDescriptor) {
        PdfObject Encoding;
        PdfObject ToUnicode = pdfObject.getDictionary(1919185554);
        if (ToUnicode != null) {
            this.unicodeMappings = new UnicodeReader(this.currentPdfFile.readStream(ToUnicode, true, true, false, false, false, ToUnicode.getCacheName(this.currentPdfFile.getObjectReader()))).readUnicode();
        }
        if ((Encoding = pdfObject.getDictionary(1232564598)) != null) {
            this.handleFontEncoding(pdfObject, Encoding);
        } else {
            this.handleNoEncoding(0, pdfObject);
        }
        if (pdfFontDescriptor != null) {
            this.missingWidth = pdfFontDescriptor.getInt(-1884569950);
        }
    }

    void setBoundsAndMatrix(PdfObject pdfFontDescriptor) {
        if (pdfFontDescriptor != null) {
            float[] newFontBBox;
            double[] newFontmatrix = pdfFontDescriptor.getDoubleArray(-2105119560);
            if (newFontmatrix != null) {
                this.FontMatrix = newFontmatrix;
            }
            if ((newFontBBox = pdfFontDescriptor.getFloatArray(676429196)) != null) {
                this.FontBBox = newFontBBox;
            }
        }
    }

    void init(String fontID, boolean renderPage) {
        this.fontID = fontID;
        this.renderPage = renderPage;
    }

    private int handleNoEncoding(int encValue, PdfObject pdfObject) {
        int enc = pdfObject.getGeneralType(1232564598);
        if (enc == 5 || !PdfFontFactory.isFontEmbedded(pdfObject) && "Wingdings".equals(this.getFontName())) {
            this.putFontEncoding(5);
            this.glyphs.defaultFont = "Zapf Dingbats";
            StandardFonts.checkLoaded(5);
            encValue = 5;
        } else if (enc == 4) {
            this.putFontEncoding(4);
            encValue = 4;
        } else {
            this.putFontEncoding(1);
        }
        this.hasEncoding = false;
        return encValue;
    }

    private void handleFontEncoding(PdfObject pdfObject, PdfObject Encoding) {
        PdfArrayIterator Diffs;
        int subType = pdfObject.getNameAsConstant(1147962727);
        int encValue = this.getFontEncoding(false);
        if (encValue == -1) {
            encValue = subType == 1217103210 ? 0 : 1;
        }
        if ((Diffs = Encoding.getMixedArray(1954328750)) != null && Diffs.getTokenCount() > 0) {
            this.handleDiffValues(Encoding, Diffs);
        }
        this.hasEncoding = true;
        int newEncodingType = Encoding.getGeneralType(1232564598);
        if (newEncodingType == -1) {
            newEncodingType = "ZapfDingbats".equals(this.getBaseFontName()) ? 5 : Encoding.getNameAsConstant(1537782955);
        }
        int EncodingType = newEncodingType != -1 ? newEncodingType : this.handleNoEncoding(encValue, pdfObject);
        if (this.spaceChar == -1 && (newEncodingType == 2 || newEncodingType == 6 || newEncodingType == 0)) {
            this.spaceChar = 32;
        }
        this.putFontEncoding(EncodingType);
    }

    private void handleDiffValues(PdfObject Encoding, PdfArrayIterator diffs) {
        this.glyphs.setIsSubsetted(true);
        byte[][] rawData = Encoding.getByteArray(1954328750);
        if (rawData != null) {
            boolean containsHexNumbers = true;
            boolean allNumbers = true;
            for (byte[] aRawData : rawData) {
                if (aRawData == null || aRawData[0] != 47) continue;
                int length = aRawData.length;
                if (containsHexNumbers) {
                    boolean bl2 = containsHexNumbers = length == 3 && PdfFont.isHex(aRawData[1], aRawData[2]);
                }
                if (!allNumbers || length >= 4) continue;
                allNumbers = PdfFont.isAllNumbers(aRawData, length);
            }
            this.readDiffValues(diffs, containsHexNumbers, allNumbers);
        }
    }

    private void readDiffValues(PdfArrayIterator diffs, boolean containsHexNumbers, boolean allNumbers) {
        int pointer = 0;
        while (diffs.hasMoreTokens()) {
            int type = diffs.getNextValueType();
            if (type == 1) {
                pointer = diffs.getNextValueAsInteger();
                continue;
            }
            if (type == 2) {
                if (this.diffCharTable == null) {
                    this.diffCharTable = new int[this.maxCharCount];
                }
                this.diffCharTable[pointer] = diffs.getNextValueAsInteger(false);
            }
            String rawKey = diffs.getNextValueAsString(false);
            this.rawDiffKeys.computeIfAbsent(rawKey.substring(1), k2 -> new HashSet());
            this.rawDiffKeys.get(rawKey.substring(1)).add(pointer);
            this.putMappedChar(pointer, diffs.getNextValueAsFontChar(pointer, containsHexNumbers, allNumbers));
            ++pointer;
        }
        this.isHex = diffs.hasHexChars();
        int spaceChar = diffs.getSpaceChar();
        if (spaceChar != -1) {
            this.spaceChar = spaceChar;
        }
    }

    private static boolean isAllNumbers(byte[] aRawData, int length) {
        for (int jj = 2; jj < length; ++jj) {
            byte c2 = aRawData[jj];
            if (c2 >= 48 && c2 <= 57) continue;
            return false;
        }
        return true;
    }

    private static boolean isHex(byte c0, byte c1) {
        return (c0 >= 48 && c0 <= 57 || c0 >= 65 && c0 <= 70) && (c1 >= 48 && c1 <= 57 || c1 >= 65 && c1 <= 70);
    }

    final void putMappedChar(int charInt, String mappedChar) {
        if (this.diffTable == null) {
            this.diffTable = new String[this.maxCharCount];
        }
        if (charInt < this.maxCharCount && this.diffTable[charInt] == null && mappedChar != null) {
            this.diffTable[charInt] = mappedChar;
        }
    }

    public String getDiffMapping(int charInt) {
        if (this.diffTable == null) {
            return null;
        }
        return this.diffTable[charInt];
    }

    public final String getMappedChar(int charInt, boolean remap) {
        String result = null;
        if (this.diffTable != null) {
            result = this.diffTable[charInt];
        }
        if (remap && ".notdef".equals(result)) {
            result = " ";
        }
        if (result == null && charInt < 335 && this.fontEnc < 7) {
            result = StandardFonts.getUnicodeChar(this.getFontEncoding(true), charInt);
        }
        if (result == null && charInt > 40 && this.getFontEncoding(true) == 2) {
            result = charInt == 173 ? "hyphen" : "bullet";
        }
        if (this.isFontEmbedded && result == null) {
            if (this.diffs != null) {
                result = this.diffs[charInt];
            }
            if (result == null && charInt < 335) {
                result = StandardFonts.getUnicodeChar(this.embeddedEnc, charInt);
            }
        }
        return result;
    }

    public final String getEmbeddedChar(int charInt) {
        String embeddedResult = null;
        if (this.isFontEmbedded) {
            if (this.diffs != null) {
                embeddedResult = this.diffs[charInt];
            }
            if (embeddedResult == null && charInt < 256) {
                embeddedResult = StandardFonts.getUnicodeChar(this.embeddedEnc, charInt);
            }
        }
        return embeddedResult;
    }

    public final int getFontType() {
        return this.fontTypes;
    }

    public float getGlyphWidth(String charGlyph, int rawInt) {
        float currentWidth = 0.0f;
        if (this.fontTypes == 1217103210 && this.isFontEmbedded) {
            currentWidth = this.glyphs.getTTWidth(charGlyph, rawInt, false);
        } else if (!this.isFontEmbedded) {
            if (rawInt < 255) {
                currentWidth = this.getWidth(rawInt);
            }
            if (currentWidth == 0.0f) {
                Float value = StandardFonts.getStandardWidth("Arial", charGlyph);
                currentWidth = value != null ? value.floatValue() : 0.0f;
            }
        }
        return currentWidth;
    }

    public PdfJavaGlyphs getGlyphData() {
        this.glyphs.setHasWidths(true);
        return this.glyphs;
    }

    public void setFont(String font, int textSize) {
        this.glyphs.setFont(font, textSize);
    }

    public boolean is1C() {
        return this.glyphs.is1C();
    }

    public boolean hasExtractionValues() {
        return this.hasExtractionValues;
    }

    public boolean isFontSubsetted() {
        return this.glyphs.isSubsetted;
    }

    public void setValuesForGlyph(int rawInt, String charGlyph, String displayValue, String embeddedChar) {
        this.glyphs.setValuesForGlyph(rawInt, charGlyph, displayValue, embeddedChar);
    }

    public Rectangle getBoundingBox() {
        float[] standardBB = StandardFonts.getFontBounds(this.getFontName());
        Rectangle BBox = standardBB == null ? (!this.isFontEmbedded ? new Rectangle(0, 0, 1000, 1000) : new Rectangle((int)this.FontBBox[0], (int)this.FontBBox[1], (int)(this.FontBBox[2] - this.FontBBox[0]), (int)(this.FontBBox[3] - this.FontBBox[1]))) : new Rectangle((int)standardBB[0], (int)standardBB[1], (int)(standardBB[2] - standardBB[0]), (int)(standardBB[3] - standardBB[1]));
        return BBox;
    }

    public void setRawFontName(String baseFont) {
        this.rawFontName = baseFont;
    }

    public static String getSpaces(float currentGap, float spaceWidth, float currentThreshold) {
        StringBuilder space = new StringBuilder();
        if (spaceWidth > 0.0f) {
            if (currentGap > spaceWidth && currentGap / spaceWidth < 300.0f && (currentThreshold < 1.0f || currentGap > spaceWidth * currentThreshold)) {
                while (currentGap >= spaceWidth) {
                    space.insert(0, ' ');
                    currentGap -= spaceWidth;
                }
            } else if (currentGap > spaceWidth * currentThreshold) {
                space.append(' ');
            }
        }
        return space.toString();
    }

    public int getDiffChar(int index) {
        if (this.diffCharTable == null) {
            return 0;
        }
        return this.diffCharTable[index];
    }

    public float[] getFontBounds() {
        return this.FontBBox;
    }

    public boolean isFontVertical() {
        return this.isFontVertical;
    }

    public void setLastWidth(float lastWidth) {
        this.lastWidth = lastWidth;
    }

    public boolean isSingleByte() {
        return this.isSingleByte;
    }

    public boolean isBrokenFont() {
        return this.handleOddSapFontMapping;
    }

    public boolean hasToUnicode() {
        return this.unicodeMappings != null;
    }

    public float getDefaultWidth(int idx) {
        if (idx == -1) {
            return this.defaultWidth;
        }
        if (this.widthTable == null) {
            return -1.0f;
        }
        return this.widthTable[idx];
    }

    public int isDoubleBytes(int firstVal, int secondByte, boolean secondByteIsEscaped) {
        if (this.hasDoubleBytes) {
            return 1;
        }
        if (this.isFirstScan) {
            this.isDouble = firstVal == secondByte && firstVal > 0 || !this.isHex && secondByte == 41 && !secondByteIsEscaped || this.getMappedChar(firstVal, true) != null && this.getMappedChar(secondByte, true) != null ? 0 : 1;
            this.isFirstScan = false;
        }
        return this.isDouble;
    }

    public int isDoubleBytes() {
        return this.isDouble;
    }

    public PdfObject getToUnicode() {
        return this.ToUnicode;
    }

    public int[] getCIDToGIDMap() {
        return this.CIDToGIDMap;
    }

    public int getEncodedCMAPValue(int ptr) {
        if (this.rawCMAP == null || ptr > this.rawCMAP.length) {
            return -1;
        }
        return this.rawCMAP[ptr];
    }

    public String[] getCMAP() {
        return this.CMAP;
    }

    public void setFallbackFont(FallbackFont fallbackFont) {
        this.fallbackFont = fallbackFont;
    }

    public FallbackFont getFallbackFont() {
        return this.fallbackFont;
    }

    public void setSource(FontSource source) {
        this.source = source;
    }

    public FontSource getSource() {
        return this.source;
    }

    static {
        PdfFont.setStandardFontMappings();
    }
}

