/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts;

import java.awt.GraphicsEnvironment;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import org.jpedal.exception.PdfFontException;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.io.ObjectStore;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.parser.FallbackFont;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;

public final class FontMappings {
    public static boolean fontsInitialised;
    public static String defaultFont;
    public static Map<String, String> fontSubstitutionTable;
    public static Map<String, String> fontPropertiesTable;
    public static Map<String, Integer> fontPropertiesTableType;
    public static Map<String, String> fontPropertiesTablePath;
    private static Map<String, String> fontPossDuplicates;
    public static Map<String, Integer> fontSubstitutionFontID;
    public static Map<String, String> fontSubstitutionLocation;
    public static Map<String, String> fontSubstitutionAliasTable;
    private static boolean fontsSet;
    private static final String separator;
    public static String[] defaultFontDirs;
    private static int fontSubstitutionMode;

    private FontMappings() {
    }

    public static void initFonts() {
        try {
            String fontMaps = System.getProperty("org.jpedal.fontmaps");
            if (fontMaps != null) {
                StringTokenizer fontPaths = new StringTokenizer(fontMaps, ",");
                while (fontPaths.hasMoreTokens()) {
                    String fontPath = fontPaths.nextToken();
                    StringTokenizer values = new StringTokenizer(fontPath, "=:");
                    int count = values.countTokens() - 1;
                    String[] nameInPDF = new String[count];
                    String key = values.nextToken();
                    for (int i2 = 0; i2 < count; ++i2) {
                        nameInPDF[i2] = values.nextToken();
                    }
                    FontMappings.setSubstitutedFontAliases(key, nameInPDF);
                }
            }
        }
        catch (Exception e2) {
            LogWriter.writeLog("Unable to read org.jpedal.fontmaps " + e2.getMessage());
        }
        try {
            String fontDirs = System.getProperty("org.jpedal.fontdirs");
            if (fontDirs != null) {
                FontMappings.addFonts(fontDirs);
            }
        }
        catch (Exception e3) {
            LogWriter.writeLog("Unable to read FontDirs " + e3.getMessage());
        }
    }

    public static void addFallBackFont(FallbackFont fallbackFont) {
        FontMappings.checkFontTablesInitialised();
        String fontName = fallbackFont.getName();
        String rawPath = "/org/jpedal/res/" + fallbackFont.getPath() + '/' + fontName + ".ttf";
        String outPath = ObjectStore.temp_dir + fontName + ".ttf";
        URL inUrl = FontMappings.class.getResource(rawPath);
        File outFile = new File(outPath);
        try {
            boolean isAlreadyStored;
            boolean bl2 = isAlreadyStored = outFile.exists() && inUrl != null && (long)inUrl.openConnection().getContentLength() == outFile.length();
            if (!isAlreadyStored) {
                InputStream url = FontMappings.class.getResourceAsStream(rawPath);
                BufferedOutputStream to = new BufferedOutputStream(new FileOutputStream(outPath));
                ObjectStore.copy(url, to);
                to.close();
            }
            fontSubstitutionTable.put(fontName, "/TrueType");
            fontSubstitutionLocation.put(fontName, outPath);
            fontPropertiesTableType.put(fontName, 1217103210);
            fontPropertiesTablePath.put(fontName, outPath);
        }
        catch (IOException e2) {
            LogWriter.writeLog("[PDF] Exception writing fallback font " + e2);
        }
    }

    public static void setFontSubstitutionMode(int mode) {
        fontSubstitutionMode = mode;
    }

    public static int getFontSubstitutionMode() {
        return fontSubstitutionMode;
    }

    public static void setSubstitutedFontAliases(String fontFileName, String[] aliases) {
        if (aliases != null) {
            String name = fontFileName.toLowerCase();
            for (String aliase : aliases) {
                if (aliase.equalsIgnoreCase(name)) continue;
                fontSubstitutionAliasTable.put(aliase.toLowerCase(), name);
            }
        }
    }

    private static void addFonts(String fontDirs) {
        StringTokenizer fontPaths = new StringTokenizer(fontDirs, ",");
        while (fontPaths.hasMoreTokens()) {
            String fontPath = fontPaths.nextToken();
            if (!fontPath.endsWith("/") && !fontPath.endsWith("\\")) {
                fontPath = fontPath + separator;
            }
            FontMappings.addTTDir(fontPath);
        }
    }

    public static void dispose() {
        fontSubstitutionTable = null;
        fontPropertiesTable = null;
        fontPropertiesTableType = null;
        fontPropertiesTablePath = null;
        fontPossDuplicates = null;
        fontSubstitutionFontID = null;
        fontSubstitutionLocation = null;
        fontSubstitutionAliasTable = null;
    }

    private static void addTTDir(String fontPath) {
        String[] files;
        FontMappings.checkFontTablesInitialised();
        File currentDir = new File(fontPath);
        if (currentDir.exists() && currentDir.isDirectory() && (files = currentDir.list()) != null) {
            for (String currentFont : files) {
                FontMappings.addFontFile(currentFont, fontPath);
            }
        }
    }

    public static void setFontReplacements() {
        String[] aliases6 = new String[]{"acarialunicodems__cn"};
        FontMappings.setSubstitutedFontAliases("adobeheitistd-regular", aliases6);
        if (DecoderOptions.isRunningOnMac) {
            FontMappings.setSubstitutedFontAliases("Courier italic", new String[]{"Courier-Oblique"});
            FontMappings.setSubstitutedFontAliases("Courier bold", new String[]{"Courier-Bold"});
            FontMappings.setSubstitutedFontAliases("Courier bold italic", new String[]{"Courier-BoldOblique"});
            FontMappings.setSubstitutedFontAliases("Courier new italic", new String[]{"CourierNew,italic", "CourierStd-Oblique", "CourierNewPS-ItalicMT"});
            FontMappings.setSubstitutedFontAliases("Courier new bold", new String[]{"CourierNew,Bold", "Courier-Bold", "CourierStd-Bold", "CourierNewPS-BoldMT", "CourierPS-Bold"});
            FontMappings.setSubstitutedFontAliases("Courier new bold italic", new String[]{"CourierNew-BoldOblique", "CourierStd-BoldOblique", "CourierNewPS-BoldItalicMT"});
            FontMappings.setSubstitutedFontAliases("Courier new", new String[]{"CourierNew", "Courier", "CourierStd", "CourierNewPSMT", "CourierPS"});
            FontMappings.setSubstitutedFontAliases("arial", new String[]{"Helvetica", "arialmt", "ArialMTInsurity"});
            FontMappings.setSubstitutedFontAliases("arial italic", new String[]{"arial-italic", "arial-italicmt", "Helvetica-Oblique", "Arial,Italic"});
            FontMappings.setSubstitutedFontAliases("arial bold", new String[]{"arial-boldmt,bold", "arial-boldmt", "Helvetica-Bold", "Arial,bold", "ArialMTInsurity-bold"});
            FontMappings.setSubstitutedFontAliases("arial bold italic", new String[]{"Arial-BoldItalicMT", "Helvetica-BoldOblique"});
            FontMappings.setSubstitutedFontAliases("arial Narrow", new String[]{"ArialNarrow"});
            FontMappings.setSubstitutedFontAliases("arial Narrow italic", new String[]{"ArialNarrow-italic"});
            FontMappings.setSubstitutedFontAliases("arial Narrow bold", new String[]{"ArialNarrow-bold", "ArialNarrow,Bold"});
            FontMappings.setSubstitutedFontAliases("arial Narrow bold italic", new String[]{"ArialNarrow-bolditalic"});
            FontMappings.setSubstitutedFontAliases("times new roman bold", new String[]{"Times-Bold", "TimesNewRoman,Bold", "TimesNewRomanPS-BoldMT"});
            FontMappings.setSubstitutedFontAliases("times new roman bold italic", new String[]{"Times-BoldItalic", "TimesNewRoman,BoldItalic", "TimesNewRomanPS-BoldItalicMT"});
            FontMappings.setSubstitutedFontAliases("times new roman italic", new String[]{"Times-Italic", "TimesNewRoman,Italic", "TimesNewRomanPS-ItalicMT"});
            FontMappings.setSubstitutedFontAliases("times new roman", new String[]{"Times-Roman", "TimesNewRoman", "Times", "TimesNewRomanPSMT"});
            FontMappings.setSubstitutedFontAliases("wingdings", new String[]{"ZapfDingbats", "ZaDb"});
        } else {
            FontMappings.setSubstitutedFontAliases("Couri", new String[]{"Courier-Oblique", "CourierNew,italic", "CourierStd-Oblique", "CourierNewPS-ItalicMT"});
            FontMappings.setSubstitutedFontAliases("Courbd", new String[]{"Courier-Bold", "CourierNew,Bold", "CourierStd-Bold", "CourierNewPS-BoldMT", "CourierPS-Bold"});
            FontMappings.setSubstitutedFontAliases("Courbi", new String[]{"Courier-BoldOblique", "CourierNew-BoldOblique", "CourierStd-BoldOblique", "CourierNewPS-BoldItalicMT"});
            FontMappings.setSubstitutedFontAliases("Cour", new String[]{"CourierNew", "Courier", "CourierStd", "CourierNewPSMT", "CourierNewPSMT", "CourierPS"});
            FontMappings.setSubstitutedFontAliases("arial", new String[]{"Helvetica", "arialmt", "ArialMTInsurity"});
            FontMappings.setSubstitutedFontAliases("arialn", new String[]{"ArialNarrow", "acisansnarrow"});
            FontMappings.setSubstitutedFontAliases("ariali", new String[]{"arial-italic", "arial-italicmt", "Helvetica-Oblique", "Arial,Italic", "ArialNarrow-Italic"});
            FontMappings.setSubstitutedFontAliases("arialbd", new String[]{"arial-boldmt,bold", "arial-boldmt", "Helvetica-Bold", "Arial,bold", "arial bold", "ArialNarrow-Bold", "ArialMTInsurity-bold"});
            FontMappings.setSubstitutedFontAliases("arialbi", new String[]{"Arial-BoldItalicMT", "Helvetica-BoldOblique", "ArialNarrow-BoldItalic"});
            FontMappings.setSubstitutedFontAliases("timesbd", new String[]{"Times-Bold", "TimesNewRoman,Bold", "TimesNewRomanPS-BoldMT"});
            FontMappings.setSubstitutedFontAliases("timesbi", new String[]{"Times-BoldItalic", "TimesNewRoman,BoldItalic", "TimesNewRomanPS-BoldItalicMT"});
            FontMappings.setSubstitutedFontAliases("timesi", new String[]{"Times-Italic", "TimesNewRoman,Italic", "TimesNewRomanPS-ItalicMT"});
            FontMappings.setSubstitutedFontAliases("times", new String[]{"Times-Roman", "TimesNewRoman", "Times", "TimesNewRomanPSMT"});
            FontMappings.setSubstitutedFontAliases("wingdings", new String[]{"ZapfDingbats", "ZaDb"});
        }
        FontMappings.setSubstitutedFontAliases("AdobeSongStd-Light", new String[]{"STSong-Light"});
        if (!fontsSet) {
            String[] subdirs;
            File adobeFonts;
            fontsSet = true;
            FontMappings.setFontDirs(defaultFontDirs);
            if (DecoderOptions.isRunningOnWindows && (adobeFonts = new File("C:\\Program Files\\Adobe\\")).exists() && (subdirs = adobeFonts.list()) != null) {
                for (String path : subdirs) {
                    String adobePath = "C:\\Program Files\\Adobe\\" + path + "\\Resource\\CIDFont";
                    File testAdobe = new File(adobePath);
                    if (!testAdobe.exists()) continue;
                    FontMappings.addTTDir(adobePath);
                }
            }
        }
    }

    public static void setFontDirs(String[] fontDirs) {
        FontMappings.checkFontTablesInitialised();
        try {
            if (fontDirs == null) {
                LogWriter.writeLog("Null font parameter passed");
                fontSubstitutionAliasTable.clear();
                fontSubstitutionLocation.clear();
                fontSubstitutionTable.clear();
                fontSubstitutionFontID.clear();
                fontPossDuplicates.clear();
                fontPropertiesTable.clear();
                fontPropertiesTableType.clear();
                fontPropertiesTablePath.clear();
                fontsSet = false;
            } else {
                for (String fontDir : fontDirs) {
                    String fontPath = fontDir;
                    if (!fontPath.endsWith("/") && !fontPath.endsWith("\\")) {
                        fontPath = fontPath + separator;
                    }
                    FontMappings.addTTDir(fontPath);
                }
            }
        }
        catch (Exception e2) {
            LogWriter.writeLog("Unable to run setFontDirs " + e2.getMessage());
        }
    }

    private static void checkFontTablesInitialised() {
        if (fontSubstitutionTable == null) {
            fontSubstitutionTable = new ConcurrentHashMap<String, String>();
            fontSubstitutionFontID = new ConcurrentHashMap<String, Integer>();
            fontPossDuplicates = new ConcurrentHashMap<String, String>();
            fontPropertiesTable = new ConcurrentHashMap<String, String>();
            fontPropertiesTableType = new ConcurrentHashMap<String, Integer>();
            fontPropertiesTablePath = new ConcurrentHashMap<String, String>();
        }
    }

    private static void addFontFile(String currentFont, String fontPath) {
        String name;
        int type;
        FontMappings.checkFontTablesInitialised();
        if (fontPath != null && !fontPath.endsWith("/") && !fontPath.endsWith("\\")) {
            fontPath = fontPath + separator;
        }
        if ((type = StandardFonts.getFontType(name = currentFont.toLowerCase())) != 8 && new File(fontPath + currentFont).exists()) {
            String fontName = FontMappings.getFontName(currentFont);
            if (fontSubstitutionMode == 1 || type == 1133081971) {
                FontMappings.useFileName(currentFont, fontPath, type, fontName);
            } else if (type == 7 || type == 1217103210) {
                if (fontSubstitutionMode == 5) {
                    FontMappings.usePSName(currentFont, fontPath, type, fontName);
                } else {
                    FontMappings.useFontName(currentFont, fontPath, fontName, type, "/TrueType");
                }
            } else if (type == 1228944677) {
                FontMappings.useFontName(currentFont, fontPath, fontName, 1228944677, "/Type1");
            }
        }
    }

    private static void useFontName(String currentFont, String fontPath, String fontName, int type1, String s2) {
        String[] fontNames = null;
        try {
            fontNames = StandardFonts.readNamesFromFont(type1, fontPath + currentFont, fontSubstitutionMode);
        }
        catch (Exception e2) {
            LogWriter.writeLog("Exception: " + e2.getMessage());
        }
        if (fontNames != null) {
            for (int i2 = 0; i2 < fontNames.length; ++i2) {
                if (fontNames[i2] == null) {
                    fontNames[i2] = Strip.stripAllSpaces(fontName);
                }
                fontSubstitutionTable.put(fontNames[i2], s2);
                fontSubstitutionLocation.put(fontNames[i2], fontPath + currentFont);
                fontSubstitutionFontID.put(fontNames[i2], i2);
                fontPropertiesTableType.put(fontNames[i2], type1);
                fontPropertiesTablePath.put(fontNames[i2], fontPath + currentFont);
            }
        }
    }

    private static void usePSName(String currentFont, String fontPath, int type, String fontName) {
        String[] postscriptNames = null;
        try {
            postscriptNames = StandardFonts.readNamesFromFont(type, fontPath + currentFont, 2);
        }
        catch (Exception e2) {
            LogWriter.writeLog("Exception: " + e2.getMessage());
        }
        String[] familyNames = null;
        try {
            familyNames = StandardFonts.readNamesFromFont(type, fontPath + currentFont, 3);
        }
        catch (Exception e3) {
            LogWriter.writeLog("Exception: " + e3.getMessage());
        }
        int fontCount = 0;
        if (postscriptNames != null) {
            fontCount = postscriptNames.length;
        }
        for (int ii = 0; ii < fontCount; ++ii) {
            boolean hasFamilyName;
            if (postscriptNames[ii] == null) {
                postscriptNames[ii] = Strip.stripAllSpaces(fontName);
            }
            boolean bl2 = hasFamilyName = familyNames != null && familyNames[ii] != null;
            if (hasFamilyName) {
                familyNames[ii] = Strip.stripAllSpaces(fontName);
            }
            String fontSubValue = fontSubstitutionTable.get(postscriptNames[ii]);
            String possDuplicate = fontPossDuplicates.get(postscriptNames[ii]);
            if (fontSubValue == null && possDuplicate == null) {
                fontSubstitutionTable.put(postscriptNames[ii], "/TrueType");
                fontSubstitutionLocation.put(postscriptNames[ii], fontPath + currentFont);
                fontSubstitutionFontID.put(postscriptNames[ii], ii);
                if (!hasFamilyName) continue;
                fontPossDuplicates.put(postscriptNames[ii], familyNames[ii]);
                continue;
            }
            if (familyNames == null || familyNames[ii].equals(postscriptNames[ii])) continue;
            fontSubstitutionTable.put(postscriptNames[ii], "/TrueType");
            fontSubstitutionLocation.put(postscriptNames[ii], fontPath + currentFont);
            fontSubstitutionFontID.put(postscriptNames[ii], ii);
            fontPropertiesTableType.put(postscriptNames[ii], type);
            fontPropertiesTablePath.put(postscriptNames[ii], fontPath + currentFont);
            if ("DONE".equals(possDuplicate)) continue;
            fontPossDuplicates.put(postscriptNames[ii], "DONE");
            fontSubstitutionTable.remove(postscriptNames[ii]);
            fontSubstitutionTable.put(familyNames[ii], "/TrueType");
            String font = fontSubstitutionLocation.get(postscriptNames[ii]);
            fontSubstitutionLocation.remove(postscriptNames[ii]);
            fontSubstitutionLocation.put(familyNames[ii], font);
            fontSubstitutionFontID.remove(postscriptNames[ii]);
            fontSubstitutionFontID.put(familyNames[ii], ii);
            fontPropertiesTablePath.remove(familyNames[ii]);
            fontPropertiesTableType.remove(familyNames[ii]);
            fontPropertiesTableType.put(familyNames[ii], type);
            fontPropertiesTablePath.put(familyNames[ii], fontPath + currentFont);
        }
    }

    private static void useFileName(String currentFont, String fontPath, int type, String fontName) {
        if (type == 1228944677) {
            fontSubstitutionTable.put(fontName, "/Type1");
        } else {
            fontSubstitutionTable.put(fontName, "/TrueType");
        }
        fontSubstitutionLocation.put(fontName, fontPath + currentFont);
        fontPropertiesTableType.put(fontName, type);
        fontPropertiesTablePath.put(fontName, fontPath + currentFont);
    }

    private static String getFontName(String currentFont) {
        int pointer = currentFont.indexOf(46);
        String fontName = pointer == -1 ? currentFont.toLowerCase() : currentFont.substring(0, pointer).toLowerCase();
        return fontName;
    }

    public static void setDefaultDisplayFont(String fontName) throws PdfFontException {
        boolean isFontInstalled = false;
        String[] fontList = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        int count = fontList.length;
        for (int i2 = 0; i2 < count; ++i2) {
            if (!fontList[i2].equalsIgnoreCase(fontName)) continue;
            isFontInstalled = true;
            defaultFont = fontList[i2];
            i2 = count;
        }
        if (!isFontInstalled) {
            throw new PdfFontException("Font " + fontName + " is not available.");
        }
    }

    static {
        fontSubstitutionLocation = new ConcurrentHashMap<String, String>();
        fontSubstitutionAliasTable = new ConcurrentHashMap<String, String>();
        separator = System.getProperty("file.separator");
        defaultFontDirs = new String[]{"C:/windows/fonts/", "C:/winNT/fonts/", "/Library/Fonts/", "/System/Library/Fonts/Supplemental/", "/usr/share/fonts/truetype/msttcorefonts/", "usr/local/Fonts/"};
        fontSubstitutionMode = 1;
    }
}

