/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.zip.Inflater;
import org.jpedal.fonts.CmapSpec;
import org.jpedal.utils.LogWriter;

public class CodeSpaceRange {
    private static final String[] ALL_CMAPS = new String[]{"Adobe-CNS1-0", "0,14335", "2", "CNS", "Adobe-CNS1-1", "0,17407", "2", "CNS", "Adobe-CNS1-2", "0,17663", "2", "CNS", "Adobe-CNS1-3", "0,18943", "2", "CNS", "Adobe-CNS1-4", "0,19199", "2", "CNS", "Adobe-CNS1-5", "0,19199", "2", "CNS", "Adobe-CNS1-6", "0,19199", "2", "CNS", "Adobe-CNS1-UCS2", "0,65535", "2", "CNS", "B5-H", "0,128,41280,65278", "1,2", "CNS", "B5-V", "0,128,41280,65278", "1,2", "CNS", "B5pc-H", "0,128,41280,64766,253,255", "1,2", "CNS", "B5pc-V", "0,128,41280,64766,253,255", "1,2", "CNS", "CNS-EUC-H", "0,128,2392957345,2392981246,2393022881,2393046782,2393088417,2393112318,41377,65278", "1,2,4", "CNS", "CNS-EUC-V", "0,128,2392957345,2392981246,2393022881,2393046782,2393088417,2393112318,41377,65278", "1,2,4", "CNS", "CNS1-H", "8481,32382", "2", "CNS", "CNS1-V", "8481,32382", "2", "CNS", "CNS2-H", "8481,32382", "2", "CNS", "CNS2-V", "8481,32382", "2", "CNS", "ETen-B5-H", "0,128,41280,65278", "1,2", "CNS", "ETen-B5-V", "0,128,41280,65278", "1,2", "CNS", "ETenms-B5-H", "0,65535", "2", "CNS", "ETenms-B5-V", "0,65535", "2", "CNS", "ETHK-B5-H", "0,128,34624,65278", "1,2", "CNS", "ETHK-B5-V", "0,128,34624,65278", "1,2", "CNS", "HKdla-B5-H", "0,128,41280,65278", "1,2", "CNS", "HKdla-B5-V", "0,128,41280,65278", "1,2", "CNS", "HKdlb-B5-H", "0,128,36416,65278", "1,2", "CNS", "HKdlb-B5-V", "0,128,36416,65278", "1,2", "CNS", "HKgccs-B5-H", "0,128,35392,65278", "1,2", "CNS", "HKgccs-B5-V", "0,128,35392,65278", "1,2", "CNS", "HKm314-B5-H", "0,128,41280,65278", "1,2", "CNS", "HKm314-B5-V", "0,128,41280,65278", "1,2", "CNS", "HKm471-B5-H", "0,128,41280,65278", "1,2", "CNS", "HKm471-B5-V", "0,128,41280,65278", "1,2", "CNS", "HKscs-B5-H", "0,128,34624,65278", "1,2", "CNS", "HKscs-B5-V", "0,128,34624,65278", "1,2", "CNS", "UniCNS-UCS2-H", "0,55295,57344,65535", "2", "CNS", "UniCNS-UCS2-V", "0,55295,57344,65535", "2", "CNS", "UniCNS-UTF16-H", "0,55295,3623934976,3690979327,57344,65535", "2,4", "CNS", "UniCNS-UTF16-V", "0,55295,3623934976,3690979327,57344,65535", "2,4", "CNS", "UniCNS-UTF32-H", "0,1114111", "4", "CNS", "UniCNS-UTF32-V", "0,1114111", "4", "CNS", "UniCNS-UTF8-H", "0,127,49280,57279,14712960,15712191,4034953344,4156538815", "1,2,3,4", "CNS", "UniCNS-UTF8-V", "0,127,49280,57279,14712960,15712191,4034953344,4156538815", "1,2,3,4", "CNS", "Adobe-GB1-0", "0,7935", "2", "GB", "Adobe-GB1-1", "0,9983", "2", "GB", "Adobe-GB1-2", "0,22271", "2", "GB", "Adobe-GB1-3", "0,22527", "2", "GB", "Adobe-GB1-4", "0,29183", "2", "GB", "Adobe-GB1-5", "0,30463", "2", "GB", "Adobe-GB1-UCS2", "0,65535", "2", "GB", "GB-EUC-H", "0,128,41377,65278", "1,2", "GB", "GB-EUC-V", "0,65535", "2", "GB", "GB-H", "8481,32382", "2", "GB", "GB-V", "8481,32382", "2", "GB", "GBK-EUC-H", "0,128,33088,65278", "1,2", "GB", "GBK-EUC-V", "0,128,33088,65278", "1,2", "GB", "GBK2K-H", "0,127,2167439664,4265213497,33088,65278", "1,2,4", "GB", "GBK2K-V", "0,127,2167439664,4265213497,33088,65278", "1,2,4", "GB", "GBKp-EUC-H", "0,128,33088,65278", "1,2", "GB", "GBKp-EUC-V", "0,128,33088,65278", "1,2", "GB", "GBpc-EUC-H", "0,128,41377,64766,253,255", "1,2", "GB", "GBpc-EUC-V", "0,128,41377,64766,253,255", "1,2", "GB", "GBT-EUC-H", "0,128,41377,65278", "1,2", "GB", "GBT-EUC-V", "0,128,41377,65278", "1,2", "GB", "GBT-H", "8481,32382", "2", "GB", "GBT-V", "8481,32382", "2", "GB", "GBTpc-EUC-H", "0,128,41377,64766,253,255", "1,2", "GB", "GBTpc-EUC-V", "0,128,41377,64766,253,255", "1,2", "GB", "UniGB-UCS2-H", "0,55295,57344,65535", "2", "GB", "UniGB-UCS2-V", "0,55295,57344,65535", "2", "GB", "UniGB-UTF16-H", "0,55295,3623934976,3690979327,57344,65535", "2,4", "GB", "UniGB-UTF16-V", "0,55295,3623934976,3690979327,57344,65535", "2,4", "GB", "UniGB-UTF32-H", "0,1114111", "4", "GB", "UniGB-UTF32-V", "0,1114111", "4", "GB", "UniGB-UTF8-H", "0,127,49280,57279,14712960,15712191,4034953344,4156538815", "1,2,3,4", "GB", "UniGB-UTF8-V", "0,127,49280,57279,14712960,15712191,4034953344,4156538815", "1,2,3,4", "GB", "78-EUC-H", "0,128,36512,36575,41377,65278", "1,2", "JAPAN", "78-EUC-V", "0,128,36512,36575,41377,65278", "1,2", "JAPAN", "78-H", "8481,32382", "2", "JAPAN", "78-RKSJ-H", "0,128,33088,40956,160,223,57408,64764", "1,2", "JAPAN", "78-RKSJ-V", "0,128,33088,40956,160,223,57408,64764", "1,2", "JAPAN", "78-V", "8481,32382", "2", "JAPAN", "78ms-RKSJ-H", "0,128,33088,40956,160,223,57408,64764", "1,2", "JAPAN", "78ms-RKSJ-V", "0,128,33088,40956,160,223,57408,64764", "1,2", "JAPAN", "83pv-RKSJ-H", "0,128,33088,40956,160,223,57408,64764,253,255", "1,2", "JAPAN", "90ms-RKSJ-H", "0,128,33088,40956,160,223,57408,64764", "1,2", "JAPAN", "90ms-RKSJ-V", "0,128,33088,40956,160,223,57408,64764", "1,2", "JAPAN", "90msp-RKSJ-H", "0,128,33088,40956,160,223,57408,64764", "1,2", "JAPAN", "90msp-RKSJ-V", "0,128,33088,40956,160,223,57408,64764", "1,2", "JAPAN", "90pv-RKSJ-H", "0,128,33088,40956,160,223,57408,64764,253,255", "1,2", "JAPAN", "90pv-RKSJ-V", "0,128,33088,40956,160,223,57408,64764,253,255", "1,2", "JAPAN", "Add-H", "8481,32382", "2", "JAPAN", "Add-RKSJ-H", "0,128,33088,40956,160,223,57408,64764", "1,2", "JAPAN", "Add-RKSJ-V", "0,128,33088,40956,160,223,57408,64764", "1,2", "JAPAN", "Add-V", "8481,32382", "2", "JAPAN", "Adobe-Japan1-0", "0,8447", "2", "JAPAN", "Adobe-Japan1-1", "0,8447", "2", "JAPAN", "Adobe-Japan1-2", "0,8959", "2", "JAPAN", "Adobe-Japan1-3", "0,9471", "2", "JAPAN", "Adobe-Japan1-4", "0,15615", "2", "JAPAN", "Adobe-Japan1-5", "0,20479", "2", "JAPAN", "Adobe-Japan1-6", "0,23295", "2", "JAPAN", "Adobe-Japan1-UCS2", "0,65535", "2", "JAPAN", "EUC-H", "0,128,36512,36575,41377,65278", "1,2", "JAPAN", "EUC-V", "0,128,36512,36575,41377,65278", "1,2", "JAPAN", "Ext-H", "8481,32382", "2", "JAPAN", "Ext-RKSJ-H", "0,128,33088,40956,160,223,57408,64764", "1,2", "JAPAN", "Ext-RKSJ-V", "0,128,33088,40956,160,223,57408,64764", "1,2", "JAPAN", "Ext-V", "8481,32382", "2", "JAPAN", "H", "8481,32382", "2", "JAPAN", "Hankaku", "0,255", "1", "JAPAN", "Hiragana", "0,255", "1", "JAPAN", "Katakana", "0,255", "1", "JAPAN", "NWP-H", "8481,32382", "2", "JAPAN", "NWP-V", "8481,32382", "2", "JAPAN", "RKSJ-H", "0,128,33088,40956,160,223,57408,64764", "1,2", "JAPAN", "RKSJ-V", "0,128,33088,40956,160,223,57408,64764", "1,2", "JAPAN", "Roman", "0,255", "1", "JAPAN", "UniJIS-UCS2-H", "0,55295,57344,65535", "2", "JAPAN", "UniJIS-UCS2-HW-H", "0,65535", "2", "JAPAN", "UniJIS-UCS2-HW-V", "0,65535", "2", "JAPAN", "UniJIS-UCS2-V", "0,55295,57344,65535", "2", "JAPAN", "UniJIS-UTF16-H", "0,55295,3623934976,3690979327,57344,65535", "2,4", "JAPAN", "UniJIS-UTF16-V", "0,55295,3623934976,3690979327,57344,65535", "2,4", "JAPAN", "UniJIS-UTF32-H", "0,1114111", "4", "JAPAN", "UniJIS-UTF32-V", "0,1114111", "4", "JAPAN", "UniJIS-UTF8-H", "0,127,49280,57279,14712960,15712191,4034953344,4156538815", "1,2,3,4", "JAPAN", "UniJIS-UTF8-V", "0,127,49280,57279,14712960,15712191,4034953344,4156538815", "1,2,3,4", "JAPAN", "UniJIS2004-UTF16-H", "0,55295,3623934976,3690979327,57344,65535", "2,4", "JAPAN", "UniJIS2004-UTF16-V", "0,55295,3623934976,3690979327,57344,65535", "2,4", "JAPAN", "UniJIS2004-UTF32-H", "0,1114111", "4", "JAPAN", "UniJIS2004-UTF32-V", "0,1114111", "4", "JAPAN", "UniJIS2004-UTF8-H", "0,127,49280,57279,14712960,15712191,4034953344,4156538815", "1,2,3,4", "JAPAN", "UniJIS2004-UTF8-V", "0,65535", "2", "JAPAN", "UniJISPro-UCS2-HW-V", "0,65535", "2", "JAPAN", "UniJISPro-UCS2-V", "0,65535", "2", "JAPAN", "UniJISPro-UTF8-V", "0,127,49280,57279,14712960,15712191,4034953344,4156538815", "1,2,3,4", "JAPAN", "UniJISX0213-UTF32-H", "0,1114111", "4", "JAPAN", "UniJISX0213-UTF32-V", "0,1114111", "4", "JAPAN", "UniJISX02132004-UTF32-H", "0,1114111", "4", "JAPAN", "UniJISX02132004-UTF32-V", "0,1114111", "4", "JAPAN", "V", "8481,32382", "2", "JAPAN", "WP-Symbol", "0,255", "1", "JAPAN", "Adobe-Korea1-0", "0,9471", "2", "KOREA", "Adobe-Korea1-1", "0,18175", "2", "KOREA", "Adobe-Korea1-2", "0,18431", "2", "KOREA", "Adobe-Korea1-UCS2", "0,65535", "2", "KOREA", "KSC-EUC-H", "0,128,41377,65278", "1,2", "KOREA", "KSC-EUC-V", "0,128,41377,65278", "1,2", "KOREA", "KSC-H", "8481,32382", "2", "KOREA", "KSC-Johab-H", "0,128,33857,54270,55345,57086,57393,63998", "1,2", "KOREA", "KSC-Johab-V", "0,128,33857,54270,55345,57086,57393,63998", "1,2", "KOREA", "KSC-V", "8481,32382", "2", "KOREA", "KSCms-UHC-H", "0,128,33089,65278", "1,2", "KOREA", "KSCms-UHC-HW-H", "0,128,33089,65278", "1,2", "KOREA", "KSCms-UHC-HW-V", "0,128,33089,65278", "1,2", "KOREA", "KSCms-UHC-V", "0,128,33089,65278", "1,2", "KOREA", "KSCpc-EUC-H", "0,132,41281,65022,254,255", "1,2", "KOREA", "KSCpc-EUC-V", "0,132,41281,65022,254,255", "1,2", "KOREA", "UniKS-UCS2-H", "0,55295,57344,65535", "2", "KOREA", "UniKS-UCS2-V", "0,55295,57344,65535", "2", "KOREA", "UniKS-UTF16-H", "0,55295,3623934976,3690979327,57344,65535", "2,4", "KOREA", "UniKS-UTF16-V", "0,55295,3623934976,3690979327,57344,65535", "2,4", "KOREA", "UniKS-UTF32-H", "0,1114111", "4", "KOREA", "UniKS-UTF32-V", "0,1114111", "4", "KOREA", "UniKS-UTF8-H", "0,127,49280,57279,14712960,15712191,4034953344,4156538815", "1,2,3,4", "KOREA", "UniKS-UTF8-V", "0,127,49280,57279,14712960,15712191,4034953344,4156538815", "1,2,3,4", "KOREA"};
    private final boolean[] bps = new boolean[8];
    private long[] range;
    public final int[] uniMap = new int[65536];
    public final int[] cidMap = new int[65536];
    public boolean hasEncoding;

    public CodeSpaceRange(String name) {
        int len = ALL_CMAPS.length;
        for (int i2 = 0; i2 < len; i2 += 4) {
            if (!ALL_CMAPS[i2].equals(name)) continue;
            String[] temp = ALL_CMAPS[i2 + 1].split(",");
            this.range = new long[temp.length];
            for (int j2 = 0; j2 < temp.length; ++j2) {
                this.range[j2] = Long.parseLong(temp[j2]);
            }
            for (String temp1 : temp = ALL_CMAPS[i2 + 2].split(",")) {
                this.bps[Integer.parseInt((String)temp1)] = true;
            }
            String enc = ALL_CMAPS[i2 + 3];
            this.updateUnicode(enc);
            if (name.endsWith("V")) {
                String cmap = name.substring(0, name.length() - 1) + 'H';
                this.updateCMAP(cmap);
            }
            this.updateCMAP(name);
            this.hasEncoding = true;
        }
    }

    private void updateCMAP(String name) {
        block21: {
            if ("Adobe-CNS1-UCS2".equals(name) || "Adobe-Japan1-UCS2".equals(name) || "Adobe-GB1-UCS2".equals(name) || "Adobe-Korea1-UCS2".equals(name)) {
                for (int i2 = 0; i2 < 65536; ++i2) {
                    this.cidMap[i2] = i2;
                }
                return;
            }
            try (InputStream input_stream = this.getClass().getResourceAsStream("/org/jpedal/res/pdf/" + name + ".flate");){
                if (input_stream != null) {
                    byte[] cmapData;
                    try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                        int nRead;
                        byte[] data = new byte[4096];
                        while ((nRead = input_stream.read(data, 0, data.length)) != -1) {
                            bos.write(data, 0, nRead);
                        }
                        cmapData = CodeSpaceRange.decompress(bos.toByteArray());
                    }
                    CmapSpec spec = new CmapSpec(cmapData);
                    for (Long key : spec.cidRange.keySet()) {
                        int start = (int)(key >>> 32);
                        int end = (int)(key & 0xFFFFFFFFL);
                        int cid = spec.cidRange.get(key);
                        for (int i3 = start; i3 <= end; ++i3) {
                            if (i3 >= 0 && i3 < 65536) {
                                this.cidMap[i3] = cid;
                            }
                            ++cid;
                        }
                    }
                    break block21;
                }
                LogWriter.writeLog("input stream not found " + name);
            }
            catch (Exception e2) {
                LogWriter.writeLog(e2);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void updateUnicode(String ucsName) {
        block29: {
            configFile = null;
            try {
                var4_3 = ucsName;
                var5_5 = -1;
                switch (var4_3.hashCode()) {
                    case 70355942: {
                        if (!var4_3.equals("JAPAN")) break;
                        var5_5 = 0;
                        break;
                    }
                    case 2267: {
                        if (!var4_3.equals("GB")) break;
                        var5_5 = 1;
                        break;
                    }
                    case 71698570: {
                        if (!var4_3.equals("KOREA")) break;
                        var5_5 = 2;
                        break;
                    }
                    case 66888: {
                        if (!var4_3.equals("CNS")) break;
                        var5_5 = 3;
                    }
                }
                switch (var5_5) {
                    case 0: {
                        configFile = "/org/jpedal/res/pdf/ADOBE_JAPAN_UCS2.cfg";
                        break;
                    }
                    case 1: {
                        configFile = "/org/jpedal/res/pdf/ADOBE_GB_UCS2.cfg";
                        break;
                    }
                    case 2: {
                        configFile = "/org/jpedal/res/pdf/ADOBE_KOREA_UCS2.cfg";
                        break;
                    }
                    case 3: {
                        configFile = "/org/jpedal/res/pdf/ADOBE_CNS_UCS2.cfg";
                        break;
                    }
                }
                if (configFile == null) break block29;
                stream = this.getClass().getResourceAsStream(configFile);
                try {
                    if (stream == null) break block29;
                    input_stream = new BufferedReader(new InputStreamReader(stream));
                    try {
                        block24: while (true) {
                            if ((line = input_stream.readLine()) == null) {
                                break;
                            }
                            if (line.startsWith("#")) continue;
                            values = new StringTokenizer(line);
                            ss = values.nextToken();
                            ee = values.nextToken();
                            uu = values.nextToken();
                            si = Integer.parseInt(ss, 16);
                            ei = Integer.parseInt(ee, 16);
                            ui = Integer.parseInt(uu, 16);
                            p = 0;
                            i = si;
                            while (true) {
                                if (i <= ei) ** break;
                                continue block24;
                                vv = ui + p;
                                if (vv >= 0L && vv < 65536L) {
                                    this.uniMap[i] = (int)vv;
                                }
                                ++p;
                                ++i;
                            }
                            break;
                        }
                    }
                    finally {
                        input_stream.close();
                    }
                }
                finally {
                    if (stream != null) {
                        stream.close();
                    }
                }
            }
            catch (Exception e) {
                LogWriter.writeLog(e);
            }
        }
    }

    public boolean isInCodeSpaceRange(int v2, int byteLen) {
        if (this.bps[byteLen]) {
            for (int i2 = 0; i2 < this.range.length; i2 += 2) {
                if ((long)v2 < this.range[i2] || (long)v2 > this.range[i2 + 1]) continue;
                return true;
            }
        }
        return false;
    }

    private static byte[] decompress(byte[] data) throws Exception {
        Inflater inflater = new Inflater();
        inflater.setInput(data);
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream(data.length);){
            byte[] buffer = new byte[1024];
            while (!inflater.finished()) {
                int count = inflater.inflate(buffer);
                outputStream.write(buffer, 0, count);
            }
            outputStream.close();
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
    }
}

