/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts;

import java.util.TreeMap;

final class CmapSpec {
    private static final byte[] CHAR256 = new byte[]{1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 2, 0, 0, 2, 2, 0, 0, 0, 0, 0, 2, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 0, 0, 2, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private final byte[] cmapData;
    private long[][] codeSpaceRange;
    public final TreeMap<Long, Integer> cidRange = new TreeMap();
    private int p;
    private final int len;

    CmapSpec(byte[] cmapData) {
        this.cmapData = cmapData;
        this.len = cmapData.length;
        this.codeSpaceRange = new long[1][2];
        this.codeSpaceRange[0][1] = 65535L;
        while (this.p < this.len) {
            if ((cmapData[this.p] & 0xFF) == 37) {
                this.skipLine();
                continue;
            }
            String line = this.getNextLine().trim();
            if (line.isEmpty()) continue;
            TreeMap<Long, Integer> bfRange = new TreeMap<Long, Integer>();
            TreeMap<Long, Integer> notDefRange = new TreeMap<Long, Integer>();
            if (line.contains("begincodespacerange")) {
                this.begincodespacerange(line);
                continue;
            }
            if (line.contains("begincidrange")) {
                this.begincidrange(line, this.cidRange);
                continue;
            }
            if (line.contains("begincidchar")) {
                this.begincidchar(line, this.cidRange);
                continue;
            }
            if (line.contains("beginnotdefrange")) {
                this.begincidrange(line, notDefRange);
                continue;
            }
            if (line.contains("beginnotdefchar")) {
                this.begincidchar(line, notDefRange);
                continue;
            }
            if (line.contains("beginbfrange")) {
                this.begincidrange(line, bfRange);
                continue;
            }
            if (!line.contains("beginbfchar")) continue;
            this.begincidchar(line, bfRange);
        }
    }

    private void begincidchar(String line, TreeMap<Long, Integer> cidRange) {
        String[] nn = line.split(" ");
        int count = Integer.parseInt(nn[0]);
        for (int i2 = 0; i2 < count; ++i2) {
            long start = this.getIntOrHex();
            int cid = (int)this.getIntOrHex();
            long v2 = start << 32 | start;
            cidRange.put(v2, cid);
        }
    }

    private void begincidrange(String line, TreeMap<Long, Integer> cidRange) {
        String[] nn = line.split(" ");
        int count = Integer.parseInt(nn[0]);
        for (int i2 = 0; i2 < count; ++i2) {
            long start = this.getIntOrHex();
            long end = this.getIntOrHex();
            int cid = (int)this.getIntOrHex();
            long v2 = start << 32 | end;
            cidRange.put(v2, cid);
        }
    }

    private void begincodespacerange(String line) {
        String[] nn = line.split(" ");
        int count = Integer.parseInt(nn[0]);
        this.codeSpaceRange = new long[count][2];
        for (int i2 = 0; i2 < count; ++i2) {
            long start = this.getIntOrHex();
            long end = this.getIntOrHex();
            this.codeSpaceRange[i2][0] = start;
            this.codeSpaceRange[i2][1] = end;
        }
    }

    private long getIntOrHex() {
        StringBuilder sb = new StringBuilder();
        while (this.p < this.len) {
            int v2 = this.cmapData[this.p] & 0xFF;
            if (v2 == 60) {
                ++this.p;
                while (this.p < this.len && (v2 = this.cmapData[this.p++] & 0xFF) != 62) {
                    sb.append((char)v2);
                }
                String str = sb.toString();
                if (str.length() > 4) {
                    str = str.substring(0, 4);
                }
                return Long.parseLong(str, 16);
            }
            if (CmapSpec.isDigit(v2)) {
                while (this.p < this.len && CmapSpec.isDigit(v2 = this.cmapData[this.p++] & 0xFF)) {
                    sb.append((char)v2);
                }
                return Long.parseLong(sb.toString());
            }
            ++this.p;
        }
        return 0L;
    }

    private String getNextLine() {
        StringBuilder bb2 = new StringBuilder();
        int v2 = this.cmapData[this.p++] & 0xFF;
        block4: while (this.p < this.len) {
            switch (v2) {
                case 13: {
                    if ((this.cmapData[this.p] & 0xFF) != 10) break block4;
                    ++this.p;
                    break block4;
                }
                case 10: {
                    break block4;
                }
                default: {
                    bb2.append((char)v2);
                    v2 = this.cmapData[this.p++] & 0xFF;
                    continue block4;
                }
            }
        }
        return bb2.toString();
    }

    private void skipLine() {
        int v2 = this.cmapData[this.p++] & 0xFF;
        while (this.p < this.len) {
            switch (v2) {
                case 10: {
                    return;
                }
                case 13: {
                    if ((this.cmapData[this.p] & 0xFF) == 10) {
                        ++this.p;
                    }
                    return;
                }
            }
            v2 = this.cmapData[this.p++] & 0xFF;
        }
    }

    private static boolean isDigit(int ch) {
        return CHAR256[ch] == 4;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("codespacerange \n");
        for (long[] codeSpaceRange1 : this.codeSpaceRange) {
            sb.append(codeSpaceRange1[0]).append(" ... ").append(codeSpaceRange1[1]).append('\n');
        }
        sb.append("cidrange \n");
        Object object = this.cidRange.keySet().iterator();
        while (object.hasNext()) {
            Long key = (Long)object.next();
            int start = (int)(key >>> 32);
            int end = (int)(key & 0xFFFFFFFFL);
            int v2 = this.cidRange.get(key);
            sb.append(start).append(" ... ").append(end).append(" ==> ").append(v2).append('\n');
        }
        return sb.toString();
    }
}

