/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts;

import org.jpedal.fonts.TrueType;
import org.jpedal.fonts.tt.TTGlyphs;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.PdfObject;

public class CIDFontType2
extends TrueType {
    public CIDFontType2(PdfObjectReader currentPdfFile, String substituteFontFile) {
        this.isCIDFont = true;
        this.TTstreamisCID = true;
        this.glyphs = new TTGlyphs();
        this.init(currentPdfFile);
        this.substituteFontFile = substituteFontFile;
    }

    public CIDFontType2(PdfObjectReader currentPdfFile, boolean ttflag) {
        this.isCIDFont = true;
        this.TTstreamisCID = ttflag;
        this.glyphs = new TTGlyphs();
        this.init(currentPdfFile);
    }

    @Override
    public void createFont(PdfObject pdfObject, String fontID, boolean renderPage) {
        byte[] stream;
        PdfObject fontFile;
        this.fontTypes = -1684566724;
        this.fontID = fontID;
        PdfObject Descendent = pdfObject.getDictionary(-1547306032);
        PdfObject pdfFontDescriptor = Descendent.getDictionary(-1044665361);
        this.createCIDFont(pdfObject, Descendent);
        if (pdfFontDescriptor != null && (fontFile = CIDFontType2.getEmbeddedFontFile(pdfFontDescriptor)) != null && (stream = this.currentPdfFile.readStream(fontFile, true, true, false, false, false, fontFile.getCacheName(this.currentPdfFile.getObjectReader()))) != null) {
            this.readEmbeddedFont(stream, null);
        }
        if (renderPage && !this.isFontEmbedded && this.substituteFontFile != null) {
            this.substituteFontUsed(this.substituteFontFile);
            this.isFontSubstituted = true;
            this.isFontEmbedded = true;
            this.glyphs.setFontEmbedded(true);
        }
        if (renderPage) {
            this.setFont(this.getFontName(), 1);
        }
    }
}

