/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.external;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import org.jpedal.external.AdditonalHandler;
import org.jpedal.external.ColorHandler;
import org.jpedal.external.CustomFormPrint;
import org.jpedal.external.CustomMessageHandler;
import org.jpedal.external.CustomPrintHintingHandler;
import org.jpedal.external.ErrorTracker;
import org.jpedal.external.GlyphTracker;
import org.jpedal.external.RenderChangeListener;
import org.jpedal.external.ShapeTracker;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.Javascript;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.objects.acroforms.actions.ActionHandler;
import org.jpedal.objects.acroforms.actions.EmptyActionHandler;
import org.jpedal.objects.acroforms.creation.FormFactory;
import org.jpedal.objects.javascript.ExpressionEngine;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.RemoteTrackerInternal;

public class ExternalHandlers {
    private static final boolean isXFAPresent;
    private static final boolean isFormvuPresent;
    private static final boolean isIDRViewerPresent;
    private static final boolean isJPedalPresent;
    private static final boolean ULCSupport;
    private FormFactory userFormFactory;
    private AdditonalHandler additionalHandler;
    private AcroRenderer formRenderer;
    private DynamicVectorRenderer customDVR;
    private ActionHandler userActionHandler = new EmptyActionHandler();
    private Object customSwingHandle;
    private Object customPluginHandle;
    private ExpressionEngine userExpressionEngine;
    private boolean useXFA;
    private Javascript javascript;
    private RenderChangeListener customRenderChangeListener;
    private GlyphTracker customGlyphTracker;
    private ShapeTracker customShapeTracker;
    private boolean alwaysUseXFA;
    private Map<Integer, Object> jpedalActionHandlers;
    private CustomPrintHintingHandler customPrintHintingHandler;
    private ColorHandler customColorHandler;
    private ErrorTracker customErrorTracker;
    private RemoteTrackerInternal customRemoteTracker;
    private CustomFormPrint customFormPrint;
    private CustomMessageHandler customMessageHandler;
    private Object swingGUI;
    private static final String xfaClassName = "org.jpedal.objects.acroforms.AcroRendererXFA";

    public static boolean isJPedalPresent() {
        return isJPedalPresent;
    }

    public static boolean isXFAPresent() {
        return isXFAPresent;
    }

    public static boolean isFormvuPresent() {
        return isFormvuPresent;
    }

    public static boolean isIDRViewerPresent() {
        return isIDRViewerPresent;
    }

    public static boolean isULCPresent() {
        return ULCSupport;
    }

    public ExternalHandlers() {
        if (isXFAPresent) {
            this.useXFA = true;
        }
    }

    public void addHandlers(PdfStreamDecoder streamDecoder) {
        streamDecoder.setObjectValue(12, this.customGlyphTracker);
        streamDecoder.setObjectValue(13, this.customShapeTracker);
        if (this.customErrorTracker != null) {
            streamDecoder.setObjectValue(31, this.customErrorTracker);
        }
    }

    public void addExternalHandler(Object newHandler, int type) {
        switch (type) {
            case 39: {
                this.additionalHandler = (AdditonalHandler)newHandler;
                break;
            }
            case 29: {
                this.alwaysUseXFA = (Boolean)newHandler;
                break;
            }
            case 28: {
                this.useXFA = (Boolean)newHandler;
                break;
            }
            case -4: {
                this.customPluginHandle = newHandler;
                break;
            }
            case 4: {
                this.customSwingHandle = newHandler;
                break;
            }
            case 31: {
                this.customErrorTracker = (ErrorTracker)newHandler;
                break;
            }
            case 40: {
                this.customRemoteTracker = (RemoteTrackerInternal)newHandler;
                break;
            }
            case 6: {
                this.userExpressionEngine = (ExpressionEngine)newHandler;
                break;
            }
            case 3: {
                this.userFormFactory = (FormFactory)newHandler;
                break;
            }
            case 11: {
                this.swingGUI = newHandler;
                break;
            }
            case 19: {
                this.customColorHandler = (ColorHandler)newHandler;
                break;
            }
            case 12: {
                this.customGlyphTracker = (GlyphTracker)newHandler;
                break;
            }
            case 13: {
                this.customShapeTracker = (ShapeTracker)newHandler;
                break;
            }
            case 14: {
                this.customFormPrint = (CustomFormPrint)newHandler;
                break;
            }
            case 9: {
                this.jpedalActionHandlers = (Map)newHandler;
                break;
            }
            case 15: {
                this.customMessageHandler = (CustomMessageHandler)newHandler;
                break;
            }
            case 21: {
                this.customRenderChangeListener = (RenderChangeListener)newHandler;
                break;
            }
            case 18: {
                this.customPrintHintingHandler = (CustomPrintHintingHandler)newHandler;
                break;
            }
            case 20: {
                this.customDVR = (DynamicVectorRenderer)newHandler;
                break;
            }
            case 5: {
                this.userActionHandler = (ActionHandler)newHandler;
                break;
            }
            default: {
                if (this.additionalHandler != null) {
                    this.additionalHandler.addExternalHandler(newHandler, type);
                    break;
                }
                throw new IllegalArgumentException("Unknown type=" + type);
            }
        }
    }

    public Object getExternalHandler(int type) {
        switch (type) {
            case 3: {
                return this.formRenderer.getFormFactory();
            }
            case 4: {
                return this.customSwingHandle;
            }
            case -4: {
                return this.customPluginHandle;
            }
            case 6: {
                return this.userExpressionEngine;
            }
            case 31: {
                return this.customErrorTracker;
            }
            case 40: {
                return this.customRemoteTracker;
            }
            case 19: {
                return this.customColorHandler;
            }
            case 12: {
                return this.customGlyphTracker;
            }
            case 18: {
                return this.customPrintHintingHandler;
            }
            case 13: {
                return this.customShapeTracker;
            }
            case 14: {
                return this.customFormPrint;
            }
            case 11: {
                return this.swingGUI;
            }
            case 9: 
            case 24: {
                if (this.jpedalActionHandlers == null) {
                    return null;
                }
                return Collections.unmodifiableMap(this.jpedalActionHandlers);
            }
            case 15: {
                return this.customMessageHandler;
            }
            case 20: {
                return this.customDVR;
            }
            case 21: {
                return this.customRenderChangeListener;
            }
        }
        if (this.additionalHandler != null) {
            return this.additionalHandler.getExternalHandler(type);
        }
        throw new IllegalArgumentException("Unknown type " + type);
    }

    public Javascript getJavaScript() {
        return this.javascript;
    }

    public void dispose() {
        this.additionalHandler = null;
        this.customPluginHandle = null;
        this.customSwingHandle = null;
        this.customErrorTracker = null;
        this.userExpressionEngine = null;
        this.userFormFactory = null;
        this.swingGUI = null;
        this.customColorHandler = null;
        this.customGlyphTracker = null;
        this.customShapeTracker = null;
        this.customFormPrint = null;
        this.jpedalActionHandlers = null;
        this.customMessageHandler = null;
        this.customRenderChangeListener = null;
        this.customPrintHintingHandler = null;
        this.customDVR = null;
        if (this.javascript != null) {
            this.javascript.dispose();
        }
        this.javascript = null;
        if (this.formRenderer != null) {
            this.formRenderer.dispose();
        }
        this.formRenderer = null;
        this.userActionHandler = null;
    }

    public AcroRenderer getFormRenderer() {
        return this.formRenderer;
    }

    public ActionHandler getFormActionHandler() {
        return this.userActionHandler;
    }

    public void useXFA(boolean useXFA) {
        this.useXFA = useXFA;
    }

    public void openPdfFile(ExpressionEngine userExpressionEngine) {
        this.initObjects(userExpressionEngine);
    }

    public static BufferedImage decode(PdfObject pdfObject, PdfObjectReader currentPdfFile, PdfObject XObject2, int subtype, int width, int height, int offsetImage, float pageScaling) {
        if (isXFAPresent) {
            try {
                AcroRenderer formRenderer = (AcroRenderer)Class.forName(xfaClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                return formRenderer.decode(pdfObject, currentPdfFile, XObject2, subtype, width, height, offsetImage, pageScaling);
            }
            catch (Exception ex) {
                LogWriter.writeLog("[PDF] Unable to instance XFA " + ex);
            }
        }
        return null;
    }

    private void initObjects(ExpressionEngine userExpressionEngine1) {
        if (isXFAPresent) {
            try {
                this.formRenderer = (AcroRenderer)Class.forName(xfaClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                LogWriter.writeLog("[PDF] Unable to instance XFA " + ex);
                this.formRenderer = new AcroRenderer();
            }
        } else {
            this.formRenderer = new AcroRenderer();
        }
        this.formRenderer.useXFAIfAvailable(this.useXFA);
        this.formRenderer.init();
        this.formRenderer.alwaysuseXFA(this.alwaysUseXFA);
        FormFactory userFormFactory = this.userFormFactory;
        if (userFormFactory != null) {
            this.formRenderer.setFormFactory(userFormFactory);
        }
        this.javascript = new Javascript(userExpressionEngine1, this.formRenderer);
    }

    static {
        boolean isULCSupported = false;
        try (InputStream rs = ExternalHandlers.class.getResourceAsStream("/com/ulcjava/base/application/ULCTextComponent.class");){
            isULCSupported = rs != null;
        }
        catch (IOException e2) {
            LogWriter.writeLog(e2);
        }
        ULCSupport = isULCSupported;
        String xfaClassPath = "/org/jpedal/objects/acroforms/AcroRendererXFA.class";
        isXFAPresent = ExternalHandlers.class.getResource("/org/jpedal/objects/acroforms/AcroRendererXFA.class") != null;
        String formvuClassPath = "/org/jpedal/examples/html/FormVu.class";
        isFormvuPresent = ExternalHandlers.class.getResource("/org/jpedal/examples/html/FormVu.class") != null;
        String idrviewerClassPath = "/idrviewer/examples/complete/index.html";
        isIDRViewerPresent = ExternalHandlers.class.getResource("/idrviewer/examples/complete/index.html") != null;
        String jpedalClassPath = "/org/jpedal/examples/JPedal.class";
        isJPedalPresent = ExternalHandlers.class.getResource("/org/jpedal/examples/JPedal.class") != null;
    }
}

