/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jpedal.gui.ShowGUIMessage;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.SecureDocumentBuilderFactory;
import org.jpedal.utils.SecureTransformerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PropertiesFile {
    private String userDir;
    private String configFile;
    private InputStream configInputStream;
    private boolean isReadOnly;
    private Document doc;
    private static final int noOfRecentDocs = 6;

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public PropertiesFile() {
        String separator = System.getProperty("file.separator");
        String defaultPropertiesName = ".properties.xml";
        try (InputStream configStream = PropertiesFile.class.getResourceAsStream("/org/jpedal/examples/viewer/profiles/trial.xml");){
            if (configStream != null) {
                defaultPropertiesName = ".propertiesFile.xml";
            }
            String jarLoc = this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
            this.userDir = jarLoc.substring(0, jarLoc.lastIndexOf(47));
            this.configFile = !this.userDir.isEmpty() ? this.userDir + separator + defaultPropertiesName : defaultPropertiesName;
            if (DecoderOptions.isRunningOnWindows) {
                this.configFile = this.configFile.substring(1);
                this.configFile = this.configFile.replaceAll("\\\\", "/");
            }
        }
        catch (IOException | URISyntaxException e2) {
            this.configFile = this.userDir + separator + defaultPropertiesName;
            LogWriter.writeLog("Exception " + e2);
        }
        if (this.userDir == null) {
            this.userDir = System.getProperty("user.dir");
        }
    }

    public void loadProperties() {
        try (InputStream configStream = PropertiesFile.class.getResourceAsStream("/org/jpedal/examples/viewer/profiles/trial.xml");){
            SecureDocumentBuilderFactory dbf = new SecureDocumentBuilderFactory();
            DocumentBuilder db = dbf.newDocumentBuilder();
            File config = new File(this.configFile);
            if (configStream == null) {
                try (InputStream fallBackStream = PropertiesFile.class.getResourceAsStream("/org/jpedal/examples/viewer/profiles/default.xml");){
                    if (fallBackStream != null) {
                        this.doc = db.parse(fallBackStream);
                        fallBackStream.close();
                    } else {
                        this.doc = db.newDocument();
                    }
                }
                catch (Exception e2) {
                    LogWriter.writeLog("Exception " + e2 + " generating properties file");
                }
            } else {
                this.doc = db.parse(configStream);
            }
            Document localDoc = PropertiesFile.loadLocalProperties(db, config, this.configInputStream, this.doc);
            this.checkAllElementsPresent(localDoc);
            this.isReadOnly = this.configInputStream != null || config.exists() && !config.canWrite() || "true".equalsIgnoreCase(this.getValue("readOnly"));
        }
        catch (Exception e3) {
            LogWriter.writeLog("Exception " + e3 + " generating properties file");
        }
    }

    public void loadDebugProperties() {
        try (InputStream configStream = PropertiesFile.class.getResourceAsStream("/org/jpedal/examples/viewer/profiles/debug.xml");){
            SecureDocumentBuilderFactory dbf = new SecureDocumentBuilderFactory();
            DocumentBuilder db = dbf.newDocumentBuilder();
            File config = new File(this.configFile);
            this.doc = configStream == null ? db.newDocument() : db.parse(configStream);
            this.checkAllElementsPresent(this.doc);
            this.isReadOnly = this.configInputStream != null || config.exists() && !config.canWrite() || "true".equalsIgnoreCase(this.getValue("readOnly"));
        }
        catch (Exception e2) {
            LogWriter.writeLog("Exception " + e2 + " generating properties file");
        }
    }

    private static Document loadLocalProperties(DocumentBuilder db, File config, InputStream configInputStream, Document defaultConfig) {
        if (configInputStream != null) {
            try {
                return db.parse(configInputStream);
            }
            catch (IOException | SAXException e2) {
                LogWriter.writeLog("Exception " + e2);
                return db.newDocument();
            }
        }
        if (config.exists() && config.length() > 0L) {
            try {
                return db.parse(config);
            }
            catch (IOException | SAXException e3) {
                LogWriter.writeLog("Exception " + e3);
                return db.newDocument();
            }
        }
        return defaultConfig;
    }

    public String[] getRecentDocuments() {
        String[] recentDocuments;
        try {
            NodeList nl = this.doc.getElementsByTagName("recentfiles");
            ArrayList<String> fileNames = new ArrayList<String>(6);
            if (nl != null && nl.getLength() > 0) {
                NodeList allRecentDocs = ((Element)nl.item(0)).getElementsByTagName("*");
                for (int i2 = 0; i2 < allRecentDocs.getLength(); ++i2) {
                    Node item = allRecentDocs.item(i2);
                    NamedNodeMap attrs = item.getAttributes();
                    fileNames.add(attrs.getNamedItem("name").getNodeValue());
                }
            }
            while (fileNames.size() > 6) {
                fileNames.remove(0);
            }
            Collections.reverse(fileNames);
            recentDocuments = fileNames.toArray(new String[6]);
        }
        catch (DOMException e2) {
            LogWriter.writeLog("Exception " + e2 + " getting recent documents");
            return null;
        }
        return recentDocuments;
    }

    public void addRecentDocument(String file) {
        try {
            Element recentElement = (Element)this.doc.getElementsByTagName("recentfiles").item(0);
            PropertiesFile.checkExists(file, recentElement);
            Element elementToAdd = this.doc.createElement("file");
            elementToAdd.setAttribute("name", file);
            recentElement.appendChild(elementToAdd);
            PropertiesFile.removeOldFiles(recentElement);
        }
        catch (Exception e2) {
            LogWriter.writeLog("Exception " + e2 + " adding recent document to properties file");
        }
    }

    public void setValue(String elementName, String newValue) {
        try {
            NodeList nl = this.doc.getElementsByTagName(elementName);
            Element element = (Element)nl.item(0);
            if (element == null || newValue == null) {
                ShowGUIMessage.showGUIMessage("The property " + elementName + " was either not found in the properties file or the value " + newValue + " was not set.", "Property not found.");
            } else {
                element.setAttribute("value", newValue);
            }
        }
        catch (DOMException e2) {
            LogWriter.writeLog("Exception " + e2 + " setting value in properties file");
        }
    }

    public NodeList getChildren(String item) {
        return this.doc.getElementsByTagName(item).item(0).getChildNodes();
    }

    public String getValue(String elementName) {
        NamedNodeMap attrs;
        try {
            NodeList nl = this.doc.getElementsByTagName(elementName);
            Element element = (Element)nl.item(0);
            if (element == null) {
                return "";
            }
            attrs = element.getAttributes();
        }
        catch (Exception e2) {
            LogWriter.writeLog("Exception " + e2 + " generating properties file");
            return "";
        }
        return attrs.getNamedItem("value").getNodeValue();
    }

    private static void removeOldFiles(Element recentElement) {
        NodeList allRecentDocs = recentElement.getElementsByTagName("*");
        while (allRecentDocs.getLength() > 6) {
            recentElement.removeChild(allRecentDocs.item(0));
        }
    }

    private static void checkExists(String file, Element recentElement) {
        NodeList allRecentDocs = recentElement.getElementsByTagName("*");
        for (int i2 = 0; i2 < allRecentDocs.getLength(); ++i2) {
            Node item = allRecentDocs.item(i2);
            NamedNodeMap attrs = item.getAttributes();
            String value = attrs.getNamedItem("name").getNodeValue();
            if (!value.equals(file)) continue;
            recentElement.removeChild(item);
        }
    }

    public void writeDoc() throws Exception {
        if (!this.isReadOnly && !"true".equalsIgnoreCase(this.getValue("readOnly"))) {
            StreamSource ss;
            StreamResult str;
            try (InputStream stylesheet = this.getClass().getResourceAsStream("/org/jpedal/examples/viewer/res/xmlstyle.xslt");){
                str = new StreamResult(this.configFile);
                ss = new StreamSource(stylesheet);
                DOMSource dom = new DOMSource(this.doc);
                TransformerFactory transformerFactory = SecureTransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer(ss);
                transformer.transform(dom, str);
            }
            ss.getInputStream().close();
            try (OutputStream sos = str.getOutputStream();){
                if (sos != null) {
                    sos.close();
                }
            }
        }
    }

    public void dispose() {
        this.doc = null;
        this.configFile = null;
    }

    private void checkAllElementsPresent(Document localDoc) {
        NodeList localElements = localDoc.getElementsByTagName("*");
        for (int i2 = 0; i2 < localElements.getLength(); ++i2) {
            Node node = localElements.item(i2);
            String nodeName = node.getNodeName();
            Element defaultElement = (Element)this.doc.getElementsByTagName(nodeName).item(0);
            if (defaultElement == null) continue;
            Element localElement = (Element)localDoc.getElementsByTagName(nodeName).item(0);
            String value = localElement.getAttribute("value");
            if (value != null && !value.isEmpty()) {
                defaultElement.setAttribute("value", localElement.getAttribute("value"));
                continue;
            }
            if (!"recentfiles".equals(nodeName)) continue;
            NodeList recentFiles = localElement.getElementsByTagName("*");
            for (int f2 = 0; f2 < recentFiles.getLength(); ++f2) {
                this.addRecentDocument(((Element)recentFiles.item(f2)).getAttribute("name"));
            }
        }
    }

    public static int getNoRecentDocumentsToDisplay() {
        return 6;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void loadProperties(String configFile) {
        if (configFile.startsWith("jar:")) {
            String jarInternalFile = configFile.substring(4);
            if (jarInternalFile.startsWith("http:") || jarInternalFile.startsWith("file:")) {
                try {
                    URL url = new URL(configFile);
                    JarURLConnection jarConnection = (JarURLConnection)url.openConnection();
                    this.configInputStream = jarConnection.getInputStream();
                }
                catch (IOException e2) {
                    LogWriter.writeLog(e2);
                }
            } else {
                InputStream is = this.getClass().getResourceAsStream(jarInternalFile);
                if (is == null) throw new RuntimeException("unable to open resource stream for " + jarInternalFile);
                this.configInputStream = is;
            }
        } else {
            if (configFile.startsWith("http:")) {
                try {
                    URL url = new URL(configFile);
                    URLConnection con = url.openConnection();
                    con.setDoOutput(true);
                    this.configInputStream = url.openStream();
                }
                catch (IOException e3) {
                    LogWriter.writeLog(e3);
                }
            }
            if (this.configInputStream == null) {
                String localFile;
                if (configFile.startsWith("file:/")) {
                    try {
                        localFile = URLDecoder.decode(configFile.substring(5), StandardCharsets.UTF_8.name());
                    }
                    catch (UnsupportedEncodingException e4) {
                        throw new RuntimeException("Properties file provided with file:/ protocol and the encoding was not supported.");
                    }
                } else {
                    localFile = configFile;
                }
                File p2 = new File(localFile);
                if (!p2.exists() && (p2.exists() || p2.canWrite())) {
                    throw new RuntimeException("Unable to load properties file.");
                }
                this.configFile = localFile;
                this.isReadOnly = !p2.canWrite();
            }
        }
        this.loadProperties();
    }

    public Document getDoc() {
        return this.doc;
    }
}

