/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterJob;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.SetOfIntegerSyntax;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.PrinterResolution;
import javax.print.event.PrintJobEvent;
import javax.print.event.PrintJobListener;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import javax.swing.Timer;
import org.jpedal.PdfDecoder;
import org.jpedal.PdfDecoderInt;
import org.jpedal.color.PdfPaint;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.examples.viewer.gui.popups.PrintPanel;
import org.jpedal.examples.viewer.utils.PrintStatus;
import org.jpedal.exception.PdfException;
import org.jpedal.external.ColorHandler;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public class Printer {
    private int rangeStart = 1;
    private int rangeEnd = 1;
    private int subset = 8;
    private boolean wasCancelled;
    private boolean messageShown;
    private boolean pagesReversed;
    private Timer updatePrinterProgress;
    private ProgressMonitor status;
    private DocPrintJob printJob;
    private static final boolean showOptionPane = true;
    private String dots = ".";

    public void printPDF(PdfDecoderInt decodePdf, SwingGUI currentGUI, String blacklist, String defaultPrinter) {
        ++PrintStatus.printingThreads;
        Thread worker = new Thread(() -> {
            boolean printFile = this.printing(decodePdf, currentGUI, defaultPrinter, blacklist);
            if (this.updatePrinterProgress != null) {
                this.updatePrinterProgress.stop();
                this.status.close();
            }
            if (!printFile && !((PdfDecoder)decodePdf).isPageSuccessful()) {
                Printer.showPrintErrorMessage(decodePdf, currentGUI);
            }
            --PrintStatus.printingThreads;
            ((PdfDecoder)decodePdf).resetCurrentPrintPage();
            ((Component)((Object)decodePdf)).invalidate();
            ((JComponent)((Object)decodePdf)).updateUI();
            decodePdf.repaint();
            if (printFile && !this.wasCancelled) {
                currentGUI.showMessageDialog(Messages.getMessage("PdfViewerPrintingFinished"));
            }
        });
        worker.setDaemon(true);
        worker.start();
    }

    private boolean printing(PdfDecoderInt decodePdf, SwingGUI currentGUI, String defaultPrinter, String blacklist) {
        boolean printFile = false;
        try {
            PageFormat pf = Printer.createDefaultPageFormat();
            SimpleDoc doc = new SimpleDoc(decodePdf, DocFlavor.SERVICE_FORMATTED.PAGEABLE, null);
            HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
            aset.add(new PageRanges(1, decodePdf.getPageCount()));
            PrintPanel printPanel = currentGUI.printDialog(PrintStatus.getAvailablePrinters(blacklist), defaultPrinter);
            printFile = printPanel.okClicked();
            decodePdf.repaint();
            this.setPrinter(printPanel.getPrinter());
            this.setPrintModeFromPrintPanel(printPanel, decodePdf);
            SetOfIntegerSyntax range = printPanel.getPrintRange();
            Object storedColorHandler = decodePdf.getExternalHandler(19);
            if (range == null) {
                currentGUI.showMessageDialog("No pages to print");
            } else {
                this.setPrintRange(decodePdf, range);
                Printer.setPrintRenderSettings(aset, printPanel, decodePdf, pf);
            }
            this.displayProgressPane(decodePdf, currentGUI);
            if (decodePdf.getFileName() != null) {
                String[] jobString = decodePdf.getFileName().split("/");
                JobName jobName = new JobName(jobString[jobString.length - 1], null);
                if (this.printJob.getPrintService().isAttributeValueSupported(jobName, DocFlavor.SERVICE_FORMATTED.PAGEABLE, aset)) {
                    aset.add(jobName);
                }
            }
            if (printFile) {
                this.printJob.addPrintJobListener(new PDFPrintJobListener());
                this.printJob.print(doc, aset);
            }
            decodePdf.addExternalHandler(storedColorHandler, 19);
        }
        catch (IllegalArgumentException | PrintException | PdfException e2) {
            LogWriter.writeLog("Exception " + e2 + " printing");
            currentGUI.showMessageDialog("Exception " + e2);
        }
        return printFile;
    }

    private void displayProgressPane(PdfDecoderInt decodePdf, SwingGUI currentGUI) {
        this.status = new ProgressMonitor(currentGUI.getFrame(), "", "", 1, 100);
        this.updatePrinterProgress = new Timer(1000, event -> {
            int currentPage = ((PdfDecoder)decodePdf).getCurrentPrintPage();
            if (currentPage > 0) {
                this.updatePrinterProgess(decodePdf, currentPage);
            }
            if (currentPage == -1) {
                this.updatePrinterProgress.stop();
                this.status.close();
            }
        });
        this.updatePrinterProgress.setRepeats(true);
        this.updatePrinterProgress.start();
    }

    private static void showPrintErrorMessage(PdfDecoderInt decodePdf, SwingGUI currentGUI) {
        StringBuilder builder = new StringBuilder(Messages.getMessage("PdfViewerError.ProblemsEncountered"));
        builder.append(((PdfDecoder)decodePdf).getPageFailureMessage());
        builder.append('\n');
        if (((PdfDecoder)decodePdf).getPageFailureMessage().toLowerCase().contains("memory")) {
            builder.append(Messages.getMessage("PdfViewerError.RerunJava"));
            builder.append(Messages.getMessage("PdfViewerError.RerunJava1"));
            builder.append(Messages.getMessage("PdfViewerError.RerunJava2"));
        }
        currentGUI.showMessageDialog(builder.toString());
    }

    private static void setPrintRenderSettings(PrintRequestAttributeSet aset, PrintPanel printPanel, PdfDecoderInt decodePdf, PageFormat pf) {
        aset.add(new Copies(printPanel.getCopies()));
        ((PdfDecoder)decodePdf).setPrintAutoRotateAndCenter(printPanel.isAutoRotateAndCenter());
        ((PdfDecoder)decodePdf).setPrintCurrentView(printPanel.isPrintingCurrentView());
        ((PdfDecoder)decodePdf).setPrintPageScalingMode(printPanel.getPageScaling());
        if (printPanel.isMonochrome()) {
            aset.remove(Chromaticity.COLOR);
            aset.add(Chromaticity.MONOCHROME);
            decodePdf.addExternalHandler(new MonochromeColorHandler(), 19);
        } else {
            aset.remove(Chromaticity.MONOCHROME);
            aset.add(Chromaticity.COLOR);
        }
        if (printPanel.getSelectedPaper() != null) {
            pf.setPaper(printPanel.getSelectedPaper());
        }
        pf.setOrientation(printPanel.getSelectedPrinterOrientation());
        ((PdfDecoder)decodePdf).setPageFormat(pf);
        ((PdfDecoder)decodePdf).setUsePDFPaperSize(printPanel.isPaperSourceByPDFSize());
        PrinterResolution res = printPanel.getResolution();
        if (res != null) {
            aset.add(res);
        }
    }

    private void setPrintRange(PdfDecoderInt decodePdf, SetOfIntegerSyntax range) throws PdfException {
        ((PdfDecoder)decodePdf).setPagePrintRange(range);
        int i2 = this.rangeStart = range.next(0);
        this.rangeEnd = this.rangeStart;
        if (range.contains(Integer.MAX_VALUE)) {
            this.rangeEnd = decodePdf.getPageCount();
        } else {
            while (range.next(i2) != -1) {
                ++i2;
            }
            this.rangeEnd = i2;
        }
    }

    private void setPrintModeFromPrintPanel(PrintPanel printPanel, PdfDecoderInt decodePdf) {
        int printMode = 0;
        this.subset = 8;
        if (printPanel.isOddPagesOnly()) {
            printMode = 16;
            this.subset = 16;
        } else if (printPanel.isEvenPagesOnly()) {
            printMode = 32;
            this.subset = 32;
        }
        this.pagesReversed = printPanel.isPagesReversed();
        if (this.pagesReversed) {
            printMode += 64;
        }
        ((PdfDecoder)decodePdf).setPrintPageMode(printMode);
    }

    private static PageFormat createDefaultPageFormat() {
        PageFormat pf = PrinterJob.getPrinterJob().defaultPage();
        Paper paper = new Paper();
        paper.setSize(595.0, 842.0);
        paper.setImageableArea(43.0, 43.0, 509.0, 756.0);
        pf.setPaper(paper);
        return pf;
    }

    private void updatePrinterProgess(PdfDecoderInt decode_pdf, int currentPage) {
        boolean isBackwards;
        int noOfPagesPrinting = this.rangeEnd - this.rangeStart + 1;
        int currentPrintingPage = currentPage - this.rangeStart;
        int actualCount = noOfPagesPrinting;
        int actualPage = currentPrintingPage;
        int actualPercentage = (int)((float)actualPage / (float)actualCount * 100.0f);
        if (this.status.isCanceled()) {
            ((PdfDecoder)decode_pdf).stopPrinting();
            this.updatePrinterProgress.stop();
            this.status.close();
            this.wasCancelled = true;
            --PrintStatus.printingThreads;
            if (!this.messageShown) {
                JOptionPane.showMessageDialog(null, Messages.getMessage("PdfViewerPrint.PrintingCanceled"));
                this.messageShown = true;
            }
            return;
        }
        this.dots = this.dots + '.';
        if (this.dots.length() > 8) {
            this.dots = ".";
        }
        boolean bl2 = isBackwards = currentPrintingPage <= 0;
        if (this.rangeStart == this.rangeEnd) {
            isBackwards = false;
        }
        if (isBackwards) {
            noOfPagesPrinting = this.rangeStart - this.rangeEnd + 1;
        }
        int percentage = (int)((float)currentPrintingPage / (float)noOfPagesPrinting * 100.0f);
        if (!isBackwards && percentage < 1) {
            percentage = 1;
        }
        if (isBackwards) {
            percentage = -percentage;
        }
        if (this.pagesReversed) {
            percentage = 100 - percentage;
        }
        this.status.setProgress(percentage);
        if (this.subset == 16 || this.subset == 32) {
            actualCount = actualCount / 2 + 1;
            actualPage /= 2;
        }
        if (actualCount == 1) {
            actualPercentage = 50;
            actualPage = 1;
            this.status.setProgress(actualPercentage);
        }
        String message = actualPage + " " + Messages.getMessage("PdfViewerPrint.Of") + ' ' + actualCount + ": " + actualPercentage + '%' + ' ' + this.dots;
        if (this.pagesReversed) {
            message = actualCount - actualPage + " " + Messages.getMessage("PdfViewerPrint.Of") + ' ' + actualCount + ": " + percentage + '%' + ' ' + this.dots;
            this.status.setNote(Messages.getMessage("PdfViewerPrint.ReversedPrinting") + ' ' + message);
        } else if (isBackwards) {
            this.status.setNote(Messages.getMessage("PdfViewerPrint.ReversedPrinting") + ' ' + message);
        } else {
            this.status.setNote(Messages.getMessage("PdfViewerPrint.Printing") + ' ' + message);
        }
    }

    private void setPrinter(String chosenPrinter) throws PdfException {
        PrintService[] service = PrinterJob.lookupPrintServices();
        int count = service.length;
        boolean matchFound = false;
        for (int i2 = 0; i2 < count; ++i2) {
            if (!service[i2].getName().contains(chosenPrinter)) continue;
            this.printJob = service[i2].createPrintJob();
            i2 = count;
            matchFound = true;
        }
        if (!matchFound) {
            throw new PdfException("Unknown printer " + chosenPrinter);
        }
    }

    static class MonochromeColorHandler
    implements ColorHandler {
        MonochromeColorHandler() {
        }

        @Override
        public void setPaint(Graphics2D g2, PdfPaint textFillCol, int pageNumber, boolean isPrinting) {
            if (isPrinting && textFillCol != null) {
                int rgb = textFillCol.getRGB();
                float[] val = new float[]{(float)(rgb >> 16 & 0xFF) / 255.0f, (float)(rgb >> 8 & 0xFF) / 255.0f, (float)(rgb & 0xFF) / 255.0f};
                ColorSpace cs = ColorSpace.getInstance(1003);
                float[] grayVal = cs.fromRGB(val);
                Color colGray = new Color(cs, grayVal, 1.0f);
                g2.setPaint(colGray);
            } else {
                g2.setPaint(textFillCol);
            }
        }

        @Override
        public BufferedImage processImage(BufferedImage image, int pageNumber, boolean isPrinting) {
            if (isPrinting && image != null) {
                BufferedImage newImage = new BufferedImage(image.getWidth(), image.getHeight(), 10);
                Graphics2D newG2 = newImage.createGraphics();
                newG2.setPaint(Color.WHITE);
                newG2.fillRect(0, 0, image.getWidth(), image.getHeight());
                newG2.drawImage((Image)image, 0, 0, null);
                return newImage;
            }
            return image;
        }
    }

    private static class PDFPrintJobListener
    implements PrintJobListener {
        private static final boolean showMessages = false;

        private PDFPrintJobListener() {
        }

        @Override
        public void printDataTransferCompleted(PrintJobEvent printJobEvent) {
        }

        @Override
        public void printJobCompleted(PrintJobEvent printJobEvent) {
        }

        @Override
        public void printJobFailed(PrintJobEvent printJobEvent) {
        }

        @Override
        public void printJobCanceled(PrintJobEvent printJobEvent) {
        }

        @Override
        public void printJobNoMoreEvents(PrintJobEvent printJobEvent) {
        }

        @Override
        public void printJobRequiresAttention(PrintJobEvent printJobEvent) {
        }
    }
}

