/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.utils;

import java.awt.Color;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import org.jpedal.io.PdfFileReader;
import org.jpedal.objects.raw.StreamObject;
import org.jpedal.utils.LogWriter;

public final class ObjectHighlighter {
    private static final Color blue = new Color(12, 25, 207);
    private static final Color grey = new Color(31, 96, 105);
    private static final Color red = new Color(230, 48, 64);
    private static final Color purple = new Color(214, 0, 175);
    private static final Color green = new Color(19, 149, 0);
    private static final Color orange = new Color(244, 124, 16);
    private final PdfFileReader pdfFileReader;
    private final Pattern objectPattern = Pattern.compile("((?<=(?<!end)stream)[\\s\\S]+?(?=endstream))|(\\s*<<)|(\\s*>>)|(\\s*%.*)|(\\s*\\([^()]+\\))|(\\s*<[^<>]+>)|(\\s*/[^\\s\\[\\]/<>\\r\\n()]+)|(\\s*\\d+\\s\\d+\\s(?:R|obj))|(\\s*endobj)|(\\s*stream)|(\\s*endstream)|(\\s*[-+]?(?:\\d*[.])?\\d+)|(\\s*\\[)|(\\s*])|(\\s*true)|(\\s*false)|(\\r\\n|\\r|\\n)");

    public ObjectHighlighter(PdfFileReader pdfFileReader) {
        this.pdfFileReader = pdfFileReader;
    }

    public void highlight(String object, JTextPane textPane) {
        try {
            DefaultStyledDocument styledDocument = new DefaultStyledDocument();
            Style dictionaryKeyStyle = textPane.addStyle("dictionaryKey", null);
            StyleConstants.setForeground(dictionaryKeyStyle, orange);
            Style dictionaryValueStyle = textPane.addStyle("dictionaryValue", null);
            StyleConstants.setForeground(dictionaryValueStyle, grey);
            Style objectRefStyle = textPane.addStyle("objectRef", null);
            StyleConstants.setForeground(objectRefStyle, red);
            Style numberStyle = textPane.addStyle("number", null);
            StyleConstants.setForeground(numberStyle, purple);
            Style booleanStyle = textPane.addStyle("boolean", null);
            StyleConstants.setForeground(booleanStyle, green);
            Style stringStyle = textPane.addStyle("string", null);
            StyleConstants.setForeground(stringStyle, blue);
            Matcher matcher = this.objectPattern.matcher(object);
            boolean nextIsKey = true;
            boolean inArray = false;
            while (matcher.find()) {
                Style style = null;
                for (int i2 = 1; i2 <= 17; ++i2) {
                    String match = matcher.group(i2);
                    if (match == null) continue;
                    switch (i2) {
                        case 2: {
                            nextIsKey = true;
                            break;
                        }
                        case 3: {
                            break;
                        }
                        case 5: 
                        case 6: {
                            style = stringStyle;
                            nextIsKey = !nextIsKey;
                            break;
                        }
                        case 7: {
                            if (nextIsKey && !inArray) {
                                style = dictionaryKeyStyle;
                                nextIsKey = false;
                                break;
                            }
                            style = dictionaryValueStyle;
                            nextIsKey = true;
                            break;
                        }
                        case 8: {
                            style = objectRefStyle;
                            nextIsKey = !nextIsKey;
                            break;
                        }
                        case 12: {
                            style = numberStyle;
                            nextIsKey = !nextIsKey;
                            break;
                        }
                        case 13: {
                            inArray = true;
                            nextIsKey = false;
                            break;
                        }
                        case 14: {
                            inArray = false;
                            nextIsKey = true;
                            break;
                        }
                        case 15: 
                        case 16: {
                            style = booleanStyle;
                            nextIsKey = !nextIsKey;
                            break;
                        }
                        case 1: {
                            style = stringStyle;
                            break;
                        }
                        case 4: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 17: {
                            style = null;
                        }
                    }
                    styledDocument.insertString(styledDocument.getLength(), match, style);
                }
            }
            textPane.setStyledDocument(styledDocument);
        }
        catch (BadLocationException e2) {
            LogWriter.writeLog("Failed to highlight object");
            textPane.setText(object);
        }
    }

    public String hexifyStream(byte[] object) {
        boolean invalidStream;
        boolean crlf;
        int streamStart = ObjectHighlighter.indexOfSubArray(object, new byte[]{115, 116, 114, 101, 97, 109});
        int streamEnd = ObjectHighlighter.indexOfSubArrayLast(object, new byte[]{101, 110, 100, 115, 116, 114, 101, 97, 109});
        if (object[streamStart + 6] == 13 && object[streamStart + 7] == 10) {
            crlf = true;
            invalidStream = false;
        } else if (object[streamStart + 6] == 10) {
            crlf = false;
            invalidStream = false;
        } else {
            crlf = false;
            invalidStream = true;
        }
        if (streamStart != -1 && streamEnd != -1 && !invalidStream) {
            String textBeforeStream = ObjectHighlighter.getBytesAsString(object, 0, streamStart += crlf ? 8 : 7);
            Matcher objectRef = Pattern.compile("(\\d+ \\d+ )obj").matcher(textBeforeStream);
            if (!objectRef.find()) {
                LogWriter.writeLog("Cannot parse stream");
                return ObjectHighlighter.getBytesAsString(object, 0, object.length);
            }
            StreamObject streamObject = new StreamObject(objectRef.group(1) + 'R');
            this.pdfFileReader.readObject(streamObject);
            int streamLength = streamObject.getInt(1043816557);
            if (streamLength == -1) {
                LogWriter.writeLog("Cannot parse stream");
                return ObjectHighlighter.getBytesAsString(object, 0, object.length);
            }
            streamEnd = streamStart + streamLength;
            StringBuilder sb = new StringBuilder();
            for (int i2 = streamStart; i2 < streamEnd; ++i2) {
                sb.append(String.format("%02X", object[i2]));
                if (i2 == streamEnd - 1) continue;
                sb.append(' ');
            }
            String streamText = sb.toString();
            String textAfterStream = ObjectHighlighter.getBytesAsString(object, streamEnd, object.length);
            return textBeforeStream + streamText + textAfterStream;
        }
        LogWriter.writeLog("Cannot parse stream");
        return ObjectHighlighter.getBytesAsString(object, 0, object.length);
    }

    public static String getBytesAsString(byte[] bytes) {
        return new String(bytes).replaceAll("\\r\\n?", "\n");
    }

    private static String getBytesAsString(byte[] bytes, int start, int end) {
        return new String(Arrays.copyOfRange(bytes, start, end)).replaceAll("\\r\\n?", "\n");
    }

    private static int indexOfSubArray(byte[] array, byte[] subArray) {
        int i2 = 0;
        int j2 = 0;
        int index = 0;
        while (i2 < array.length && j2 < subArray.length) {
            if (array[i2] == subArray[j2]) {
                ++i2;
                if (++j2 != subArray.length) continue;
                return index;
            }
            index = i2 = i2 - j2 + 1;
            j2 = 0;
        }
        return -1;
    }

    private static int indexOfSubArrayLast(byte[] array, byte[] subArray) {
        int i2 = array.length - 1;
        int j2 = subArray.length - 1;
        int index = i2 - j2;
        while (i2 >= 0 && j2 >= 0) {
            if (array[i2] == subArray[j2]) {
                --i2;
                if (--j2 != -1) continue;
                return index;
            }
            i2 = i2 + subArray.length - j2 - 2;
            index = i2 - j2;
            j2 = subArray.length - 1;
        }
        return -1;
    }
}

