/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.utils;

import java.util.TreeSet;
import javax.swing.JFormattedTextField;
import javax.swing.JList;
import javax.swing.JSlider;
import javax.swing.text.NumberFormatter;
import org.jpedal.PdfDecoder;
import org.jpedal.external.ErrorTracker;

public class LimitDecodeTrackerNoSwing
implements ErrorTracker {
    private final PdfDecoder decode_pdf;
    private final NumberFormatter formatter;
    private final JFormattedTextField field;
    private final JSlider slider;
    private int pageCounted = -1;
    private int commandCounted;
    private int currentDecodePt;
    private int currentLimit = -1;
    private String lastFilename = "";
    private boolean isCountingCommands;
    private final TreeSet<?> breaks;
    private final JList<?> list;

    public LimitDecodeTrackerNoSwing(PdfDecoder decode_pdf, NumberFormatter formatter, JFormattedTextField field, JSlider slider, TreeSet<?> breaks, JList<?> list) {
        this.decode_pdf = decode_pdf;
        this.formatter = formatter;
        this.field = field;
        this.slider = slider;
        this.breaks = breaks;
        this.list = list;
    }

    public void onPageChange() {
        this.breaks.clear();
        this.formatter.setMaximum(Integer.valueOf(this.commandCounted));
        this.field.setValue(this.commandCounted);
        this.slider.setMaximum(this.commandCounted);
        this.slider.setValue(this.commandCounted);
    }

    public void repaint(int limit) {
        this.currentLimit = limit;
        this.decode_pdf.decodePage(this.decode_pdf.getPageNumber());
        this.decode_pdf.repaint();
    }

    @Override
    public String getPageFailureMessage() {
        return "";
    }

    @Override
    public void addPageFailureMessage(String value) {
    }

    @Override
    public boolean ispageSuccessful() {
        return true;
    }

    @Override
    public boolean checkForExitRequest(int dataPointer, int streamSize) {
        if (this.currentDecodePt == this.currentLimit) {
            int lastIndex = this.list.getModel().getSize() - 1;
            if (lastIndex >= 0) {
                this.list.ensureIndexIsVisible(lastIndex);
            }
            return true;
        }
        if (this.isCountingCommands) {
            ++this.commandCounted;
        }
        ++this.currentDecodePt;
        return false;
    }

    @Override
    public void finishedPageDecoding(int rawPage) {
        this.pageCounted = rawPage;
        this.currentLimit = this.commandCounted;
    }

    @Override
    public void startedPageDecoding(int rawPage) {
        String currentFilename = this.decode_pdf.getFileName();
        boolean bl2 = this.isCountingCommands = !this.lastFilename.equals(currentFilename) || this.pageCounted != rawPage;
        if (this.isCountingCommands) {
            this.commandCounted = -1;
            this.currentLimit = -1;
            this.lastFilename = currentFilename;
        }
        this.currentDecodePt = 0;
    }
}

