/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.utils;

import com.idrsolutions.image.JDeli;
import com.idrsolutions.image.encoder.options.EncoderOptions;
import com.idrsolutions.image.jpeg.options.JpegEncoderOptions;
import com.idrsolutions.image.jpeg2000.options.Jpeg2000EncoderOptions;
import com.idrsolutions.image.webp.options.WebpEncoderOptions;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import javax.swing.ProgressMonitor;
import org.jpedal.PdfDecoder;
import org.jpedal.PdfDecoderInt;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.examples.viewer.gui.popups.SaveBitmap;
import org.jpedal.examples.viewer.gui.popups.SaveImage;
import org.jpedal.examples.viewer.gui.popups.SaveText;
import org.jpedal.exception.PdfException;
import org.jpedal.exception.PdfSecurityException;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.objects.PdfImageData;
import org.jpedal.objects.PdfPageData;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;
import org.jpedal.utils.Strip;
import org.jpedal.utils.SwingWorker;

public class Exporter {
    public static final int RECTANGLE = 1;
    public static final int WORDLIST = 2;
    private static final String separator = System.getProperty("file.separator");
    private final String fileName;
    private final SwingGUI currentGUI;
    private final PdfDecoderInt dPDF;
    private final String selectedFile;

    public Exporter(SwingGUI currentGUI, String selectedFile, PdfDecoderInt decode_pdf) {
        int index;
        String fileName = new File(selectedFile).getName();
        if (fileName.lastIndexOf(46) != -1) {
            fileName = fileName.substring(0, fileName.lastIndexOf(46));
        }
        StringBuilder fileNameBuffer = new StringBuilder(fileName);
        while ((index = fileNameBuffer.toString().indexOf("%20")) != -1) {
            fileNameBuffer.replace(index, index + 3, " ");
        }
        this.fileName = fileNameBuffer.toString();
        this.currentGUI = currentGUI;
        this.selectedFile = selectedFile;
        this.dPDF = decode_pdf;
    }

    public void extractPagesAsImages(SaveBitmap current_selection) {
        final int startPage = current_selection.getStartPage();
        final int endPage = current_selection.getEndPage();
        if (startPage < 1 || endPage < 1) {
            return;
        }
        final String format = current_selection.getPrefix();
        final int scaling = current_selection.getScaling();
        final String output_dir = current_selection.getRootDir() + separator + this.fileName + separator + "thumbnails" + separator;
        File testDirExists = new File(output_dir);
        if (!testDirExists.exists()) {
            testDirExists.mkdirs();
        }
        final ProgressMonitor status = new ProgressMonitor(this.currentGUI.getFrame(), Messages.getMessage("PdfViewerMessage.GeneratingBitmaps"), "", startPage, endPage);
        SwingWorker worker = new SwingWorker(){

            @Override
            public Object construct() {
                int count = 0;
                boolean yesToAll = false;
                block9: for (int page = startPage; page < endPage + 1; ++page) {
                    if (status.isCanceled()) {
                        Exporter.this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerError.UserStoppedExport") + count + ' ' + Messages.getMessage("PdfViewerError.ReportNumberOfImagesExported"));
                        return null;
                    }
                    BufferedImage image_to_save = null;
                    try {
                        image_to_save = Exporter.this.dPDF.getPageAsImage(page);
                    }
                    catch (PdfException e1) {
                        LogWriter.writeLog(e1);
                    }
                    if (image_to_save != null) {
                        File fileToSave;
                        if (scaling != 100) {
                            int newWidth = image_to_save.getWidth() * scaling / 100;
                            Image scaledImage = image_to_save.getScaledInstance(newWidth, -1, 4);
                            image_to_save = new BufferedImage(scaledImage.getWidth(null), scaledImage.getHeight(null), 1);
                            Graphics2D g2 = image_to_save.createGraphics();
                            g2.drawImage(scaledImage, 0, 0, null);
                        }
                        if ((fileToSave = new File(output_dir + page + '.' + format)).exists() && !yesToAll) {
                            if (endPage - startPage > 1) {
                                int n2 = Exporter.this.currentGUI.showOverwriteDialog(fileToSave.getAbsolutePath(), true);
                                switch (n2) {
                                    case 0: {
                                        break;
                                    }
                                    case 1: {
                                        yesToAll = true;
                                        break;
                                    }
                                    case 2: {
                                        status.setProgress(page);
                                        continue block9;
                                    }
                                    default: {
                                        Exporter.this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerError.UserStoppedExport") + count + ' ' + Messages.getMessage("PdfViewerError.ReportNumberOfPagesExported"));
                                        status.close();
                                        return null;
                                    }
                                }
                            } else {
                                int n3 = Exporter.this.currentGUI.showOverwriteDialog(fileToSave.getAbsolutePath(), false);
                                if (n3 != 0) {
                                    return null;
                                }
                            }
                        }
                        try {
                            JDeli.write(image_to_save, format, new File(output_dir + page + '.' + format));
                        }
                        catch (Exception e2) {
                            LogWriter.writeLog("Exception in writing image " + e2);
                        }
                    }
                    ++count;
                    status.setProgress(page + 1);
                }
                Exporter.this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerTitle.PagesSavedAsImages") + ' ' + output_dir);
                return null;
            }
        };
        worker.start();
    }

    private static void saveImage(BufferedImage image_to_save, String fileName, String prefix) {
        try {
            JDeli.write(image_to_save, prefix, new File(fileName));
        }
        catch (Exception ex) {
            LogWriter.writeLog("Exception in writing image " + ex);
        }
    }

    private void decodeHires(int start, int end, String imageType, int comp, String output_dir) {
        String target = "";
        PdfDecoderInt decode_pdf = Exporter.getPdfDecoder(this.selectedFile);
        if (decode_pdf == null) {
            return;
        }
        ProgressMonitor status = new ProgressMonitor(this.currentGUI.getFrame(), Messages.getMessage("PdfViewerMessage.ExtractImages"), "", start, end);
        try {
            int count = 0;
            boolean yesToAll = false;
            for (int page = start; page < end + 1; ++page) {
                File targetExists;
                if (status.isCanceled()) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerError.UserStoppedExport") + count + ' ' + Messages.getMessage("PdfViewerError.ReportNumberOfImagesExported"));
                    return;
                }
                decode_pdf.decodePage(page);
                PdfImageData pdf_images = decode_pdf.getPdfImageData();
                int image_count = pdf_images.getImageCount();
                if (image_count > 0 && !(targetExists = new File(target = output_dir + page + separator)).exists()) {
                    targetExists.mkdirs();
                }
                block26: for (int i2 = 0; i2 < image_count; ++i2) {
                    String image_name = pdf_images.getImageName(i2);
                    float x1 = pdf_images.getImageXCoord(i2);
                    float y1 = pdf_images.getImageYCoord(i2);
                    float w2 = pdf_images.getImageWidth(i2);
                    float h2 = pdf_images.getImageHeight(i2);
                    try {
                        BufferedImage image_to_save = decode_pdf.getObjectStore().loadStoredImage("CLIP_" + image_name);
                        if (image_to_save != null) {
                            File fileToSave;
                            if (imageType.toLowerCase().startsWith("jp")) {
                                image_to_save = ColorSpaceConvertor.convertToRGB(image_to_save);
                            }
                            if ((fileToSave = new File(target + image_name + '.' + imageType)).exists() && !yesToAll) {
                                int n2 = this.currentGUI.showOverwriteDialog(fileToSave.getAbsolutePath(), true);
                                switch (n2) {
                                    case 0: {
                                        break;
                                    }
                                    case 1: {
                                        yesToAll = true;
                                        break;
                                    }
                                    case 2: {
                                        status.setProgress(page);
                                        continue block26;
                                    }
                                    default: {
                                        this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerError.UserStoppedExport") + count + ' ' + Messages.getMessage("PdfViewerError.ReportNumberOfImagesExported"));
                                        status.close();
                                        return;
                                    }
                                }
                            }
                            switch (imageType) {
                                case "jpx": {
                                    EncoderOptions options = new Jpeg2000EncoderOptions();
                                    ((Jpeg2000EncoderOptions)options).setQuality(comp);
                                    try {
                                        JDeli.write(image_to_save, options, new File(target + image_name + '.' + imageType));
                                    }
                                    catch (Exception e2) {
                                        LogWriter.writeLog("Exception in writing image " + e2);
                                    }
                                    break;
                                }
                                case "jpeg": {
                                    EncoderOptions options = new JpegEncoderOptions();
                                    ((JpegEncoderOptions)options).setQuality(comp);
                                    try {
                                        JDeli.write(image_to_save, options, new File(target + image_name + '.' + imageType));
                                    }
                                    catch (Exception e3) {
                                        LogWriter.writeLog("Exception in writing image " + e3);
                                    }
                                    break;
                                }
                                case "webp": {
                                    EncoderOptions options = new WebpEncoderOptions();
                                    ((WebpEncoderOptions)options).setQuality(comp);
                                    try {
                                        JDeli.write(image_to_save, options, new File(target + image_name + '.' + imageType));
                                    }
                                    catch (Exception e4) {
                                        LogWriter.writeLog("Exception in writing image " + e4);
                                    }
                                    break;
                                }
                                default: {
                                    Exporter.saveImage(image_to_save, target + image_name + '.' + imageType, imageType);
                                }
                            }
                            ++count;
                        }
                        this.writeXML(target, image_name, x1, y1, w2, h2);
                        continue;
                    }
                    catch (IOException ee) {
                        LogWriter.writeLog(ee);
                    }
                }
                decode_pdf.flushObjectValues(true);
                status.setProgress(page + 1);
            }
            status.close();
            if (count == 0) {
                this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.NoImagesSaved"));
            } else {
                String image_message = Messages.getMessage("PdfViewerMessage.ImagesExported");
                if (count == 1) {
                    image_message = Messages.getMessage("PdfViewerMessage.ImageExported");
                }
                this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.ImagesSavedTo") + ' ' + output_dir + image_message + count);
            }
        }
        catch (Exception e5) {
            decode_pdf.closePdfFile();
            LogWriter.writeLog("Exception " + e5.getMessage());
        }
        decode_pdf.closePdfFile();
    }

    private static PdfDecoderInt getPdfDecoder(String selectedFile) {
        PdfDecoder decode_pdf = null;
        try {
            decode_pdf = new PdfDecoder(false);
            decode_pdf.setExtractionMode(36, 1.0f);
            decode_pdf.openPdfFile(selectedFile);
        }
        catch (PdfException e2) {
            LogWriter.writeLog(e2);
        }
        if (decode_pdf.isEncrypted() && !decode_pdf.isPasswordSupplied() || !decode_pdf.isExtractionAllowed()) {
            return null;
        }
        return decode_pdf;
    }

    private void writeXML(String target, String image_name, float x1, float y1, float w2, float h2) throws IOException {
        try (OutputStreamWriter output_stream = new OutputStreamWriter((OutputStream)new FileOutputStream(target + image_name + ".xml"), StandardCharsets.UTF_8);){
            output_stream.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            output_stream.write("<!-- Pixel Location of image x1,y1,x2,y2\n");
            output_stream.write("(x1,y1 is top left corner)\n");
            output_stream.write("(origin is bottom left corner)  -->\n");
            output_stream.write("\n\n<META>\n");
            output_stream.write("<PAGELOCATION x1=\"" + x1 + "\" y1=\"" + (y1 + h2) + "\" x2=\"" + (x1 + w2) + "\" y2=\"" + y1 + "\" />\n");
            output_stream.write("<FILE>" + this.fileName + "</FILE>\n");
            output_stream.write("</META>\n");
        }
    }

    public void extractImagesOnPages(SaveImage current_selection) {
        final int startPage = current_selection.getStartPage();
        final int endPage = current_selection.getEndPage();
        final int comp = current_selection.getCompression();
        if (startPage < 1 || endPage < 1) {
            return;
        }
        final String format = current_selection.getPrefix();
        final String output_dir = current_selection.getRootDir() + separator + this.fileName + separator + "images" + separator;
        SwingWorker worker = new SwingWorker(){

            @Override
            public Object construct() {
                Exporter.this.decodeHires(startPage, endPage, format, comp, output_dir);
                return null;
            }
        };
        worker.start();
    }

    public void extractTextOnPages(SaveText current_selection) {
        final int startPage = current_selection.getStartPage();
        final int endPage = current_selection.getEndPage();
        if (startPage < 1 || endPage < 1) {
            return;
        }
        final int type = current_selection.getTextType();
        final boolean useXMLExtraction = current_selection.isXMLExtaction();
        final String output_dir = current_selection.getRootDir() + separator + this.fileName + separator + "text" + separator;
        File testDirExists = new File(output_dir);
        if (!testDirExists.exists()) {
            testDirExists.mkdirs();
        }
        SwingWorker worker = new SwingWorker(){

            @Override
            public Object construct() {
                switch (type) {
                    case 1: {
                        Exporter.this.decodeTextRectangle(startPage, endPage, output_dir, useXMLExtraction);
                        break;
                    }
                    case 2: {
                        Exporter.this.decodeTextWordlist(startPage, endPage, output_dir, useXMLExtraction);
                        break;
                    }
                    default: {
                        System.out.println("Unknown setting");
                    }
                }
                return null;
            }
        };
        worker.start();
    }

    private void decodeTextWordlist(int startPage, int endPage, String output_dir, boolean useXMLExtraction) {
        PdfDecoderInt decode_pdf = this.getPdfDecoder();
        if (decode_pdf != null && decode_pdf.isEncrypted() && !decode_pdf.isPasswordSupplied() && !decode_pdf.isExtractionAllowed()) {
            System.out.println("Encrypted settings");
            System.out.println("Please look at Viewer for code sample to handle such files");
        } else {
            ProgressMonitor status = new ProgressMonitor(this.currentGUI.getFrame(), Messages.getMessage("PdfViewerMessage.ExtractText"), "", startPage, endPage);
            try {
                int count = 0;
                boolean yesToAll = false;
                block8: for (int page = startPage; page < endPage + 1; ++page) {
                    if (decode_pdf == null || status.isCanceled()) {
                        this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerError.UserStoppedExport") + count + ' ' + Messages.getMessage("PdfViewerError.ReportNumberOfPagesExported"));
                        return;
                    }
                    List<String> words = Exporter.decodeAndExtractWords(decode_pdf, page);
                    if (words == null) {
                        System.out.println("No text found");
                    } else {
                        File fileToSave;
                        String target = output_dir + separator + "wordlist" + separator;
                        File output_path = new File(target);
                        if (!output_path.exists()) {
                            output_path.mkdirs();
                        }
                        String prefix = "_text.txt";
                        String encoding = System.getProperty("file.encoding");
                        if (useXMLExtraction) {
                            prefix = "_xml.txt";
                            encoding = "UTF-8";
                        }
                        if ((fileToSave = new File(target + this.fileName + '_' + page + prefix)).exists() && !yesToAll) {
                            int n2;
                            if (endPage - startPage > 1) {
                                n2 = this.currentGUI.showOverwriteDialog(fileToSave.getAbsolutePath(), true);
                                switch (n2) {
                                    case 0: {
                                        break;
                                    }
                                    case 1: {
                                        yesToAll = true;
                                        break;
                                    }
                                    case 2: {
                                        status.setProgress(page);
                                        continue block8;
                                    }
                                    default: {
                                        this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerError.UserStoppedExport") + count + ' ' + Messages.getMessage("PdfViewerError.ReportNumberOfPagesExported"));
                                        status.close();
                                        return;
                                    }
                                }
                            } else {
                                n2 = this.currentGUI.showOverwriteDialog(fileToSave.getAbsolutePath(), false);
                                if (n2 != 0) {
                                    return;
                                }
                            }
                        }
                        Exporter.writeOutText(useXMLExtraction, page, words, target, prefix, encoding, this.fileName);
                    }
                    ++count;
                    status.setProgress(page + 1);
                    decode_pdf.flushObjectValues(false);
                }
                status.close();
                this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.TextSavedTo") + ' ' + output_dir);
            }
            catch (Exception e2) {
                if (decode_pdf != null) {
                    decode_pdf.closePdfFile();
                }
                System.err.println("Exception " + e2 + " in " + this.selectedFile);
                LogWriter.writeLog(e2);
            }
            catch (Error e3) {
                LogWriter.writeLog(e3);
            }
        }
        if (decode_pdf != null) {
            decode_pdf.closePdfFile();
        }
    }

    private static List<String> decodeAndExtractWords(PdfDecoderInt decode_pdf, int page) throws PdfException {
        decode_pdf.decodePage(page);
        PdfGroupingAlgorithms currentGrouping = decode_pdf.getGroupingObject();
        PdfPageData currentPageData = decode_pdf.getPdfPageData();
        int x1 = currentPageData.getMediaBoxX(page);
        int x2 = currentPageData.getMediaBoxWidth(page) + x1;
        int y2 = currentPageData.getMediaBoxX(page);
        int y1 = currentPageData.getMediaBoxHeight(page) - y2;
        List<String> words = null;
        try {
            words = currentGrouping.extractTextAsWordlist(x1, y1, x2, y2, page, true, "&:=()!;.,\\/\"\"''");
        }
        catch (PdfException e2) {
            decode_pdf.closePdfFile();
            System.err.println("Exception= " + e2 + " when extracting word list");
            LogWriter.writeLog(e2);
        }
        catch (Error e3) {
            LogWriter.writeLog(e3);
        }
        return words;
    }

    private static void writeOutText(boolean useXMLExtraction, int page, List<String> words, String target, String prefix, String encoding, String fileName) throws IOException {
        try (OutputStreamWriter output_stream = new OutputStreamWriter((OutputStream)new FileOutputStream(target + fileName + '_' + page + prefix), encoding);){
            Iterator<String> wordIterator = words.iterator();
            while (wordIterator.hasNext()) {
                String currentWord = wordIterator.next();
                if (!useXMLExtraction) {
                    currentWord = Strip.convertToText(currentWord, true);
                }
                int wx1 = (int)Float.parseFloat(wordIterator.next());
                int wy1 = (int)Float.parseFloat(wordIterator.next());
                int wx2 = (int)Float.parseFloat(wordIterator.next());
                int wy2 = (int)Float.parseFloat(wordIterator.next());
                output_stream.write(currentWord + ',' + wx1 + ',' + wy1 + ',' + wx2 + ',' + wy2 + '\n');
            }
        }
    }

    private PdfDecoderInt getPdfDecoder() {
        try {
            PdfDecoder decode_pdf = new PdfDecoder(false);
            decode_pdf.setExtractionMode(1);
            PdfDecoder.init(true);
            decode_pdf.openPdfFile(this.selectedFile);
            return decode_pdf;
        }
        catch (Exception e2) {
            System.err.println("Exception " + e2 + " in pdf code for wordlist" + this.selectedFile);
            LogWriter.writeLog(e2);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decodeTextRectangle(int startPage, int endPage, String output_dir, boolean useXMLExtraction) {
        PdfDecoder decode_pdf = null;
        try {
            decode_pdf = new PdfDecoder(false);
            if (!useXMLExtraction) {
                decode_pdf.useTextExtraction();
            }
            decode_pdf.setExtractionMode(1);
            PdfDecoder.init(true);
            decode_pdf.openPdfFile(this.selectedFile);
            if (decode_pdf.isEncrypted() && !decode_pdf.isPasswordSupplied() && !decode_pdf.isExtractionAllowed()) {
                System.out.println("Encrypted settings");
                System.out.println("Please look at Viewer for code sample to handle such files");
            } else {
                this.extractPages(startPage, endPage, output_dir, useXMLExtraction, decode_pdf);
            }
        }
        catch (PdfSecurityException se) {
            System.err.println("Security Exception " + se + " in pdf code for text extraction on file ");
        }
        catch (PdfException se) {
            System.err.println("Pdf Exception " + se + " in pdf code for text extraction on file ");
        }
        catch (Exception e2) {
            System.err.println("Exception " + e2 + " in pdf code for text extraction on file ");
            LogWriter.writeLog(e2);
        }
        finally {
            if (decode_pdf != null) {
                decode_pdf.closePdfFile();
            }
        }
    }

    private void extractPages(int startPage, int endPage, String output_dir, boolean useXMLExtraction, PdfDecoderInt decode_pdf) throws PdfException, IOException {
        ProgressMonitor status = new ProgressMonitor(this.currentGUI.getFrame(), Messages.getMessage("PdfViewerMessage.ExtractText"), "", startPage, endPage);
        int count = 0;
        boolean yesToAll = false;
        block12: for (int page = startPage; page < endPage + 1; ++page) {
            File fileToSave;
            if (status.isCanceled()) {
                this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerError.UserStoppedExport") + count + ' ' + Messages.getMessage("PdfViewerError.ReportNumberOfPagesExported"));
                return;
            }
            decode_pdf.decodePage(page);
            PdfGroupingAlgorithms currentGrouping = decode_pdf.getGroupingObject();
            PdfPageData currentPageData = decode_pdf.getPdfPageData();
            int x1 = currentPageData.getMediaBoxX(page);
            int x2 = currentPageData.getMediaBoxWidth(page) + x1;
            int y2 = currentPageData.getMediaBoxY(page);
            int y1 = currentPageData.getMediaBoxHeight(page) + y2;
            String text = null;
            try {
                text = currentGrouping.extractTextInRectangle(x1, y1, x2, y2, page, false, true);
            }
            catch (PdfException e2) {
                decode_pdf.closePdfFile();
                System.err.println("Exception " + e2.getMessage() + " in file " + decode_pdf.getObjectStore().fullFileName);
                LogWriter.writeLog(e2);
            }
            if (text == null) continue;
            String target = output_dir + separator + "rectangle" + separator;
            File page_path = new File(target);
            if (!page_path.exists()) {
                page_path.mkdirs();
            }
            String prefix = "_text.txt";
            String encoding = System.getProperty("file.encoding");
            if (useXMLExtraction) {
                prefix = "_xml.txt";
                encoding = "UTF-8";
            }
            if ((fileToSave = new File(target + this.fileName + '_' + page + prefix)).exists() && !yesToAll) {
                int n2;
                if (endPage - startPage > 1) {
                    n2 = this.currentGUI.showOverwriteDialog(fileToSave.getAbsolutePath(), true);
                    switch (n2) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            yesToAll = true;
                            break;
                        }
                        case 2: {
                            status.setProgress(page);
                            continue block12;
                        }
                        default: {
                            this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerError.UserStoppedExport") + count + ' ' + Messages.getMessage("PdfViewerError.ReportNumberOfPagesExported"));
                            status.close();
                            return;
                        }
                    }
                } else {
                    n2 = this.currentGUI.showOverwriteDialog(fileToSave.getAbsolutePath(), false);
                    if (n2 != 0) {
                        return;
                    }
                }
            }
            try (OutputStreamWriter output_stream = new OutputStreamWriter((OutputStream)new FileOutputStream(target + this.fileName + '_' + page + prefix), encoding);){
                if (useXMLExtraction) {
                    Exporter.saveExtractPagesXMLOutput(output_stream, text, x1, y1, x2, y2);
                } else {
                    output_stream.write(text);
                }
            }
            ++count;
            status.setProgress(page + 1);
            decode_pdf.flushObjectValues(true);
        }
        status.close();
        this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.TextSavedTo") + ' ' + output_dir);
    }

    private static void saveExtractPagesXMLOutput(OutputStreamWriter output_stream, String text, int x1, int y1, int x2, int y2) throws IOException {
        output_stream.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n");
        output_stream.write("<!-- Pixel Location of text x1,y1,x2,y2\n");
        output_stream.write("(x1,y1 is top left corner)\n");
        output_stream.write("(x1,y1 is bottom right corner)\n");
        output_stream.write("(origin is bottom left corner)  -->\n");
        output_stream.write("\n\n<ARTICLE>\n");
        output_stream.write("<LOCATION x1=\"" + x1 + "\" y1=\"" + y1 + "\" x2=\"" + x2 + "\" y2=\"" + y2 + "\" />\n");
        output_stream.write("\n\n<TEXT>\n");
        output_stream.write(text);
        output_stream.write("\n\n</TEXT>\n");
        output_stream.write("\n\n</ARTICLE>\n");
    }
}

