/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.jpedal.PdfDecoderInt;
import org.jpedal.ThumbnailDecoder;
import org.jpedal.examples.viewer.Values;
import org.jpedal.objects.PdfPageData;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;
import org.jpedal.utils.SwingWorker;

public class SwingThumbnailPanel
extends JScrollPane {
    private static final boolean debugThumbnails = false;
    private SwingWorker worker;
    private JPanel panel = new JPanel();
    private ThumbPainter painter = new ThumbPainter();
    private boolean showThumbnailsdefault = true;
    private boolean showThumbnails = true;
    private boolean interrupt;
    private boolean drawing;
    private boolean generateOtherVisibleThumbnails;
    private ThumbnailDecoder thumbDecoder;
    private JButton[] pageButton;
    private BufferedImage[] images;
    private boolean[] buttonDrawn;
    private boolean[] isLandscape;
    private int[] pageHeight;
    private static final int thumbH = 100;
    private static final int thumbW = 70;
    private final PdfDecoderInt decode_pdf;
    private int lastPage = -1;

    public SwingThumbnailPanel(final PdfDecoderInt decode_pdf) {
        this.setHorizontalScrollBarPolicy(30);
        this.setVerticalScrollBarPolicy(20);
        this.decode_pdf = decode_pdf;
        this.thumbDecoder = new ThumbnailDecoder(decode_pdf);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                if (SwingThumbnailPanel.this.drawing) {
                    SwingThumbnailPanel.this.terminateDrawing();
                }
                decode_pdf.waitForDecodingToFinish();
                if (decode_pdf.isOpen()) {
                    SwingThumbnailPanel.this.drawThumbnails();
                }
            }
        });
    }

    public synchronized void generateOtherVisibleThumbnails(int currentPage) {
        this.generateOtherVisibleThumbnails = true;
        if (currentPage == -1 || currentPage == this.lastPage || this.pageButton == null) {
            return;
        }
        this.lastPage = currentPage;
        int count = this.decode_pdf.getPageCount();
        for (int i1 = 0; i1 < count; ++i1) {
            if (!this.generateOtherVisibleThumbnails) {
                return;
            }
            if (i1 == currentPage - 1 || i1 >= this.pageButton.length || this.pageButton[i1] == null) continue;
            this.pageButton[i1].setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        }
        if (currentPage - 1 < this.pageButton.length && this.pageButton[currentPage - 1] != null) {
            Rectangle rect;
            if (count > 1) {
                this.pageButton[currentPage - 1].setBorder(BorderFactory.createLineBorder(Color.red));
            }
            if (!(rect = this.panel.getVisibleRect()).contains(this.pageButton[currentPage - 1].getLocation())) {
                if (SwingUtilities.isEventDispatchThread()) {
                    Rectangle vis = new Rectangle(this.pageButton[currentPage - 1].getLocation().x, this.pageButton[currentPage - 1].getLocation().y, this.pageButton[currentPage - 1].getBounds().width, this.pageButton[currentPage - 1].getBounds().height);
                    this.panel.scrollRectToVisible(vis);
                } else {
                    SwingUtilities.invokeLater(() -> {
                        if (!this.generateOtherVisibleThumbnails) {
                            return;
                        }
                        Rectangle vis = new Rectangle(this.pageButton[currentPage - 1].getLocation().x, this.pageButton[currentPage - 1].getLocation().y, this.pageButton[currentPage - 1].getBounds().width, this.pageButton[currentPage - 1].getBounds().height);
                        if (!this.generateOtherVisibleThumbnails) {
                            return;
                        }
                        this.panel.scrollRectToVisible(vis);
                    });
                }
            }
        }
        if (!this.generateOtherVisibleThumbnails) {
            return;
        }
        if (this.drawing) {
            this.terminateDrawing();
        }
        if (!this.generateOtherVisibleThumbnails) {
            return;
        }
        this.drawThumbnails();
    }

    public void drawThumbnails() {
        if (!this.isEnabled()) {
            return;
        }
        if (this.decode_pdf.isLoadingLinearizedPDF()) {
            return;
        }
        if (this.drawing) {
            this.terminateDrawing();
        }
        this.worker = new SwingWorker(){

            @Override
            public Object construct() {
                SwingThumbnailPanel.this.drawing = true;
                try {
                    Rectangle rect = SwingThumbnailPanel.this.panel.getVisibleRect();
                    int pages = SwingThumbnailPanel.this.decode_pdf.getPageCount();
                    for (int i2 = 0; i2 < pages; ++i2) {
                        SwingThumbnailPanel.this.decode_pdf.waitForDecodingToFinish();
                        if (SwingThumbnailPanel.this.interrupt) {
                            i2 = pages;
                            continue;
                        }
                        if (SwingThumbnailPanel.this.buttonDrawn == null || SwingThumbnailPanel.this.pageButton == null || rect == null || SwingThumbnailPanel.this.buttonDrawn[i2] || SwingThumbnailPanel.this.pageButton[i2] == null || !rect.intersects(SwingThumbnailPanel.this.pageButton[i2].getBounds())) continue;
                        int h2 = 100;
                        if (SwingThumbnailPanel.this.isLandscape[i2]) {
                            h2 = 70;
                        }
                        BufferedImage page = SwingThumbnailPanel.this.thumbDecoder.getPageAsThumbnail(i2 + 1, h2);
                        if (SwingThumbnailPanel.this.interrupt) continue;
                        SwingThumbnailPanel.this.createThumbnail(page, i2 + 1);
                    }
                }
                catch (Exception e2) {
                    LogWriter.writeLog(e2);
                }
                SwingThumbnailPanel.this.interrupt = false;
                SwingThumbnailPanel.this.drawing = false;
                return null;
            }
        };
        this.worker.start();
    }

    private static BufferedImage createBlankThumbnail(int w2, int h2) {
        BufferedImage blank = new BufferedImage(w2 + 1, h2 + 1, 1);
        Graphics2D g2 = (Graphics2D)blank.getGraphics();
        g2.setColor(Color.white);
        g2.fill(new Rectangle(0, 0, w2, h2));
        g2.setColor(Color.black);
        String line1 = Messages.getMessage("PdfDefaultThumbnail.line1");
        String line2 = Messages.getMessage("PdfDefaultThumbnail.line2");
        String line3 = Messages.getMessage("PdfDefaultThumbnail.line3");
        String line4 = Messages.getMessage("PdfDefaultThumbnail.line4");
        int line1Inset = (int)((double)(w2 / 2) - g2.getFontMetrics().getStringBounds(line1, g2).getWidth() / 2.0);
        int line2Inset = (int)((double)(w2 / 2) - g2.getFontMetrics().getStringBounds(line2, g2).getWidth() / 2.0);
        int line3Inset = (int)((double)(w2 / 2) - g2.getFontMetrics().getStringBounds(line3, g2).getWidth() / 2.0);
        int line4Inset = (int)((double)(w2 / 2) - g2.getFontMetrics().getStringBounds(line4, g2).getWidth() / 2.0);
        int fontHeight = g2.getFontMetrics().getHeight();
        int inset = (h2 - fontHeight * 4) / 2;
        g2.drawString(line1, line1Inset, inset + fontHeight);
        g2.drawString(line2, line2Inset, inset + fontHeight * 2);
        g2.drawString(line3, line3Inset, inset + fontHeight * 3);
        g2.drawString(line4, line4Inset, inset + fontHeight * 4);
        return blank;
    }

    public synchronized BufferedImage getImage(int page) {
        if (page < 1) {
            return null;
        }
        if (this.images[--page] == null) {
            BufferedImage image;
            int h2 = 100;
            if (this.isLandscape[page]) {
                h2 = 70;
            }
            this.images[page] = image = this.thumbDecoder.getPageAsThumbnail(page + 1, h2);
            return image;
        }
        return this.images[page];
    }

    private void createThumbnail(BufferedImage page, int i2) {
        --i2;
        if (page != null) {
            Graphics2D g2 = (Graphics2D)page.getGraphics();
            g2.setColor(Color.black);
            g2.draw(new Rectangle(0, 0, page.getWidth() - 1, page.getHeight() - 1));
            ImageIcon pageIcon = new ImageIcon(page);
            if (SwingUtilities.isEventDispatchThread()) {
                this.pageButton[i2].setIcon(pageIcon);
                this.buttonDrawn[i2] = true;
            } else {
                int ii = i2;
                Runnable doPaintComponent = () -> {
                    this.pageButton[ii].setIcon(pageIcon);
                    this.buttonDrawn[ii] = true;
                };
                SwingUtilities.invokeLater(doPaintComponent);
            }
        }
    }

    public void setupThumbnails(int pages, Font textFont, PdfPageData pageData) {
        this.lastPage = -1;
        this.getViewport().removeAll();
        this.panel.removeAll();
        this.getViewport().add(this.panel);
        this.panel.setLayout(new GridLayout(pages, 1, 0, 10));
        this.panel.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
        this.getVerticalScrollBar().setUnitIncrement(80);
        BufferedImage blankPortrait = SwingThumbnailPanel.createBlankThumbnail(70, 100);
        BufferedImage blankLandscape = SwingThumbnailPanel.createBlankThumbnail(100, 70);
        ImageIcon landscape = new ImageIcon(blankLandscape.getScaledInstance(-1, 70, 4));
        ImageIcon portrait = new ImageIcon(blankPortrait.getScaledInstance(-1, 100, 4));
        this.isLandscape = new boolean[pages];
        this.pageHeight = new int[pages];
        this.pageButton = new JButton[pages];
        this.images = new BufferedImage[pages];
        this.buttonDrawn = new boolean[pages];
        for (int i2 = 0; i2 < pages; ++i2) {
            ImageIcon usedPortrait;
            ImageIcon usedLandscape;
            int ph;
            String pageLabel;
            int page = i2 + 1;
            if (this.decode_pdf.getIO() != null) {
                pageLabel = this.decode_pdf.getIO().convertPageNumberToLabel(page);
                if (pageLabel == null) {
                    pageLabel = String.valueOf(page);
                }
            } else {
                pageLabel = String.valueOf(page);
            }
            int cropWidth = pageData.getCropBoxWidth(page);
            int cropHeight = pageData.getCropBoxHeight(page);
            int rotation = pageData.getRotation(page);
            if (rotation == 0 | rotation == 180) {
                ph = pageData.getMediaBoxHeight(page);
                usedLandscape = landscape;
                usedPortrait = portrait;
            } else {
                ph = pageData.getMediaBoxWidth(page);
                usedLandscape = portrait;
                usedPortrait = landscape;
            }
            if (cropWidth > cropHeight) {
                this.pageButton[i2] = new JButton(pageLabel, usedLandscape);
                this.isLandscape[i2] = true;
            } else {
                this.pageButton[i2] = new JButton(pageLabel, usedPortrait);
                this.isLandscape[i2] = false;
            }
            this.pageHeight[i2] = ph;
            this.pageButton[i2].setVerticalTextPosition(3);
            this.pageButton[i2].setHorizontalTextPosition(0);
            if (i2 == 0 && pages > 1) {
                this.pageButton[0].setBorder(BorderFactory.createLineBorder(Color.red));
            } else {
                this.pageButton[i2].setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            }
            this.pageButton[i2].setFont(textFont);
            this.panel.add((Component)this.pageButton[i2], "Center");
        }
    }

    public JButton[] getButtons() {
        return this.pageButton;
    }

    public void setThumbnailsEnabled(boolean newValue) {
        this.showThumbnailsdefault = newValue;
        this.showThumbnails = newValue;
    }

    public boolean isShownOnscreen() {
        return this.showThumbnails;
    }

    public void resetToDefault() {
        this.showThumbnails = this.showThumbnailsdefault;
    }

    public void setIsDisplayedOnscreen(boolean b2) {
        this.showThumbnails = b2;
    }

    public void addComponentListener() {
        this.panel.addComponentListener(this.painter);
    }

    public void removeAllListeners() {
        JButton[] buttons;
        if (this.panel != null) {
            this.panel.removeComponentListener(this.painter);
        }
        if ((buttons = this.getButtons()) != null) {
            for (JButton button : buttons) {
                ActionListener[] l2;
                if (button == null || (l2 = ((AbstractButton)button).getActionListeners()) == null) continue;
                for (ActionListener aL2 : l2) {
                    ((AbstractButton)button).removeActionListener(aL2);
                }
            }
        }
    }

    public void terminateDrawing() {
        this.generateOtherVisibleThumbnails = false;
        if (this.drawing) {
            this.interrupt = true;
            while (this.drawing) {
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException e2) {
                    LogWriter.writeLog(e2);
                }
            }
            this.interrupt = false;
        }
    }

    public void dispose() {
        this.removeAll();
        this.worker = null;
        if (this.panel != null) {
            this.panel.removeAll();
        }
        this.panel = null;
        this.painter = null;
        this.thumbDecoder = null;
        this.pageButton = null;
        this.buttonDrawn = null;
        this.isLandscape = null;
        this.pageHeight = null;
        this.images = null;
    }

    private class ThumbPainter
    extends ComponentAdapter {
        boolean requestMade;
        final Timer trapMultipleMoves = new Timer(250, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (!ThumbPainter.this.requestMade) {
                    ThumbPainter.this.requestMade = true;
                    if (!Values.isProcessing()) {
                        if (SwingThumbnailPanel.this.drawing) {
                            SwingThumbnailPanel.this.terminateDrawing();
                        }
                        ThumbPainter.this.requestMade = false;
                        SwingThumbnailPanel.this.drawThumbnails();
                    }
                }
            }
        });

        private ThumbPainter() {
        }

        @Override
        public void componentMoved(ComponentEvent e2) {
            if (this.trapMultipleMoves.isRunning()) {
                this.trapMultipleMoves.stop();
            }
            this.trapMultipleMoves.setRepeats(false);
            this.trapMultipleMoves.start();
        }
    }
}

