/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.swing;

import java.util.Iterator;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.jpedal.PdfDecoderInt;
import org.jpedal.examples.viewer.gui.swing.SignaturesTreeCellRenderer;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;

public class SwingSignaturesPanel
extends JTree {
    public SwingSignaturesPanel() {
        SignaturesTreeCellRenderer treeCellRenderer = new SignaturesTreeCellRenderer();
        this.setCellRenderer(treeCellRenderer);
    }

    public void reinitialise(PdfDecoderInt decode_pdf, Iterator<FormObject> signatureObjects) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Signatures");
        DefaultMutableTreeNode signed = new DefaultMutableTreeNode("The following have digitally counter-signed this document");
        DefaultMutableTreeNode blank = new DefaultMutableTreeNode("The following signature fields are not signed");
        while (signatureObjects.hasNext()) {
            FormObject formObj = signatureObjects.next();
            PdfObject sigObject = formObj.getDictionary(38);
            decode_pdf.getIO().checkResolved(formObj);
            if (sigObject == null) {
                if (!blank.isNodeChild(root)) {
                    root.add(blank);
                }
                DefaultMutableTreeNode blankNode = new DefaultMutableTreeNode(formObj.getTextStreamValue(36) + " on page " + formObj.getPageNumber());
                blank.add(blankNode);
                continue;
            }
            if (!signed.isNodeChild(root)) {
                root.add(signed);
            }
            String name = sigObject.getName(506543413);
            DefaultMutableTreeNode owner = new DefaultMutableTreeNode("Signed by " + name);
            signed.add(owner);
            DefaultMutableTreeNode type = new DefaultMutableTreeNode("Type");
            owner.add(type);
            String filter = null;
            PdfArrayIterator filters = sigObject.getMixedArray(1011108731);
            if (filters != null && filters.hasMoreTokens()) {
                filter = filters.getNextValueAsString(true);
            }
            DefaultMutableTreeNode filterNode = new DefaultMutableTreeNode("Filter: " + filter);
            type.add(filterNode);
            String subFilter = sigObject.getName(-2122953826);
            DefaultMutableTreeNode subFilterNode = new DefaultMutableTreeNode("Sub Filter: " + subFilter);
            type.add(subFilterNode);
            DefaultMutableTreeNode details = new DefaultMutableTreeNode("Details");
            owner.add(details);
            String rawDate = sigObject.getTextStreamValue(29);
            if (rawDate != null) {
                StringBuilder date = new StringBuilder(rawDate);
                date.delete(0, 2);
                date.insert(4, '/');
                date.insert(7, '/');
                date.insert(10, ' ');
                date.insert(13, ':');
                date.insert(16, ':');
                date.insert(19, ' ');
                DefaultMutableTreeNode time = new DefaultMutableTreeNode("Time: " + date);
                details.add(time);
            } else {
                DefaultMutableTreeNode time = new DefaultMutableTreeNode("Time: unset");
                details.add(time);
            }
            String reason = sigObject.getTextStreamValue(826499443);
            DefaultMutableTreeNode reasonNode = new DefaultMutableTreeNode("Reason: " + reason);
            details.add(reasonNode);
            String location = sigObject.getTextStreamValue(1618506351);
            DefaultMutableTreeNode locationNode = new DefaultMutableTreeNode("Location: " + location);
            details.add(locationNode);
            DefaultMutableTreeNode field = new DefaultMutableTreeNode("Field: " + formObj.getTextStreamValue(36) + " on page " + formObj.getPageNumber());
            details.add(field);
        }
        ((DefaultTreeModel)this.getModel()).setRoot(root);
    }
}

