/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;
import org.jpedal.PdfDecoderInt;
import org.jpedal.display.GUIDisplay;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.commands.NextResults;
import org.jpedal.examples.viewer.commands.PageNavigator;
import org.jpedal.examples.viewer.commands.Scroll;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.examples.viewer.gui.swing.SearchList;
import org.jpedal.external.JPedalActionHandler;
import org.jpedal.grouping.DefaultSearchListener;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.objects.PdfPageData;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;
import org.jpedal.utils.repositories.generic.Vector_Rectangle_Int;

public class SwingSearchWindow
extends JFrame {
    public static final int SEARCH_EXTERNAL_WINDOW = 0;
    public static final int SEARCH_TABBED_PANE = 1;
    public static final int SEARCH_MENU_BAR = 2;
    private boolean hasSearched;
    private Map<Integer, int[][]> searchAreas;
    private boolean backGroundSearch;
    private int searchKey;
    private final ExecutorService service = Executors.newCachedThreadPool();
    private Future<?> searchFuture;
    private int style;
    private boolean isSetup;
    private boolean usingMenuBarSearch;
    private int lastPage = -1;
    private String defaultMessage = "Search PDF Here";
    private JTextField searchText;
    private JTextField searchCount;
    private DefaultListModel<String> listModel;
    private SearchList resultsList;
    private JLabel label;
    private JPanel advancedPanel;
    private JComboBox<String> searchType;
    private JCheckBox wholeWordsOnlyBox;
    private JCheckBox caseSensitiveBox;
    private JCheckBox multiLineBox;
    private JCheckBox highlightAll;
    private JCheckBox searchAll;
    private JCheckBox useRegEx;
    private JCheckBox searchHighlightedOnly;
    private JCheckBox ignoreWhiteSpace;
    private boolean updateListDuringSearch = true;
    private JButton searchButton;
    private int itemFoundCount;
    private String[] searchTerms = new String[]{""};
    private String lastSearchTerms;
    private boolean singlePageSearch;
    private Values commonValues;
    private PdfDecoderInt decode_pdf;
    private int searchTypeParameters;
    private int firstPageWithResults;
    private boolean deleteOnClick;
    private final Map<Integer, Integer> textPages = new HashMap<Integer, Integer>();
    private final Map<Integer, Object> textRectangles = new HashMap<Integer, Object>();
    private final JPanel nav = new JPanel();
    private final SwingGUI currentGUI;
    private final Runnable searchRunner = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SwingSearchWindow.this.itemFoundCount = 0;
            SwingSearchWindow.this.resultsList.setSelectedIndex(-1);
            Thread.currentThread().setName("SwingSearchWindow");
            SwingSearchWindow.this.clearCurrentResults();
            long startTime = System.currentTimeMillis();
            boolean searchingInBackground = SwingSearchWindow.this.backGroundSearch;
            SwingSearchWindow.this.backGroundSearch = false;
            int currentKey = SwingSearchWindow.this.searchKey;
            try {
                DefaultListModel<String> resultListModel = SwingSearchWindow.this.updateListDuringSearch ? SwingSearchWindow.this.listModel : new DefaultListModel<String>();
                int start = 1;
                int end = SwingSearchWindow.this.decode_pdf.getPageCount() + 1;
                if (SwingSearchWindow.this.singlePageSearch) {
                    start = SwingSearchWindow.this.decode_pdf.getPageNumber();
                    end = start + 1;
                }
                if (!this.searchPages(start, end, currentKey, resultListModel, searchingInBackground)) {
                    this.setResultsInGUI(resultListModel, searchingInBackground, startTime);
                }
            }
            catch (Exception e2) {
                LogWriter.writeLog("Exception in handling search " + e2);
                if (SwingSearchWindow.this.currentGUI != null && SwingSearchWindow.this.currentGUI.getButtons() != null && !searchingInBackground) {
                    if (SwingSearchWindow.this.currentGUI.getButtons().getButton(19) != null) {
                        SwingSearchWindow.this.currentGUI.getButtons().getButton(19).setEnabled(false);
                    }
                    if (SwingSearchWindow.this.currentGUI.getButtons().getButton(18) != null) {
                        SwingSearchWindow.this.currentGUI.getButtons().getButton(18).setEnabled(false);
                    }
                }
            }
            finally {
                SwingSearchWindow.this.commonValues.setIsSearching(false);
            }
        }

        private void setResultsInGUI(DefaultListModel<String> resultListModel, boolean searchingInBackground, long searchStartTime) throws InvocationTargetException, InterruptedException {
            int listSize;
            if (!searchingInBackground) {
                SwingSearchWindow.this.searchCount.setText(Messages.getMessage("PdfViewerSearch.ItemsFound") + ' ' + SwingSearchWindow.this.itemFoundCount + "  " + Messages.getMessage("PdfViewerSearch.Done"));
            }
            if ((listSize = resultListModel.size()) > 1500) {
                resultListModel.removeRange(1500, listSize - 1);
                resultListModel.addElement("Too many results to list...");
            }
            SwingSearchWindow.this.listModel = resultListModel;
            SwingUtilities.invokeAndWait(() -> {
                if (SwingSearchWindow.this.resultsList != null && SwingSearchWindow.this.listModel != null) {
                    SwingSearchWindow.this.resultsList.setModel(SwingSearchWindow.this.listModel);
                }
            });
            SwingSearchWindow.this.currentGUI.setResults(SwingSearchWindow.this.resultsList);
            SwingSearchWindow.this.resultsList.setSelectedIndex(0);
            SwingSearchWindow.this.decode_pdf.repaint();
            if (!searchingInBackground) {
                SwingSearchWindow.this.currentGUI.getButtons().getButton(19).setEnabled(true);
                SwingSearchWindow.this.currentGUI.getButtons().getButton(18).setEnabled(true);
            }
            if (LogWriter.isRunningFromIDE) {
                System.out.println("Search memory=" + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1000L + 'K');
                System.out.println("Search time=" + (float)Math.abs((System.currentTimeMillis() - searchStartTime) / 100L) / 10.0f + 's');
            }
        }

        private boolean searchPages(int start, int end, int currentKey, DefaultListModel<String> resultListModel, boolean searchingInBackground) throws Exception {
            int currentPage = SwingSearchWindow.this.commonValues.getCurrentPage();
            for (int i2 = start; i2 != end; ++i2) {
                int page;
                if (SwingSearchWindow.this.usingMenuBarSearch) {
                    if (SwingSearchWindow.this.resultsList.getResultCount() >= 1) break;
                    page = currentPage + (i2 - 1) > SwingSearchWindow.this.commonValues.getPageCount() ? currentPage + (i2 - 1) - SwingSearchWindow.this.commonValues.getPageCount() : currentPage + (i2 - 1);
                } else {
                    page = i2;
                }
                if (!Thread.currentThread().isInterrupted()) {
                    if (SwingSearchWindow.this.searchAreas != null) {
                        int[][] highlights = (int[][])SwingSearchWindow.this.searchAreas.get(page);
                        if (highlights != null) {
                            for (int[] a10 : highlights) {
                                SwingSearchWindow.this.searchPage(page, a10[0], a10[1], a10[0] + a10[2], a10[1] + a10[3], currentKey, resultListModel);
                            }
                        }
                    } else {
                        SwingSearchWindow.this.searchPage(page, currentKey, resultListModel);
                    }
                } else {
                    return true;
                }
                if ((searchingInBackground || resultListModel.getSize() <= 0) && page % 16 != 0) continue;
                SwingSearchWindow.this.searchCount.setText(Messages.getMessage("PdfViewerSearch.ItemsFound") + ' ' + SwingSearchWindow.this.itemFoundCount + ' ' + Messages.getMessage("PdfViewerSearch.Scanning") + page);
            }
            return false;
        }
    };

    public SwingSearchWindow(SwingGUI currentGUI) {
        this.currentGUI = currentGUI;
        this.setName("searchFrame");
        this.setDefaultCloseOperation(2);
    }

    public void setWholeWords(boolean wholeWords) {
        this.wholeWordsOnlyBox.setSelected(wholeWords);
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitiveBox.setSelected(caseSensitive);
    }

    public void setMultiLine(boolean multiLine) {
        this.multiLineBox.setSelected(multiLine);
    }

    public void setIgnoreSpaces(boolean ignoreSpaces) {
        this.ignoreWhiteSpace.setSelected(ignoreSpaces);
    }

    public void setUpdateListDuringSearch(boolean updateListDuringSearch) {
        this.updateListDuringSearch = updateListDuringSearch;
    }

    public void init(PdfDecoderInt dec, Values values) {
        this.decode_pdf = dec;
        this.commonValues = values;
        if (this.isSetup) {
            this.searchCount.setText(Messages.getMessage("PdfViewerSearch.ItemsFound") + ' ' + this.itemFoundCount);
            this.searchText.selectAll();
            this.searchText.grabFocus();
        } else {
            this.isSetup = true;
            this.setTitle(Messages.getMessage("PdfViewerSearchGUITitle.DefaultMessage"));
            this.defaultMessage = Messages.getMessage("PdfViewerSearchGUI.DefaultMessage");
            this.searchText = new JTextField(10);
            this.searchText.setText(this.defaultMessage);
            this.searchText.setName("searchText");
            this.createAdvancedOptionsPanel();
            this.nav.setLayout(new BorderLayout());
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent arg0) {
                    SwingSearchWindow.this.removeSearchWindow(true);
                }
            });
            this.nav.add((Component)this.searchButton, "East");
            this.nav.add((Component)this.searchText, "Center");
            this.searchAll = new JCheckBox();
            this.searchAll.setSelected(true);
            this.searchAll.setText(Messages.getMessage("PdfViewerSearch.CheckBox"));
            JPanel topPanel = new JPanel();
            topPanel.setLayout(new BorderLayout());
            topPanel.add((Component)this.searchAll, "North");
            this.label = new JLabel("<html><center> Show Advanced");
            Color bgColor = this.label.getBackground();
            if (bgColor != null) {
                double luma = (0.299 * (double)bgColor.getRed() + 0.587 * (double)bgColor.getGreen() + 0.114 * (double)bgColor.getBlue()) / 255.0;
                if (luma > 0.5) {
                    this.label.setForeground(Color.BLUE);
                } else {
                    this.label.setForeground(new Color(64, 128, 255));
                }
            } else {
                this.label.setForeground(Color.BLUE);
            }
            this.label.setName("advSearch");
            this.label.addMouseListener(new MouseAdapter(){
                boolean isVisible;
                String text = "Show Advanced";

                @Override
                public void mouseEntered(MouseEvent e2) {
                    if (GUIDisplay.allowChangeCursor) {
                        SwingSearchWindow.this.nav.setCursor(new Cursor(12));
                    }
                    SwingSearchWindow.this.label.setText("<html><center><a href=" + this.text + '>' + this.text + "</a></center>");
                }

                @Override
                public void mouseExited(MouseEvent e2) {
                    if (GUIDisplay.allowChangeCursor) {
                        SwingSearchWindow.this.nav.setCursor(new Cursor(0));
                    }
                    SwingSearchWindow.this.label.setText("<html><center>" + this.text);
                }

                @Override
                public void mouseClicked(MouseEvent e2) {
                    if (this.isVisible) {
                        this.text = Messages.getMessage("PdfViewerSearch.ShowOptions");
                        SwingSearchWindow.this.label.setText("<html><center><a href=" + this.text + '>' + this.text + "</a></center>");
                        SwingSearchWindow.this.advancedPanel.setVisible(false);
                    } else {
                        this.text = Messages.getMessage("PdfViewerSearch.HideOptions");
                        SwingSearchWindow.this.label.setText("<html><center><a href=" + this.text + '>' + this.text + "</a></center>");
                        SwingSearchWindow.this.advancedPanel.setVisible(true);
                    }
                    this.isVisible = !this.isVisible;
                }
            });
            this.label.setBorder(BorderFactory.createEmptyBorder(3, 4, 4, 4));
            topPanel.add((Component)this.label, "South");
            this.nav.add((Component)topPanel, "North");
            this.itemFoundCount = 0;
            this.textPages.clear();
            this.textRectangles.clear();
            this.listModel = null;
            this.searchCount = new JTextField(Messages.getMessage("PdfViewerSearch.ItemsFound") + ' ' + this.itemFoundCount);
            this.searchCount.setEditable(false);
            this.nav.add((Component)this.searchCount, "South");
            this.listModel = new DefaultListModel();
            this.resultsList = new SearchList(this.listModel, this.textPages, this.textRectangles);
            this.resultsList.setName("results");
            this.addListeners();
            this.addComponentsToInterface();
        }
    }

    private void createAdvancedOptionsPanel() {
        this.searchText.addFocusListener(new SearchTextFocusListener());
        this.searchButton = new JButton(Messages.getMessage("PdfViewerSearch.Button"));
        this.advancedPanel = new JPanel(new GridBagLayout());
        this.searchType = new JComboBox<String>(new String[]{Messages.getMessage("PdfViewerSearch.MatchWhole"), Messages.getMessage("PdfViewerSearch.MatchAny")});
        this.wholeWordsOnlyBox = new JCheckBox(Messages.getMessage("PdfViewerSearch.WholeWords"));
        this.wholeWordsOnlyBox.setName("wholeWords");
        this.searchHighlightedOnly = new JCheckBox(Messages.getMessage("PdfViewerSearch.HighlightsOnly"));
        this.searchHighlightedOnly.setName("highlightsOnly");
        this.caseSensitiveBox = new JCheckBox(Messages.getMessage("PdfViewerSearch.CaseSense"));
        this.caseSensitiveBox.setName("caseSensitive");
        this.multiLineBox = new JCheckBox(Messages.getMessage("PdfViewerSearch.MultiLine"));
        this.multiLineBox.setName("multiLine");
        this.highlightAll = new JCheckBox(Messages.getMessage("PdfViewerSearch.HighlightsCheckBox"));
        this.highlightAll.setName("highlightAll");
        this.useRegEx = new JCheckBox(Messages.getMessage("PdfViewerSearch.RegExCheckBox"));
        this.useRegEx.setName("useregex");
        this.ignoreWhiteSpace = new JCheckBox(Messages.getMessage("PdfViewerSearch.IgnoreWhiteSpace"));
        this.ignoreWhiteSpace.setName("ignoreWhiteSpace");
        this.searchType.setName("combo");
        GridBagConstraints c2 = new GridBagConstraints();
        this.advancedPanel.setPreferredSize(new Dimension(this.advancedPanel.getPreferredSize().width, 150));
        c2.gridx = 0;
        c2.gridy = 0;
        c2.anchor = 19;
        c2.fill = 2;
        c2.weightx = 1.0;
        c2.weighty = 0.0;
        this.advancedPanel.add((Component)new JLabel(Messages.getMessage("PdfViewerSearch.ReturnResultsAs")), c2);
        c2.insets = new Insets(5, 0, 0, 0);
        c2.gridy = 1;
        this.advancedPanel.add(this.searchType, c2);
        c2.gridy = 2;
        this.advancedPanel.add((Component)new JLabel(Messages.getMessage("PdfViewerSearch.AdditionalOptions")), c2);
        c2.insets = new Insets(0, 0, 0, 0);
        c2.weighty = 1.0;
        c2.gridy = 3;
        this.advancedPanel.add((Component)this.wholeWordsOnlyBox, c2);
        c2.weighty = 1.0;
        c2.gridy = 4;
        this.advancedPanel.add((Component)this.caseSensitiveBox, c2);
        c2.weighty = 1.0;
        c2.gridy = 5;
        this.advancedPanel.add((Component)this.multiLineBox, c2);
        c2.weighty = 1.0;
        c2.gridy = 6;
        this.advancedPanel.add((Component)this.highlightAll, c2);
        c2.weighty = 1.0;
        c2.gridy = 7;
        this.advancedPanel.add((Component)this.useRegEx, c2);
        c2.weighty = 1.0;
        c2.gridy = 8;
        this.advancedPanel.add((Component)this.searchHighlightedOnly, c2);
        c2.weighty = 1.0;
        c2.gridy = 9;
        this.advancedPanel.add((Component)this.ignoreWhiteSpace, c2);
        this.advancedPanel.setVisible(false);
    }

    private void addListeners() {
        this.resultsList.addListSelectionListener(new searchListListener());
        this.resultsList.setSelectionMode(1);
        this.searchButton.addActionListener(e2 -> {
            if (!this.commonValues.isSearching()) {
                try {
                    this.searchTypeParameters = this.getSearchOptionsAsInt();
                    String textToFind = this.searchText.getText().trim();
                    if (this.searchType.getSelectedIndex() == 0) {
                        this.searchTerms = new String[]{textToFind};
                    } else {
                        this.searchTerms = textToFind.split(" ");
                        for (int i2 = 0; i2 < this.searchTerms.length; ++i2) {
                            this.searchTerms[i2] = this.searchTerms[i2].trim();
                        }
                    }
                    this.singlePageSearch = !this.searchAll.isSelected();
                    this.searchText();
                }
                catch (Exception e1) {
                    LogWriter.writeLog(e1);
                }
            } else {
                this.commonValues.setIsSearching(false);
                this.searchButton.setText(Messages.getMessage("PdfViewerSearch.Button"));
            }
            this.decode_pdf.requestFocus();
        });
        this.searchText.selectAll();
        this.deleteOnClick = true;
        final SwingSearchWindow finalSearchWindow = this;
        this.searchText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e2) {
                char key;
                int id2;
                String textToFind = SwingSearchWindow.this.searchText.getText().trim();
                if (textToFind.isEmpty()) {
                    SwingSearchWindow.this.lastSearchTerms = null;
                }
                if ((id2 = e2.getID()) == 400 && (key = e2.getKeyChar()) == '\n') {
                    if (!SwingSearchWindow.this.decode_pdf.isOpen()) {
                        SwingSearchWindow.this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerFileMenuFind.noFile"));
                    } else {
                        try {
                            SwingSearchWindow.this.commonValues.setIsSearching(false);
                            SwingSearchWindow.this.searchTypeParameters = SwingSearchWindow.this.getSearchOptionsAsInt();
                            if (textToFind.equals(SwingSearchWindow.this.lastSearchTerms)) {
                                NextResults.execute(null, SwingSearchWindow.this.commonValues, finalSearchWindow, SwingSearchWindow.this.currentGUI, SwingSearchWindow.this.decode_pdf);
                            } else {
                                SwingSearchWindow.this.lastSearchTerms = textToFind;
                                if (SwingSearchWindow.this.searchType.getSelectedIndex() == 0) {
                                    SwingSearchWindow.access$2402(SwingSearchWindow.this, new String[]{textToFind});
                                } else {
                                    SwingSearchWindow.access$2402(SwingSearchWindow.this, textToFind.split(" "));
                                    for (int i2 = 0; i2 < SwingSearchWindow.this.searchTerms.length; ++i2) {
                                        ((SwingSearchWindow)SwingSearchWindow.this).searchTerms[i2] = SwingSearchWindow.this.searchTerms[i2].trim();
                                    }
                                }
                                SwingSearchWindow.this.singlePageSearch = !SwingSearchWindow.this.searchAll.isSelected();
                                SwingSearchWindow.this.searchText();
                                if (!SwingSearchWindow.this.usingMenuBarSearch) {
                                    SwingSearchWindow.this.decode_pdf.requestFocus();
                                }
                            }
                        }
                        catch (Exception e1) {
                            LogWriter.writeLog("Error performing search " + e1.getMessage());
                        }
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
                if (SwingSearchWindow.this.currentGUI.getButtons().getButton(19) != null) {
                    SwingSearchWindow.this.currentGUI.getButtons().getButton(19).setEnabled(false);
                }
                if (SwingSearchWindow.this.currentGUI.getButtons().getButton(18) != null) {
                    SwingSearchWindow.this.currentGUI.getButtons().getButton(18).setEnabled(false);
                }
            }
        });
        this.searchText.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e2) {
                if (((JTextComponent)e2.getComponent()).getText().isEmpty()) {
                    ((JTextComponent)e2.getComponent()).setText(SwingSearchWindow.this.defaultMessage);
                    SwingSearchWindow.this.deleteOnClick = true;
                }
            }

            @Override
            public void focusGained(FocusEvent e2) {
                if (SwingSearchWindow.this.deleteOnClick) {
                    SwingSearchWindow.this.deleteOnClick = false;
                    ((JTextComponent)e2.getComponent()).setText("");
                }
            }
        });
    }

    private void addComponentsToInterface() {
        if (this.style == 0 || this.style == 1) {
            JScrollPane scrollPane = new JScrollPane();
            scrollPane.getViewport().add(this.resultsList);
            scrollPane.setVerticalScrollBarPolicy(20);
            scrollPane.setHorizontalScrollBarPolicy(30);
            scrollPane.getVerticalScrollBar().setUnitIncrement(80);
            scrollPane.getHorizontalScrollBar().setUnitIncrement(80);
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)scrollPane, "Center");
            this.getContentPane().add((Component)this.nav, "North");
            this.getContentPane().add((Component)this.advancedPanel, "South");
            Container frame = this.currentGUI.getFrame();
            if (this.style == 0) {
                int w2 = 230;
                int h2 = frame.getHeight();
                int x1 = frame.getLocationOnScreen().x;
                int x2 = frame.getWidth() + x1;
                int y2 = frame.getLocationOnScreen().y;
                Dimension d2 = Toolkit.getDefaultToolkit().getScreenSize();
                int width = d2.width;
                if (x2 + 230 > width) {
                    x2 = width - 230;
                    frame.setSize(x2 - x1, frame.getHeight());
                }
                this.setSize(230, h2);
                this.setLocation(x2, y2);
            }
            this.searchAll.setFocusable(false);
            this.searchText.grabFocus();
            if (this.style == 1) {
                this.currentGUI.setSearchText(this.searchText);
            }
        } else {
            this.currentGUI.setSearchText(this.searchText);
        }
    }

    public void findWithoutWindow(PdfDecoderInt dec, Values values, int searchType, boolean listOfTerms, boolean singlePageOnly, String searchValue) {
        this.init(dec, values);
        if (!this.commonValues.isSearching()) {
            this.backGroundSearch = true;
            this.commonValues.setIsSearching(true);
            this.decode_pdf = dec;
            this.commonValues = values;
            if (!listOfTerms) {
                this.searchTerms = new String[]{searchValue};
            } else {
                this.searchTerms = searchValue.split(" ");
                for (int i2 = 0; i2 < this.searchTerms.length; ++i2) {
                    this.searchTerms[i2] = this.searchTerms[i2].trim();
                }
            }
            this.searchTypeParameters = searchType;
            this.singlePageSearch = singlePageOnly;
            this.find(dec, values);
        } else {
            this.currentGUI.showMessageDialog("Please wait for search to finish before starting another.");
        }
    }

    public void find(PdfDecoderInt dec, Values values) {
        if (!this.backGroundSearch) {
            this.init(dec, values);
            if (this.style == 0) {
                this.setVisible(true);
            }
        } else {
            try {
                this.searchText();
            }
            catch (Exception e2) {
                LogWriter.writeLog(e2);
            }
        }
    }

    public void removeSearchWindow(boolean justHide) {
        this.setVisible(false);
        if (this.isSetup && !justHide) {
            if (this.listModel != null) {
                this.listModel.clear();
            }
            this.itemFoundCount = 0;
            this.commonValues.setIsSearching(false);
        }
        if (this.decode_pdf != null) {
            this.decode_pdf.getTextLines().clearHighlights();
            this.decode_pdf.repaint();
        }
    }

    private void clearCurrentResults() {
        this.listModel.clear();
        this.resultsList.clearSelection();
        this.textPages.clear();
        this.textRectangles.clear();
        this.itemFoundCount = 0;
        this.decode_pdf.getTextLines().clearHighlights();
        this.decode_pdf.repaintPane(0);
        this.decode_pdf.getPages().refreshDisplay();
        this.resultsList.repaint();
    }

    private void searchText() {
        this.usingMenuBarSearch = this.style == 2;
        ++this.searchKey;
        this.lastPage = -1;
        if (this.searchKey > 3000) {
            this.searchKey = 0;
        }
        if (this.searchFuture != null) {
            this.searchFuture.cancel(true);
        }
        this.searchAreas = !this.usingMenuBarSearch && (this.searchTypeParameters & 0x40) == 64 ? this.decode_pdf.getTextLines().getAllHighlights() : null;
        this.searchFuture = this.service.submit(this.searchRunner);
    }

    private void searchPage(int page, int currentKey, DefaultListModel<String> model) throws Exception {
        PdfPageData currentPageData = this.decode_pdf.getPdfPageData();
        int x1 = currentPageData.getMediaBoxX(page);
        int x2 = currentPageData.getMediaBoxWidth(page) + x1;
        int y2 = currentPageData.getMediaBoxY(page);
        int y1 = currentPageData.getMediaBoxHeight(page) + y2;
        this.searchPage(page, x1, y1, x2, y2, currentKey, model);
    }

    private void searchPage(int page, int x1, int y1, int x2, int y2, int currentKey, DefaultListModel<String> model) throws Exception {
        PdfGroupingAlgorithms grouping;
        this.firstPageWithResults = 0;
        PdfPageData pageSize = this.decode_pdf.getPdfPageData();
        if (this.decode_pdf.getDisplayView() == 1 && page == this.commonValues.getCurrentPage()) {
            grouping = this.decode_pdf.getGroupingObject();
        } else {
            this.decode_pdf.decodePageInBackground(page);
            grouping = this.decode_pdf.getBackgroundGroupingObject();
        }
        DefaultSearchListener listener = new DefaultSearchListener();
        grouping.generateTeasers();
        grouping.setIncludeHTML(true);
        StringBuilder term = new StringBuilder();
        for (int i2 = 0; i2 != this.searchTerms.length; ++i2) {
            term.append(this.searchTerms[i2]).append(' ');
        }
        this.resultsList.setSearchTerm(term.toString());
        SortedMap<Object, String> highlightsWithTeasers = grouping.findTextWithinInAreaWithTeasers(x1, y1, x2, y2, pageSize.getRotation(page), this.searchTerms, this.searchTypeParameters, listener);
        if (!highlightsWithTeasers.isEmpty()) {
            this.itemFoundCount += highlightsWithTeasers.size();
            for (Map.Entry<Object, String> e2 : highlightsWithTeasers.entrySet()) {
                Object highlight = e2.getKey();
                String teaser = e2.getValue();
                if (!SwingUtilities.isEventDispatchThread() && model == this.listModel) {
                    Runnable setTextRun = () -> {
                        if (currentKey == this.searchKey) {
                            if (!teaser.contains("<b>")) {
                                model.addElement(teaser);
                            } else {
                                model.addElement("<html>" + teaser + "</html>");
                            }
                        }
                    };
                    SwingUtilities.invokeLater(setTextRun);
                } else if (!teaser.contains("<b>")) {
                    model.addElement(teaser);
                } else {
                    model.addElement("<html>" + teaser + "</html>");
                }
                Integer key = this.textRectangles.size();
                this.textRectangles.put(key, highlight);
                this.textPages.put(key, page);
                if (page >= this.firstPageWithResults && this.firstPageWithResults != 0) continue;
                this.firstPageWithResults = page;
            }
        }
        this.lastPage = page;
    }

    public int getFirstPageWithResults() {
        return this.firstPageWithResults;
    }

    public void grabFocusInInput() {
        this.searchText.grabFocus();
    }

    public boolean isSearchVisible() {
        return this.isVisible();
    }

    public void setViewStyle(int style) {
        this.style = style;
    }

    public int getViewStyle() {
        return this.style;
    }

    public void setSearchText(String s2) {
        this.deleteOnClick = false;
        this.searchText.setText(s2);
    }

    public Map<Integer, Object> getTextRectangles() {
        return Collections.unmodifiableMap(this.textRectangles);
    }

    public SearchList getResults() {
        return this.resultsList;
    }

    public SearchList getResults(int page) {
        boolean bl2 = this.usingMenuBarSearch = this.style == 2;
        if (page != this.lastPage && this.usingMenuBarSearch) {
            try {
                ++this.searchKey;
                if (this.searchKey > 3000) {
                    this.searchKey = 0;
                }
                this.clearCurrentResults();
                this.searchPage(page, this.searchKey, this.listModel);
            }
            catch (Exception e2) {
                LogWriter.writeLog(e2);
            }
        }
        return this.resultsList;
    }

    public void resetSearchWindow() {
        if (this.isSetup) {
            this.searchText.setText(this.defaultMessage);
            this.deleteOnClick = true;
            this.searchCount.setText(Messages.getMessage("PdfViewerSearch.ItemsFound") + ' ' + this.itemFoundCount);
            if (this.hasSearched) {
                this.currentGUI.getButtons().getButton(19).setEnabled(false);
                this.currentGUI.getButtons().getButton(18).setEnabled(false);
                this.hasSearched = false;
            }
            this.decode_pdf.requestFocus();
        }
    }

    @Override
    public void dispose() {
        if (this.searchFuture != null) {
            this.searchFuture.cancel(true);
            this.clearCurrentResults();
        }
        if (this.resultsList != null) {
            for (EventListener eventListener : this.resultsList.getListSelectionListeners()) {
                this.resultsList.removeListSelectionListener((ListSelectionListener)eventListener);
            }
        }
        this.resultsList = null;
        if (this.searchButton != null) {
            for (EventListener eventListener : this.searchButton.getActionListeners()) {
                this.searchButton.removeActionListener((ActionListener)eventListener);
            }
        }
        this.searchButton = null;
        if (this.searchText != null) {
            for (EventListener eventListener : this.searchText.getKeyListeners()) {
                this.searchText.removeKeyListener((KeyListener)eventListener);
            }
            for (EventListener eventListener : this.searchText.getFocusListeners()) {
                this.searchText.removeFocusListener((FocusListener)eventListener);
            }
        }
        this.searchText = null;
        if (this.label != null) {
            for (EventListener eventListener : this.label.getMouseListeners()) {
                this.label.removeMouseListener((MouseListener)eventListener);
            }
        }
        this.label = null;
        for (EventListener eventListener : this.getWindowListeners()) {
            this.removeWindowListener((WindowListener)eventListener);
        }
        for (EventListener eventListener : this.getPropertyChangeListeners()) {
            this.removePropertyChangeListener((PropertyChangeListener)eventListener);
        }
        for (EventListener eventListener : this.getComponentListeners()) {
            this.removeComponentListener((ComponentListener)eventListener);
        }
        for (EventListener eventListener : this.getMouseListeners()) {
            this.removeMouseListener((MouseListener)eventListener);
        }
        for (EventListener eventListener : this.getFocusListeners()) {
            this.removeFocusListener((FocusListener)eventListener);
        }
        if (this.searchAreas != null) {
            this.searchAreas.clear();
        }
        this.searchAreas = null;
        if (this.listModel != null) {
            this.listModel.clear();
        }
        this.listModel = null;
        if (this.advancedPanel != null) {
            for (EventListener eventListener : this.advancedPanel.getPropertyChangeListeners()) {
                this.advancedPanel.removePropertyChangeListener((PropertyChangeListener)eventListener);
            }
            this.advancedPanel.removeAll();
        }
        this.advancedPanel = null;
        this.removeAll();
        this.decode_pdf = null;
        this.service.shutdown();
        super.dispose();
    }

    private int getSearchOptionsAsInt() {
        int searchOptions = 0;
        if (this.wholeWordsOnlyBox.isSelected()) {
            searchOptions |= 1;
        }
        if (this.caseSensitiveBox.isSelected()) {
            searchOptions |= 2;
        }
        if (this.multiLineBox.isSelected()) {
            searchOptions |= 8;
        }
        if (this.highlightAll.isSelected()) {
            searchOptions |= 0x10;
        }
        if (this.useRegEx.isSelected()) {
            searchOptions |= 0x20;
        }
        if (this.ignoreWhiteSpace.isSelected()) {
            searchOptions |= 0x80;
        }
        if (this.searchHighlightedOnly.isSelected()) {
            searchOptions |= 0x40;
        }
        return searchOptions;
    }

    static /* synthetic */ String[] access$2402(SwingSearchWindow x0, String[] x1) {
        x0.searchTerms = x1;
        return x1;
    }

    class searchListListener
    implements ListSelectionListener {
        searchListListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e2) {
            if (!e2.getValueIsAdjusting()) {
                if (!Values.isProcessing()) {
                    Integer newPage;
                    int id2 = SwingSearchWindow.this.resultsList.getSelectedIndex();
                    SwingSearchWindow.this.decode_pdf.getTextLines().clearHighlights();
                    if (id2 != -1 && (newPage = (Integer)SwingSearchWindow.this.textPages.get(id2)) != null) {
                        if (SwingSearchWindow.this.commonValues.getCurrentPage() != newPage.intValue()) {
                            PageNavigator.gotoPage(newPage.toString(), SwingSearchWindow.this.currentGUI, SwingSearchWindow.this.commonValues, SwingSearchWindow.this.decode_pdf);
                        }
                        while (Values.isProcessing()) {
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException e22) {
                                LogWriter.writeLog(e22);
                            }
                        }
                        if ((SwingSearchWindow.this.searchTypeParameters & 0x10) == 16) {
                            this.highlightAllSearchResults();
                        } else {
                            this.highlightSingleSearchResults(id2);
                        }
                        SwingSearchWindow.this.decode_pdf.repaintPane(0);
                        SwingSearchWindow.this.decode_pdf.getPages().refreshDisplay();
                    }
                }
                SwingSearchWindow.this.currentGUI.getButtons().setBackNavigationButtonsEnabled(SwingSearchWindow.this.commonValues.getCurrentPage() != 1);
                SwingSearchWindow.this.currentGUI.getButtons().setForwardNavigationButtonsEnabled(SwingSearchWindow.this.commonValues.getCurrentPage() != SwingSearchWindow.this.decode_pdf.getPageCount());
            } else {
                SwingSearchWindow.this.resultsList.repaint();
            }
        }

        private void highlightAllSearchResults() {
            int[][] showAllOnPage;
            Vector_Rectangle_Int storageVector = new Vector_Rectangle_Int();
            int lastPage = -1;
            for (int k2 = 0; k2 != SwingSearchWindow.this.resultsList.getModel().getSize(); ++k2) {
                Object highlight;
                Integer page = (Integer)SwingSearchWindow.this.textPages.get(k2);
                if (page == null) continue;
                int currentPage = page;
                if (currentPage != lastPage) {
                    storageVector.trim();
                    showAllOnPage = storageVector.get();
                    SwingSearchWindow.this.decode_pdf.getTextLines().addHighlights(showAllOnPage, true, lastPage);
                    lastPage = currentPage;
                    storageVector = new Vector_Rectangle_Int();
                }
                if ((highlight = SwingSearchWindow.this.textRectangles.get(k2)) instanceof int[]) {
                    storageVector.addElement((int[])highlight);
                }
                if (!(highlight instanceof int[][])) continue;
                int[][] areas = (int[][])highlight;
                for (int i2 = 0; i2 != areas.length; ++i2) {
                    storageVector.addElement(areas[i2]);
                }
            }
            storageVector.trim();
            showAllOnPage = storageVector.get();
            SwingSearchWindow.this.decode_pdf.getTextLines().addHighlights(showAllOnPage, true, lastPage);
        }

        private void highlightSingleSearchResults(int id2) {
            int currentPage = (Integer)SwingSearchWindow.this.textPages.get(id2);
            Vector_Rectangle_Int storageVector = new Vector_Rectangle_Int();
            int[] scroll = null;
            Object highlight = SwingSearchWindow.this.textRectangles.get(id2);
            if (highlight instanceof int[]) {
                storageVector.addElement((int[])highlight);
                scroll = (int[])highlight;
            }
            if (highlight instanceof int[][]) {
                int[][] areas = (int[][])highlight;
                scroll = areas[0];
                for (int i2 = 0; i2 != areas.length; ++i2) {
                    storageVector.addElement(areas[i2]);
                }
            }
            if (scroll != null) {
                Scroll.rectToHighlight(scroll, currentPage, SwingSearchWindow.this.decode_pdf);
            }
            storageVector.trim();
            SwingSearchWindow.this.decode_pdf.getTextLines().addHighlights(storageVector.get(), true, currentPage);
        }
    }

    class SearchTextFocusListener
    extends FocusAdapter {
        SearchTextFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e2) {
            Object handler;
            if (SwingSearchWindow.this.decode_pdf != null && (handler = SwingSearchWindow.this.decode_pdf.getExternalHandler(30)) instanceof JPedalActionHandler) {
                ((JPedalActionHandler)handler).actionPerformed(SwingSearchWindow.this.currentGUI, null);
            }
        }
    }
}

