/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.swing;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.SwingUtilities;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.ViewerCommands;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.utils.LogWriter;

public class SwingScrollListener
extends MouseAdapter
implements AdjustmentListener {
    private static final boolean debugThumbnail = false;
    private Timer t;
    private TimerTask listener;
    private int pNum = -1;
    private int lastPageSent = -1;
    private boolean usingMouseClick;
    private boolean mousePressed;
    private boolean showLast;
    public BufferedImage lastImage;
    private final boolean previewOnSingleScroll;
    private final SwingGUI swingGui;

    public SwingScrollListener(SwingGUI gui, boolean previewOnSingleScroll) {
        this.swingGui = gui;
        this.previewOnSingleScroll = previewOnSingleScroll;
    }

    public void dispose() {
        if (this.t != null) {
            this.t.cancel();
        }
        this.t = null;
    }

    private void startTimer() {
        if (this.t == null) {
            this.t = new Timer();
        }
        if (this.listener != null) {
            this.listener.cancel();
            this.t.purge();
        }
        long delay = 175L;
        if (!this.usingMouseClick) {
            delay = 500L;
        }
        this.listener = new PageListener();
        this.t.schedule(this.listener, delay);
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e2) {
        this.pNum = e2.getAdjustable().getValue() + 1;
        if (!this.mousePressed) {
            this.showLast = false;
            this.lastImage = null;
        }
        if (this.showLast) {
            this.swingGui.getPdfDecoder().setPreviewThumbnail(this.lastImage, "Page " + this.pNum + " of " + this.swingGui.getPdfDecoder().getPageCount());
            this.swingGui.getPdfDecoder().repaint();
        } else if (this.lastImage != null) {
            BufferedImage img = new BufferedImage(this.lastImage.getWidth(), this.lastImage.getHeight(), this.lastImage.getType());
            Graphics2D g2 = (Graphics2D)img.getGraphics();
            g2.drawImage((Image)this.lastImage, 0, 0, null);
            g2.setPaint(new Color(0, 0, 0, 130));
            g2.fillRect(0, 0, this.lastImage.getWidth(), this.lastImage.getHeight());
            String l2 = "Loading...";
            int textW = g2.getFontMetrics().stringWidth("Loading...");
            int textH = g2.getFontMetrics().getHeight();
            g2.setPaint(Color.WHITE);
            g2.drawString("Loading...", this.lastImage.getWidth() / 2 - textW / 2, this.lastImage.getHeight() / 2 + textH / 2);
            this.lastImage = img;
            this.showLast = true;
            this.swingGui.getPdfDecoder().setPreviewThumbnail(img, "Page " + this.pNum + " of " + this.swingGui.getPdfDecoder().getPageCount());
            this.swingGui.getPdfDecoder().repaint();
        }
        if (this.previewOnSingleScroll) {
            this.startTimer();
        }
    }

    private void releaseAndUpdate() {
        if (this.usingMouseClick) {
            this.usingMouseClick = false;
        }
        if (this.listener != null) {
            this.listener.cancel();
            this.t.purge();
        }
        if (this.swingGui.getPdfDecoder().getDisplayView() != 5) {
            this.swingGui.getPdfDecoder().setPreviewThumbnail(null, "Page " + this.pNum + " of " + this.swingGui.getPdfDecoder().getPageCount());
        }
        this.swingGui.getCommand().executeCommand(ViewerCommands.GOTO, new Object[]{Integer.toString(this.pNum)});
        this.swingGui.setPageNumber();
        this.swingGui.getPdfDecoder().repaint();
    }

    @Override
    public void mousePressed(MouseEvent e2) {
        this.mousePressed = true;
        this.usingMouseClick = true;
        if (this.previewOnSingleScroll) {
            this.startTimer();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
        if (this.mousePressed) {
            this.releaseAndUpdate();
        }
        this.mousePressed = false;
    }

    class PageListener
    extends TimerTask {
        PageListener() {
        }

        @Override
        public void run() {
            SwingUtilities.invokeLater(() -> {
                if (SwingScrollListener.this.mousePressed) {
                    this.setThumbnail();
                } else {
                    SwingScrollListener.this.usingMouseClick = false;
                    SwingScrollListener.this.releaseAndUpdate();
                }
                this.cancel();
            });
        }

        private synchronized void setThumbnail() {
            if (SwingScrollListener.this.lastPageSent != SwingScrollListener.this.pNum && SwingScrollListener.this.swingGui.getValues().getFileType() == Values.FileType.PDF) {
                SwingScrollListener.this.lastPageSent = SwingScrollListener.this.pNum;
                try {
                    BufferedImage image;
                    SwingScrollListener.this.lastImage = image = SwingScrollListener.this.swingGui.getThumbnailPanel().getImage(SwingScrollListener.this.pNum);
                    SwingScrollListener.this.showLast = false;
                    SwingScrollListener.this.swingGui.getPdfDecoder().setPreviewThumbnail(image, "Page " + SwingScrollListener.this.pNum + " of " + SwingScrollListener.this.swingGui.getPdfDecoder().getPageCount());
                    SwingScrollListener.this.swingGui.getPdfDecoder().repaint();
                }
                catch (Exception ee) {
                    LogWriter.writeLog("Caught an Exception " + ee);
                }
            }
        }
    }
}

